/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.message;

import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jms.encoding.ThreadContextObjectInputStream;
import com.solacesystems.jms.message.ObjectMessageIF;
import com.solacesystems.jms.message.SolMessage;
import jakarta.jms.JMSException;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotWriteableException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class SolObjectMessage
extends SolMessage
implements ObjectMessageIF {
    private static final long serialVersionUID = -617192027978987608L;
    private Serializable mObject = null;
    private transient byte[] mSerializedObject;

    public SolObjectMessage() {
    }

    public SolObjectMessage(BytesXMLMessage message) {
        super(message);
    }

    @Override
    public byte[] getSerializedObject() {
        try {
            this.initializeReading();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return this.mSerializedObject;
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.mObject = null;
    }

    public void setObject(Serializable newObject) throws JMSException {
        if (this.mBodyMode != SolMessage.MessageBodyMode.WriteMode) {
            throw new MessageNotWriteableException("The message is read-only");
        }
        try {
            this.setObjectInternal(newObject);
        }
        catch (IOException e) {
            throw (MessageFormatException)new MessageFormatException("Could not serialize the object: " + e.getMessage()).initCause((Throwable)e);
        }
    }

    private void setObjectInternal(Serializable newObject) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(out);
        objOut.writeObject(newObject);
        objOut.flush();
        this.mSerializedObject = out.toByteArray();
        this.mObject = newObject;
    }

    public Serializable getObject() throws JMSException {
        this.initializeReading();
        return this.mObject;
    }

    private void initializeReading() throws JMSException {
        if (this.mBodyMode == SolMessage.MessageBodyMode.ReadUnloadedMode) {
            this.mBodyMode = SolMessage.MessageBodyMode.ReadLoadedMode;
            try {
                ByteBuffer byteBufferIn = this.mMessage.getAttachmentByteBuffer();
                if (byteBufferIn != null && byteBufferIn.hasArray()) {
                    ByteArrayInputStream bytesIn = new ByteArrayInputStream(byteBufferIn.array());
                    DataInputStream dataIn = new DataInputStream(bytesIn);
                    ThreadContextObjectInputStream objIn = new ThreadContextObjectInputStream(dataIn);
                    this.mSerializedObject = byteBufferIn.array();
                    this.mObject = (Serializable)objIn.readObject();
                    objIn.close();
                }
            }
            catch (Exception e) {
                throw (MessageFormatException)new MessageFormatException("Could not deserialize the object: " + e.getMessage()).initCause((Throwable)e);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.initializeReading();
            out.defaultWriteObject();
        }
        catch (JMSException e) {
            throw (IOException)new IOException("eError serializing object").initCause(e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setObjectInternal(this.mObject);
    }
}

