/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.impl.transaction.xa.XASessionImpl;
import com.solacesystems.jms.SolConnectionIF;
import com.solacesystems.jms.SolSession;
import com.solacesystems.jms.impl.JCSMPXASession;
import com.solacesystems.jms.impl.JMSState;
import com.solacesystems.jms.impl.Validator;
import com.solacesystems.jms.message.SolMessage;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import jakarta.jms.TransactionInProgressException;
import jakarta.jms.XASession;
import javax.transaction.xa.XAResource;

public class SolXASession
extends SolSession
implements XASession {
    private static final String Component = "XASession";
    private final LogWrapper log = new LogWrapper(SolXASession.class);
    protected XASessionImpl mXASession;

    SolXASession(SolConnectionIF connection, JMSState state) throws JMSException {
        super(connection, false, 1, state);
        this.mSessionProps.enableXA();
        this.mAcknowledgeMode = 0;
        try {
            this.mXASession = (XASessionImpl)connection.getProperties().getJCSMPSession().createXASession();
            this.mSessionProps.getUserProperties().put(Component, new JCSMPXASession(this.mXASession));
        }
        catch (JCSMPException e) {
            throw Validator.createJMSException("soljms.operation.session.create", e);
        }
        this.log.setContextInfo(this.getLogContextInfo());
        if (this.log.isDebugEnabled()) {
            this.log.debug("SolXASession created. State: " + (Object)((Object)state));
        }
    }

    public Session getSession() throws JMSException {
        return this;
    }

    public synchronized XAResource getXAResource() {
        try {
            return this.mXASession.getXAResource();
        }
        catch (JCSMPException e) {
            return null;
        }
    }

    @Override
    public void commit() throws JMSException {
        throw new TransactionInProgressException("Can't commit() inside an XASession");
    }

    @Override
    public boolean getTransacted() throws JMSException {
        return super.getTransacted();
    }

    @Override
    public void rollback() throws JMSException {
        throw new TransactionInProgressException("Can't rollback() inside an XASession");
    }

    public void trackMessage(Message message) throws JMSException {
        try {
            this.mXASession.trackMessage(((SolMessage)message).getMessage());
        }
        catch (JCSMPException e) {
            throw Validator.createJMSException("soljms.operation.session.create", e);
        }
    }

    public void setParentSession(XASessionImpl parentSession) {
        this.mXASession.setParent(parentSession);
    }

    @Override
    public String getName() {
        if (this.mXASession != null) {
            return this.mXASession.getName();
        }
        return super.getName();
    }
}

