/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPProperties;
import com.solacesystems.jms.SolDestination;
import com.solacesystems.jms.SolMessageProducerIF;
import com.solacesystems.jms.SolProducerEventListener;
import com.solacesystems.jms.SolProducerEventSource;
import com.solacesystems.jms.SolSession;
import com.solacesystems.jms.SolSessionIF;
import com.solacesystems.jms.encoding.DefaultJMSEncoder;
import com.solacesystems.jms.encoding.JMSEncoder;
import com.solacesystems.jms.impl.DefaultMessageProducerAdapter;
import com.solacesystems.jms.impl.FlowMessageProducerAdapter;
import com.solacesystems.jms.impl.IdGenerator;
import com.solacesystems.jms.impl.JMSState;
import com.solacesystems.jms.impl.MessageProducerAdapter;
import com.solacesystems.jms.impl.MessageProducerAdapterFactory;
import com.solacesystems.jms.impl.SessionProperties;
import com.solacesystems.jms.impl.TransactedMessageProducerAdapter;
import com.solacesystems.jms.impl.Validator;
import com.solacesystems.jms.impl.XAMessageProducerAdapter;
import com.solacesystems.jms.interceptors.MessageProducerInterceptor;
import com.solacesystems.jms.interceptors.impl.SolMessageProducerInterceptingContextImpl;
import com.solacesystems.jms.message.SolMessage;
import com.solacesystems.jms.message.SolMessageFactory;
import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;

public class SolMessageProducer
implements SolMessageProducerIF,
SolProducerEventSource {
    private final LogWrapper log = new LogWrapper(SolMessageProducer.class);
    private static IdGenerator idGenerator = new IdGenerator();
    private static final String Component = "MessageProducer";
    public static JMSEncoder Encoder = DefaultJMSEncoder.getInstance();
    protected SolSessionIF mSession;
    protected SessionProperties mSessionProps;
    protected MessageProducerAdapter mProducer;
    protected int mDeliveryMode;
    protected Destination mDestination;
    protected boolean mDisableMessageId;
    protected boolean mDisableMessageTimestamp;
    protected int mPriority;
    protected long mTimeToLive;
    protected JMSState mState;
    protected boolean mIsXMLPayload;
    protected boolean mDeliverToOne;
    protected boolean mUseDirectMessaging;
    protected boolean mIsDMQEligible;
    protected boolean mIsElidingEligible;
    protected boolean mIsReplyMsg;
    protected String mMessageIDMode;
    private final MessageProducerInterceptor mInterceptor;
    protected boolean messageIDModeAsciiEncodedHash = false;

    SolMessageProducer(SolSessionIF session, Destination destination) throws JMSException {
        this.mSession = session;
        this.mSessionProps = session.getProperties();
        try {
            this.mProducer = MessageProducerAdapterFactory.createMessageProducerAdapter(this.mSessionProps, this.mSession);
        }
        catch (Exception e) {
            throw Validator.createJMSException("soljms.operation.producer.create", e);
        }
        this.mDeliveryMode = this.mSessionProps.getConnectionProperties().getPropertyBean().getDeliveryMode();
        this.mDestination = destination;
        this.mDisableMessageId = false;
        this.mDisableMessageTimestamp = false;
        this.mPriority = 4;
        this.mTimeToLive = 0L;
        this.mState = JMSState.Started;
        this.mIsXMLPayload = this.mSessionProps.getConnectionProperties().getPropertyBean().getXmlPayload();
        this.mDeliverToOne = this.mSessionProps.getConnectionProperties().getPropertyBean().getDeliverToOne();
        this.mUseDirectMessaging = this.mSessionProps.getConnectionProperties().getPropertyBean().getDirectTransport();
        this.mIsDMQEligible = this.mSessionProps.getConnectionProperties().getPropertyBean().getDmqEligible();
        this.mIsElidingEligible = this.mSessionProps.getConnectionProperties().getPropertyBean().getElidingEligible();
        this.mMessageIDMode = this.mSessionProps.getConnectionProperties().getPropertyBean().getMessageIDMode();
        this.mInterceptor = this.mSession.getConnection().getMessageProducerInterceptorInstance();
        if (this.mMessageIDMode != null && this.mMessageIDMode.equals("ASCII_ENCODED_HASH")) {
            this.messageIDModeAsciiEncodedHash = true;
        } else {
            if (this.mMessageIDMode == null || !this.mMessageIDMode.equals("DEFAULT")) {
                this.log.warn("Using default MessageIDMode - Unexpected value for Solace_JMS_MessageIDMode  was: " + this.mMessageIDMode + "  priority: ");
            }
            this.messageIDModeAsciiEncodedHash = false;
        }
        this.log.setContextInfo(this.getLogContextInfo());
        if (this.log.isDebugEnabled()) {
            this.log.debug("SolMessageProducer created.  Destination: " + destination);
        }
    }

    protected String getLogContextInfo() {
        if (this.mProducer != null) {
            if (this.mProducer instanceof FlowMessageProducerAdapter) {
                return ((FlowMessageProducerAdapter)this.mProducer).getLogContextInfo();
            }
            if (this.mProducer instanceof TransactedMessageProducerAdapter) {
                return ((TransactedMessageProducerAdapter)this.mProducer).getLogContextInfo();
            }
            if (this.mProducer instanceof XAMessageProducerAdapter) {
                return ((XAMessageProducerAdapter)this.mProducer).getLogContextInfo();
            }
            if (this.mProducer instanceof DefaultMessageProducerAdapter) {
                return ((DefaultMessageProducerAdapter)this.mProducer).getLogContextInfo();
            }
        }
        return "";
    }

    @Override
    public void close() throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering close()");
        }
        this.cancel(new JCSMPException("closing producer ..."));
        this.mProducer.close();
        this.mSession.remove(this);
        this.mState = JMSState.Closed;
        if (this.log.isDebugEnabled()) {
            this.log.debug("SolMessageProducer closed");
        }
    }

    @Override
    public void cancel(JCSMPException e) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("cancel() called.  Exception: " + e.getMessage());
        }
        this.mProducer.cancel(e);
    }

    @Override
    public void setProducerEventListener(SolProducerEventListener eventHandler) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setProducerEventListener() called.");
        }
        this.mProducer.setProducerEventListener(eventHandler);
    }

    public synchronized int getDeliveryMode() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return this.mDeliveryMode;
    }

    public synchronized Destination getDestination() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return this.mDestination;
    }

    public synchronized boolean getDisableMessageID() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return this.mDisableMessageId;
    }

    public synchronized boolean getDisableMessageTimestamp() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return this.mDisableMessageTimestamp;
    }

    public synchronized int getPriority() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return this.mPriority;
    }

    public synchronized long getTimeToLive() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return this.mTimeToLive;
    }

    public void send(Message message) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering send()");
        }
        Validator.checkClosed(this.mState, Component);
        Validator.checkSendDestination(this.mSessionProps.getConnectionProperties().getRouterCapabilities().crMode(), this.mDestination, null);
        Validator.checkMessage(message);
        this.sendMessage(this.mDestination, message, this.mDeliveryMode, this.mPriority, this.mTimeToLive);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving send()");
        }
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering send()");
        }
        Validator.checkClosed(this.mState, Component);
        Validator.checkSendDestination(this.mSessionProps.getConnectionProperties().getRouterCapabilities().crMode(), this.mDestination, null);
        Validator.checkMessage(message);
        Validator.checkDeliveryMode(deliveryMode);
        Validator.checkPriority(priority);
        this.sendMessage(this.mDestination, message, deliveryMode, priority, timeToLive);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving send()");
        }
    }

    public void send(Destination destination, Message message) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering send()");
        }
        Validator.checkClosed(this.mState, Component);
        Destination destinationToUse = Validator.checkSendDestination(this.mSessionProps.getConnectionProperties().getRouterCapabilities().crMode(), this.mDestination, destination);
        Validator.checkMessage(message);
        this.sendMessage(destinationToUse, message, this.mDeliveryMode, this.mPriority, this.mTimeToLive);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving send()");
        }
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering send()");
        }
        Validator.checkClosed(this.mState, Component);
        Destination destinationToUse = Validator.checkSendDestination(this.mSessionProps.getConnectionProperties().getRouterCapabilities().crMode(), this.mDestination, destination);
        Validator.checkMessage(message);
        Validator.checkDeliveryMode(deliveryMode);
        Validator.checkPriority(priority);
        this.sendMessage(destinationToUse, message, deliveryMode, priority, timeToLive);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving send()");
        }
    }

    public synchronized void setDeliveryMode(int deliveryMode) throws JMSException {
        Validator.checkClosed(this.mState, Component);
        Validator.checkDeliveryMode(deliveryMode);
        this.mDeliveryMode = deliveryMode;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Delivery mode is now " + this.mDeliveryMode);
        }
    }

    public synchronized void setDisableMessageID(boolean value) throws JMSException {
        Validator.checkClosed(this.mState, Component);
        this.mDisableMessageId = value;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Disable Message Id is now " + value);
        }
    }

    public synchronized void setDisableMessageTimestamp(boolean value) throws JMSException {
        Validator.checkClosed(this.mState, Component);
        this.mDisableMessageTimestamp = value;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Disable message timestamp is now " + value);
        }
    }

    public synchronized void setPriority(int defaultPriority) throws JMSException {
        Validator.checkClosed(this.mState, Component);
        Validator.checkPriority(defaultPriority);
        this.mPriority = defaultPriority;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Priority is now " + this.mPriority);
        }
    }

    public synchronized void setTimeToLive(long timeToLive) throws JMSException {
        Validator.checkClosed(this.mState, Component);
        Validator.checkTimeToLive(timeToLive);
        this.mTimeToLive = timeToLive;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Time to live is now " + timeToLive);
        }
    }

    @Override
    public boolean deliverToOne() {
        return this.mDeliverToOne;
    }

    @Override
    public boolean isDMQEligible() {
        return this.mIsDMQEligible;
    }

    @Override
    public boolean isElidingEligible() {
        return this.mIsElidingEligible;
    }

    @Override
    public boolean isXMLPayload() {
        return this.mIsXMLPayload;
    }

    @Override
    public boolean useDirectMessaging() {
        return this.mUseDirectMessaging;
    }

    @Override
    public boolean isReplyMessage() {
        return this.mIsReplyMsg;
    }

    protected void sendMessage(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        try {
            long currentTime = 0L;
            SolMessage solMsg = SolMessageFactory.getSolMessage(message, (SolSession)this.mSession, this.mInterceptor != null);
            solMsg.setJMSPriority(priority);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Entering sendMessage.  Destination: " + (destination == null ? "null" : destination.toString()) + "  delivery mode: " + deliveryMode + "  priority: " + solMsg.getJMSPriority() + "  timeToLive: " + timeToLive);
            }
            if (!this.mDisableMessageId) {
                if (this.messageIDModeAsciiEncodedHash) {
                    solMsg.setJMSMessageID("ID:" + idGenerator.generateShortId());
                } else {
                    solMsg.setJMSMessageID("ID:" + idGenerator.generateId());
                }
            }
            if (!this.mDisableMessageTimestamp) {
                currentTime = System.currentTimeMillis();
                solMsg.setJMSTimestamp(currentTime);
            }
            if (timeToLive > 0L) {
                if (currentTime == 0L) {
                    currentTime = System.currentTimeMillis();
                }
                solMsg.setJMSExpiration(currentTime + timeToLive);
            }
            solMsg.setJMSDestination(destination);
            solMsg.setJMSDeliveryMode(deliveryMode);
            boolean isXML = this.mIsXMLPayload;
            if (solMsg.isXML() != null) {
                isXML = solMsg.isXML();
            }
            boolean isDTO = this.mDeliverToOne;
            if (solMsg.isDTO() != null) {
                isDTO = solMsg.isDTO();
            }
            boolean isReplyMsg = this.mIsReplyMsg;
            if (solMsg.isReplyMsg() != null) {
                isReplyMsg = solMsg.isReplyMsg();
            }
            boolean isDMQEligible = this.mIsDMQEligible;
            if (solMsg.isDMQEligible() != null) {
                isDMQEligible = solMsg.isDMQEligible();
            }
            boolean isElidingEligible = this.mIsElidingEligible;
            if (solMsg.isElidingEligible() != null) {
                isElidingEligible = solMsg.isElidingEligible();
            }
            if (this.mSession.getConnection().getProperties().getPropertyBean().getJMSXUserIDEnabled().booleanValue()) {
                JCSMPProperties jcsmpProps = this.mSession.getConnection().getJCSMPProperties();
                if (jcsmpProps.getStringProperty("AUTHENTICATION_SCHEME").equals("AUTHENTICATION_SCHEME_BASIC")) {
                    solMsg.setObjectPropertyWithoutReadOnlyCheck("JMSXUserID", jcsmpProps.getStringProperty("username"));
                } else if (solMsg.getStringProperty("JMSXUserID") != null) {
                    solMsg.removeProperty("JMSXUserID");
                }
            }
            if (this.mInterceptor != null) {
                SolMessageProducerInterceptingContextImpl interceptor_context = new SolMessageProducerInterceptingContextImpl(this, solMsg);
                solMsg.clearPropertyReadOnlyFlag();
                this.mInterceptor.onPrePublish(interceptor_context);
                solMsg = (SolMessage)interceptor_context.getMessage();
            }
            BytesXMLMessage jcsmpMessage = Encoder.encode(this.mProducer, solMsg, isXML, isDTO, this.mUseDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
            this.mProducer.send(jcsmpMessage, ((SolDestination)destination).getJCSMPDestination());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Leaving sendMessage()");
            }
        }
        catch (Throwable t) {
            throw Validator.createJMSException("soljms.operation.send", t);
        }
    }

    public void send(Message message, CompletionListener completionListener) throws JMSException {
        throw new UnsupportedOperationException("send(Message, CompletionListener) is not supported");
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        throw new UnsupportedOperationException("send(Message, int, int, long, CompletionListener) is not supported");
    }

    public void send(Destination destination, Message message, CompletionListener completionListener) throws JMSException {
        throw new UnsupportedOperationException("send(Destination, Message, CompletionListener) is not supported");
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        throw new UnsupportedOperationException("send(Destination, Message, int, int, long, CompletionListener) is not supported");
    }

    public long getDeliveryDelay() throws JMSException {
        return -1L;
    }

    public void setDeliveryDelay(long deliveryDelay) throws JMSException {
        this.log.warn("setDeliveryDelay(long) is not supported ");
    }
}

