/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.jms.SolEventListener;
import com.solacesystems.jms.SolEventSource;
import com.solacesystems.jms.events.SolEvent;

public class SolEventFilter {
    protected long mEventTypeMask;
    protected SolEventSource mSource;
    protected SolEventListener mListener;

    SolEventFilter(SolEventSource source, SolEventListener listener, long eventTypeMask) {
        this.mEventTypeMask = eventTypeMask;
        this.mSource = source;
        this.mListener = listener;
    }

    public void onEvent(SolEvent event) {
        if ((event.getEventType() & this.mEventTypeMask) != 0L) {
            this.mListener.handleEvent(this.mSource, event);
        }
    }

    public SolEventSource getSource() {
        return this.mSource;
    }

    public SolEventListener getListener() {
        return this.mListener;
    }

    public long getEventMask() {
        return this.mEventTypeMask;
    }

    public void addEventType(long eventTypeMask) {
        this.mEventTypeMask |= eventTypeMask;
    }

    public void removeEventType(long eventTypeMask) {
        this.mEventTypeMask &= eventTypeMask ^ 0xFFFFFFFFFFFFFFFFL;
    }
}

