/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf;

import com.solace.transport.SolTransport;
import com.solace.transport.TransportInboundFrameDecoder;
import com.solacesystems.common.util.BitTwiddleUtil;
import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.WireMessagePool;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.smf.SMFWireMessageHandler;
import com.solacesystems.jcsmp.protocol.smf.TransportWireMessageHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class SMFFrameHandler
implements TransportInboundFrameDecoder {
    private final LogWrapper Trace = new LogWrapper(SMFFrameHandler.class);
    private final int HEADER_LENGTH = 12;
    private final int MESSAGE_LENTH_INDEX_VERSION_2 = 4;
    private final int MESSAGE_LENTH_INDEX_VERSION_3 = 8;
    private int byte_to_read = 12;
    private Parser_State state = Parser_State.READ_HEADER;
    private final SMFWireMessageHandler smfWireMessageHandler = new SMFWireMessageHandler();
    private final boolean needRxTimestamp;
    private final TransportWireMessageHandler callback;

    SMFFrameHandler(boolean needRxTimestamp, TransportWireMessageHandler handler) {
        this.needRxTimestamp = needRxTimestamp;
        this.callback = handler;
    }

    private void dumpData(String msg, ByteBuf buf, Exception ex) {
        if (this.Trace.isErrorEnabled()) {
            this.Trace.error(msg, ex);
        }
        int cnt = 0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < buf.readableBytes(); ++i) {
            if (cnt >= 16) {
                sb.append("\n");
                cnt = 1;
            } else {
                ++cnt;
            }
            sb.append(String.format("%02X ", buf.getByte(i)));
        }
        if (this.Trace.isErrorEnabled()) {
            this.Trace.error(sb.toString());
        }
    }

    @Override
    public void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        ByteBufInputStream in = new ByteBufInputStream(buf);
        int offset = 0;
        while (buf.readableBytes() >= this.byte_to_read) {
            if (this.state == Parser_State.READ_HEADER) {
                int length;
                int version = (int)BitTwiddleUtil.extractBits(buf.getInt(offset), 3L, 24L);
                switch (version) {
                    case 2: {
                        length = buf.getInt(4 + offset);
                        break;
                    }
                    case 3: {
                        length = buf.getInt(8 + offset);
                        break;
                    }
                    default: {
                        IOException ex = new IOException(JCSMPRB.BUNDLE.getStringSafely("SMFHeaderDecoder.couldNotReadValidSmfHeaderFromNet") + " found smf version=" + String.valueOf(version));
                        this.dumpData("Lost Frame Error", buf, ex);
                        buf.clear();
                        throw ex;
                    }
                }
                this.byte_to_read = length;
                this.state = Parser_State.READ_MESSAGE;
                if (buf.readableBytes() < length) {
                    return;
                }
            }
            if (this.state != Parser_State.READ_MESSAGE) continue;
            long timestamp = System.currentTimeMillis();
            WireMessage wm = WireMessagePool.getInstance().getWireMessage();
            this.smfWireMessageHandler.readMessage((InputStream)in, wm);
            if (this.needRxTimestamp) {
                wm.setRxTimestamp(timestamp);
            }
            this.callback.onMessage(wm);
            this.updateBytesRecvedStats(ctx, this.byte_to_read);
            this.state = Parser_State.READ_HEADER;
            offset += this.byte_to_read;
            this.byte_to_read = 12;
        }
        buf.discardReadBytes();
    }

    private void updateBytesRecvedStats(ChannelHandlerContext ctx, long v) {
        AttributeKey attr_key = AttributeKey.valueOf((String)SolTransport.Stats.TOTAL_SOCKET_BYTES_RECVED.getNameValue());
        ctx.channel().attr(attr_key).set((Object)((Long)ctx.channel().attr(attr_key).get() + v));
    }

    static enum Parser_State {
        READ_HEADER,
        READ_MESSAGE;

    }
}

