/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.nio.impl;

import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPStreamingPublishCorrelatingEventHandler;
import com.solacesystems.jcsmp.JCSMPStreamingPublishEventHandler;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageProducer;
import com.solacesystems.jcsmp.impl.MsgIdInfo;
import com.solacesystems.jcsmp.protocol.nio.Notification;
import com.solacesystems.jcsmp.protocol.nio.impl.AbstractNotification;
import com.solacesystems.jcsmp.statistics.StatType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProducerErrorNotification
extends AbstractNotification
implements Notification {
    private static final Log log = LogFactory.getLog(ProducerErrorNotification.class);
    private JCSMPStreamingPublishEventHandler _handler;
    private JCSMPException _cause;
    private MsgIdInfo _msgInfo;
    private long _timestamp;
    private JCSMPXMLMessageProducer _producer;
    private boolean _forceNotifyIfClosed;

    public ProducerErrorNotification(JCSMPStreamingPublishEventHandler handler, MsgIdInfo msgInfo, JCSMPException cause, long timestamp, JCSMPXMLMessageProducer producer, boolean forceNotifyIfClosed) {
        this._handler = handler;
        this._msgInfo = msgInfo;
        this._cause = cause;
        this._timestamp = timestamp;
        this._producer = producer;
        this._forceNotifyIfClosed = forceNotifyIfClosed;
    }

    @Override
    public int handleNotification() {
        if (this._handler != null && !this.is_canceled()) {
            if (this._handler != this._producer.getStreamingCallbackHandlerInternal()) {
                log.info((Object)"Streaming publish event handler has been changed, abort notify");
            } else if (this._forceNotifyIfClosed || this._producer.isOpenInternal()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Notify exception during publishing " + (this._msgInfo.getMsgId() == null ? "0" : this._msgInfo.getMsgId()) + ": " + this._cause.getMessage()));
                }
                if (this._handler instanceof JCSMPStreamingPublishCorrelatingEventHandler) {
                    ((JCSMPStreamingPublishCorrelatingEventHandler)this._handler).handleErrorEx(this._msgInfo.getCorrKey(), this._cause, this._timestamp);
                } else {
                    this._handler.handleError(this._msgInfo.getMsgId() == null ? "0" : this._msgInfo.getMsgId(), this._cause, this._timestamp);
                }
                this._producer.getSessionStats().incStat(StatType.TOTAL_ERROR_RESPONSE_CALLBACKS);
            } else {
                log.info((Object)"Producer is closed, abort notify.");
            }
        } else {
            log.info((Object)("Streaming publish event handler is null for msgId " + this._msgInfo.getMsgId()));
        }
        return 0;
    }

    @Override
    public boolean usesHandler(JCSMPStreamingPublishEventHandler handler) {
        return this._handler == handler;
    }

    @Override
    public boolean usesListener(XMLMessageListener listener) {
        return false;
    }
}

