/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.sdt;

import com.solacesystems.common.util.ByteArray;
import com.solacesystems.common.util.SolByteBuffer;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.Queue;
import com.solacesystems.jcsmp.RawSMFMessage;
import com.solacesystems.jcsmp.SDTEOFException;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.SDTStream;
import com.solacesystems.jcsmp.SDTUnknownType;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.impl.AbstractDestination;
import com.solacesystems.jcsmp.impl.QueueImpl;
import com.solacesystems.jcsmp.impl.RawSMFMessageImpl;
import com.solacesystems.jcsmp.impl.TopicImpl;
import com.solacesystems.jcsmp.impl.sdt.MapImpl;
import com.solacesystems.jcsmp.impl.sdt.MapTLVBuffer;
import com.solacesystems.jcsmp.impl.sdt.StreamImpl;
import com.solacesystems.jcsmp.impl.sdt.StreamTLVBuffer;
import com.solacesystems.jcsmp.impl.sdt.TLVUnsupportedException;
import com.solacesystems.jcsmp.impl.sdt.UnsupportedTLV;
import java.io.EOFException;
import java.math.BigInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TLVBuffer {
    private static final Log Trace = LogFactory.getLog(TLVBuffer.class);
    public static final byte NULL_TAG = 0;
    public static final byte BOOLEAN_TAG = 1;
    public static final byte INTEGER_TAG = 2;
    public static final byte UINTEGER_TAG = 3;
    public static final byte FLOAT_TAG = 4;
    public static final byte CHARACTER_TAG = 5;
    public static final byte BYTE_ARRAY_TAG = 6;
    public static final byte STRING_TAG = 7;
    public static final byte DESTINATION_TAG = 8;
    public static final byte SMF_MESSAGE_TAG = 9;
    public static final byte MAP_TAG = 10;
    public static final byte STREAM_TAG = 11;
    public static final byte UNSUPPORTED_TAG = 63;
    public static final byte LENGTH_BYTES_MASK = 3;
    public static final byte ONE_LENGTH_BYTE = 0;
    public static final byte TWO_LENGTH_BYTES = 1;
    public static final byte THREE_LENGTH_BYTES = 2;
    public static final byte FOUR_LENGTH_BYTES = 3;
    public static final byte TOPIC_DESTINATION = 0;
    public static final byte QUEUE_DESTINATION = 1;
    public static final short MAX_UBYTE = 255;
    public static final int MAX_USHORT = 65535;
    public static final int MAX_UTHRINT = 0xFFFFFF;
    public static final long MAX_UINT = 0xFFFFFFFFL;
    public static final BigInteger MAX_ULONG = new BigInteger("18446744073709551615");
    public static final int MAX_ONE_BYTE_LENGTH = 253;
    public static final int MAX_TWO_BYTE_LENGTH = 65532;
    public static final int MAX_THREE_BYTE_LENGTH = 0xFFFFFB;
    public static final byte[] EMPTY_SDT = new byte[]{0, 0, 0, 5};
    protected SolByteBuffer mBuffer;

    public TLVBuffer(int capacity) {
        this.mBuffer = new SolByteBuffer(capacity);
    }

    public TLVBuffer(byte[] data) {
        this.mBuffer = new SolByteBuffer(data, 0);
    }

    public TLVBuffer(ByteArray data) {
        this.mBuffer = new SolByteBuffer(data);
    }

    public TLVBuffer(TLVBuffer toclone) {
        this.mBuffer = toclone.mBuffer == null ? null : new SolByteBuffer(toclone.mBuffer);
    }

    public SolByteBuffer getSolByteBuffer() {
        return this.mBuffer;
    }

    public ByteArray asByteArray() {
        return this.mBuffer.asByteArray();
    }

    public void mark() {
        this.mBuffer.mark();
    }

    public void reset() {
        this.mBuffer.reset();
    }

    public void rewind() {
        this.mBuffer.rewind();
    }

    public void clear() {
        this.mBuffer.clear();
    }

    public boolean hasRemaining() {
        return this.mBuffer.hasRemaining();
    }

    public void skip(int num) throws SDTEOFException {
        try {
            this.mBuffer.skipRead(num);
        }
        catch (EOFException e) {
            throw new SDTEOFException("unexpected end of buffer reached", e);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof TLVBuffer) {
            TLVBuffer other = (TLVBuffer)obj;
            return this.mBuffer.equals(other.mBuffer);
        }
        return false;
    }

    public int hashCode() {
        return this.mBuffer.hashCode();
    }

    public Object read() throws SDTEOFException {
        int tag = 0;
        long tlvLength = 0L;
        try {
            Object retObj = null;
            short byte0 = this.mBuffer.readUByte();
            tag = this.decodeTag(byte0);
            int lengthBytes = this.decodeNumLengthBytes(byte0);
            tlvLength = lengthBytes == 1 ? (long)this.mBuffer.readUByte() : (lengthBytes == 2 ? (long)this.mBuffer.readUShort() : (lengthBytes == 3 ? (long)this.mBuffer.readUThrint() : this.mBuffer.readUInt()));
            if (tlvLength < 2L) {
                if (Trace.isErrorEnabled()) {
                    Trace.error((Object)("TLV length too short - " + tlvLength));
                }
                this.mBuffer.skipToEnd();
                throw new SDTEOFException("unexpected end of data reached");
            }
            if (tlvLength > Integer.MAX_VALUE) {
                if (Trace.isErrorEnabled()) {
                    Trace.error((Object)("TLV length too long - " + tlvLength));
                }
                this.mBuffer.skipToEnd();
                throw new SDTEOFException("unexpected end of data reached");
            }
            int valueLength = (int)tlvLength - (lengthBytes + 1);
            if (valueLength > this.mBuffer.remaining()) {
                this.mBuffer.skipToEnd();
                throw new SDTEOFException("unexpected end of data reached");
            }
            if (tag == 0) {
                retObj = this.readNull(valueLength);
            } else if (tag == 1) {
                retObj = this.readBoolean(valueLength);
            } else if (tag == 2) {
                retObj = this.readInteger(valueLength);
            } else if (tag == 3) {
                retObj = this.readUInteger(valueLength);
            } else if (tag == 4) {
                retObj = this.readFloat(valueLength);
            } else if (tag == 5) {
                retObj = this.readCharacter(valueLength);
            } else if (tag == 6) {
                retObj = this.readByteArray(valueLength);
            } else if (tag == 7) {
                retObj = this.readString(valueLength);
            } else if (tag == 8) {
                retObj = this.readDestination(valueLength);
            } else if (tag == 9) {
                retObj = this.readSMFMessage(valueLength);
            } else if (tag == 10) {
                retObj = this.readMap(lengthBytes, valueLength);
            } else if (tag == 11) {
                retObj = this.readStream(lengthBytes, valueLength);
            } else {
                this.mBuffer.skipRead(valueLength);
                throw new TLVUnsupportedException(UnsupportedTLV.Reason.UnsupportedTag);
            }
            return retObj;
        }
        catch (EOFException e) {
            throw new SDTEOFException("unexpected end of data reached", e);
        }
        catch (TLVUnsupportedException e) {
            return new UnsupportedTLV(e.getReason(), (byte)tag, e.getMessage(), new ByteArray(this.asByteArray().getBuffer(), this.mBuffer.readPosition() - (int)tlvLength, (int)tlvLength));
        }
    }

    public int write(Object value) {
        if (value == null) {
            return this.writeNull();
        }
        if (value instanceof Boolean) {
            return this.write((Boolean)value);
        }
        if (value instanceof Byte) {
            return this.write((Byte)value);
        }
        if (value instanceof byte[]) {
            return this.write((byte[])value);
        }
        if (value instanceof ByteArray) {
            return this.write((ByteArray)value);
        }
        if (value instanceof Short) {
            return this.write((Short)value);
        }
        if (value instanceof Integer) {
            return this.write((Integer)value);
        }
        if (value instanceof Long) {
            return this.write((Long)value);
        }
        if (value instanceof Float) {
            return this.write((Float)value);
        }
        if (value instanceof Double) {
            return this.write((Double)value);
        }
        if (value instanceof Character) {
            return this.write((Character)value);
        }
        if (value instanceof String) {
            return this.write((String)value);
        }
        if (value instanceof SDTMap) {
            return this.write((SDTMap)value);
        }
        if (value instanceof SDTStream) {
            return this.write((SDTStream)value);
        }
        if (value instanceof Destination) {
            return this.write((Destination)value);
        }
        if (value instanceof RawSMFMessage) {
            return this.write((RawSMFMessage)value);
        }
        if (value instanceof SDTUnknownType) {
            return this.write((SDTUnknownType)value);
        }
        if (value instanceof BigInteger) {
            return this.writeUnsigned((BigInteger)value);
        }
        throw new IllegalArgumentException("Error encoding type " + value.getClass().getSimpleName());
    }

    public int write(Boolean value) {
        if (value == null) {
            return this.writeNull();
        }
        int tlvLength = this.writeTagAndLength((byte)1, 1);
        if (value.booleanValue()) {
            this.mBuffer.writeByte((byte)1);
        } else {
            this.mBuffer.writeByte((byte)0);
        }
        this.updateLength();
        return tlvLength;
    }

    public int write(Byte value) {
        if (value == null) {
            return this.writeNull();
        }
        int tlvLength = this.writeTagAndLength((byte)2, 1);
        this.mBuffer.writeByte(value);
        this.updateLength();
        return tlvLength;
    }

    public int write(Short value) {
        if (value == null) {
            return this.writeNull();
        }
        int tlvLength = this.writeTagAndLength((byte)2, 2);
        this.mBuffer.writeShort(value);
        this.updateLength();
        return tlvLength;
    }

    public int write(Integer value) {
        if (value == null) {
            return this.writeNull();
        }
        int tlvLength = this.writeTagAndLength((byte)2, 4);
        this.mBuffer.writeInt(value);
        this.updateLength();
        return tlvLength;
    }

    public int write(Long value) {
        if (value == null) {
            return this.writeNull();
        }
        int tlvLength = this.writeTagAndLength((byte)2, 8);
        this.mBuffer.writeLong(value);
        this.updateLength();
        return tlvLength;
    }

    public int write(Float value) {
        if (value == null) {
            return this.writeNull();
        }
        int tlvLength = this.writeTagAndLength((byte)4, 4);
        this.mBuffer.writeFloat(value.floatValue());
        this.updateLength();
        return tlvLength;
    }

    public int write(Double value) {
        if (value == null) {
            return this.writeNull();
        }
        int tlvLength = this.writeTagAndLength((byte)4, 8);
        this.mBuffer.writeDouble(value);
        this.updateLength();
        return tlvLength;
    }

    public int write(Character value) {
        if (value == null) {
            return this.writeNull();
        }
        int tlvLength = this.writeTagAndLength((byte)5, 2);
        this.mBuffer.writeChar(value.charValue());
        this.updateLength();
        return tlvLength;
    }

    public int write(byte[] value) {
        if (value == null) {
            return this.writeNull();
        }
        int tlvLength = this.writeTagAndLength((byte)6, value.length);
        this.mBuffer.writeBytes(value);
        this.updateLength();
        return tlvLength;
    }

    public int write(byte[] value, int offset, int length) {
        if (value == null) {
            return this.writeNull();
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset cannot be less than 0");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length cannot be less than 0");
        }
        if (length > 0) {
            if (offset >= value.length) {
                throw new IllegalArgumentException("incompatible offset for byte array length");
            }
            if (offset + length > value.length) {
                throw new IllegalArgumentException("incompatible offset/length for byte array length");
            }
        }
        int tlvLength = this.writeTagAndLength((byte)6, length);
        if (length > 0) {
            this.mBuffer.writeBytes(value, offset, length);
        }
        this.updateLength();
        return tlvLength;
    }

    public int write(ByteArray value) {
        if (value == null) {
            return this.writeNull();
        }
        int tlvlen = this.write(value.getBuffer(), value.getOffset(), value.getLength());
        this.updateLength();
        return tlvlen;
    }

    public int write(String value) {
        int tlvlen;
        if (value == null) {
            return this.writeNull();
        }
        this.mBuffer.writeMark();
        int maxutflen = 6 * value.length() + 1;
        if (maxutflen <= 253) {
            this.writeTag((byte)7, (byte)0);
            this.mBuffer.skipWrite(1);
            int utflen = this.writeUTF8(value);
            this.mBuffer.writeByte((byte)0);
            tlvlen = 2 + utflen + 1;
            this.mBuffer.writeUByte(this.mBuffer.getWriteMark() + 1, (short)tlvlen);
        } else if (maxutflen <= 65532) {
            this.writeTag((byte)7, (byte)1);
            this.mBuffer.skipWrite(2);
            int utflen = this.writeUTF8(value);
            this.mBuffer.writeByte((byte)0);
            tlvlen = 3 + utflen + 1;
            this.mBuffer.writeUShort(this.mBuffer.getWriteMark() + 1, tlvlen);
        } else if (maxutflen <= 0xFFFFFB) {
            this.writeTag((byte)7, (byte)2);
            this.mBuffer.skipWrite(3);
            int utflen = this.writeUTF8(value);
            this.mBuffer.writeByte((byte)0);
            tlvlen = 4 + utflen + 1;
            this.mBuffer.writeUThrint(this.mBuffer.getWriteMark() + 1, tlvlen);
        } else {
            this.writeTag((byte)7, (byte)3);
            this.mBuffer.skipWrite(4);
            int utflen = this.writeUTF8(value);
            this.mBuffer.writeByte((byte)0);
            tlvlen = 5 + utflen + 1;
            this.mBuffer.writeUInt(this.mBuffer.getWriteMark() + 1, tlvlen);
        }
        this.updateLength();
        return tlvlen;
    }

    public int write(RawSMFMessage value) {
        if (value == null) {
            return this.writeNull();
        }
        ByteArray ba = value.getData();
        int tlvLength = this.writeTagAndLength((byte)9, ba.getLength());
        this.mBuffer.writeBytes(ba);
        this.updateLength();
        return tlvLength;
    }

    public int write(SDTMap value) {
        if (value == null) {
            return this.writeNull();
        }
        ByteArray ba = ((MapImpl)value).asByteArray();
        this.mBuffer.writeBytes(ba);
        this.updateLength();
        return ba.getLength();
    }

    public int write(SDTStream value) {
        if (value == null) {
            return this.writeNull();
        }
        ByteArray ba = ((StreamImpl)value).asByteArray();
        this.mBuffer.writeBytes(ba);
        this.updateLength();
        return ba.getLength();
    }

    public int write(Destination value) {
        int tlvlen;
        if (value == null) {
            return this.writeNull();
        }
        String physicalName = ((AbstractDestination)value).getName();
        this.mBuffer.writeMark();
        int maxutflen = 3 * physicalName.length() + 2;
        if (maxutflen <= 253) {
            this.writeTag((byte)8, (byte)0);
            this.mBuffer.skipWrite(1);
            tlvlen = this.writeDestinationValue(value) + 2;
            this.mBuffer.writeUByte(this.mBuffer.getWriteMark() + 1, (short)tlvlen);
        } else if (maxutflen <= 65532) {
            this.writeTag((byte)8, (byte)1);
            this.mBuffer.skipWrite(2);
            tlvlen = this.writeDestinationValue(value) + 3;
            this.mBuffer.writeUShort(this.mBuffer.getWriteMark() + 1, tlvlen);
        } else if (maxutflen <= 0xFFFFFB) {
            this.writeTag((byte)8, (byte)2);
            this.mBuffer.skipWrite(3);
            tlvlen = this.writeDestinationValue(value) + 4;
            this.mBuffer.writeUThrint(this.mBuffer.getWriteMark() + 1, tlvlen);
        } else {
            this.writeTag((byte)8, (byte)3);
            this.mBuffer.skipWrite(4);
            tlvlen = this.writeDestinationValue(value) + 5;
            this.mBuffer.writeUInt(this.mBuffer.getWriteMark() + 1, tlvlen);
        }
        this.updateLength();
        return tlvlen;
    }

    public int write(SDTUnknownType value) {
        if (value == null) {
            return this.writeNull();
        }
        ByteArray ba = value.getByteArray();
        this.mBuffer.writeBytes(ba);
        this.updateLength();
        return ba.getLength();
    }

    public int writeUnsigned(Object value) {
        if (value == null) {
            return this.writeNull();
        }
        if (value instanceof Short) {
            return this.writeUnsigned((Short)value);
        }
        if (value instanceof Integer) {
            return this.writeUnsigned((Integer)value);
        }
        if (value instanceof Long) {
            return this.writeUnsigned((Long)value);
        }
        if (value instanceof BigInteger) {
            return this.writeUnsigned((BigInteger)value);
        }
        throw new IllegalArgumentException("Error encoding type " + value.getClass().getSimpleName());
    }

    public int writeUnsigned(Short value) {
        if (value == null) {
            return this.writeNull();
        }
        int tlvLength = this.writeTagAndLength((byte)3, 1);
        this.mBuffer.writeUByte(value);
        this.updateLength();
        return tlvLength;
    }

    public int writeUnsigned(Integer value) {
        if (value == null) {
            return this.writeNull();
        }
        int tlvLength = this.writeTagAndLength((byte)3, 2);
        this.mBuffer.writeUShort(value);
        this.updateLength();
        return tlvLength;
    }

    public int writeUnsigned(Long value) {
        if (value == null) {
            return this.writeNull();
        }
        int tlvLength = this.writeTagAndLength((byte)3, 4);
        this.mBuffer.writeUInt(value);
        this.updateLength();
        return tlvLength;
    }

    public int writeUnsigned(BigInteger value) {
        if (value == null) {
            return this.writeNull();
        }
        if (value.compareTo(BigInteger.ZERO) < 0 || value.compareTo(MAX_ULONG) > 0) {
            throw new IllegalArgumentException("unsigned long value out of range (" + value + ")");
        }
        int tlvLength = this.writeTagAndLength((byte)3, 8);
        this.mBuffer.writeULong(value);
        this.updateLength();
        return tlvLength;
    }

    public int writeRawByte(byte b) {
        this.mBuffer.writeByte(b);
        this.updateLength();
        return 1;
    }

    protected Object readNull(int length) throws TLVUnsupportedException, EOFException {
        if (length == 0) {
            return null;
        }
        this.mBuffer.skipRead(length);
        throw new TLVUnsupportedException(UnsupportedTLV.Reason.UnsupportedLength);
    }

    protected Object readBoolean(int length) throws TLVUnsupportedException, EOFException {
        if (length == 1) {
            byte boolByte = this.mBuffer.readByte();
            if (boolByte == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        this.mBuffer.skipRead(length);
        throw new TLVUnsupportedException(UnsupportedTLV.Reason.UnsupportedLength);
    }

    protected Object readInteger(int length) throws TLVUnsupportedException, EOFException {
        if (length == 1) {
            return this.mBuffer.readByte();
        }
        if (length == 2) {
            return this.mBuffer.readShort();
        }
        if (length == 4) {
            return this.mBuffer.readInt();
        }
        if (length == 8) {
            return this.mBuffer.readLong();
        }
        this.mBuffer.skipRead(length);
        throw new TLVUnsupportedException(UnsupportedTLV.Reason.UnsupportedLength);
    }

    protected Object readUInteger(int length) throws TLVUnsupportedException, EOFException {
        if (length == 1) {
            return this.mBuffer.readUByte();
        }
        if (length == 2) {
            return this.mBuffer.readUShort();
        }
        if (length == 4) {
            return this.mBuffer.readUInt();
        }
        if (length == 8) {
            return this.mBuffer.readULong();
        }
        this.mBuffer.skipRead(length);
        throw new TLVUnsupportedException(UnsupportedTLV.Reason.UnsupportedLength);
    }

    protected Object readFloat(int length) throws TLVUnsupportedException, EOFException {
        if (length == 4) {
            return Float.valueOf(this.mBuffer.readFloat());
        }
        if (length == 8) {
            return this.mBuffer.readDouble();
        }
        this.mBuffer.skipRead(length);
        throw new TLVUnsupportedException(UnsupportedTLV.Reason.UnsupportedLength);
    }

    protected Object readCharacter(int length) throws TLVUnsupportedException, EOFException {
        if (length == 2) {
            return Character.valueOf(this.mBuffer.readChar());
        }
        this.mBuffer.skipRead(length);
        throw new TLVUnsupportedException(UnsupportedTLV.Reason.UnsupportedLength);
    }

    protected Object readByteArray(int length) throws EOFException {
        ByteArray ba = new ByteArray(this.asByteArray().getBuffer(), this.mBuffer.readPosition(), length);
        this.mBuffer.skipRead(length);
        return ba;
    }

    protected Object readString(int length) throws TLVUnsupportedException, EOFException {
        String retVal = null;
        try {
            retVal = this.readUTF8(length - 1);
        }
        catch (TLVUnsupportedException e) {
            if (this.mBuffer.hasRemaining()) {
                this.mBuffer.readByte();
            }
            throw e;
        }
        byte nullByte = this.mBuffer.readByte();
        if (nullByte != 0) {
            throw new TLVUnsupportedException(UnsupportedTLV.Reason.UnsupportedFormat, "No null termination on string");
        }
        return retVal;
    }

    protected Object readDestination(int length) throws TLVUnsupportedException, EOFException {
        if (length >= 2) {
            byte destType = this.mBuffer.readByte();
            if (destType == 0) {
                Object obj = this.readString(length - 1);
                if (obj instanceof String) {
                    return TopicImpl.createFastNoValidation((String)obj);
                }
                return obj;
            }
            if (destType == 1) {
                Object obj = this.readString(length - 1);
                if (obj instanceof String) {
                    return QueueImpl.createFastNoValidation((String)obj);
                }
                return obj;
            }
            this.mBuffer.skipRead(length - 1);
            throw new TLVUnsupportedException(UnsupportedTLV.Reason.UnsupportedFormat, "Unsupported destination type");
        }
        this.mBuffer.skipRead(length);
        throw new TLVUnsupportedException(UnsupportedTLV.Reason.UnsupportedLength, "Unsupported destination length");
    }

    protected Object readSMFMessage(int length) throws EOFException {
        RawSMFMessageImpl msg = new RawSMFMessageImpl(new ByteArray(this.asByteArray().getBuffer(), this.mBuffer.readPosition(), length));
        this.mBuffer.skipRead(length);
        return msg;
    }

    protected Object readMap(int lengthBytes, int length) throws EOFException, TLVUnsupportedException {
        if (length == 0) {
            return new MapImpl(1);
        }
        if (lengthBytes == 4) {
            int preambleLen = lengthBytes + 1;
            ByteArray mapBA = new ByteArray(this.asByteArray().getBuffer(), this.mBuffer.readPosition() - preambleLen, length + preambleLen);
            MapImpl map = new MapImpl(new MapTLVBuffer(mapBA));
            this.mBuffer.skipRead(length);
            return map;
        }
        this.mBuffer.skipRead(length);
        throw new TLVUnsupportedException(UnsupportedTLV.Reason.UnsupportedLength);
    }

    protected Object readStream(int lengthBytes, int length) throws EOFException, TLVUnsupportedException {
        if (length == 0) {
            return new StreamImpl(1);
        }
        if (lengthBytes == 4) {
            int preambleLen = lengthBytes + 1;
            ByteArray strBA = new ByteArray(this.asByteArray().getBuffer(), this.mBuffer.readPosition() - preambleLen, length + preambleLen);
            StreamImpl stream = new StreamImpl(new StreamTLVBuffer(strBA));
            this.mBuffer.skipRead(length);
            return stream;
        }
        this.mBuffer.skipRead(length);
        throw new TLVUnsupportedException(UnsupportedTLV.Reason.UnsupportedLength);
    }

    protected String readUTF8(int length) throws TLVUnsupportedException, EOFException {
        StringBuffer str = new StringBuffer(length);
        byte c = 0;
        int index = 0;
        while (index < length) {
            boolean badUTF8 = false;
            try {
                int char5;
                int char4;
                int char1;
                int char3;
                int char2;
                c = this.mBuffer.readByte();
                if (c > 0 && c <= 127) {
                    ++index;
                    str.append((char)c);
                } else if ((c & 0xE0) == 192) {
                    char2 = this.mBuffer.readByte();
                    index += 2;
                    if ((char2 & 0xC0) == 128) {
                        str.append((char)((c & 0x1F) << 6 | char2 & 0x3F));
                    } else {
                        badUTF8 = true;
                    }
                } else if ((c & 0xF0) == 224) {
                    char2 = this.mBuffer.readByte();
                    char3 = this.mBuffer.readByte();
                    index += 3;
                    if ((char2 & 0xC0) == 128 && (char3 & 0xC0) == 128) {
                        str.append((char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0));
                    } else {
                        badUTF8 = true;
                    }
                } else if ((c & 0xF8) == 240) {
                    char1 = c & 0xFF;
                    char2 = this.mBuffer.readByte() & 0xFF;
                    char3 = this.mBuffer.readByte() & 0xFF;
                    char4 = this.mBuffer.readByte() & 0xFF;
                    index += 4;
                    if ((char2 & 0xC0) == 128 && (char3 & 0xC0) == 128 && (char4 & 0xC0) == 128) {
                        str.appendCodePoint((char1 & 3) << 18 | (char2 & 0x3F) << 12 | (char3 & 0x3F) << 6 | (char4 & 0x3F) << 0);
                    } else {
                        badUTF8 = true;
                    }
                } else if ((c & 0xFC) == 248) {
                    char1 = c & 0xFF;
                    char2 = this.mBuffer.readByte() & 0xFF;
                    char3 = this.mBuffer.readByte() & 0xFF;
                    char4 = this.mBuffer.readByte() & 0xFF;
                    char5 = this.mBuffer.readByte() & 0xFF;
                    index += 5;
                    if ((char2 & 0xC0) == 128 && (char3 & 0xC0) == 128 && (char4 & 0xC0) == 128 && (char5 & 0xC0) == 128) {
                        str.appendCodePoint((c & 2) << 24 | (char2 & 0x3F) << 18 | (char3 & 0x3F) << 12 | (char4 & 0x3F) << 6 | (char5 & 0x3F) << 0);
                    } else {
                        badUTF8 = true;
                    }
                } else if ((c & 0xFE) == 252) {
                    char1 = c & 0xFF;
                    char2 = this.mBuffer.readByte() & 0xFF;
                    char3 = this.mBuffer.readByte() & 0xFF;
                    char4 = this.mBuffer.readByte() & 0xFF;
                    char5 = this.mBuffer.readByte() & 0xFF;
                    int char6 = this.mBuffer.readByte() & 0xFF;
                    index += 6;
                    if ((char2 & 0xC0) == 128 && (char3 & 0xC0) == 128 && (char4 & 0xC0) == 128 && (char5 & 0xC0) == 128 && (char6 & 0xC0) == 128) {
                        str.appendCodePoint((c & 1) << 30 | (char2 & 0x3F) << 24 | (char3 & 0x3F) << 18 | (char4 & 0x3F) << 12 | (char5 & 0x3F) << 6 | (char6 & 0x3F) << 0);
                    } else {
                        badUTF8 = true;
                    }
                } else {
                    badUTF8 = true;
                }
            }
            catch (IllegalArgumentException e) {
                badUTF8 = true;
            }
            if (!badUTF8) continue;
            this.mBuffer.skipRead(length - index - 1);
            throw new TLVUnsupportedException(UnsupportedTLV.Reason.UnsupportedFormat, String.format("error formatting UTF-8 value %d (0x%2x)", c, c));
        }
        return new String(str);
    }

    protected int writeNull() {
        int tlvLength = this.writeTagAndLength((byte)0, 0);
        this.updateLength();
        return tlvLength;
    }

    public void writeTag(byte tag, byte lengthByte) {
        this.mBuffer.writeUByte((short)(tag << 2 | lengthByte));
    }

    public int writeTagAndLength(byte tag, int length) {
        int tlvLength;
        if (length <= 253) {
            this.writeTag(tag, (byte)0);
            tlvLength = length + 2;
            this.mBuffer.writeUByte((short)tlvLength);
        } else if (length <= 65532) {
            this.writeTag(tag, (byte)1);
            tlvLength = length + 3;
            this.mBuffer.writeUShort(tlvLength);
        } else if (length <= 0xFFFFFB) {
            this.writeTag(tag, (byte)2);
            tlvLength = length + 4;
            this.mBuffer.writeUThrint(tlvLength);
        } else {
            this.writeTag(tag, (byte)3);
            tlvLength = length + 5;
            this.mBuffer.writeUInt(tlvLength);
        }
        return tlvLength;
    }

    protected int writeDestinationValue(Destination value) {
        String destName = ((AbstractDestination)value).getName();
        if (value instanceof Topic) {
            this.mBuffer.writeByte((byte)0);
        } else if (value instanceof Queue) {
            this.mBuffer.writeByte((byte)1);
        } else {
            throw new IllegalArgumentException("Unsupported destination");
        }
        int utflen = this.writeUTF8(destName);
        this.mBuffer.writeByte((byte)0);
        return utflen + 2;
    }

    protected int writeUTF8(String value) {
        int utflen = 0;
        int strlen = value.length();
        this.mBuffer.realloc(strlen * 3);
        int i = 0;
        while (i < strlen) {
            int c = value.codePointAt(i);
            if (c > 0 && c <= 127) {
                this.mBuffer.writeByteUnsafe((byte)c);
                ++i;
                ++utflen;
                continue;
            }
            if (c <= 2047) {
                this.mBuffer.writeByteUnsafe((byte)(0xC0 | c >> 6 & 0x1F));
                this.mBuffer.writeByteUnsafe((byte)(0x80 | c >> 0 & 0x3F));
                ++i;
                utflen += 2;
                continue;
            }
            if (c < 65535) {
                this.mBuffer.writeByteUnsafe((byte)(0xE0 | c >> 12 & 0xF));
                this.mBuffer.writeByteUnsafe((byte)(0x80 | c >> 6 & 0x3F));
                this.mBuffer.writeByteUnsafe((byte)(0x80 | c >> 0 & 0x3F));
                ++i;
                utflen += 3;
                continue;
            }
            if (c <= 0x1FFFFF) {
                this.mBuffer.writeByteUnsafe((byte)(0xF0 | c >> 18 & 3));
                this.mBuffer.writeByteUnsafe((byte)(0x80 | c >> 12 & 0x3F));
                this.mBuffer.writeByteUnsafe((byte)(0x80 | c >> 6 & 0x3F));
                this.mBuffer.writeByteUnsafe((byte)(0x80 | c >> 0 & 0x3F));
                i += 2;
                utflen += 4;
                continue;
            }
            if (c <= 0x3FFFFFF) {
                this.mBuffer.writeByteUnsafe((byte)(0xF8 | c >> 24 & 2));
                this.mBuffer.writeByteUnsafe((byte)(0x80 | c >> 18 & 0x3F));
                this.mBuffer.writeByteUnsafe((byte)(0x80 | c >> 12 & 0x3F));
                this.mBuffer.writeByteUnsafe((byte)(0x80 | c >> 6 & 0x3F));
                this.mBuffer.writeByteUnsafe((byte)(0x80 | c >> 0 & 0x3F));
                i += 2;
                utflen += 5;
                continue;
            }
            if (c > Integer.MAX_VALUE) continue;
            this.mBuffer.writeByteUnsafe((byte)(0xFC | c >> 30 & 1));
            this.mBuffer.writeByteUnsafe((byte)(0x80 | c >> 24 & 0x3F));
            this.mBuffer.writeByteUnsafe((byte)(0x80 | c >> 18 & 0x3F));
            this.mBuffer.writeByteUnsafe((byte)(0x80 | c >> 12 & 0x3F));
            this.mBuffer.writeByteUnsafe((byte)(0x80 | c >> 6 & 0x3F));
            this.mBuffer.writeByteUnsafe((byte)(0x80 | c >> 0 & 0x3F));
            i += 2;
            utflen += 6;
        }
        return utflen;
    }

    protected int decodeTag(short byte0) {
        return (byte0 & 0xFF) >> 2;
    }

    protected int decodeNumLengthBytes(short byte0) {
        return (byte0 & 3) + 1;
    }

    protected void updateLength() {
    }

    public String toString() {
        return this.asByteArray().toString();
    }
}

