/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.sdt;

import com.solacesystems.common.util.ByteArray;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.RawSMFMessage;
import com.solacesystems.jcsmp.SDTException;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.SDTStream;
import com.solacesystems.jcsmp.impl.sdt.Formatter;
import com.solacesystems.jcsmp.impl.sdt.PermissiveFormatter;
import com.solacesystems.jcsmp.impl.sdt.SDTSerializable;
import com.solacesystems.jcsmp.impl.sdt.SDTStreamIF;
import com.solacesystems.jcsmp.impl.sdt.StreamTLVBuffer;
import com.solacesystems.jcsmp.impl.sdt.TLVBuffer;

public class StreamImpl
implements SDTStreamIF,
SDTSerializable {
    private static final int DEFAULT_INITIAL_SIZE = 1024;
    protected StreamTLVBuffer mBuffer;
    protected Formatter mFmter;
    protected long mVersion;

    public StreamImpl() {
        this(1024);
    }

    public StreamImpl(int capacity) {
        this.mBuffer = new StreamTLVBuffer(capacity);
        this.mFmter = PermissiveFormatter.OnlyInstance;
        this.mVersion = 0L;
    }

    public StreamImpl(StreamTLVBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null");
        }
        this.mBuffer = buffer;
        this.mFmter = PermissiveFormatter.OnlyInstance;
        this.mVersion = 0L;
    }

    @Override
    public void serialize(TLVBuffer buffer) {
        buffer.getSolByteBuffer().writeBytes(this.mBuffer.getSolByteBuffer().getBackingArray(), this.mBuffer.getSolByteBuffer().getBackingArrayOffset(), this.mBuffer.getSolByteBuffer().getLength());
    }

    public long getVersion() {
        return this.mVersion;
    }

    @Override
    public void setFormatter(Formatter fmter) {
        this.mFmter = fmter;
    }

    @Override
    public void clear() {
        this.mBuffer.clear();
        ++this.mVersion;
    }

    @Override
    public ByteArray asByteArray() {
        return this.mBuffer.asByteArray();
    }

    @Override
    public void mark() {
        this.mBuffer.mark();
    }

    @Override
    public void reset() {
        this.mBuffer.reset();
    }

    @Override
    public void rewind() {
        this.mBuffer.rewind();
    }

    @Override
    public boolean hasRemaining() {
        return this.mBuffer.hasRemaining();
    }

    public boolean equals(Object obj) {
        if (obj instanceof StreamImpl) {
            StreamImpl other = (StreamImpl)obj;
            return this.mBuffer.equals(other.mBuffer);
        }
        return false;
    }

    public int hashCode() {
        return this.mBuffer.hashCode();
    }

    @Override
    public Object read() throws SDTException {
        return this.mBuffer.read();
    }

    @Override
    public Boolean readBoolean() throws SDTException {
        return this.mFmter.getBoolean(this.mBuffer.read());
    }

    @Override
    public Byte readByte() throws SDTException {
        return this.mFmter.getByte(this.mBuffer.read());
    }

    @Override
    public byte[] readBytes() throws SDTException {
        return this.mFmter.getBytes(this.mBuffer.read());
    }

    @Override
    public ByteArray readByteArray() throws SDTException {
        return this.mFmter.getByteArray(this.mBuffer.read());
    }

    @Override
    public Character readCharacter() throws SDTException {
        return this.mFmter.getCharacter(this.mBuffer.read());
    }

    @Override
    public Destination readDestination() throws SDTException {
        return this.mFmter.getDestination(this.mBuffer.read());
    }

    @Override
    public Double readDouble() throws SDTException {
        return this.mFmter.getDouble(this.mBuffer.read());
    }

    @Override
    public Float readFloat() throws SDTException {
        return this.mFmter.getFloat(this.mBuffer.read());
    }

    @Override
    public Integer readInteger() throws SDTException {
        return this.mFmter.getInteger(this.mBuffer.read());
    }

    @Override
    public Long readLong() throws SDTException {
        return this.mFmter.getLong(this.mBuffer.read());
    }

    @Override
    public SDTMap readMap() throws SDTException {
        return this.mFmter.getMap(this.mBuffer.read());
    }

    @Override
    public RawSMFMessage readMessage() throws SDTException {
        return this.mFmter.getMessage(this.mBuffer.read());
    }

    @Override
    public Short readShort() throws SDTException {
        return this.mFmter.getShort(this.mBuffer.read());
    }

    @Override
    public SDTStream readStream() throws SDTException {
        return this.mFmter.getStream(this.mBuffer.read());
    }

    @Override
    public String readString() throws SDTException {
        return this.mFmter.getString(this.mBuffer.read());
    }

    @Override
    public void writeBoolean(Boolean value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    @Override
    public void writeByte(Byte value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    @Override
    public void writeBytes(byte[] value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    @Override
    public void writeBytes(byte[] value, int offset, int length) {
        this.mBuffer.write(value, offset, length);
        ++this.mVersion;
    }

    @Override
    public void writeByteArray(ByteArray value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    @Override
    public void writeCharacter(Character value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    @Override
    public void writeDestination(Destination value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    @Override
    public void writeDouble(Double value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    @Override
    public void writeFloat(Float value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    @Override
    public void writeInteger(Integer value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    @Override
    public void writeLong(Long value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    @Override
    public void writeMap(SDTMap value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    @Override
    public void writeMessage(RawSMFMessage value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    @Override
    public void writeObject(Object value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    @Override
    public void writeShort(Short value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    @Override
    public void writeStream(SDTStream value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    @Override
    public void writeString(String value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    public String toString() {
        return this.mBuffer.toString();
    }
}

