/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp;

import com.solacesystems.common.HostInfo;
import com.solacesystems.common.SolReserved;
import com.solacesystems.jcsmp.BytesMessage;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.ClientName;
import com.solacesystems.jcsmp.Context;
import com.solacesystems.jcsmp.ContextProperties;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.DurableTopicEndpoint;
import com.solacesystems.jcsmp.Endpoint;
import com.solacesystems.jcsmp.InvalidPropertiesException;
import com.solacesystems.jcsmp.JCSMPChannelProperties;
import com.solacesystems.jcsmp.JCSMPDestinationSession;
import com.solacesystems.jcsmp.JCSMPGlobalProperties;
import com.solacesystems.jcsmp.JCSMPProperties;
import com.solacesystems.jcsmp.JCSMPSendMultipleEntry;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.MapMessage;
import com.solacesystems.jcsmp.Queue;
import com.solacesystems.jcsmp.ReplayStartLocation;
import com.solacesystems.jcsmp.ReplayStartLocationDate;
import com.solacesystems.jcsmp.ReplicationGroupMessageId;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.SDTStream;
import com.solacesystems.jcsmp.SessionEventHandler;
import com.solacesystems.jcsmp.StreamMessage;
import com.solacesystems.jcsmp.SubscriberEndpoint;
import com.solacesystems.jcsmp.TextMessage;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.TopicEndpoint;
import com.solacesystems.jcsmp.TopicProperties;
import com.solacesystems.jcsmp.XMLContentMessage;
import com.solacesystems.jcsmp.XMLMessage;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.BytesMessageImpl;
import com.solacesystems.jcsmp.impl.ClientNameImpl;
import com.solacesystems.jcsmp.impl.ContextImpl;
import com.solacesystems.jcsmp.impl.DurableTopicEndpointImpl;
import com.solacesystems.jcsmp.impl.InputValidationUtil;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.JCSMPGenericXMLMessage;
import com.solacesystems.jcsmp.impl.MapMessageImpl;
import com.solacesystems.jcsmp.impl.QueueImpl;
import com.solacesystems.jcsmp.impl.ReplayStartLocationBeginningImpl;
import com.solacesystems.jcsmp.impl.ReplayStartLocationDateImpl;
import com.solacesystems.jcsmp.impl.ReplicationGroupMessageIdImpl;
import com.solacesystems.jcsmp.impl.SendMultipleEntry;
import com.solacesystems.jcsmp.impl.StreamMessageImpl;
import com.solacesystems.jcsmp.impl.TargetRouterMode;
import com.solacesystems.jcsmp.impl.TextMessageImpl;
import com.solacesystems.jcsmp.impl.TopicImpl;
import com.solacesystems.jcsmp.impl.XMLContentMessageImpl;
import com.solacesystems.jcsmp.impl.client.ClientInfoUtil;
import com.solacesystems.jcsmp.impl.sdt.MapImpl;
import com.solacesystems.jcsmp.impl.sdt.StreamImpl;
import com.solacesystems.jcsmp.secure.SecureProperties;
import com.solacesystems.jcsmpx.impl.DestinationUtils;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JCSMPFactory {
    private static JCSMPFactory instance = new JCSMPFactory();
    private JCSMPGlobalProperties _globalprops = new JCSMPGlobalProperties();
    private volatile boolean _lockGlobalProps = false;
    private ContextImpl _defaultCtx;
    private static final Log Trace = LogFactory.getLog(JCSMPFactory.class);
    private final int MAX_OAUTH_PARAM_LENGHT = 65530;
    private volatile Boolean _isUseDirectBufMsg = null;

    private JCSMPFactory() {
        ContextProperties ctx_prop = new ContextProperties();
        ctx_prop.setName("Default Context");
        this._defaultCtx = new ContextImpl(ctx_prop);
    }

    public static JCSMPFactory onlyInstance() {
        return instance;
    }

    public void setGlobalProperties(JCSMPGlobalProperties globalproperties) {
        if (this._lockGlobalProps) {
            throw new IllegalStateException(JCSMPRB.BUNDLE.getStringSafely("JCSMPFactory.mayNotSetGlobal"));
        }
        this._globalprops = (JCSMPGlobalProperties)globalproperties.clone();
    }

    public JCSMPGlobalProperties getGlobalProperties() {
        return (JCSMPGlobalProperties)this._globalprops.clone();
    }

    public JCSMPSession createSession(JCSMPProperties properties) throws InvalidPropertiesException {
        return this.createSession(properties, null, null);
    }

    public JCSMPSession createSession(JCSMPProperties properties, Context context) throws InvalidPropertiesException {
        return this.createSession(properties, context, null);
    }

    public JCSMPSession createSession(JCSMPProperties properties, Context context, SessionEventHandler eventHandler) throws InvalidPropertiesException {
        try {
            this.validate(properties);
            SecureProperties secureProps = new SecureProperties(properties);
            this.validate(properties, secureProps);
            this._lockGlobalProps = true;
            Context ctx = context != null ? context : this.getDefaultContext();
            return new JCSMPBasicSession(properties, secureProps, (ContextImpl)ctx, eventHandler);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            throw new InvalidPropertiesException(JCSMPRB.BUNDLE.getStringSafely("JCSMPFactory.propertyValueHasWrongDataType"));
        }
    }

    @SolReserved
    public JCSMPSession createSession(JCSMPProperties properties, Context context, SessionEventHandler eventHandler, boolean allowSharedClientId) throws InvalidPropertiesException, InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        try {
            this.validate(properties);
            SecureProperties secureProps = new SecureProperties(properties);
            this.validate(properties, secureProps);
            this._lockGlobalProps = true;
            Context ctx = context != null ? context : this.getDefaultContext();
            JCSMPBasicSession session = new JCSMPBasicSession(properties, secureProps, (ContextImpl)ctx, eventHandler, allowSharedClientId);
            if (properties.isMessageConsumeInterceptorClassNameSet()) {
                session.loadConsumeInterceptorByClassName(properties.getStringProperty("Message_Consume_Interceptor_Constructor_Argument"));
            }
            return session;
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            throw new InvalidPropertiesException(JCSMPRB.BUNDLE.getStringSafely("JCSMPFactory.propertyValueHasWrongDataType"));
        }
    }

    public JCSMPDestinationSession createDestinationSession(JCSMPProperties properties) throws InvalidPropertiesException {
        try {
            this.validate(properties);
            SecureProperties secureProps = new SecureProperties(properties);
            this.validate(properties, secureProps);
            this._lockGlobalProps = true;
            return new JCSMPBasicSession(properties, secureProps, (ContextImpl)this.getDefaultContext(), null);
        }
        catch (ClassCastException e) {
            throw new InvalidPropertiesException(JCSMPRB.BUNDLE.getStringSafely("JCSMPFactory.propertyValueHasWrongDataType"));
        }
    }

    @Deprecated
    public Destination createTopicDestination(String topicName) throws InvalidPropertiesException {
        return DestinationUtils.createTopicDestination(topicName);
    }

    private void validate(JCSMPProperties properties) throws InvalidPropertiesException {
        String unknownPubFlowAction;
        if (properties == null) {
            throw new InvalidPropertiesException(JCSMPRB.BUNDLE.getStringSafely("JCSMPFactory.nullPropertiesPassedIn"));
        }
        JCSMPProperties defaultProperties = new JCSMPProperties();
        for (String name : properties.propertyNames()) {
            Object value = properties.getProperty(name);
            Object defaultValue = defaultProperties.getProperty(name);
            if (value != null) {
                if (defaultValue != null) {
                    if (value.getClass().getName().equals(defaultValue.getClass().getName())) continue;
                    throw new InvalidPropertiesException(JCSMPRB.BUNDLE.getFormattedMessage("JCSMPFactory.typeOfPropertyValueIsNot", new Object[]{name}) + defaultValue.getClass().getName());
                }
                if ((name.equals("SSL_TRUST_STORE_PASSWORD") || name.equals("SSL_KEY_STORE_PASSWORD") || name.equals("SSL_PRIVATE_KEY_PASSWORD")) && !value.getClass().getName().equals(String.class.getName())) {
                    throw new InvalidPropertiesException(JCSMPRB.BUNDLE.getFormattedMessage("JCSMPFactory.typeOfPropertyValueIsNot", new Object[]{name}) + String.class.getName());
                }
                if (!name.equals("SSL_IN_MEMORY_KEY_STORE") && !name.equals("SSL_IN_MEMORY_TRUST_STORE") || value.getClass().isAssignableFrom(KeyStore.class)) continue;
                throw new InvalidPropertiesException(JCSMPRB.BUNDLE.getFormattedMessage("JCSMPFactory.typeOfPropertyValueIsNot", new Object[]{name}) + KeyStore.class.getName());
            }
            if (name.equals("password")) {
                properties.setProperty(name, "");
                continue;
            }
            if (name.equals("username")) {
                if (properties.getProperty("AUTHENTICATION_SCHEME").equals("AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE")) continue;
                throw new InvalidPropertiesException(JCSMPRB.BUNDLE.getFormattedMessage("JCSMPFactory.nullValuePassedInForProperty", new Object[]{name}));
            }
            if (name.equals("SSL_IN_MEMORY_KEY_STORE") || name.equals("SSL_IN_MEMORY_TRUST_STORE")) continue;
            throw new InvalidPropertiesException(JCSMPRB.BUNDLE.getFormattedMessage("JCSMPFactory.nullValuePassedInForProperty", new Object[]{name}));
        }
        this.checkMandatoryProperty(properties, "host");
        String authScheme = properties.getStringProperty("AUTHENTICATION_SCHEME");
        if (!(authScheme.equals("AUTHENTICATION_SCHEME_BASIC") || authScheme.equals("AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE") || authScheme.equals("AUTHENTICATION_SCHEME_OAUTH2") || authScheme.equals("AUTHENTICATION_SCHEME_GSS_KRB"))) {
            throw new InvalidPropertiesException(String.format("Invalid %s specified - must be one of [%s, %s, %s, %s]", "AUTHENTICATION_SCHEME", "AUTHENTICATION_SCHEME_BASIC", "AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE", "AUTHENTICATION_SCHEME_GSS_KRB", "AUTHENTICATION_SCHEME_OAUTH2"));
        }
        String sslDowngradeToPropto = properties.getStringProperty("SSL_CONNECTION_DOWNGRADE_TO");
        if (!sslDowngradeToPropto.equals("PLAIN_TEXT") && !sslDowngradeToPropto.equals("")) {
            throw new InvalidPropertiesException(String.format("Invalid %s specified - must be one of [%s]", "SSL_CONNECTION_DOWNGRADE_TO", "PLAIN_TEXT"));
        }
        String connectionType = properties.getStringProperty("connection_type");
        if (!connectionType.equals("CONNECTION_TYPE_BASIC") && !connectionType.equals("CONNECTION_TYPE_XA")) {
            throw new InvalidPropertiesException(String.format("Invalid %s specified - must be one of [%s, %s]", "connection_type", "CONNECTION_TYPE_BASIC", "CONNECTION_TYPE_XA"));
        }
        if (authScheme.equals("AUTHENTICATION_SCHEME_BASIC")) {
            this.checkMandatoryProperty(properties, "username");
        }
        this.checkMaxLengthStringProperty(properties, "username", 189);
        this.checkMaxLengthStringProperty(properties, "password", 128);
        String routerHost = properties.getStringProperty("host");
        boolean isWebsocketSchema = false;
        try {
            List<HostInfo> hosts = HostInfo.toHostInfoList(routerHost);
            Iterator<HostInfo> it = hosts.iterator();
            boolean hasResolvableHost = false;
            boolean isSecured = false;
            while (it.hasNext()) {
                HostInfo info = it.next();
                try {
                    this.checkHost(info, this.noConfiguredProxyServer());
                    hasResolvableHost = true;
                    if (!isWebsocketSchema) {
                        isWebsocketSchema = info.isWebSocketEnabled();
                    }
                    if (isSecured) continue;
                    isSecured = info.isSecure();
                }
                catch (InvalidPropertiesException e) {
                    if (this.noConfiguredProxyServer()) {
                        Trace.warn((Object)e.getMessage());
                        continue;
                    }
                    throw e;
                }
            }
            if (!hasResolvableHost) {
                throw new InvalidPropertiesException("All hosts in the host list: '" + routerHost + "' are not resolvable");
            }
            JCSMPChannelProperties cp = (JCSMPChannelProperties)properties.getProperty("client_channel");
            if (isWebsocketSchema && cp.getCompressionLevel() > 0) {
                throw new InvalidPropertiesException("Compression over WebSocket is not supported");
            }
            if (!sslDowngradeToPropto.equals("") && isWebsocketSchema && isSecured) {
                throw new InvalidPropertiesException("SSL downgrade over secured WebSocket is not supported");
            }
        }
        catch (IllegalArgumentException e) {
            throw new InvalidPropertiesException(e.getMessage(), e);
        }
        if (authScheme.equals("AUTHENTICATION_SCHEME_OAUTH2") && properties.getStringProperty("OAUTH2_ACCESS_TOKEN") == null && properties.getStringProperty("OIDC_ID_TOKEN") == null) {
            throw new InvalidPropertiesException("At least one OAUTH token has to be specified.");
        }
        if (properties.getStringProperty("OIDC_ID_TOKEN") != null && properties.getStringProperty("OIDC_ID_TOKEN").length() > 65530) {
            throw new InvalidPropertiesException("the token length " + properties.getStringProperty("OIDC_ID_TOKEN").length() + " exceeds its limit " + 65530);
        }
        if (properties.getStringProperty("OAUTH2_ACCESS_TOKEN") != null && properties.getStringProperty("OAUTH2_ACCESS_TOKEN").length() > 65530) {
            throw new InvalidPropertiesException("the token length " + properties.getStringProperty("OAUTH2_ACCESS_TOKEN").length() + " exceeds its limit " + 65530);
        }
        if (properties.getStringProperty("OAUTH2_ISSUER_IDENTIFIER") != null && properties.getStringProperty("OAUTH2_ISSUER_IDENTIFIER").length() > 65530) {
            throw new InvalidPropertiesException("the identifier length " + properties.getStringProperty("OAUTH2_ISSUER_IDENTIFIER").length() + " exceeds its limit " + 65530);
        }
        String localIP = properties.getStringProperty("localhost");
        if (localIP != null && localIP.trim().length() > 0) {
            this.checkHost(localIP);
        }
        if ((unknownPubFlowAction = properties.getStringProperty("gd_reconnect_fail_action")) != null && !unknownPubFlowAction.equals("gd_reconnect_fail_action_disconnect") && !unknownPubFlowAction.equals("gd_reconnect_fail_action_auto_retry")) {
            throw new InvalidPropertiesException(String.format("Invalid value '%s' specified for '%s' - must be one of [%s, %s]", unknownPubFlowAction, "gd_reconnect_fail_action", "gd_reconnect_fail_action_auto_retry", "gd_reconnect_fail_action_disconnect"));
        }
        this.checkWindowedAckProps(properties);
        this.checkLargeMessagingProps(properties);
        this.checkControlChannelProperties(properties);
        this.checkPublisherChannelProperties(properties);
        this.checkSubscriberChannelProperties(properties);
        this.checkClientChannelProperties(properties);
        this.checkClientProperties(properties);
        this.validateIntegerProperty(properties.getIntegerProperty("PAYLOAD_COMPRESSION_LEVEL"), "PAYLOAD_COMPRESSION_LEVEL", 0, 9);
        Boolean genTS = properties.getBooleanProperty("generate_send_timestamps");
        if (genTS == null) {
            throw new InvalidPropertiesException(JCSMPRB.BUNDLE.getFormattedMessage("JCSMPFactory.nullValuePassedInForProperty", new Object[]{"generate_send_timestamps"}));
        }
        Boolean genSeqNo = properties.getBooleanProperty("generate_sequence_numbers");
        if (genSeqNo == null) {
            throw new InvalidPropertiesException(JCSMPRB.BUNDLE.getFormattedMessage("JCSMPFactory.nullValuePassedInForProperty", new Object[]{"generate_sequence_numbers"}));
        }
    }

    private boolean noConfiguredProxyServer() {
        return System.getProperty("solace.proxy.host") == null;
    }

    private void validate(JCSMPProperties properties, SecureProperties secureProperties) throws InvalidPropertiesException {
        if (secureProperties.usingSecure()) {
            secureProperties.loadTrustStore();
            if (secureProperties.isClientCertificateAuthenticationEnabled()) {
                secureProperties.loadKeyStore();
            }
            secureProperties.initCertPathParameters();
        }
    }

    private void checkClientProperties(JCSMPProperties props) throws InvalidPropertiesException {
        String vpnName;
        String clientDescription = props.getStringProperty("application_description");
        if (!InputValidationUtil.validateStringLengthAscii(clientDescription, 254)) {
            throw new InvalidPropertiesException(JCSMPRB.BUNDLE.getFormattedMessage("JCSMPFactory.propertyTooLong", new Object[]{"application_description", 254}));
        }
        String clientName = props.getStringProperty("client_name");
        if (clientName != null && clientName.length() > 0) {
            try {
                ClientInfoUtil.validateClientName(clientName, TargetRouterMode.TRB);
            }
            catch (IllegalArgumentException iae) {
                throw new InvalidPropertiesException(iae.getMessage());
            }
        }
        if (!InputValidationUtil.validateStringLengthUtf8(vpnName = props.getStringProperty("vpn_name"), 32)) {
            throw new InvalidPropertiesException(JCSMPRB.BUNDLE.getFormattedMessage("JCSMPFactory.propertyTooLong", new Object[]{"vpn_name", 32}));
        }
        Boolean includeClientName = props.getBooleanProperty("generate_sender_id");
        if (includeClientName == null) {
            throw new InvalidPropertiesException(JCSMPRB.BUNDLE.getFormattedMessage("JCSMPFactory.nullValuePassedInForProperty", new Object[]{"generate_sender_id"}));
        }
        this.validateIntegerProperty(props.getIntegerProperty("subscriber_local_priority"), "SUBSCRIBER_LOCAL_PRIORITY", 1, 4);
        this.validateIntegerProperty(props.getIntegerProperty("subscriber_network_priority"), "SUBSCRIBER_NETWORK_PRIORITY", 1, 4);
    }

    private void checkWindowedAckProps(JCSMPProperties props) throws InvalidPropertiesException {
        this.validateIntegerProperty(props.getIntegerProperty("pub_ack_time"), "PUB_ACK_TIME", 20, 60000);
        this.validateIntegerProperty(props.getIntegerProperty("pub_ack_window_size"), "PUB_ACK_WINDOW_SIZE", 1, 255);
        Integer max_resends = props.getIntegerProperty("max_resends");
        this.validateIntegerProperty(max_resends, "MAX_RESENDS", 0, Integer.MAX_VALUE);
        if (max_resends != 30) {
            Trace.warn((Object)("Attempt to set the deprecated property 'MAX_RESENDS' value to " + max_resends));
        }
        this.validateIntegerProperty(props.getIntegerProperty("sub_ack_time"), "SUB_ACK_TIME", 20, 1500);
        this.validateIntegerProperty(props.getIntegerProperty("sub_ack_window_size"), "SUB_ACK_WINDOW_SIZE", 1, 255);
        this.validateIntegerProperty(props.getIntegerProperty("sub_ack_window_threshold"), "SUB_ACK_WINDOW_THRESHOLD", 1, 75);
    }

    private void checkLargeMessagingProps(JCSMPProperties props) throws InvalidPropertiesException {
        boolean msgCallbackOnReactor = props.getBooleanProperty("MESSAGE_CALLBACK_ON_REACTOR");
        String msgAckMode = props.getStringProperty("message_ack_mode");
        boolean largeMessaging = props.getBooleanProperty("large_messaging");
        if (msgCallbackOnReactor && largeMessaging) {
            throw new InvalidPropertiesException("Large messaging is not supported if async delivery of messages on IO thread is enabled");
        }
        if (msgAckMode.equals("client_ack_windowed") && largeMessaging) {
            throw new InvalidPropertiesException("Large messaging is not supported if message ack mode is client_ack_windowed");
        }
        this.validateIntegerProperty(props.getIntegerProperty("large_message_segment_size"), "LARGE_MESSAGING_SEGMENT_SIZE", 524288, 29884416);
        this.validateIntegerProperty(props.getIntegerProperty("large_message_consume_timeout"), "LARGE_MESSAGING_CONSUME_TIMEOUT", 1, Integer.MAX_VALUE);
    }

    private void validateIntegerProperty(Integer prop, String name, int lbound, int ubound) throws InvalidPropertiesException {
        if (prop == null) {
            throw new InvalidPropertiesException(JCSMPRB.BUNDLE.getFormattedMessage("JCSMPFactory.propertyNameIsNotProvided", new Object[]{name}));
        }
        int iValue = prop;
        if (lbound > iValue || ubound < iValue) {
            throw new InvalidPropertiesException(JCSMPRB.BUNDLE.getFormattedMessage("JCSMPFactory.propertyOutOfRange", new Object[]{name, lbound, ubound}));
        }
    }

    private void checkHost(HostInfo info, boolean resolvable_check) throws InvalidPropertiesException {
        if (!(info.getScheme() == null || info.isScheme("tcp") || info.isScheme("tcps") || info.isScheme("ws") || info.isScheme("wss"))) {
            throw new InvalidPropertiesException("Invalid scheme \"" + info.getScheme() + "\"");
        }
        if (info.getPort() != null && (info.getPort() < 0 || info.getPort() > 65535)) {
            throw new InvalidPropertiesException(info.getOriginal() + JCSMPRB.BUNDLE.getStringSafely("JCSMPFactory.isNotValidHostOrIpOrScheme"));
        }
        if (resolvable_check) {
            try {
                InetAddress.getByName(info.getHost());
            }
            catch (UnknownHostException e) {
                throw new InvalidPropertiesException("unresolvable host: '" + info.getOriginal() + "'" + JCSMPRB.BUNDLE.getStringSafely("JCSMPFactory.isNotValidHostOrIpOrScheme"));
            }
        }
    }

    private void checkHost(String host) throws InvalidPropertiesException {
        List<HostInfo> hosts = HostInfo.toHostInfoList(host);
        Iterator<HostInfo> it = hosts.iterator();
        boolean hasResolvableHost = false;
        while (it.hasNext()) {
            HostInfo info = it.next();
            try {
                this.checkHost(info, true);
                hasResolvableHost = true;
            }
            catch (InvalidPropertiesException e) {
                Trace.warn((Object)e.getMessage());
            }
        }
        if (!hasResolvableHost) {
            throw new InvalidPropertiesException(host + JCSMPRB.BUNDLE.getStringSafely("JCSMPFactory.isNotValidHostOrIp"));
        }
    }

    private void checkControlChannelProperties(JCSMPProperties properties) throws InvalidPropertiesException {
        JCSMPChannelProperties channelProperties = (JCSMPChannelProperties)properties.getProperty("control_channel");
        if (channelProperties == null) {
            return;
        }
        if (!channelProperties.getStack().equals("csmp.smf.tcp") && !channelProperties.getStack().equals("csmp.smfs.tcp")) {
            throw new InvalidPropertiesException(JCSMPRB.BUNDLE.getFormattedMessage("JCSMPFactory.unsupportedProtocolStackSpecifiedForChannel", new Object[]{"control"}));
        }
    }

    private void checkPublisherChannelProperties(JCSMPProperties properties) throws InvalidPropertiesException {
        JCSMPChannelProperties channelProperties = (JCSMPChannelProperties)properties.getProperty("publisher_data_channel");
        if (channelProperties == null) {
            return;
        }
    }

    private void checkSubscriberChannelProperties(JCSMPProperties properties) throws InvalidPropertiesException {
        JCSMPChannelProperties channelProperties = (JCSMPChannelProperties)properties.getProperty("subscriber_data_channel");
        if (channelProperties == null) {
            return;
        }
    }

    private void checkClientChannelProperties(JCSMPProperties properties) throws InvalidPropertiesException {
        JCSMPChannelProperties channelProperties = (JCSMPChannelProperties)properties.getProperty("client_channel");
        if (channelProperties == null) {
            return;
        }
        if (!channelProperties.getStack().equals("csmp.smf.tcp") && !channelProperties.getStack().equals("csmp.smfs.tcp")) {
            throw new InvalidPropertiesException(JCSMPRB.BUNDLE.getFormattedMessage("JCSMPFactory.unsupportedProtocolStackSpecifiedForChannel", new Object[]{"client"}));
        }
    }

    private void checkMandatoryProperty(JCSMPProperties properties, String name) throws InvalidPropertiesException {
        Object value = properties.getProperty(name);
        if (value == null) {
            throw new InvalidPropertiesException(JCSMPRB.BUNDLE.getFormattedMessage("JCSMPFactory.propertyNameIsNotProvided", new Object[]{name}));
        }
        if (value instanceof String && ((String)value).trim().length() == 0) {
            throw new InvalidPropertiesException(JCSMPRB.BUNDLE.getFormattedMessage("JCSMPFactory.propertyNameIsNotProvided", new Object[]{name}));
        }
    }

    private void checkMaxLengthStringProperty(JCSMPProperties properties, String name, int maxlen) throws InvalidPropertiesException {
        Object value = properties.getProperty(name);
        if (value != null && value instanceof String && ((String)value).length() > maxlen) {
            throw new InvalidPropertiesException(JCSMPRB.BUNDLE.getFormattedMessage("JCSMPFactory.propertyTooLong", new Object[]{name, maxlen}));
        }
    }

    public Context getDefaultContext() {
        return this._defaultCtx;
    }

    public Context createContext(ContextProperties properties) {
        return new ContextImpl(properties);
    }

    public Topic createTopic(String name) {
        return TopicImpl.createWithInit(name, false, false);
    }

    public Topic createTopic(TopicProperties props) {
        return TopicImpl.createWithInit(props);
    }

    public Queue createQueue(String name) {
        return QueueImpl.userCreateWithInit(name, true);
    }

    @Deprecated
    public Queue createQueue(String name, String virtualRouterName) {
        return QueueImpl.userCreateWithInit(name, true, virtualRouterName);
    }

    public DurableTopicEndpoint createDurableTopicEndpoint(String name) {
        return new DurableTopicEndpointImpl(name);
    }

    public TopicEndpoint createDurableTopicEndpointEx(String name) {
        return new DurableTopicEndpointImpl(name);
    }

    public Endpoint createSubscriberEndpoint(JCSMPSession session) {
        String username = ((JCSMPBasicSession)session).getJCSMPProperties().getStringProperty("username");
        return new SubscriberEndpoint("#sol/" + username);
    }

    private boolean isUseDirectBufMsg() {
        if (this._isUseDirectBufMsg == null) {
            this._isUseDirectBufMsg = System.getProperty("JCSMP_DIRECT_BUF_MESSAGE") != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._isUseDirectBufMsg;
    }

    public BytesXMLMessage createBytesXMLMessage() {
        JCSMPGenericXMLMessage bytesMessage = JCSMPBasicSession.createGenericXMLMessage(JCSMPFactory.onlyInstance().getGlobalProperties().getContentBufferSizeDefault(), this.isUseDirectBufMsg(), true);
        bytesMessage.reset();
        bytesMessage.setInternalProducerId(-1L);
        return bytesMessage;
    }

    public <M extends XMLMessage> M createMessage(Class<M> clazz) {
        if (clazz.equals(BytesXMLMessage.class)) {
            return (M)this.createBytesXMLMessage();
        }
        if (clazz.equals(BytesMessage.class)) {
            return (M)new BytesMessageImpl(this.createBytesXMLMessage());
        }
        if (clazz.equals(TextMessage.class)) {
            return (M)new TextMessageImpl(this.createBytesXMLMessage());
        }
        if (clazz.equals(StreamMessage.class)) {
            return (M)new StreamMessageImpl(this.createBytesXMLMessage());
        }
        if (clazz.equals(MapMessage.class)) {
            return (M)new MapMessageImpl(this.createBytesXMLMessage());
        }
        if (clazz.equals(XMLContentMessage.class)) {
            return (M)new XMLContentMessageImpl(this.createBytesXMLMessage());
        }
        throw new IllegalArgumentException("Invalid type argument: must be one of BytesXMLMessage, BytesMessage, MapMessage, StreamMessage, TextMessage, XMLContentMessage.");
    }

    public BytesXMLMessage createMessage(BytesXMLMessage toclone) {
        BytesXMLMessage msg = null;
        JCSMPGenericXMLMessage clonedMsg = null;
        if (toclone instanceof BytesMessageImpl) {
            msg = ((BytesMessageImpl)toclone).getWrappedMessage();
            clonedMsg = JCSMPBasicSession.createGenericXMLMessage((JCSMPGenericXMLMessage)msg, this.isUseDirectBufMsg(), false);
            return new BytesMessageImpl(clonedMsg);
        }
        if (toclone instanceof TextMessageImpl) {
            msg = ((TextMessageImpl)toclone).getWrappedMessage();
            clonedMsg = JCSMPBasicSession.createGenericXMLMessage((JCSMPGenericXMLMessage)msg, this.isUseDirectBufMsg(), false);
            return new TextMessageImpl(clonedMsg);
        }
        if (toclone instanceof MapMessageImpl) {
            msg = ((MapMessageImpl)toclone).getWrappedMessage();
            clonedMsg = JCSMPBasicSession.createGenericXMLMessage((JCSMPGenericXMLMessage)msg, this.isUseDirectBufMsg(), false);
            MapMessageImpl mapMsg = new MapMessageImpl(clonedMsg);
            mapMsg.getMap();
            return mapMsg;
        }
        if (toclone instanceof StreamMessageImpl) {
            msg = ((StreamMessageImpl)toclone).getWrappedMessage();
            clonedMsg = JCSMPBasicSession.createGenericXMLMessage((JCSMPGenericXMLMessage)msg, this.isUseDirectBufMsg(), false);
            StreamMessageImpl streamMsg = new StreamMessageImpl(clonedMsg);
            streamMsg.getStream();
            return streamMsg;
        }
        if (toclone instanceof XMLContentMessageImpl) {
            msg = ((XMLContentMessageImpl)toclone).getWrappedMessage();
            clonedMsg = JCSMPBasicSession.createGenericXMLMessage((JCSMPGenericXMLMessage)msg, this.isUseDirectBufMsg(), true);
            XMLContentMessageImpl contentMsg = new XMLContentMessageImpl(clonedMsg);
            contentMsg.setXMLContent(((XMLContentMessage)toclone).getXMLContent());
            return contentMsg;
        }
        return JCSMPBasicSession.createGenericXMLMessage((JCSMPGenericXMLMessage)toclone, this.isUseDirectBufMsg(), false);
    }

    public String createUniqueName(String prefix) {
        if (prefix == null || prefix.trim().length() == 0) {
            return UUID.randomUUID().toString();
        }
        StringBuilder bldr = new StringBuilder(prefix);
        bldr.append("/");
        bldr.append(UUID.randomUUID().toString());
        return bldr.toString();
    }

    public JCSMPSendMultipleEntry createSendMultipleEntry(XMLMessage message, Destination destination) {
        return SendMultipleEntry.create(message, destination);
    }

    public ClientName createClientName(String clientName) {
        return new ClientNameImpl(clientName);
    }

    public SDTMap createMap() {
        return new MapImpl();
    }

    public SDTStream createStream() {
        return new StreamImpl();
    }

    public ReplayStartLocation createReplayStartLocationBeginning() {
        return new ReplayStartLocationBeginningImpl();
    }

    public ReplayStartLocationDate createReplayStartLocationDate(Date date) {
        return new ReplayStartLocationDateImpl(date);
    }

    public ReplicationGroupMessageId createReplicationGroupMessageId(String id) throws InvalidPropertiesException {
        return ReplicationGroupMessageIdImpl.createReplicationGroupMessageId(id);
    }
}

