/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.xml;

public class XMLUtils {
    public static final String EscapedAmpersand = "&amp;";
    public static final int EscapedAmpersandLength = "&amp;".length();
    public static final String EscapedLessThan = "&lt;";
    public static final int EscapedLessThanLength = "&lt;".length();
    public static final String EscapedGreaterThan = "&gt;";
    public static final int EscapedGreaterThanLength = "&gt;".length();
    public static final String EscapedQuote = "&quot;";
    public static final int EscapedQuoteLength = "&quot;".length();
    public static final String EscapedApostrophe = "&apos;";
    public static final int EscapedApostropheLength = "&apos;".length();

    public static String escape(String value) {
        StringBuilder bldr = new StringBuilder();
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char current = value.charAt(i);
            if (current == '&') {
                bldr.append(EscapedAmpersand);
                continue;
            }
            if (current == '<') {
                bldr.append(EscapedLessThan);
                continue;
            }
            if (current == '>') {
                bldr.append(EscapedGreaterThan);
                continue;
            }
            if (current == '\"') {
                bldr.append(EscapedQuote);
                continue;
            }
            if (current == '\'') {
                bldr.append(EscapedApostrophe);
                continue;
            }
            bldr.append(current);
        }
        return bldr.toString();
    }

    public static String unescape(String value) {
        StringBuilder bldr = new StringBuilder();
        int length = value.length();
        int index = 0;
        while (index < length) {
            char current = value.charAt(index);
            if (current == '&') {
                if (value.regionMatches(index + 1, EscapedAmpersand, 1, EscapedAmpersandLength - 1)) {
                    bldr.append('&');
                    index += EscapedAmpersandLength;
                    continue;
                }
                if (value.regionMatches(index + 1, EscapedLessThan, 1, EscapedLessThanLength - 1)) {
                    bldr.append('<');
                    index += EscapedLessThanLength;
                    continue;
                }
                if (value.regionMatches(index + 1, EscapedGreaterThan, 1, EscapedGreaterThanLength - 1)) {
                    bldr.append('>');
                    index += EscapedGreaterThanLength;
                    continue;
                }
                if (value.regionMatches(index + 1, EscapedQuote, 1, EscapedQuoteLength - 1)) {
                    bldr.append('\"');
                    index += EscapedQuoteLength;
                    continue;
                }
                if (value.regionMatches(index + 1, EscapedApostrophe, 1, EscapedApostropheLength - 1)) {
                    bldr.append('\'');
                    index += EscapedApostropheLength;
                    continue;
                }
                bldr.append(current);
                ++index;
                continue;
            }
            bldr.append(current);
            ++index;
        }
        return bldr.toString();
    }
}

