/*
 * Decompiled with CFR 0.152.
 */
package com.solace.transport;

import java.util.HashMap;
import javax.net.ssl.SSLContext;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class TransportSSLConfiguration {
    private SSLContext sslContext;
    private String[] specifiedProtocols;
    private String[] apiSupportedProtocols;
    private String[] specifiedCipherSuites;
    private HashMap<String, String> apiCipherMap;
    private HashMap<String, String[]> apiCipherAliasesMap;
    private boolean enableHostNameValidation;

    public TransportSSLConfiguration(SSLContext ctx) {
        this.sslContext = ctx;
        this.enableHostNameValidation = false;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public boolean isHostNameValivationEnabled() {
        return this.enableHostNameValidation;
    }

    public TransportSSLConfiguration setHostNameValidation(boolean v) {
        this.enableHostNameValidation = v;
        return this;
    }

    public String[] getSpecifiedProtocols() {
        return this.specifiedProtocols;
    }

    public TransportSSLConfiguration setSpecifiedProtocols(String[] enabledProtocols) {
        this.specifiedProtocols = enabledProtocols;
        return this;
    }

    public String[] getApiSupportedProtocols() {
        return this.apiSupportedProtocols;
    }

    public TransportSSLConfiguration setApiSupportedProtocols(String[] supportedProtocolSet) {
        this.apiSupportedProtocols = supportedProtocolSet;
        return this;
    }

    public HashMap<String, String[]> getApiCipheAliasesMap() {
        return this.apiCipherAliasesMap;
    }

    public TransportSSLConfiguration setApiCipherAliasesMap(HashMap<String, String[]> cipherAliasesMap) {
        this.apiCipherAliasesMap = cipherAliasesMap;
        return this;
    }

    public HashMap<String, String> getApiCipherMap() {
        return this.apiCipherMap;
    }

    public TransportSSLConfiguration setApiCipherMap(HashMap<String, String> ciphersMap) {
        this.apiCipherMap = ciphersMap;
        return this;
    }

    public String[] getSpecifiedCipherSuites() {
        return this.specifiedCipherSuites;
    }

    public TransportSSLConfiguration setSpecifiedCipherSuites(String[] enabledCipherSuites) {
        this.specifiedCipherSuites = enabledCipherSuites;
        return this;
    }
}

