/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf;

import com.solacesystems.common.HostInfo;
import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.InvalidMessageReceivedException;
import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.JCSMPChannelProperties;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPFatalErrorException;
import com.solacesystems.jcsmp.JCSMPSecurityException;
import com.solacesystems.jcsmp.JCSMPSessionStats;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.WireMessageEncoder;
import com.solacesystems.jcsmp.impl.client.ClientRequestResponse;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimeoutHandler;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimer;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimerQueue;
import com.solacesystems.jcsmp.protocol.HeaderDescriptionBean;
import com.solacesystems.jcsmp.protocol.SeqNumAllocator;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.WireMessageHandler;
import com.solacesystems.jcsmp.protocol.impl.SeqNum63bAllocator;
import com.solacesystems.jcsmp.protocol.impl.SmfUhUtil;
import com.solacesystems.jcsmp.protocol.impl.TcpClientChannel;
import com.solacesystems.jcsmp.protocol.nio.IOReactor;
import com.solacesystems.jcsmp.protocol.nio.ReadIOHandler;
import com.solacesystems.jcsmp.protocol.nio.WriteIOHandler;
import com.solacesystems.jcsmp.protocol.nio.impl.SubscriberMessageReader;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SMFWireMessageHandler;
import com.solacesystems.jcsmp.protocol.smf.SmfClientIOException;
import com.solacesystems.jcsmp.protocol.smf.SmfTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.impl.AuthenticationSchemeBasicParameters;
import com.solacesystems.jcsmp.protocol.smf.impl.AuthenticationSchemeClientCertificateParameters;
import com.solacesystems.jcsmp.protocol.smf.impl.AuthenticationSchemeKRBParameters;
import com.solacesystems.jcsmp.protocol.smf.impl.AuthenticationSchemeParameters;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterFactorySmf;
import com.solacesystems.jcsmp.secure.JCSMPSecureProtocolSocketFactory;
import com.solacesystems.jcsmp.statistics.StatType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SimpleSmfClient
implements WriteIOHandler,
ReadIOHandler {
    public static final int WRCODE_OK = 0;
    public static final int WRCODE_DROPPED = 1;
    public static final int NOT_CONNECTED = 2;
    private static final Log Trace = LogFactory.getLog(SimpleSmfClient.class);
    protected AuthenticationSchemeParameters authParams;
    protected int connTimeout;
    protected int sockTimeout;
    protected String remoteHost;
    protected int remotePort;
    protected volatile Socket socket;
    protected boolean isconnected;
    protected boolean tcpNoDelay;
    protected int so_sndbuf;
    protected int so_rcvbuf;
    protected InetAddress localAddress;
    protected TlvParameterFactorySmf smfParamFactory = TlvParameterFactorySmf.instance();
    protected SMFWireMessageHandler wirehandler = new SMFWireMessageHandler();
    protected JCSMPSessionStats sessionStats;
    private SeqNumAllocator ctrl_seqAlloc;
    protected final boolean useIntermediateDirectBuf;
    protected final AtomicLong m_bytesWrittenCtr = new AtomicLong();
    protected SS _sharedSocketState;
    protected final IOReactor _reactor;
    private volatile SubscriberMessageReader _subReader;
    protected Object _stateLock = new Object();
    protected Semaphore _writeCompleteSem = new Semaphore(0);
    protected volatile int _connCounter = 0;
    protected static int DEFAULT_SEND_BUF_SIZE = 4096;
    protected ByteBuffer _pubDirectSendBuf = null;
    protected PriorityData _priorityData = new PriorityData();
    protected PriorityDataTimerHandler _priorityDataTimerHandler = new PriorityDataTimerHandler(this._priorityData, this);
    private static final AtomicInteger smfclient_counter = new AtomicInteger();
    protected final int _smfClientId;
    protected JCSMPChannelProperties _cprops;
    protected Exception _clientException;
    protected ByteBuffer outMessageBuf = null;
    public static final int C_CLOSED = 1;
    public static final int C_CONNECTING = 2;
    public static final int C_RECON_STARTED = 3;
    private static final Oid krb5Mechanism = SimpleSmfClient.createKRB5Mechanism();

    public String toString() {
        return String.format("SimpleSmfClient (%s) state=%s", new Object[]{this._smfClientId, this._sharedSocketState});
    }

    public int getLocalPort() {
        if (this.socket != null) {
            return this.socket.getLocalPort();
        }
        return 0;
    }

    public String getNetworkInfoString() {
        String infoString = "";
        if (this.socket != null) {
            try {
                InetAddress localAddr = this.socket.getLocalAddress();
                if (localAddr != null) {
                    infoString = localAddr.isAnyLocalAddress() ? infoString + "Local port: " + this.socket.getLocalPort() : infoString + "Local addr: " + localAddr.getHostAddress() + ":" + this.socket.getLocalPort();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            infoString = infoString + "   ";
            infoString = infoString + "Remote addr: " + this.remoteHost + ":" + this.remotePort;
        }
        return infoString;
    }

    protected SimpleSmfClient(AuthenticationSchemeParameters authParams, JCSMPSessionStats sessionStats, IOReactor reactor, boolean usePubDirectIntermediateBuf) {
        this._reactor = reactor;
        this.authParams = authParams;
        this.sessionStats = sessionStats;
        this.ctrl_seqAlloc = new SeqNum63bAllocator("controlCorrelationSeqAllocator");
        this.useIntermediateDirectBuf = usePubDirectIntermediateBuf;
        this._smfClientId = smfclient_counter.incrementAndGet();
        this.ctrl_seqAlloc.getNext63b();
        this._cprops = null;
        this.initState();
        this.outMessageBuf = this.useIntermediateDirectBuf ? ByteBuffer.allocateDirect(DEFAULT_SEND_BUF_SIZE) : ByteBuffer.allocate(DEFAULT_SEND_BUF_SIZE);
    }

    public final void initState() {
        this._sharedSocketState = SS.STARTSTATE;
    }

    public final void closeState() {
        this._sharedSocketState = SS.CLOSED;
    }

    public SeqNumAllocator getCtrl_seqAlloc() {
        return this.ctrl_seqAlloc;
    }

    public void setClientProps(JCSMPChannelProperties cprops) {
        this._cprops = cprops;
    }

    public void enqueuePriorityData(WireMessage wmsg) {
        this._priorityData.enqueue(wmsg, this);
    }

    protected void readMessage(InputStream istr, WireMessage msg) throws IOException {
        this.wirehandler.readMessage(istr, msg);
        int bytes_read = msg.getSmfHeader().getMsgTotalLenWithHeader();
        this.sessionStats.incStat(StatType.TOTAL_SOCKET_BYTES_RECVED, bytes_read);
    }

    public void setSubscriberMessageReader(SubscriberMessageReader subReader) {
        this._subReader = subReader;
    }

    public void doPost(WireMessage request, WireMessage response, boolean setAuth) throws JCSMPException, IOException {
        block12: {
            HeaderDescriptionBean encap_hdr;
            int encap_param_uhcheck;
            long corrTag = this.conditionalAddCorrelationTag(request);
            this.doPostNoResponse(request, setAuth);
            this.readMessage(this.socket.getInputStream(), response);
            response = SmfUhUtil.validateUH(response, this.sessionStats);
            if (response != null && response.getHeaderBean() != null && (encap_param_uhcheck = SmfUhUtil.testValidateUHParams(encap_hdr = response.getHeaderBean(), this.sessionStats)) == 2) {
                response = null;
            }
            if (response == null) {
                throw new InvalidMessageReceivedException(JCSMPRB.BUNDLE.getStringSafely("SimpleSmfClient.droppedUnknownElement"));
            }
            SMFHeaderBean smfResponseHeader = response.getSmfHeader();
            if (smfResponseHeader.getPm_respcode() == -1) {
                throw new InvalidMessageReceivedException(JCSMPRB.BUNDLE.getStringSafely("SimpleSmfClient.expectedResponseParameter"));
            }
            if (smfResponseHeader.getPm_corrtag() != -1 && corrTag != (long)smfResponseHeader.getPm_corrtag()) {
                throw new InvalidMessageReceivedException(String.format("Invalid message: expected CorrelationTag (%s), got (%s).", corrTag, smfResponseHeader.getPm_corrtag()));
            }
            if (this.authParams instanceof AuthenticationSchemeKRBParameters) {
                final AuthenticationSchemeKRBParameters krbAuthParams = (AuthenticationSchemeKRBParameters)this.authParams;
                if (krbAuthParams.useMutualAuthentication() && smfResponseHeader.getPm_gssapiToken() != null) {
                    final byte[] inToken = smfResponseHeader.getPm_gssapiToken();
                    Object serviceTicket = Subject.doAs(krbAuthParams.getLoginContext().getSubject(), new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            try {
                                return krbAuthParams.getGSSContext().initSecContext(inToken, 0, inToken.length);
                            }
                            catch (Throwable t) {
                                return t;
                            }
                        }
                    });
                    if (serviceTicket instanceof Throwable) {
                        throw new JCSMPSecurityException("Error mutually authenticating", (Throwable)serviceTicket);
                    }
                    if (!krbAuthParams.getGSSContext().isEstablished()) {
                        throw new JCSMPSecurityException("Error initializing security context - not established");
                    }
                    if (serviceTicket != null) {
                        throw new JCSMPSecurityException("Error initializing security context - continuation");
                    }
                }
                if (krbAuthParams.getGSSContext() != null) {
                    try {
                        krbAuthParams.getGSSContext().dispose();
                    }
                    catch (GSSException e) {
                        if (!Trace.isWarnEnabled()) break block12;
                        Trace.warn((Object)"Error disposing of GSS context", (Throwable)e);
                    }
                }
            }
        }
    }

    public void doPostNoResponse(WireMessage request, boolean setAuth) throws JCSMPException, IOException {
        if (!this.connected()) {
            this.open();
        }
        if (setAuth) {
            this.setAuth(request);
        }
        this.wirehandler.writeMessage(this.socket.getOutputStream(), request);
        this.sessionStats.incStat(StatType.TOTAL_SOCKET_BYTES_SENT, request.getSmfHeader().getSmfEncodedLength() + request.getPayload().length);
    }

    public int beginReconnection() throws InterruptedException {
        int loops = 0;
        Object object = this._stateLock;
        synchronized (object) {
            String threadName = Thread.currentThread().getName();
            while (true) {
                if (this._sharedSocketState == SS.CONNECTING) {
                    Trace.debug((Object)(threadName + String.format(" (smfclient %s) =======>_sharedSocketState=%s; reconnect already started, abort", new Object[]{this._smfClientId, this._sharedSocketState})));
                    return 2;
                }
                if (this._sharedSocketState == SS.CLOSED) {
                    Trace.debug((Object)(threadName + String.format(" (smfclient %s) =======>_sharedSocketState=%s; reconnect abort", new Object[]{this._smfClientId, this._sharedSocketState})));
                    return 1;
                }
                if (this._sharedSocketState == SS.PRERECONNECT || this._sharedSocketState == SS.READY_TO_WRITE || loops > 10) {
                    Trace.debug((Object)String.format("%s (smfclient %s) =======>_sharedSocketState=%s; change to CONNECTING; begin reconnect", new Object[]{threadName, this._smfClientId, this._sharedSocketState}));
                    this._sharedSocketState = SS.CONNECTING;
                    this._priorityData.clear();
                    this.outMessageBuf = null;
                    if (this._pubDirectSendBuf != null) {
                        this._pubDirectSendBuf.clear();
                    }
                    this._writeCompleteSem.release();
                    return 3;
                }
                Trace.debug((Object)String.format("%s (smfclient %s) =======>_sharedSocketState=%s; begin reconnection (waiting...)", new Object[]{threadName, this._smfClientId, this._sharedSocketState}));
                ++loops;
                this._stateLock.wait(100L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endReconnection(boolean success, SS stateOnSuccess, SS expectedState, int timeout) throws JCSMPTransportException {
        Object object = this._stateLock;
        synchronized (object) {
            if (success) {
                long endTime = System.currentTimeMillis() + (long)timeout;
                try {
                    while (expectedState != null && this._sharedSocketState != expectedState) {
                        this._stateLock.wait(100L);
                        if (System.currentTimeMillis() <= endTime) continue;
                        throw new JCSMPTransportException("endReconnection:Timeout setting state " + (Object)((Object)stateOnSuccess) + " (expected=" + (Object)((Object)expectedState) + " actual=" + (Object)((Object)this._sharedSocketState) + ") (smfclient " + this.getSmfClientId() + ")");
                    }
                }
                catch (InterruptedException e) {
                    throw new JCSMPTransportException("endReconnection:Interrupted setting state " + (Object)((Object)stateOnSuccess));
                }
                this._sharedSocketState = stateOnSuccess;
            } else {
                this._sharedSocketState = SS.CLOSED;
            }
            Trace.debug((Object)String.format("%s (smfclient %s)====> notifyAll reconnect end success=%s newstate=%s", new Object[]{Thread.currentThread().getName(), this._smfClientId, success, this._sharedSocketState}));
            this._stateLock.notifyAll();
            this._writeCompleteSem.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endPostReconnect() {
        Object object = this._stateLock;
        synchronized (object) {
            Trace.debug((Object)String.format("%s (smfclient %s)====> notifyAll post reconnect end", Thread.currentThread().getName(), this._smfClientId));
            this._stateLock.notifyAll();
        }
    }

    public SS getSharedSocketState() {
        return this._sharedSocketState;
    }

    public int doSmfSharedWrite(WireMessage request, ByteBuffer[] requestBB, boolean setAuth, boolean setCorrTag, boolean dropOnWouldBlock, boolean allowOnStateSub, boolean allowReactorFinishWrite, boolean stopOnNoconnection) throws JCSMPException, IOException, InterruptedException {
        return this.doSmfSharedWrite(request, requestBB, setAuth, setCorrTag, dropOnWouldBlock, allowOnStateSub, allowReactorFinishWrite, null, null, null, null, stopOnNoconnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doSmfSharedWrite(WireMessage request, ByteBuffer[] requestBB, boolean setAuth, boolean setCorrTag, boolean dropOnWouldBlock, boolean allowOnStateSub, boolean allowReactorFinishWrite, Integer idTag, TcpClientChannel channel, ClientRequestResponse req, Long corrId, boolean stopOnNoconnection) throws JCSMPException, IOException, InterruptedException {
        Object object;
        if (setAuth) {
            this.setAuth(request);
        }
        if (setCorrTag) {
            long corr;
            if (corrId != null) {
                this.conditionalAddCorrelationTag(request, corrId);
                corr = corrId;
            } else {
                corr = this.conditionalAddCorrelationTag(request);
            }
            req.setLastCorrelationTag((int)corr);
        }
        SS return_to_state = null;
        Object object2 = this._stateLock;
        synchronized (object2) {
            while (this._sharedSocketState != SS.READY_TO_WRITE && this._sharedSocketState != SS.CLOSED) {
                if (stopOnNoconnection && (this._sharedSocketState == SS.CONNECTING || this._sharedSocketState == SS.STARTSTATE || this._sharedSocketState == SS.PRERECONNECT)) {
                    return 2;
                }
                if (allowOnStateSub && this._sharedSocketState == SS.SUB_ESTABLISH) break;
                if (dropOnWouldBlock && (!allowReactorFinishWrite || this._sharedSocketState != SS.WRITING)) {
                    Trace.debug((Object)String.format("(smfclient %s) doSmfSharedWrite: skipping low-priority write request (would block), caller will retry", this._smfClientId));
                    return 1;
                }
                this._stateLock.wait(200L);
            }
            if (this._sharedSocketState == SS.CLOSED) {
                throw new SmfClientIOException("Lost connection to the router.", this._connCounter);
            }
            return_to_state = this._sharedSocketState;
            this._sharedSocketState = SS.WRITING;
            this._clientException = null;
        }
        int write_loop_return = 0;
        this._writeCompleteSem.drainPermits();
        boolean allowCompleteOnReactor = false;
        allowCompleteOnReactor = !dropOnWouldBlock ? true : allowReactorFinishWrite;
        if (this._priorityData.hasWork()) {
            this.servicePriorityQueuedData();
        }
        if (idTag != null && idTag.intValue() != this.getConnCounter()) {
            write_loop_return = 1;
        } else {
            if (request != null && request.encoder != null && channel != null && req != null) {
                WireMessageEncoder encoder = request.encoder;
                request = request.encoder.encode();
                request.encoder = encoder;
                channel.setReqCorrelationTag(request, req.getLastCorrelationTag());
            }
            ByteBuffer[] outBufLocal = this.getOutputBufferForSend(requestBB, request, this.wirehandler);
            this.enqueueForNetOutput(outBufLocal);
            write_loop_return = this.writeLoop(true, !allowCompleteOnReactor);
            this._writeCompleteSem.acquire();
            if (this._clientException != null && this._priorityData.hasWork()) {
                this.servicePriorityQueuedData();
                this._writeCompleteSem.drainPermits();
                write_loop_return = this.writeLoop(true, !allowCompleteOnReactor);
                this._writeCompleteSem.acquire();
            }
        }
        if (this._clientException != null) {
            object = this._stateLock;
            synchronized (object) {
                if (this._sharedSocketState != SS.CONNECTING && this._sharedSocketState != SS.CLOSED) {
                    this._sharedSocketState = SS.PRERECONNECT;
                }
                this._stateLock.notifyAll();
            }
            throw new SmfClientIOException(this.getNetworkInfoString() + "Error occurred in write: " + this._clientException, this._connCounter);
        }
        object = this._stateLock;
        synchronized (object) {
            if (this._sharedSocketState == SS.WRITING) {
                this._sharedSocketState = return_to_state;
                this._stateLock.notifyAll();
            }
        }
        return write_loop_return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueueForNetOutput(ByteBuffer[] bufs) {
        Object object = this._stateLock;
        synchronized (object) {
            int bytes_to_wr = SimpleSmfClient.remainingBytes(bufs);
            if (bytes_to_wr > this.outMessageBuf.remaining()) {
                int new_sz = (int)((double)(this.outMessageBuf.position() + bytes_to_wr) * 1.25);
                ByteBuffer b = this.useIntermediateDirectBuf ? ByteBuffer.allocateDirect(new_sz) : ByteBuffer.allocate(new_sz);
                this.outMessageBuf.flip();
                b.put(this.outMessageBuf);
                this.outMessageBuf = b;
            }
            for (ByteBuffer src : bufs) {
                this.outMessageBuf.put(src);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteBuffer[] getOutputBufferForSend(ByteBuffer[] requestBB, WireMessage request, WireMessageHandler wirehandler) throws IOException {
        ByteBuffer[] outBufLocal = null;
        Object object = this._stateLock;
        synchronized (object) {
            byte[] outMessageData = null;
            if (request != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                wirehandler.writeMessage(baos, request);
                outMessageData = baos.toByteArray();
            } else if (requestBB != null) {
                outMessageData = new byte[SimpleSmfClient.remainingBytes(requestBB)];
                int i = 0;
                for (ByteBuffer b : requestBB) {
                    int len = b.remaining();
                    b.get(outMessageData, i, len);
                    i += len;
                }
            } else {
                throw new IllegalArgumentException("No request.");
            }
            outBufLocal = new ByteBuffer[]{ByteBuffer.wrap(outMessageData, 0, outMessageData.length)};
            this.sessionStats.incStat(StatType.TOTAL_SOCKET_BYTES_SENT, outMessageData.length);
        }
        return outBufLocal;
    }

    public static int remainingBytes(ByteBuffer[] buf_vector) {
        int rembytes = 0;
        for (ByteBuffer b : buf_vector) {
            rembytes += b.remaining();
        }
        return rembytes;
    }

    public static int limitBytes(ByteBuffer[] buf_vector) {
        int rembytes = 0;
        for (ByteBuffer b : buf_vector) {
            rembytes += b.limit();
        }
        return rembytes;
    }

    protected boolean servicePriorityQueuedData() {
        try {
            while (this._priorityData.hasWork()) {
                ByteBuffer b = this._priorityData.dequeue();
                ByteBuffer[] bba = this.getOutputBufferForSend(new ByteBuffer[]{b}, null, null);
                this.enqueueForNetOutput(bba);
            }
        }
        catch (IOException e) {
            this._clientException = e;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int writeLoop(boolean allowReg, boolean dropOnWouldBlock) {
        long out_data_remaining = 0L;
        long out_data_written = 0L;
        Object object = this._stateLock;
        synchronized (object) {
            boolean wrote_everything;
            block13: {
                if (this.outMessageBuf == null) {
                    return 0;
                }
                this.outMessageBuf.flip();
                out_data_remaining = this.outMessageBuf.remaining();
                if (out_data_remaining > 0L) {
                    try {
                        out_data_written = this.socket.getChannel().write(this.outMessageBuf);
                        this.m_bytesWrittenCtr.addAndGet(out_data_written);
                    }
                    catch (IOException ex) {
                        this._clientException = ex;
                    }
                    catch (NotYetConnectedException ex) {
                        if ($assertionsDisabled) break block13;
                        throw new AssertionError();
                    }
                }
            }
            this.outMessageBuf.compact();
            long bytes_remaining = out_data_remaining - out_data_written;
            boolean bl = wrote_everything = bytes_remaining == 0L;
            if (this._clientException != null || wrote_everything) {
                if (!allowReg) {
                    this._reactor.deregisterHandler(this, 4);
                }
                this._writeCompleteSem.release();
            } else if (allowReg && !wrote_everything) {
                this._reactor.registerHandler(this, 4);
                if (dropOnWouldBlock) {
                    Trace.debug((Object)String.format("(smfclient %s) Buffering low-priority write request (would block), Thread=%s", this._smfClientId, Thread.currentThread().getName()));
                    this._writeCompleteSem.release();
                }
            }
        }
        return 0;
    }

    public void clearCallbackHandler() {
    }

    public AbstractSelectableChannel getChannel() {
        return this.socket == null ? null : this.socket.getChannel();
    }

    public void handleClosedSocketDuringWrite(CancelledKeyException cke, SelectableChannel sc) {
        Trace.debug((Object)(this.getNetworkInfoString() + String.format("(smfclient %s) handleClosedSocketDuringWrite", this._smfClientId)));
        this.handleClientWriteException(cke);
    }

    public void write(SelectableChannel keyChannel) {
        if (this.getChannel() != keyChannel) {
            Trace.info((Object)(this.getNetworkInfoString() + "Abort write on stale SelectableChannel."));
            return;
        }
        this.writeLoop(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClientWriteException(Exception ex) {
        Trace.debug((Object)(this.getNetworkInfoString() + String.format("(smfclient %s) handleClientWriteException", this._smfClientId)));
        Object object = this._stateLock;
        synchronized (object) {
            if (this._sharedSocketState == SS.WRITING) {
                this._clientException = ex;
                this._writeCompleteSem.release();
            }
        }
    }

    protected void setAuth(WireMessage msg) throws JCSMPException {
        SMFHeaderBean smfHeader = msg.getSmfHeader();
        if (this.authParams instanceof AuthenticationSchemeBasicParameters) {
            AuthenticationSchemeBasicParameters basicAuthParams = (AuthenticationSchemeBasicParameters)this.authParams;
            String username = basicAuthParams.getUsername();
            String password = basicAuthParams.getPassword();
            if (username == null || username.trim().length() == 0) {
                throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("SimpleSmfClient.usernameMustBeSet"));
            }
            this.conditionalAddCredentials(smfHeader, username, password);
        } else if (this.authParams instanceof AuthenticationSchemeClientCertificateParameters) {
            AuthenticationSchemeClientCertificateParameters clientCertificateAuthParameters = (AuthenticationSchemeClientCertificateParameters)this.authParams;
            if (clientCertificateAuthParameters.isUsernameSet()) {
                String username = clientCertificateAuthParameters.getUsername();
                this.conditionalAddCredentials(smfHeader, username, null);
            }
        } else {
            AuthenticationSchemeKRBParameters krbAuthParams = (AuthenticationSchemeKRBParameters)this.authParams;
            this.conditionalAddCredentials(smfHeader, krbAuthParams.getToken(), krbAuthParams.getUsername());
        }
    }

    public boolean connected() {
        if (this.socket != null) {
            return this.isconnected && this.socket.isConnected();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClientConnected() {
        Object object = this._stateLock;
        synchronized (object) {
            return this._sharedSocketState != SS.CLOSED && this._sharedSocketState != SS.STARTSTATE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws UnknownHostException, IOException, JCSMPException {
        if (this.authParams instanceof AuthenticationSchemeKRBParameters) {
            AuthenticationSchemeKRBParameters krbAuthParams = (AuthenticationSchemeKRBParameters)this.authParams;
            this.getKRBToken(krbAuthParams, krbAuthParams.getServiceName() + "@" + this.remoteHost);
        }
        if (this.outMessageBuf == null) {
            this.outMessageBuf = this.useIntermediateDirectBuf ? ByteBuffer.allocateDirect(DEFAULT_SEND_BUF_SIZE) : ByteBuffer.allocate(DEFAULT_SEND_BUF_SIZE);
        }
        this._clientException = null;
        if (this.getRemoteHost() == null || this.getRemotePort() == 0) {
            throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("SimpleSmfClient.missingConnectionData"));
        }
        this.sessionStats.incStat(StatType.TOTAL_CONNECTION_ATTEMPTS);
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)(this.getNetworkInfoString() + String.format("(smfclient %s) Attempting to open socket, host=", this._smfClientId) + this.remoteHost + ", port=" + this.remotePort));
        }
        SocketChannel socketChannel = SocketChannel.open();
        Object newSocket = null;
        try {
            socketChannel.configureBlocking(true);
        }
        catch (IOException e) {
            socketChannel.close();
            throw e;
        }
        this.socket = socketChannel.socket();
        this.setSocketOptions(this.socket);
        if (this.localAddress != null) {
            this.socket.bind(new InetSocketAddress(this.localAddress, 0));
        }
        try {
            this.socket.connect(new InetSocketAddress(this.remoteHost, this.remotePort), this.connTimeout);
        }
        catch (ClosedSelectorException cse) {
            throw new IOException("ClosedSelectorException caught from connect: " + cse.getMessage());
        }
        if (this._subReader != null) {
            this._subReader.setChannel(this.socket.getChannel());
        }
        Object object = this._stateLock;
        synchronized (object) {
            if (this._sharedSocketState == SS.STARTSTATE) {
                this._sharedSocketState = SS.READY_TO_WRITE;
                this._stateLock.notifyAll();
            }
        }
        this.incrementConnCounterTag();
        this.isconnected = true;
    }

    public int getConnCounter() {
        return this._connCounter;
    }

    public Integer getConnCounterTag() {
        return this._connCounter;
    }

    public synchronized void incrementConnCounterTag() {
        ++this._connCounter;
    }

    public long getBytesWritten() {
        return this.m_bytesWrittenCtr.get();
    }

    private void setSocketOptions(Socket socket) throws SocketException {
        socket.setSoTimeout(this.sockTimeout);
        socket.setTcpNoDelay(this.isTcpNoDelay());
        if (this.so_rcvbuf > 0) {
            socket.setReceiveBufferSize(this.so_rcvbuf);
        }
        if (this.so_sndbuf > 0) {
            socket.setSendBufferSize(this.so_sndbuf);
        }
    }

    public void close() throws IOException {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean isReconn) throws IOException {
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)(this.getNetworkInfoString() + String.format("(smfclient %s) Closing socket", this._smfClientId)));
        }
        this._priorityData.clear();
        if (!isReconn) {
            Object object = this._stateLock;
            synchronized (object) {
                this._sharedSocketState = SS.CLOSED;
                this._stateLock.notifyAll();
            }
            this.outMessageBuf = null;
        }
        if (this._subReader != null) {
            this._subReader.clearCallbackHandler();
            this._subReader.clearBuffers();
        }
        if (this.socket != null) {
            SocketChannel sc = this.socket.getChannel();
            if (sc != null) {
                SocketChannel socketChannel = sc;
                synchronized (socketChannel) {
                    this.socket.close();
                }
            } else {
                this.socket.close();
            }
        }
        this.deregisterClientRead();
        this.isconnected = false;
        if (this._subReader != null) {
            this._subReader.setChannel(null);
        }
        if (!isReconn) {
            this._writeCompleteSem.release();
        }
    }

    protected long conditionalAddCorrelationTag(WireMessage postMsg) {
        long corrId = this.ctrl_seqAlloc.getNext24b();
        return this.conditionalAddCorrelationTag(postMsg, corrId);
    }

    protected long conditionalAddCorrelationTag(WireMessage postMsg, long corrId) {
        SmfTLVParameter param;
        if (postMsg.getSmfHeader() == null) {
            return -1L;
        }
        SMFHeaderBean smfh = postMsg.getSmfHeader();
        if (postMsg.isSentFlag()) {
            smfh.deleteParameters(32);
            smfh.setPm_corrtag(-1);
        }
        if ((param = (SmfTLVParameter)smfh.findFirstParameter(32)) == null) {
            if (Trace.isDebugEnabled()) {
                Trace.debug((Object)(this.getNetworkInfoString() + "Correlation tag not found in message, adding one: " + corrId));
            }
            smfh.addParam(TlvParameterFactorySmf.instance().getCorrelationId(corrId));
            return corrId;
        }
        return NetworkByteOrderNumberUtil.threeByteToUInt(param.value);
    }

    private void conditionalAddCredentials(SMFHeaderBean smfHeader, String username, String password) {
        if (smfHeader.findFirstParameter(6) == null) {
            smfHeader.addParam(this.smfParamFactory.getUsername(username));
        }
        if (password != null && !password.trim().equals("") && smfHeader.findFirstParameter(7) == null) {
            smfHeader.addParam(this.smfParamFactory.getPassword(password));
        }
    }

    private void conditionalAddCredentials(SMFHeaderBean smfHeader, byte[] token, String username) {
        if (smfHeader.findFirstParameter(40) == null) {
            smfHeader.addParam(this.smfParamFactory.getGSSAPIToken(token));
        }
        if (username != null && !username.trim().equals("") && smfHeader.findFirstParameter(6) == null) {
            smfHeader.addParam(this.smfParamFactory.getUsername(username));
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public void setConnTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(InetAddress localAddr) {
        this.localAddress = localAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(HostInfo host) {
        this.remoteHost = host.getHost();
        if (host.getPort() == null) {
            if (host.isSecure()) {
                this.setRemotePort(55443);
            } else {
                this.setRemotePort(this._cprops.getSmfPort());
            }
        } else {
            this.setRemotePort(host.getPort());
        }
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public int getSockTimeout() {
        return this.sockTimeout;
    }

    public void setSockTimeout(int sockTimeout) {
        this.sockTimeout = sockTimeout;
    }

    public int getSO_sndbuf() {
        return this.so_sndbuf;
    }

    public void setSO_sndbuf(int so_sndbuf) {
        this.so_sndbuf = so_sndbuf;
    }

    public int getSO_rcvbuf() {
        return this.so_rcvbuf;
    }

    public void setSO_rcvbuf(int so_rcvbuf) {
        this.so_rcvbuf = so_rcvbuf;
    }

    @Deprecated
    public JCSMPSecureProtocolSocketFactory getJcsmpSecureProtocolSocketFactory() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setJcsmpSecureProtocolSocketFactory(JCSMPSecureProtocolSocketFactory jcsmpSecureProtocolSocketFactory) {
        throw new UnsupportedOperationException();
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public void handleClosedSocketDuringRead(CancelledKeyException cke, SelectableChannel sc) {
        Trace.debug((Object)String.format("(smfclient %s) handleClosedSocketDuringRead", this._smfClientId));
        this.handleClientWriteException(cke);
        if (this._subReader != null) {
            this._subReader.handleClosedSocketDuringRead(cke, sc);
        }
    }

    public void read() {
        if (this._subReader != null) {
            this._subReader.read();
        }
    }

    public void registerClientRead() {
        this._reactor.registerHandler(this, 1);
    }

    public void deregisterClientRead() {
        this._reactor.deregisterHandler(this, 1);
    }

    public int getSmfClientId() {
        return this._smfClientId;
    }

    public void notifyFatalError(JCSMPFatalErrorException ex) {
        this.handleClientWriteException((Exception)((Object)ex));
        if (this._subReader != null) {
            this._subReader.notifyFatalError(ex);
        }
    }

    private static Oid createKRB5Mechanism() {
        try {
            return new Oid("1.2.840.113554.1.2.2");
        }
        catch (GSSException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void getKRBToken(AuthenticationSchemeKRBParameters krbAuthParams, String host) throws JCSMPSecurityException {
        LoginContext lc;
        try {
            if (krbAuthParams.reloadConfigFile()) {
                Configuration.getConfiguration().refresh();
            }
            lc = new LoginContext(krbAuthParams.getLoginContextName());
            lc.login();
        }
        catch (Throwable t) {
            throw new JCSMPSecurityException(String.format("Error performing login to LoginContext (%s)", t.getMessage()), t);
        }
        krbAuthParams.setLoginContext(lc);
        try {
            GSSManager manager = GSSManager.getInstance();
            GSSName serverName = manager.createName(host, GSSName.NT_HOSTBASED_SERVICE);
            final GSSContext context = manager.createContext(serverName, krb5Mechanism, null, 0);
            context.requestMutualAuth(krbAuthParams.useMutualAuthentication());
            context.requestCredDeleg(false);
            krbAuthParams.setGSSContext(context);
            final byte[] inToken = new byte[]{};
            Object serviceTicket = Subject.doAs(lc.getSubject(), new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        return context.initSecContext(inToken, 0, inToken.length);
                    }
                    catch (Throwable t) {
                        return t;
                    }
                }
            });
            if (serviceTicket instanceof Throwable) {
                throw (Throwable)serviceTicket;
            }
            if (Trace.isWarnEnabled() && !krbAuthParams.useMutualAuthentication() && !context.isEstablished()) {
                Trace.warn((Object)"Context not established with mutual authentication off");
            }
            krbAuthParams.setToken((byte[])serviceTicket);
        }
        catch (Throwable t) {
            throw new JCSMPSecurityException(String.format("Error initializing security context (%s)", t.getMessage()), t);
        }
    }

    public static class PriorityData {
        protected final AtomicBoolean HasWork = new AtomicBoolean(false);
        protected LinkedList<ByteBuffer> mBuffers = new LinkedList();
        protected JCSMPTimer mTimer = null;

        public final boolean hasWork() {
            return this.HasWork.get();
        }

        public synchronized void enqueue(ByteBuffer buf, SimpleSmfClient parentSmfClient) {
            this.mBuffers.add(buf);
            this.HasWork.set(true);
            parentSmfClient._priorityDataTimerHandler.schedule();
        }

        public synchronized ByteBuffer dequeue() {
            ByteBuffer o = this.mBuffers.remove();
            if (this.mBuffers.isEmpty()) {
                this.HasWork.set(false);
            }
            return o;
        }

        public void enqueue(WireMessage request, SimpleSmfClient parentSmfClient) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            SMFWireMessageHandler wirehandler = new SMFWireMessageHandler();
            try {
                wirehandler.writeMessage(baos, request);
                ByteBuffer buf = ByteBuffer.wrap(baos.toByteArray());
                this.enqueue(buf, parentSmfClient);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public synchronized ByteBuffer peek() {
            return this.mBuffers.peek();
        }

        public synchronized void clear() {
            this.mBuffers.clear();
            this.HasWork.set(false);
        }

        public synchronized String toString() {
            return "[HasWork: " + this.hasWork() + ", QueueDepth: " + this.mBuffers.size() + "]";
        }
    }

    protected static class PriorityDataTimerHandler
    implements JCSMPTimeoutHandler {
        private final PriorityData mPrioData;
        private final SimpleSmfClient mSmfClient;

        public PriorityDataTimerHandler(PriorityData pData, SimpleSmfClient smfClient) {
            this.mPrioData = pData;
            this.mSmfClient = smfClient;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void schedule() {
            PriorityData priorityData = this.mPrioData;
            synchronized (priorityData) {
                JCSMPTimer timerObj;
                JCSMPTimer existingTimer = this.mPrioData.mTimer;
                if (existingTimer != null && existingTimer.isActive()) {
                    return;
                }
                JCSMPTimerQueue tq = (JCSMPTimerQueue)((Object)this.mSmfClient._reactor);
                this.mPrioData.mTimer = timerObj = tq.schedule_relative(10L, this);
            }
        }

        public void handleTimeout() {
            if (this.mPrioData == null || !this.mPrioData.hasWork()) {
                return;
            }
            ByteBuffer[] dummyBuf = new ByteBuffer[]{ByteBuffer.allocate(0)};
            try {
                int ret = this.mSmfClient.doSmfSharedWrite(null, dummyBuf, false, false, true, true, false, false);
                if (ret == 0) {
                    return;
                }
                this.schedule();
            }
            catch (Exception e) {
                Trace.info((Object)("Error handling PriorityDataTimerHandler (will reschedule): " + e));
                this.schedule();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SS {
        WRITING,
        READY_TO_WRITE,
        CONNECTING,
        CLOSED,
        STARTSTATE,
        PRERECONNECT,
        SUB_ESTABLISH;

    }
}

