/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.client;

import com.solacesystems.common.util.Base64;
import com.solacesystems.common.util.DestinationUtil;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.InputValidationUtil;
import com.solacesystems.jcsmp.impl.TargetRouterMode;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientInfoUtil {
    private AtomicInteger _connCounter = new AtomicInteger(0);
    private static ClientInfoUtil _self = null;

    public static synchronized ClientInfoUtil onlyInstance() {
        if (_self == null) {
            _self = new ClientInfoUtil();
        }
        return _self;
    }

    private ClientInfoUtil() {
    }

    public static String generateRandom10Chars() {
        byte[] randomBytes = new byte[8];
        SecureRandom rng = new SecureRandom();
        ((Random)rng).nextBytes(randomBytes);
        return Base64.encodeBytes(randomBytes, 24).substring(0, 10);
    }

    public static String constructClientName(String instanceId, String hostname, int pid) {
        String hname = ClientInfoUtil.trunc(hostname, 32);
        String random10chars = ClientInfoUtil.generateRandom10Chars();
        return String.format("%s/%s/#%s/%s", hname, pid, instanceId, random10chars);
    }

    public static void validateClientName(String clientName, TargetRouterMode rm) {
        if (!InputValidationUtil.validateStringLengthUtf8(clientName, 160)) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getFormattedMessage("JCSMPFactory.propertyTooLong", new Object[]{"client_name", 160}));
        }
        switch (rm) {
            case CRB: {
                DestinationUtil.isValidTopic(clientName, false);
                break;
            }
            case TRB: {
                DestinationUtil.isValidTopicTrb(clientName, false);
            }
        }
    }

    public static String trunc(String s, int len) {
        return s.length() > len ? s.substring(0, len) : s;
    }

    public static String truncWithElipses(String s, int len) {
        return s.length() > len ? s.substring(0, len) + " ... " : s;
    }

    public AtomicInteger getGlobalSessionCounter() {
        return this._connCounter;
    }
}

