/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.jcsmp.Context;
import com.solacesystems.jcsmp.ContextProperties;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.management.SolJmxSupport;
import com.solacesystems.jcsmp.protocol.nio.impl.ConsumerNotificationDispatcher;
import com.solacesystems.jcsmp.protocol.nio.impl.ProducerNotificationDispatcher;
import com.solacesystems.jcsmp.protocol.nio.impl.ShutdownRequestNotification;
import com.solacesystems.jcsmp.protocol.nio.impl.SyncEventDispatcherReactor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ContextImpl
implements Context {
    private String _name;
    private final int _contextId;
    private volatile SyncEventDispatcherReactor _ioreactor;
    private volatile ConsumerNotificationDispatcher _cons_dispatcher;
    private volatile ProducerNotificationDispatcher _prod_dispatcher;
    private volatile boolean destroyed = false;
    private Object lock = new Object();
    private List<JCSMPSession> _sessions = new LinkedList<JCSMPSession>();
    private ExecutorService _reconnect_service;
    private ExecutorService _connect_notify_service;
    private ExecutorService _retransmit_service;
    private ExecutorService _cache_service;
    DaemonThreadFactory _reconnect_service_thread_factory;
    DaemonThreadFactory _retransmit_service_thread_factory;
    private static AtomicInteger _global_context_counter = new AtomicInteger(0);

    private ContextImpl() {
        this._contextId = _global_context_counter.incrementAndGet();
        this._reconnect_service_thread_factory = new DaemonThreadFactory("reconnect_service");
        this._retransmit_service_thread_factory = new DaemonThreadFactory("retransmit_service");
        this._reconnect_service = Executors.newSingleThreadExecutor(this._reconnect_service_thread_factory);
        this._connect_notify_service = Executors.newSingleThreadExecutor(new DaemonThreadFactory("reconnect_notify_service"));
        this._retransmit_service = Executors.newSingleThreadExecutor(this._retransmit_service_thread_factory);
        this._cache_service = Executors.newSingleThreadExecutor(new DaemonThreadFactory("cache_service"));
    }

    public boolean isAnInternalReconnectRelatedThread() {
        Long id = Thread.currentThread().getId();
        return this._reconnect_service_thread_factory.contains(id) || this._retransmit_service_thread_factory.contains(id);
    }

    public ContextImpl(ContextProperties props) {
        this();
        if (props != null) {
            this._name = props.getName();
        }
        if (this._name == null || this._name.equals("")) {
            this._name = String.format("Context %s", this._contextId);
        }
        SolJmxSupport.instance().register(this);
    }

    private final void checkNotDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException(JCSMPRB.BUNDLE.getStringSafely("ContextImpl.AttemptedOperationOnDestroyed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SyncEventDispatcherReactor getIOReactor() {
        this.checkNotDestroyed();
        if (this._ioreactor == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this._ioreactor == null) {
                    this._ioreactor = SyncEventDispatcherReactor.create(String.valueOf(this._contextId));
                }
            }
        }
        return this._ioreactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ConsumerNotificationDispatcher getConsumerDispatcher() {
        this.checkNotDestroyed();
        if (this._cons_dispatcher == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this._cons_dispatcher == null) {
                    this._cons_dispatcher = ConsumerNotificationDispatcher.create(String.valueOf(this._contextId));
                }
            }
        }
        return this._cons_dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ProducerNotificationDispatcher getProducerDispatcher() {
        this.checkNotDestroyed();
        if (this._prod_dispatcher == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this._prod_dispatcher == null) {
                    this._prod_dispatcher = ProducerNotificationDispatcher.create(String.valueOf(this._contextId));
                }
            }
        }
        return this._prod_dispatcher;
    }

    public synchronized void addSession(JCSMPSession s) {
        this.checkNotDestroyed();
        this._sessions.add(s);
    }

    public synchronized void removeSession(JCSMPSession s) {
        this.checkNotDestroyed();
        Iterator<JCSMPSession> it = this._sessions.iterator();
        while (it.hasNext()) {
            JCSMPSession cur = it.next();
            if (cur != s) continue;
            it.remove();
            break;
        }
    }

    public ExecutorService getExecutorService() {
        return this._reconnect_service;
    }

    public ExecutorService getConnectNotifyService() {
        return this._connect_notify_service;
    }

    public ExecutorService getRetransmitService() {
        return this._retransmit_service;
    }

    public ExecutorService getCacheService() {
        return this._cache_service;
    }

    public synchronized void destroy() {
        if (this.destroyed) {
            return;
        }
        SolJmxSupport.instance().deregister(this);
        ArrayList<JCSMPSession> lst_toclose = new ArrayList<JCSMPSession>();
        lst_toclose.addAll(this._sessions);
        for (JCSMPSession cur : lst_toclose) {
            cur.closeSession();
        }
        this._sessions.clear();
        if (this._ioreactor != null) {
            this._ioreactor.requestShutdown();
            this._ioreactor = null;
        }
        if (this._cons_dispatcher != null) {
            try {
                this._cons_dispatcher.enqueueBlockingNotification(new ShutdownRequestNotification());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._cons_dispatcher = null;
        }
        if (this._prod_dispatcher != null) {
            this._prod_dispatcher.enqueueNotification(new ShutdownRequestNotification());
            this._prod_dispatcher = null;
        }
        this._reconnect_service.shutdown();
        this._connect_notify_service.shutdown();
        this._retransmit_service.shutdown();
        this._cache_service.shutdown();
        this.destroyed = true;
    }

    public String toString() {
        return this._name + String.format(" (%04x)", this._contextId);
    }

    public int getContextId() {
        return this._contextId;
    }

    class DaemonThreadFactory
    implements ThreadFactory {
        private final String executor_name;
        private Set<Long> threadIds = new HashSet<Long>();

        public DaemonThreadFactory(String executor_name) {
            this.executor_name = executor_name;
        }

        public Thread newThread(Runnable r) {
            Thread th = new Thread(r);
            th.setName(String.format("Context_%s_Thread_%s", ContextImpl.this._contextId, this.executor_name));
            th.setDaemon(true);
            this.threadIds.add(th.getId());
            return th;
        }

        public boolean contains(Long id) {
            return this.threadIds.contains(id);
        }
    }
}

