/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util.property;

import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Property<T> {
    private String mName;
    private String mDescription;
    private T mDefaultValue;
    private HashMap<String, Source> mSources;

    public Property(String name, String description, T defaultValue) {
        this.mName = name;
        this.mDescription = description;
        this.mDefaultValue = defaultValue;
        this.mSources = new HashMap();
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public T getDefaultValue() {
        return this.mDefaultValue;
    }

    public void addSource(String name, Comparable<?> comparable) {
        this.mSources.put(name, new Source(name, comparable));
    }

    public void setSourceValue(String name, T value) {
        Source source = this.mSources.get(name);
        source.setValue(value);
    }

    public boolean isSet() {
        Iterator<String> it = this.mSources.keySet().iterator();
        while (it.hasNext()) {
            Source source = this.mSources.get(it.next());
            if (!source.isSet()) continue;
            return true;
        }
        return false;
    }

    public T getValue() {
        Source master = null;
        Iterator<String> it = this.mSources.keySet().iterator();
        while (it.hasNext()) {
            Source source = this.mSources.get(it.next());
            if (!source.isSet()) continue;
            if (master == null) {
                master = source;
                continue;
            }
            if (master.getComparable().compareTo(source.getComparable()) >= 0) continue;
            master = source;
        }
        if (master == null) {
            return this.mDefaultValue;
        }
        return master.getValue();
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("name=\"");
        bldr.append(this.mName);
        bldr.append("\", desc=\"");
        bldr.append(this.mDescription);
        bldr.append("\", default=");
        bldr.append(this.mDefaultValue);
        bldr.append(", value=");
        bldr.append(this.getValue());
        bldr.append(", sources=");
        bldr.append(this.mSources.values());
        return bldr.toString();
    }

    public static void main(String[] args) {
        Property<Integer> property = new Property<Integer>("property1", "property1 description", 1000);
        property.addSource("jvm1", Integer.valueOf(4));
        property.addSource("jvm2", Integer.valueOf(2));
        property.setSourceValue("jvm1", 23);
        property.setSourceValue("jvm2", 30);
        System.out.println(property.getValue());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Source {
        private String mName;
        private Comparable<?> mComparable;
        private T mValue;
        private boolean mIsSet;

        public Source(String name, Comparable<?> comparable) {
            this.mName = name;
            this.mComparable = comparable;
            this.mValue = null;
            this.mIsSet = false;
        }

        public String getName() {
            return this.mName;
        }

        public Comparable getComparable() {
            return this.mComparable;
        }

        public T getValue() {
            return this.mValue;
        }

        public boolean isSet() {
            return this.mIsSet;
        }

        public void setValue(T value) {
            this.mValue = value;
            this.mIsSet = true;
        }

        public String toString() {
            StringBuilder bldr = new StringBuilder();
            bldr.append("name=\"");
            bldr.append(this.mName);
            bldr.append("\", value=");
            bldr.append(this.mValue);
            bldr.append(", isSet=");
            bldr.append(this.mIsSet);
            bldr.append(", comp=");
            bldr.append(this.mComparable);
            return bldr.toString();
        }
    }
}

