/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.nio.impl;

import com.solacesystems.common.util.BitTwiddleUtil;
import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NioSmfUtil {
    private static final Log Trace = LogFactory.getLog(NioSmfUtil.class);
    public static final int SMF2HEADERBLOCKLEN = 8;
    public static final int SMF3HEADERBLOCKLEN = 12;
    public static final int WORDLEN = 4;

    public static boolean isSmfMessageAvailableAtCurrentPos(ByteBuffer buf) throws IOException {
        int lenData = buf.remaining();
        return NioSmfUtil.smfSizeReqAtCurrentPos(buf) <= lenData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int smfSizeReqAtCurrentPos(ByteBuffer buf) throws IOException {
        int initLimit = buf.limit();
        int initPosition = buf.position();
        int reportedMsgLen = 0;
        try {
            int lenData = buf.remaining();
            if (lenData < 8) {
                int n = 8;
                return n;
            }
            byte[] smfword = new byte[4];
            buf.get(smfword, 0, 4);
            long lword = NetworkByteOrderNumberUtil.fourByteToUInt(smfword);
            int smfVersion = (int)BitTwiddleUtil.extractBits(lword, 3L, 24L);
            NioSmfUtil.validateSmfVersion(smfVersion);
            switch (smfVersion) {
                case 2: {
                    smfword = new byte[4];
                    buf.get(smfword, 0, 4);
                    lword = NetworkByteOrderNumberUtil.fourByteToUInt(smfword);
                    reportedMsgLen = (int)BitTwiddleUtil.extractBits(lword, 24L, 0L);
                    break;
                }
                case 3: {
                    if (lenData < 12) {
                        reportedMsgLen = 12;
                        break;
                    }
                    smfword = new byte[4];
                    buf.get(smfword, 0, 4);
                    buf.get(smfword, 0, 4);
                    lword = NetworkByteOrderNumberUtil.fourByteToUInt(smfword);
                    reportedMsgLen = (int)lword;
                }
            }
            NioSmfUtil.validateSmfDeclaredLengthLegal(smfVersion, reportedMsgLen);
        }
        finally {
            buf.position(initPosition);
            buf.limit(initLimit);
        }
        return reportedMsgLen;
    }

    public static final void validateSmfVersion(int version) throws IOException {
        if (version != 2 && version != 3) {
            throw new IOException(JCSMPRB.BUNDLE.getStringSafely("SMFHeaderDecoder.couldNotReadValidSmfHeaderFromNet") + " found smf version=" + String.valueOf(version));
        }
    }

    public static final void validateSmfDeclaredLengthLegal(int smfVersion, int declaredLength) throws IOException {
        switch (smfVersion) {
            case 2: {
                if (declaredLength >= 8) break;
                throw new IOException(String.format("Illegal SMF declared packet length (%s)", declaredLength));
            }
            case 3: {
                if (declaredLength >= 12) break;
                throw new IOException(String.format("Illegal SMF declared packet length (%s)", declaredLength));
            }
        }
    }

    public static final void validateSmfHeaderLengthSane(int smfVersion, int smfHeaderLenBytes, int declaredMessageLength) throws IOException {
        switch (smfVersion) {
            case 2: {
                if (smfHeaderLenBytes >= 8) break;
                throw new IOException(String.format("Illegal SMF declared header length (%s)", smfHeaderLenBytes));
            }
            case 3: {
                if (smfHeaderLenBytes >= 12) break;
                throw new IOException(String.format("Illegal SMF declared header length (%s)", smfHeaderLenBytes));
            }
        }
        if (smfHeaderLenBytes > declaredMessageLength) {
            throw new IOException(String.format("Illegal SMF declared header length (%s), bigger than enclosing message.", smfHeaderLenBytes));
        }
    }
}

