/*
 * Decompiled with CFR 0.152.
 */
package com.solace.transport;

import com.solace.transport.SocketLevelStats;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface SolTransport
extends AutoCloseable {
    public void open(SocketLevelStats var1) throws Throwable;

    public boolean isOpen();

    public boolean isActive();

    @Override
    public void close() throws IOException;

    public void resumeReading() throws IOException;

    public void pauseReading() throws IOException;

    public InetSocketAddress getLocalAddress();

    public void flush();

    public void write(ByteBuffer var1) throws InterruptedException, IOException;

    public boolean canWrite() throws IOException;

    public void enableCompression(int var1) throws Exception;

    public void shutdownSSL() throws Exception;

    public long getTransportStats(Stats var1);

    public static enum Stats {
        TOTAL_SOCKET_BYTES_SENT("SOLACE_TOTAL_SOCKET_BYTES_SENT"),
        TOTAL_SOCKET_BYTES_RECVED("SOLACE_TOTAL_SOCKET_BYTES_RECVED"),
        TOTAL_SOCKET_SSL_BYTES_SENT("SOLACE_TOTAL_SOCKET_SSL_BYTES_SENT"),
        TOTAL_SOCKET_SSL_BYTES_RECVED("SOLACE_TOTAL_SOCKET_SSL_BYTES_RECVED"),
        TOTAL_SOCKET_COMPRESSED_BYTES_SENT("SOLACE_TOTAL_SOCKET_COMPRESSED_BYTES_SENT"),
        TOTAL_SOCKET_COMPRESSED_BYTES_RECVED("SOLACE_TOTAL_SOCKET_COMPRESSED_BYTES_RECVED"),
        TOTAL_SOCKET_WEBSOCKET_BYTES_SENT("SOLACE_TOTAL_SOCKET_WEBSOCKET_BYTES_SENT"),
        TOTAL_SOCKET_WEBSOCKET_BYTES_RECVED("SOLACE_TOTAL_SOCKET_WEBSOCKET_BYTES_RECVED");

        private String name_value;

        private Stats(String v) {
            this.name_value = v;
        }

        public String getNameValue() {
            return this.name_value;
        }
    }
}

