/*
 * Decompiled with CFR 0.152.
 */
package com.solace.transport.impl.netty;

import com.solace.transport.TransportEventExceptionHandler;
import com.solace.transport.impl.netty.NettyTransportEvent;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class NettyTransportEventExceptionHandler
extends ChannelInboundHandlerAdapter {
    private static final Log Trace = LogFactory.getLog(NettyTransportEventExceptionHandler.class);
    TransportEventExceptionHandler callback;
    private final int tag;

    public NettyTransportEventExceptionHandler(TransportEventExceptionHandler handler, int connection_tag) {
        this.callback = handler;
        this.tag = connection_tag;
    }

    public void close() {
        this.callback = null;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        if (this.callback != null) {
            this.callback.onEvent((Object)NettyTransportEvent.NETTY_CHANNEL_ACTIVE, this.tag);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (this.callback != null) {
            this.callback.onEvent((Object)NettyTransportEvent.NETTY_CHANNEL_INACTIVE, this.tag);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Trace.debug(msg);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        super.channelUnregistered(ctx);
        if (this.callback != null) {
            this.callback.onEvent((Object)NettyTransportEvent.NETTY_CHANNEL_UNREGISTERED, this.tag);
        }
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
        if (this.callback != null) {
            this.callback.onEvent((Object)NettyTransportEvent.NETTY_CHANNEL_REGISTERED, this.tag);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.callback != null) {
            this.callback.onException(cause, this.tag);
        }
    }
}

