/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.queues;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jcsmp.impl.XMLMessageQueue;
import com.solacesystems.jcsmp.impl.flow.FlowHandle;
import com.solacesystems.jcsmp.impl.queues.AbstractUnackedMessageList;
import com.solacesystems.jcsmp.protocol.WireMessage;

public class TransactedFlowAckMessageList
extends AbstractUnackedMessageList {
    XMLMessageQueue messageQueue;
    private final LogWrapper Trace = new LogWrapper(TransactedFlowAckMessageList.class);

    public TransactedFlowAckMessageList(int size, FlowHandle flow, XMLMessageQueue messageQueue) {
        super(flow);
        this.messageQueue = messageQueue;
    }

    @Override
    public boolean hasUnsentAcks() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendAcks(String reason, boolean allowReactorComplete) {
        this.flowHandle.setNumUnackedTpMsgs(0);
        WireMessage ackMsg = null;
        Object object = this.flowHandle.getAckCreateSendLock();
        synchronized (object) {
            ackMsg = this.flowHandle.tpCreateAck();
        }
        if (this.flowHandle.getTcpChannel().hasEnqueuedPriorityData()) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("TransactedFlowAckMessageList sendAcks ack sending while channel has enqueued priority data, enqueueing ack");
            }
            this.flowHandle.getTcpChannel().enqueuePriorityData(ackMsg);
        } else {
            boolean locked = true;
            try {
                if (this.flowHandle.isReactorThread()) {
                    locked = this.flowHandle.getAckSendingLock().tryLock();
                    if (!locked) {
                        if (this.Trace.isDebugEnabled()) {
                            this.Trace.debug("Locking failed in TransactedFlowAckMessageList sendAcks, enqueueing ack");
                        }
                        this.flowHandle.getTcpChannel().enqueuePriorityData(ackMsg);
                        return;
                    }
                } else {
                    this.flowHandle.getAckSendingLock().lock();
                }
                this.flowHandle.tpSendAck(ackMsg, false, allowReactorComplete);
            }
            finally {
                if (locked) {
                    this.flowHandle.getAckSendingLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendCloseAcks(String reason, boolean allowReactorComplete) {
        this.flowHandle.setNumUnackedTpMsgs(0);
        WireMessage ackMsg = null;
        Object object = this.flowHandle.getAckCreateSendLock();
        synchronized (object) {
            ackMsg = this.flowHandle.tpCreateStopAck();
        }
        if (this.flowHandle.getTcpChannel().hasEnqueuedPriorityData()) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("TransactedFlowAckMessageList sendCloseAcks ack sending while channel has enqueued priority data, enqueueing ack");
            }
            this.flowHandle.getTcpChannel().enqueuePriorityData(ackMsg);
        } else {
            boolean locked = true;
            try {
                if (this.flowHandle.isReactorThread()) {
                    locked = this.flowHandle.getAckSendingLock().tryLock();
                    if (!locked) {
                        if (this.Trace.isDebugEnabled()) {
                            this.Trace.debug("Locking failed in TransactedFlowAckMessageList sendCloseAcks, enqueueing ack");
                        }
                        this.flowHandle.getTcpChannel().enqueuePriorityData(ackMsg);
                        return;
                    }
                } else {
                    this.flowHandle.getAckSendingLock().lock();
                }
                this.flowHandle.tpSendAck(ackMsg, false, allowReactorComplete);
            }
            finally {
                if (locked) {
                    this.flowHandle.getAckSendingLock().unlock();
                }
            }
        }
    }

    @Override
    public AbstractUnackedMessageList.EAppAckResult applicationAck(long msgId, boolean force_send) {
        return AbstractUnackedMessageList.EAppAckResult.OK;
    }

    @Override
    public AbstractUnackedMessageList.EAddResult add(long msgId) {
        return AbstractUnackedMessageList.EAddResult.OK;
    }

    @Override
    public int getWindowSize() {
        return this.messageQueue.capacityToCongestion();
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean isKnownAppAcked(long msgId) {
        return false;
    }

    @Override
    public AbstractUnackedMessageList.UnackedMessageListInfo getCurrentUnackedMessageListInfo() {
        return null;
    }
}

