/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.flow;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.common.util.StringUtil;
import com.solacesystems.common.util.ThreadUtil;
import com.solacesystems.jcsmp.AccessDeniedException;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.CacheEventMessage;
import com.solacesystems.jcsmp.CacheLiveDataAction;
import com.solacesystems.jcsmp.ClosedFacilityException;
import com.solacesystems.jcsmp.ConsumerFlowProperties;
import com.solacesystems.jcsmp.DeliveryMode;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.Endpoint;
import com.solacesystems.jcsmp.EndpointProperties;
import com.solacesystems.jcsmp.EventMessage;
import com.solacesystems.jcsmp.FlowEventArgs;
import com.solacesystems.jcsmp.FlowEventHandler;
import com.solacesystems.jcsmp.FlowReceiver;
import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPFactory;
import com.solacesystems.jcsmp.JCSMPGlobalProperties;
import com.solacesystems.jcsmp.JCSMPIncompleteLargeMessageReceivedException;
import com.solacesystems.jcsmp.JCSMPInterruptedException;
import com.solacesystems.jcsmp.JCSMPLogLevel;
import com.solacesystems.jcsmp.JCSMPProperties;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.JCSMPSessionStats;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.Queue;
import com.solacesystems.jcsmp.SDTException;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.SessionEvent;
import com.solacesystems.jcsmp.StaleSessionException;
import com.solacesystems.jcsmp.Subscription;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.TopicEndpoint;
import com.solacesystems.jcsmp.XMLMessage;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.BrowserImpl;
import com.solacesystems.jcsmp.impl.BytesMessageImpl;
import com.solacesystems.jcsmp.impl.BytesXMLMessageWrapper;
import com.solacesystems.jcsmp.impl.Closeable;
import com.solacesystems.jcsmp.impl.ContextImpl;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.JCSMPUtils;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.impl.LogLevelAdapter;
import com.solacesystems.jcsmp.impl.MapMessageImpl;
import com.solacesystems.jcsmp.impl.MessageImpl;
import com.solacesystems.jcsmp.impl.SessionEventArgsImpl;
import com.solacesystems.jcsmp.impl.SessionSubscriptionEvent;
import com.solacesystems.jcsmp.impl.StreamMessageImpl;
import com.solacesystems.jcsmp.impl.TextMessageImpl;
import com.solacesystems.jcsmp.impl.XMLContentMessageImpl;
import com.solacesystems.jcsmp.impl.XMLMessageQueue;
import com.solacesystems.jcsmp.impl.flow.FlowHandle;
import com.solacesystems.jcsmp.impl.flow.FlowSmfUtil;
import com.solacesystems.jcsmp.impl.flow.LiveMessageController;
import com.solacesystems.jcsmp.impl.flow.LiveResponseListener;
import com.solacesystems.jcsmp.impl.flow.LiveTopicListener;
import com.solacesystems.jcsmp.impl.flow.SubFlowManagerImpl;
import com.solacesystems.jcsmp.impl.flow.SubscriberQueueHooks;
import com.solacesystems.jcsmp.impl.queues.AbstractUnackedMessageList;
import com.solacesystems.jcsmp.impl.queues.AppAckRangeCache;
import com.solacesystems.jcsmp.impl.queues.TransactedFlowAckMessageList;
import com.solacesystems.jcsmp.impl.queues.UnackedMessageList2;
import com.solacesystems.jcsmp.impl.queues.WindowAckMessageList;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimeoutHandler;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimer;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimerQueue;
import com.solacesystems.jcsmp.impl.timers.MsgSegmentReconstructionTimedTask;
import com.solacesystems.jcsmp.impl.timers.RedeliveryDelayTimedTask;
import com.solacesystems.jcsmp.impl.timers.SegmentFlowCreationTimedTask;
import com.solacesystems.jcsmp.impl.timers.SubAckTimedTask;
import com.solacesystems.jcsmp.impl.transaction.AdCtrlV4TransactedSessionImpl;
import com.solacesystems.jcsmp.impl.transaction.BaseTransactedSessionImpl;
import com.solacesystems.jcsmp.interceptors.impl.JCSMPReceiverInterceptingContextImpl;
import com.solacesystems.jcsmp.management.SolJmxSupport;
import com.solacesystems.jcsmp.protocol.CSMPSubscriberChannel;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.impl.TcpChannel;
import com.solacesystems.jcsmp.protocol.impl.TcpClientChannel;
import com.solacesystems.jcsmp.protocol.nio.Notification;
import com.solacesystems.jcsmp.protocol.nio.impl.ConsumerDrainNotification;
import com.solacesystems.jcsmp.protocol.nio.impl.ConsumerErrorNotification;
import com.solacesystems.jcsmp.protocol.nio.impl.ConsumerFlowNotification;
import com.solacesystems.jcsmp.protocol.nio.impl.ConsumerLargeMessageNotification;
import com.solacesystems.jcsmp.protocol.nio.impl.ConsumerMessageNotification;
import com.solacesystems.jcsmp.protocol.nio.impl.ConsumerNotificationDispatcher;
import com.solacesystems.jcsmp.protocol.nio.impl.ConsumerNotificationDispatcherFactory;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlEnums;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterParser;
import com.solacesystems.jcsmp.statistics.StatType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class FlowHandleImpl
implements FlowReceiver,
FlowHandle,
LiveMessageController,
Closeable,
XMLMessageListener {
    protected volatile StartState _startState = StartState.STOPPED;
    volatile CountDownLatch _stoppingLatch = null;
    volatile long _inCallbackThreadId = 0L;
    private ReentrantLock _dispatcherLock = new ReentrantLock();
    final Endpoint boundToResource;
    protected volatile ResourceBoundState _boundToResourceState = ResourceBoundState.UNBOUND;
    final boolean ad_enabled;
    long flowId;
    long endpointId;
    String flowName;
    volatile long lastInOrderTpMsg;
    volatile int numUnackedTpMsg;
    int subWinSz;
    int lastReportedWinSz;
    volatile XMLMessageListener messageListener;
    Object listener_lock = new Object();
    boolean ml_read_on_reactor = false;
    final CSMPSubscriberChannel tcpChannel;
    final XMLMessageQueue messageQueue;
    final JCSMPBasicSession session;
    public final boolean deliverAsyncOnReactor;
    final BaseTransactedSessionImpl transactedSession;
    AbstractUnackedMessageList unackedList;
    public final LogWrapper Trace = new LogWrapper(FlowHandleImpl.class);
    volatile boolean explictlyActive = false;
    volatile boolean opened = false;
    volatile boolean has_ever_been_started = false;
    protected Object startStopLock = new Object();
    protected Object bindUnbindLock = new Object();
    private int ackThreshold;
    private int originalAckThreashold;
    private int ackTimeout;
    private Object ackTimerLock = new Object();
    private final Object ackInfoLock = new Object();
    private final Object ackCreateSendLock = new Object();
    private final AtomicLong ackSerialCounter = new AtomicLong();
    private volatile long ackLastSerialNumber = 0L;
    private final ReentrantLock ackSendingLock = new ReentrantLock();
    private JCSMPTimer ackTimer;
    private final JCSMPTimerQueue timerQueue;
    private SubAckTimedTask subAckTask;
    private boolean msgAckModeClient;
    private AssuredCtrlEnums.QueueAccessType queueAccessType;
    private Topic cachedTopic;
    private String cachedSelector = null;
    private SubscriberQueueHooks subQueueHook;
    private ConsumerNotificationDispatcher consumerNotifDsp;
    private ConsumerNotificationDispatcherFactory consumerNotifDspFac;
    private ContextImpl context;
    private HashMap<String, Integer> flowThruMap;
    private HashMap<String, LiveTopicListener> liveTopicMap;
    private HashMap<String, LiveResponseListener> liveResponseMap;
    private AssuredCtrlEnums.FlowType flowType;
    private Long grantedPermissions;
    private EndpointProperties endpointProperties;
    private boolean noLocal = false;
    private final AckRunner tpAckStrategy;
    private final FlowDebugStats flowDbgStats = new FlowDebugStats();
    private volatile ConsumeMode consumerMode = ConsumeMode.NOT_SET;
    private int adSessionUid;
    private final FlowEventHandler flowEventHandler;
    private static final AtomicInteger adSessionUidGlobalCounter = new AtomicInteger();
    private JCSMPException lastException = null;
    private AtomicLong lastMsgIdAcked = new AtomicLong(0L);
    private boolean largeMessaging = false;
    private LinkedList<Object> msgConstructionQueue;
    private Object msgConstructionQueueLock = new Object();
    private boolean msgConstructionQueueClosed = false;
    private ConsumerLargeMessageNotification currMsgUnderConstruction;
    private LinkedHashMap<String, FlowHandleImpl> msgSegmentFlows;
    private LinkedHashMap<String, XMLMessage> unackedMsgSegments;
    private Object msgSegmentFlowLock = new Object();
    private JCSMPTimer msgSegmentTimer;
    private MsgSegmentReconstructionTimedTask msgSegmentTimeoutTask;
    private JCSMPTimer segmentFlowCreationTimer;
    private SegmentFlowCreationTimedTask segmentFlowCreationTimeoutTask;
    private int msgSegmentTimeout;
    private int segmentFlowCreationTimeout = 3000;
    private boolean msgSegmentFlow = false;
    private boolean durableQueueFlow = false;
    private volatile boolean pauseFlowInternally = false;
    private int windowedAckMaxSize = 255;
    private Long endpointErrorId = null;
    private BrowserImpl browser = null;
    private Boolean autoBindTrggered = false;
    private int autoRebindCount = 0;
    private ConsumerFlowProperties flowProps = null;
    private boolean jmsRedeilveryCountEnabled = false;
    private long spoolerUniqueId = 0L;
    private Integer partitionGroupId = null;
    private int redelivertDelayIntervalInit = 0;
    private int redelivertDelayIntervalMax = 0;
    private float redelivertDelayBackoffMultiple = 0.0f;
    private Integer waitIntervalInMs = null;
    private Object redeliveryDelayTimerLock = new Object();
    private RedeliveryDelayTimedTask redeliveryDelayTimedTask = null;
    private JCSMPTimer redeliveryDelayTimer = null;
    private boolean applicationStopped = false;
    final LinkedList<WireMessage> ackMsgQueue = new LinkedList();
    JCSMPTimer ackRetryTimer_last = null;
    private final AckRunner ackNormalFlowStrategy = new AckRunner(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void tpSendAck(WireMessage ackMsg, boolean allowOnStateSub, boolean allowReactorComplete) {
            block13: {
                int RESCHED_MS = 10;
                if (ackMsg != null && FlowHandleImpl.this.tcpChannel.connected()) {
                    try {
                        int write_code = FlowHandleImpl.this.tcpChannel.sendAckMessage(ackMsg, true, allowReactorComplete);
                        if (write_code == 1) {
                            if (FlowHandleImpl.this.Trace.isDebugEnabled()) {
                                FlowHandleImpl.this.Trace.debug("Flow " + FlowHandleImpl.this.flowId + ": ack write dropped, enqueue for later");
                            }
                            FlowHandleImpl.this.tcpChannel.enqueuePriorityData(ackMsg);
                            break block13;
                        }
                        boolean do_resched = false;
                        Object object = FlowHandleImpl.this.ackInfoLock;
                        synchronized (object) {
                            if (ackMsg.serialNumber != null) {
                                long acksentserial = ackMsg.serialNumber;
                                if (FlowHandleImpl.this.getAckLastSerialNumber() != acksentserial) {
                                    FlowHandleImpl.this.Trace.debug(String.format("Ack inversion on flow %s (OK: will retry) expected:%s got:%s", FlowHandleImpl.this.getLogFlowInfoString(), acksentserial, FlowHandleImpl.this.getAckLastSerialNumber()));
                                    do_resched = true;
                                }
                            }
                        }
                        if (do_resched) {
                            FlowHandleImpl.this.ackRetryTimer_last = FlowHandleImpl.this.timerQueue.schedule_relative(10L, new AckRetryTimeoutHandler());
                        }
                        if (ackMsg.userDebugInfo instanceof FlowDebugStats) {
                            FlowDebugStats fds = (FlowDebugStats)ackMsg.userDebugInfo;
                            ((FlowHandleImpl)FlowHandleImpl.this).flowDbgStats.lastTpAckMsg = fds.lastTpAckMsg;
                            ((FlowHandleImpl)FlowHandleImpl.this).flowDbgStats.lastTpAckReportedWinSz = fds.lastTpAckReportedWinSz;
                        }
                    }
                    catch (JCSMPInterruptedException ex) {
                        FlowHandleImpl.this.tcpChannel.enqueuePriorityData(ackMsg);
                        FlowHandleImpl.this.handleException(ex);
                    }
                    catch (JCSMPException e) {
                        FlowHandleImpl.this.handleException(e);
                        if (FlowHandleImpl.this.ackRetryTimer_last != null && FlowHandleImpl.this.ackRetryTimer_last.isActive()) break block13;
                        FlowHandleImpl.this.Trace.debug("Flow " + FlowHandleImpl.this.flowId + ": Scheduling AckRetryTimeoutHandler (first chance).");
                        FlowHandleImpl.this.ackRetryTimer_last = FlowHandleImpl.this.timerQueue.schedule_relative(10L, new AckRetryTimeoutHandler());
                    }
                }
            }
        }
    };
    private final AckRunner ackAsBrowserStrategy = new AckRunner(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void tpSendAck(WireMessage ackMsg, boolean allowOnStateSub, boolean allowReactorComplete) {
            try {
                LinkedList<WireMessage> linkedList = FlowHandleImpl.this.ackMsgQueue;
                synchronized (linkedList) {
                    int write_code = FlowHandleImpl.this.tcpChannel.sendAckMessage(ackMsg, true, allowReactorComplete);
                    if (write_code == 1) {
                        FlowHandleImpl.this.tcpChannel.enqueuePriorityData(ackMsg);
                    }
                }
            }
            catch (JCSMPInterruptedException ex) {
                FlowHandleImpl.this.tcpChannel.enqueuePriorityData(ackMsg);
                FlowHandleImpl.this.handleException(ex);
            }
            catch (JCSMPException e) {
                FlowHandleImpl.this.handleException(e);
                FlowHandleImpl.this.timerQueue.schedule_relative(100L, FlowHandleImpl.this.subAckTask);
            }
        }
    };

    public FlowHandleImpl(Endpoint boundTo, Topic newTopic, XMLMessageListener listener, CSMPSubscriberChannel channel, JCSMPSession session, boolean ad_enabled, AssuredCtrlEnums.QueueAccessType q_access_type, AssuredCtrlEnums.FlowType boundFlowType, Long gr_permissions, EndpointProperties endpointProperties, String selector, ConsumerFlowProperties cfp, BaseTransactedSessionImpl old_ts, FlowEventHandler flowEventHandler) {
        int sub_threshold;
        this.boundToResource = boundTo;
        this.cachedTopic = newTopic;
        this.cachedSelector = selector;
        this.tcpChannel = channel;
        this.session = (JCSMPBasicSession)session;
        this.opened = true;
        this.context = ((JCSMPBasicSession)session).getContext();
        this.timerQueue = this.context.getTimeService();
        this.ad_enabled = ad_enabled;
        this.queueAccessType = q_access_type;
        this.flowType = boundFlowType;
        this.grantedPermissions = gr_permissions;
        this.endpointProperties = endpointProperties;
        this.transactedSession = old_ts;
        this.tpAckStrategy = this.isBrowser() ? this.ackAsBrowserStrategy : this.ackNormalFlowStrategy;
        JCSMPProperties props = null;
        this.endpointErrorId = null;
        this.flowProps = cfp;
        props = cfp != null && cfp.getFlowSessionProps() != null ? cfp.getFlowSessionProps() : this.session.getJCSMPProperties();
        this.subWinSz = cfp != null && cfp.getTransportWindowSize() != 0 ? cfp.getTransportWindowSize() : props.getIntegerProperty("sub_ack_window_size").intValue();
        this.flowEventHandler = flowEventHandler;
        if (cfp != null && cfp.getAckThreshold() != 0) {
            sub_threshold = cfp.getAckThreshold();
            this.originalAckThreashold = cfp.getAckThreshold();
        } else {
            sub_threshold = props.getIntegerProperty("sub_ack_window_threshold");
            this.originalAckThreashold = props.getIntegerProperty("sub_ack_window_threshold");
        }
        this.ackThreshold = sub_threshold * this.subWinSz / 100;
        this.ackTimeout = cfp != null && cfp.getAckTimerInMsecs() != 0 ? cfp.getAckTimerInMsecs() : props.getIntegerProperty("sub_ack_time").intValue();
        this.consumerNotifDsp = null;
        this.consumerNotifDspFac = null;
        if (cfp != null) {
            this.consumerNotifDspFac = cfp.getConsumerNotificationDispatcherFactory();
        }
        this.deliverAsyncOnReactor = props.getBooleanProperty("MESSAGE_CALLBACK_ON_REACTOR");
        this.noLocal = cfp != null && cfp.isNoLocal();
        int uncongestedThreshold = Math.max(this.subWinSz - this.ackThreshold - 1, 0);
        this.messageQueue = new XMLMessageQueue(String.format("MessageQueue_%s_%s", boundTo, ((JCSMPBasicSession)session).getSessionID()), this.subWinSz, uncongestedThreshold);
        this.setMessageListener(listener);
        String strAckMode = cfp != null && cfp.getAckMode() != null ? cfp.getAckMode() : props.getStringProperty("message_ack_mode");
        if (cfp != null) {
            Endpoint ep = cfp.getEndpoint();
            this.durableQueueFlow = ep.isDurable() && ep instanceof Queue;
            this.msgSegmentFlow = cfp.isSegmentFlow();
            this.windowedAckMaxSize = cfp.getWindowedAckMaxSize();
        }
        this.unackedList = this.isTransacted() ? new TransactedFlowAckMessageList(this.subWinSz, this, this.messageQueue) : (strAckMode.equals("client_ack_windowed") ? new WindowAckMessageList(this.subWinSz, this, this.windowedAckMaxSize) : new UnackedMessageList2(2 * this.subWinSz, this, this.ackThreshold, this.messageQueue));
        this.subAckTask = new SubAckTimedTask(this.unackedList);
        this.msgAckModeClient = boundFlowType == AssuredCtrlEnums.FlowType.BROWSER ? true : strAckMode.equals("client_ack") || strAckMode.equals("client_ack_windowed");
        this.largeMessaging = props.getBooleanProperty("large_messaging");
        this.msgConstructionQueue = new LinkedList();
        this.msgSegmentFlows = new LinkedHashMap();
        this.msgSegmentTimeout = props.getIntegerProperty("large_message_consume_timeout");
        if (this.largeMessaging && this.isTransacted()) {
            this.unackedMsgSegments = new LinkedHashMap();
        }
        this.subQueueHook = null;
        this.flowThruMap = new HashMap();
        this.liveTopicMap = new HashMap();
        this.liveResponseMap = new HashMap();
        this.init();
    }

    protected FlowHandleImpl(XMLMessageListener listener, JCSMPSession session, CSMPSubscriberChannel channel, Topic topic, ConsumerNotificationDispatcherFactory dispatcherFactory) {
        this.boundToResource = null;
        this.cachedTopic = topic;
        this.tcpChannel = channel;
        this.session = (JCSMPBasicSession)session;
        this.opened = true;
        this.context = ((JCSMPBasicSession)session).getContext();
        this.timerQueue = this.context.getTimeService();
        this.ad_enabled = false;
        JCSMPProperties props = this.session.getJCSMPProperties();
        this.subWinSz = props.getIntegerProperty("sub_ack_window_size");
        int sub_threshold = props.getIntegerProperty("sub_ack_window_threshold");
        this.ackTimeout = 0;
        this.ackThreshold = sub_threshold * this.subWinSz / 100;
        this.deliverAsyncOnReactor = props.getBooleanProperty("MESSAGE_CALLBACK_ON_REACTOR");
        this.transactedSession = null;
        this.flowEventHandler = null;
        this.consumerNotifDsp = null;
        this.consumerNotifDspFac = dispatcherFactory;
        int uncongestedThreshold = Math.max(this.subWinSz - this.ackThreshold - 1, 0);
        this.messageQueue = new XMLMessageQueue(String.format("MessageQueue_Reliable_%s_%s", ((JCSMPBasicSession)session).getSessionID(), this.cachedTopic.getName()), this.subWinSz, uncongestedThreshold);
        this.setMessageListener(listener);
        this.unackedList = null;
        this.subAckTask = null;
        this.msgAckModeClient = false;
        this.subQueueHook = null;
        this.flowThruMap = null;
        this.liveTopicMap = new HashMap();
        this.liveResponseMap = new HashMap();
        this.endpointProperties = null;
        this.tpAckStrategy = null;
        this.flowProps = null;
    }

    final void init() {
        this.transportInit();
        SolJmxSupport.instance().register(this, this.session);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        SolJmxSupport.instance().deregister(this);
    }

    @Override
    public CSMPSubscriberChannel getTcpChannel() {
        return this.tcpChannel;
    }

    public Integer getPartitionGroupId() {
        return this.partitionGroupId;
    }

    public void setPartitionGroupId(int v) {
        this.partitionGroupId = new Integer(v);
    }

    public void resetPartitionGroupId() {
        this.partitionGroupId = null;
    }

    public void resetWaitIntervalInMs() {
        this.waitIntervalInMs = null;
    }

    public int getNextWaitIntervalInMs() {
        this.waitIntervalInMs = this.waitIntervalInMs == null ? Integer.valueOf(this.redelivertDelayIntervalInit) : Integer.valueOf((int)((float)this.waitIntervalInMs.intValue() * this.redelivertDelayBackoffMultiple));
        if (this.waitIntervalInMs > this.redelivertDelayIntervalMax) {
            this.waitIntervalInMs = this.redelivertDelayIntervalMax;
        }
        return this.waitIntervalInMs;
    }

    public int getRedelivertDelayIntervalInitValue() {
        return this.redelivertDelayIntervalInit;
    }

    public void setRedelivertDelayIntervalInitValue(int v) {
        this.redelivertDelayIntervalInit = v;
    }

    public int getRedelivertDelayIntervalMaxValue() {
        return this.redelivertDelayIntervalMax;
    }

    public void setRedelivertDelayIntervalMaxValue(int v) {
        this.redelivertDelayIntervalMax = v;
    }

    public float getRedelivertDelayBackoffMultiple() {
        return this.redelivertDelayBackoffMultiple;
    }

    public void setRedelivertDelayBackoffMultiple(int v) {
        this.redelivertDelayBackoffMultiple = (float)v / 100.0f;
    }

    public boolean isRedelivertDelayEnabled() {
        return this.redelivertDelayIntervalMax > 0;
    }

    public boolean isRedelivertDelayInProgress() {
        return this.redeliveryDelayTimer != null && this.redeliveryDelayTimer.isActive();
    }

    public void setRedeliveryDelayConfig(TlvParameterParser.RedeliveryDelayConfiguration config) {
        if (config != null) {
            this.setRedelivertDelayIntervalInitValue(config.getInitValue());
            this.setRedelivertDelayIntervalMaxValue(config.getMaxValue());
            this.setRedelivertDelayBackoffMultiple(config.getMultiple());
            if (this.isRedelivertDelayEnabled() && this.redeliveryDelayTimedTask == null) {
                this.redeliveryDelayTimedTask = new RedeliveryDelayTimedTask(this);
            }
        } else {
            if (this.isRedelivertDelayInProgress()) {
                this.stopRedeliveryDelayTimer();
            }
            this.setRedelivertDelayIntervalInitValue(0);
            this.setRedelivertDelayIntervalMaxValue(0);
            this.setRedelivertDelayBackoffMultiple(0);
            this.redeliveryDelayTimedTask = null;
        }
        this.resetWaitIntervalInMs();
    }

    public long getSpoolerUniqueId() {
        return this.spoolerUniqueId;
    }

    public void setSpoolerUniqueId(long id) {
        this.spoolerUniqueId = id;
    }

    public LogWrapper getLogTrace() {
        return this.Trace;
    }

    public boolean isRedeliveryCountEnabled() {
        return this.jmsRedeilveryCountEnabled;
    }

    public void setReliveryCountEnabled(boolean flag) {
        this.jmsRedeilveryCountEnabled = flag;
    }

    public ReentrantLock getLock() {
        return this._dispatcherLock;
    }

    public JCSMPBasicSession getSession() {
        return this.session;
    }

    public Long getGrantedPermissions() {
        return this.grantedPermissions;
    }

    @Override
    public Object getAckCreateSendLock() {
        return this.ackCreateSendLock;
    }

    @Override
    public ReentrantLock getAckSendingLock() {
        return this.ackSendingLock;
    }

    public EndpointProperties getEndpointProperties() {
        return this.endpointProperties;
    }

    public CSMPSubscriberChannel getCSMPSubscriberChannel() {
        return this.tcpChannel;
    }

    public LiveMessageController getLiveMessageController() {
        return this;
    }

    public long getLastMsgIdAcked() {
        return this.lastMsgIdAcked.get();
    }

    public Boolean tryToStartAutoRebind() {
        if (this.isAutoRebindEnabled().booleanValue()) {
            if (this.autoRebindCount > 0) {
                --this.autoRebindCount;
            }
            return true;
        }
        this.autoBindTrggered = false;
        return this.autoBindTrggered;
    }

    public Boolean isAutoRebindEnabled() {
        return this.autoBindTrggered != false && this.autoRebindCount != 0;
    }

    public Boolean isAutoRebindTriggered() {
        return this.autoBindTrggered;
    }

    public void tryToTriggerAutoRebind(Boolean enabled) {
        this.autoRebindCount = this.flowProps.getReconnectTries();
        this.autoBindTrggered = enabled != false && this.autoRebindCount != 0;
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("flow auto reconnect setup (" + this.flowName + "): enabled=" + enabled + "; autoRebindCount=" + this.autoRebindCount);
        }
    }

    public int getReconnectRetryIntervalInMsecs() {
        return this.flowProps.getReconnectRetryIntervalInMsecs();
    }

    public final void transportInit() {
        this.numUnackedTpMsg = 0;
        this.lastInOrderTpMsg = 0L;
        this.adSessionUid = adSessionUidGlobalCounter.incrementAndGet();
        this.stopAckTimer();
    }

    @Override
    public long getFlowId() {
        return this.flowId;
    }

    public XMLMessageListener getMessageListener() {
        return this.messageListener;
    }

    public BrowserImpl getBrowserFlow() {
        return this.browser;
    }

    public void setBrowserFlow(BrowserImpl flow) {
        this.browser = flow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void setMessageListener(XMLMessageListener listener) {
        while (true) {
            Object object = this.messageQueue.getLock();
            synchronized (object) {
                if (this._inCallbackThreadId == 0L) break;
                if (this._inCallbackThreadId == Thread.currentThread().getId()) {
                    throw new IllegalStateException("Error setting message listener from message listener");
                }
            }
        }
        {
            if (!this.has_ever_been_started || this.deliverAsyncOnReactor) {
                // empty if block
            }
            if (this.messageListener == null && listener == null) {
                return;
            }
            if (this.messageListener == null && listener != null) {
                this.consumerMode = ConsumeMode.ASYNC;
                this.messageListener = listener;
            } else if (this.messageListener != null && listener == null) {
                this.consumerMode = ConsumeMode.SYNC;
                this.messageListener = null;
            } else if (this.messageListener != null && listener != null) {
                if (this.messageListener == listener) {
                    return;
                }
                this.messageListener = listener;
            }
        }
        try {
            this.getConsumerNotifDsp().enqueueBlockingNotification(new ConsumerDrainNotification(this));
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setLastReportedWinSz(int winSz) {
        this.lastReportedWinSz = winSz;
    }

    public void setFlowId(long flowId) {
        this.flowId = flowId;
        this.Trace.setContextInfo(this.getLogContextInfo());
    }

    public String getLogContextInfo() {
        if (this.transactedSession != null && this.transactedSession instanceof AdCtrlV4TransactedSessionImpl) {
            return ((AdCtrlV4TransactedSessionImpl)this.transactedSession).getLogContextInfo() + ":Flow-" + this.getFlowId();
        }
        return this.session.getLogContextInfo() + ":SubFlow-" + this.getFlowId();
    }

    public long getEndpointId() {
        return this.endpointId;
    }

    public void setEndpointId(long endpointId) {
        this.endpointId = endpointId;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public Endpoint getBoundResource() {
        return this.boundToResource;
    }

    public Topic getCachedTopic() {
        return this.cachedTopic;
    }

    public String getCachedSelector() {
        return this.cachedSelector;
    }

    public void setCachedSelector(String cachedSelector) {
        this.cachedSelector = cachedSelector;
    }

    public void closeChannelDied() {
    }

    @Override
    public void close() {
        this.close(false);
    }

    @Override
    public boolean isClosed() {
        return !this.opened;
    }

    @Override
    public void close(boolean linger) {
        try {
            if (this.session != null) {
                this.session.waitUntilSessionReconnectDone("close");
            }
        }
        catch (JCSMPException e) {
            this.Trace.warn("flow (" + this.flowId + ") close interrupted: " + e.getMessage());
        }
        this.closeSegmentFlows(linger, false);
        if (this.isTransacted()) {
            if (!this.opened) {
                return;
            }
            this.stopImpl(true, true, false);
            this.transactedSession.closeFlow(this);
        } else {
            this.closeImpl(true, linger, TcpChannel.WriteBlockPolicy.DEFAULT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSegmentFlows(boolean linger, boolean rollback) {
        if (this.largeMessaging) {
            this.stopSegmentFlowCreationTimer();
            Object object = this.msgSegmentFlowLock;
            synchronized (object) {
                if (this.msgSegmentFlows.size() > 0) {
                    for (FlowHandleImpl segFlow : this.msgSegmentFlows.values()) {
                        if (this.Trace.isDebugEnabled()) {
                            this.Trace.debug("Close segment flow flowId=" + segFlow.getFlowId());
                        }
                        segFlow.close(linger);
                    }
                    this.msgSegmentFlows.clear();
                }
                if (this.unackedMsgSegments != null) {
                    this.unackedMsgSegments.clear();
                }
            }
        }
    }

    protected void notifyReconnectAborted() {
        this.opened = false;
        this.resetResourceBoundStateToUnbound(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetResourceBoundStateToUnbound(boolean reset) {
        Object object = this.bindUnbindLock;
        synchronized (object) {
            this._boundToResourceState = ResourceBoundState.UNBOUND;
            if (reset && this.isTransacted()) {
                this.setFlowId(-1L);
                if (this.getTransactedSession() instanceof AdCtrlV4TransactedSessionImpl) {
                    this.messageQueue.clear();
                    long lastMsgIdToApp = this.getTransactedSession().getLastMessageIdDeliveredToApp(this);
                    if (this.lastInOrderTpMsg > lastMsgIdToApp) {
                        this.lastInOrderTpMsg = lastMsgIdToApp;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceBoundStateToBound(long respFlowId) {
        Object object = this.bindUnbindLock;
        synchronized (object) {
            this._boundToResourceState = ResourceBoundState.BOUND;
            this.setFlowId(respFlowId);
        }
    }

    public void setAckThreshold(int threshold) {
        this.ackThreshold = threshold;
        this.unackedList.setAckThreshold(threshold);
    }

    public int getAckThreshold() {
        return this.ackThreshold;
    }

    public int getOriginalAckThreshold() {
        return this.originalAckThreashold;
    }

    public int getSubWindowSize() {
        return this.subWinSz;
    }

    public boolean isBoundToResource() {
        return this._boundToResourceState.equals((Object)ResourceBoundState.BOUND);
    }

    public void closeImpl(boolean allowAcks, boolean linger, TcpChannel.WriteBlockPolicy wpol, JCSMPException cause) {
        this.lastException = cause;
        this.closeImpl(allowAcks, linger, wpol);
    }

    @Override
    public boolean isReactorThread() {
        return this.context.getIOReactor().isManagedThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeImpl(boolean allowAcks, boolean linger, TcpChannel.WriteBlockPolicy wpol) {
        if (!this.opened) {
            return;
        }
        if (this.boundToResource != null && this.boundToResource instanceof Queue && !this.boundToResource.isDurable()) {
            this.session.notifySubscriptionEvent(new SessionSubscriptionEvent(this.boundToResource, (Subscription)null, SessionSubscriptionEvent.SubscriptionEventType.REM_EVENT, null));
        }
        this.stopImpl(false, true, false);
        this.opened = false;
        Object object = this.messageQueue.getLock();
        synchronized (object) {
            this.messageQueue.close();
        }
        object = this.msgConstructionQueueLock;
        synchronized (object) {
            this.msgConstructionQueueClosed = true;
        }
        SolJmxSupport.instance().deregister(this);
        this.handleControllerException(new JCSMPTransportException("flow closing"));
        if (allowAcks && this.tcpChannel.connected() && this.ad_enabled) {
            this.unackedList.sendAcks("flow-closing", false);
            try {
                SubFlowManagerImpl subflowmgr = this.tcpChannel.getSubFlowManager();
                if (subflowmgr != null) {
                    boolean set_linger = linger && this.getBoundResource() != null && !this.getBoundResource().isDurable();
                    subflowmgr.unbindFlowHandle(this, set_linger, wpol);
                }
            }
            catch (JCSMPException e) {
                this.Trace.debug("Error unbinding message flow " + this.flowId, e);
            }
        }
    }

    @Override
    public void closeSync() throws JCSMPException {
        this.closeSync(false);
    }

    @Override
    public void closeSync(boolean linger) throws JCSMPException {
        try {
            this.session.waitUntilSessionReconnectDone("closeSync");
        }
        catch (JCSMPException e) {
            this.Trace.warn("flow (" + this.flowId + ") close interrupted: " + e.getMessage());
        }
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("closeSync: flowId =" + this.flowId);
        }
        this.closeSegmentFlows(linger, false);
        if (this.isTransacted()) {
            if (!this.opened) {
                return;
            }
            try {
                this.stopSyncImpl(true, true);
            }
            catch (JCSMPInterruptedException e) {
                this.Trace.debug("closeSync interrupted, flowId= " + this.flowId);
                SubFlowManagerImpl subflowmgr = this.tcpChannel.getSubFlowManager();
                if (subflowmgr != null) {
                    subflowmgr.unbindFlowHandle(this, linger, TcpChannel.WriteBlockPolicy.DROP_AND_IGNORE);
                }
                throw e;
            }
            this.transactedSession.closeFlow(this);
        } else {
            this.closeSyncImpl(true, linger, TcpChannel.WriteBlockPolicy.DROP_AND_IGNORE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSyncImpl(boolean allowAcks, boolean linger, TcpChannel.WriteBlockPolicy wpol) throws JCSMPInterruptedException {
        if (!this.opened) {
            return;
        }
        if (this.boundToResource != null && this.boundToResource instanceof Queue && !this.boundToResource.isDurable()) {
            this.session.notifySubscriptionEvent(new SessionSubscriptionEvent(this.boundToResource, (Subscription)null, SessionSubscriptionEvent.SubscriptionEventType.REM_EVENT, null));
        }
        this.stopSyncImpl(false, true);
        this.opened = false;
        Object object = this.messageQueue.getLock();
        synchronized (object) {
            this.messageQueue.close();
        }
        SolJmxSupport.instance().deregister(this);
        this.handleControllerException(new JCSMPTransportException("flow closing"));
        if (allowAcks && this.tcpChannel.connected() && this.ad_enabled) {
            this.unackedList.sendAcks("flow-closing", false);
            try {
                SubFlowManagerImpl subflowmgr = this.tcpChannel.getSubFlowManager();
                if (subflowmgr != null) {
                    boolean set_linger = linger && this.getBoundResource() != null && !this.getBoundResource().isDurable() && this.isBoundToResource();
                    subflowmgr.unbindFlowHandle(this, set_linger, wpol);
                }
            }
            catch (JCSMPException e) {
                this.Trace.debug("Error unbinding message flow " + this.flowId, e);
            }
        }
    }

    public void resetAdState() {
        if (this.Trace.isInfoEnabled()) {
            this.Trace.info("FlowHandleImpl resetting AD state for flow " + this.flowId);
        }
        this.transportInit();
        if (this.unackedList != null) {
            this.unackedList.clear();
        }
    }

    @Override
    public BytesXMLMessage receive() throws JCSMPException {
        return this.receive(0);
    }

    public boolean isOpened() {
        return this.opened;
    }

    private void setLastMsgIdAcked(long newValue) {
        this.lastMsgIdAcked.set(newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BytesXMLMessage receive(int timeoutInMillis) throws JCSMPException {
        if (!this.opened) {
            this.throwClosedException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageConsumer.triedToCallRecvClosedMsgConsumer"));
        }
        if (this.isTransacted()) {
            this.getTransactedSession().waitForActiveStateAfterInterruption();
            this.getTransactedSession().allowOperation(BaseTransactedSessionImpl.AllowedOperation.RECEIVE);
        }
        try {
            Object o = null;
            Object object = this.messageQueue.getLock();
            synchronized (object) {
                if (this.consumerMode != ConsumeMode.SYNC) {
                    if (this.consumerMode == ConsumeMode.NOT_SET) {
                        this.consumerMode = ConsumeMode.SYNC;
                    } else if (this.consumerMode == ConsumeMode.ASYNC) {
                        throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageConsumer.triedToCallRecvAsyncMsgConsumer"));
                    }
                }
                o = timeoutInMillis < 0 ? this.messageQueue.dequeueNoWait() : (timeoutInMillis == 0 ? this.messageQueue.dequeue() : this.messageQueue.dequeue(timeoutInMillis));
                while (o != null && o instanceof JCSMPXMLMessage && this.isTransacted() && !this.getTransactedSession().hasNotDeliveredToFlow(this, (JCSMPXMLMessage)o)) {
                    if (timeoutInMillis < 0) {
                        o = this.messageQueue.dequeueNoWait();
                        continue;
                    }
                    if (timeoutInMillis == 0) {
                        o = this.messageQueue.dequeue();
                        continue;
                    }
                    o = this.messageQueue.dequeue(timeoutInMillis);
                }
            }
            if (o == null) {
                if (this.opened) {
                    return null;
                }
                throw new JCSMPTransportException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageConsumer.recvTransportException"));
            }
            this.postDequeueTrigger();
            if (o instanceof JCSMPException) {
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug("Blocking consumer receive an exception for flow " + this.flowId);
                }
                throw (JCSMPException)o;
            }
            if (o instanceof EventMessage) {
                return (EventMessage)o;
            }
            JCSMPXMLMessage message = (JCSMPXMLMessage)o;
            message.setSession(this.session);
            this.autoAckOrSetConsumer(message);
            if (this.isTransacted()) {
                this.addMsgToTransactionStep(message);
            }
            this.checkLocalQueueEmptyAcks();
            this.setLastMsgIdAcked(message.getMessageIdLong());
            return FlowHandleImpl.createStructuredType(message);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public BytesXMLMessage receiveNoWait() throws JCSMPException {
        return this.receive(-1);
    }

    @Override
    public void start() throws JCSMPException {
        this.applicationStopped = false;
        this.startImpl(true, false);
    }

    public void startByDelayedDeliveryTimer() throws JCSMPException {
        if (this.isStoppedByApplication()) {
            return;
        }
        this.startImpl(true, false);
    }

    public boolean isStoppedByApplication() {
        return this.applicationStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startImpl(boolean startChild, boolean startInternal) throws JCSMPException {
        block33: {
            if (!this.opened) {
                this.throwClosedException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageConsumer.triedToStartClosedMsgConsumer"));
            }
            Object object = this.startStopLock;
            synchronized (object) {
                if ((this._startState.equals((Object)StartState.STARTED) || this._startState.equals((Object)StartState.STARTING)) && !this.pauseFlowInternally) {
                    return;
                }
                if (startInternal && !this.pauseFlowInternally) {
                    if (this.Trace.isDebugEnabled()) {
                        this.Trace.debug(String.format("Flow %s is stopped (startState %s) by client already, cannot start internally", new Object[]{this.flowId, this._startState}));
                    }
                    return;
                }
                this._startState = StartState.STARTED;
                this.pauseFlowInternally = false;
                this.has_ever_been_started = true;
                if (this.ad_enabled) {
                    WireMessage ackMsg = null;
                    Object object2 = this.getAckCreateSendLock();
                    synchronized (object2) {
                        ackMsg = this.tpCreateAck();
                    }
                    boolean locked = true;
                    try {
                        if (this.isReactorThread()) {
                            locked = this.getAckSendingLock().tryLock();
                            if (!locked) {
                                this.getTcpChannel().enqueuePriorityData(ackMsg);
                            } else {
                                this.tpSendAck(ackMsg, false, true);
                            }
                        } else {
                            this.getAckSendingLock().lock();
                            this.tpSendAck(ackMsg, false, true);
                        }
                    }
                    finally {
                        if (locked) {
                            this.getAckSendingLock().unlock();
                        }
                    }
                    if (this.unackedList.hasUnsentAcks()) {
                        this.startAckTimer();
                    }
                    if (this.Trace.isDebugEnabled()) {
                        this.Trace.debug(String.format("Start flow, force ack>>> flow=%s, tp=%s, ws=%s", this.getFlowId(), this.getLastInOrderTpMsg(), this.getWindowSize()));
                    }
                }
            }
            object = this.messageQueue.getLock();
            synchronized (object) {
                this.messageQueue.start();
            }
            try {
                this.getConsumerNotifDsp().enqueueBlockingNotification(new ConsumerDrainNotification(this));
            }
            catch (InterruptedException e) {
                if (!startChild || !this.largeMessaging) break block33;
                Object object3 = this.msgSegmentFlowLock;
                synchronized (object3) {
                    if (this.msgSegmentFlows.size() > 0) {
                        if (this.Trace.isDebugEnabled()) {
                            this.Trace.debug("start segment flows and timer for flow " + this.flowId);
                        }
                        Iterator<FlowHandleImpl> it = this.msgSegmentFlows.values().iterator();
                        while (it.hasNext()) {
                            it.next().startImpl(false, false);
                        }
                        this.startMsgSegmentTimer(true);
                    }
                }
            }
        }
    }

    @Override
    public void stop() {
        this.applicationStopped = true;
        this.stopImpl(true, true, false);
    }

    public void stopByRollback() {
        this.stopImpl(true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopImpl(boolean allowSendAcks, boolean stopChild, boolean stopInternal) {
        if (stopChild) {
            this.manageChildFlowStop(allowSendAcks);
        }
        Object object = this.startStopLock;
        synchronized (object) {
            if (this._startState.equals((Object)StartState.STOPPED) || this._startState.equals((Object)StartState.STOPPING)) {
                return;
            }
            this.pauseFlowInternally = stopInternal;
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("Flow " + this.flowId + ": pauseFlowInternally=" + this.pauseFlowInternally);
            }
            if (!stopInternal) {
                this._startState = StartState.STOPPED;
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug("Flow " + this.flowId + ": _startState=" + (Object)((Object)this._startState));
                }
            }
            this.manageAckForStop(allowSendAcks);
        }
    }

    @Override
    public void startSync() throws JCSMPException {
        this.applicationStopped = false;
        this.startSyncImpl(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSyncImpl(boolean startChild) throws JCSMPException {
        Object object;
        while (true) {
            try {
                Object object2;
                if (!this.opened) {
                    this.throwClosedException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageConsumer.triedToStartClosedMsgConsumer"));
                }
                object = this.startStopLock;
                synchronized (object) {
                    if (this._startState.equals((Object)StartState.STARTED) || this._startState.equals((Object)StartState.STARTING)) {
                        return;
                    }
                    if (this._startState.equals((Object)StartState.STOPPING)) {
                        throw new IllegalStateException("Cannot start consumer, already stopping");
                    }
                    this.pauseFlowInternally = false;
                    this._startState = StartState.STARTING;
                    object2 = this.messageQueue.getLock();
                    synchronized (object2) {
                        this.messageQueue.start();
                    }
                }
                this.has_ever_been_started = true;
                if (this.ad_enabled) {
                    WireMessage ackMsg = null;
                    object2 = this.getAckCreateSendLock();
                    synchronized (object2) {
                        ackMsg = this.tpCreateAck();
                    }
                    boolean locked = true;
                    try {
                        if (this.isReactorThread()) {
                            locked = this.getAckSendingLock().tryLock();
                            if (!locked) {
                                this.getTcpChannel().enqueuePriorityData(ackMsg);
                            } else {
                                this.tpSendAck(ackMsg, false, true);
                            }
                        } else {
                            this.getAckSendingLock().lock();
                            this.tpSendAck(ackMsg, false, true);
                        }
                    }
                    finally {
                        if (locked) {
                            this.getAckSendingLock().unlock();
                        }
                    }
                    if (this.unackedList.hasUnsentAcks()) {
                        this.startAckTimer();
                    }
                    if (this.Trace.isDebugEnabled()) {
                        this.Trace.debug(String.format("Start flow sync, force ack>>> flow=%s, tp=%s, ws=%s", this.getFlowId(), this.getLastInOrderTpMsg(), this.getWindowSize()));
                    }
                }
                object = this.startStopLock;
                synchronized (object) {
                    if (this._startState == StartState.STARTING) {
                        this._startState = StartState.STARTED;
                    }
                }
                try {
                    this.getConsumerNotifDsp().enqueueBlockingNotification(new ConsumerDrainNotification(this));
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IllegalStateException illegalStateException) {
                continue;
            }
            break;
        }
        if (startChild && this.largeMessaging) {
            object = this.msgSegmentFlowLock;
            synchronized (object) {
                if (this.msgSegmentFlows.size() > 0) {
                    if (this.Trace.isDebugEnabled()) {
                        this.Trace.debug("start segment flows and timer for flow " + this.flowId);
                    }
                    Iterator<FlowHandleImpl> it = this.msgSegmentFlows.values().iterator();
                    while (it.hasNext()) {
                        it.next().startImpl(false, false);
                    }
                    this.startMsgSegmentTimer(true);
                }
            }
        }
    }

    @Override
    public void stopSync() throws JCSMPInterruptedException {
        this.stopSyncImpl(true, true);
    }

    protected void stopSyncImpl(boolean allowSendAcks, boolean stopChild) throws JCSMPInterruptedException {
        this.pauseFlowInternally = false;
        if (stopChild) {
            this.manageChildFlowStop(allowSendAcks);
        }
        if (this.stopSyncStart(allowSendAcks)) {
            this.stopSyncWait();
        }
    }

    @Override
    public boolean stopSyncStart() {
        this.applicationStopped = true;
        return this.stopSyncStart(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean stopSyncStart(boolean allowSendAcks) {
        while (true) {
            try {
                Object object = this.startStopLock;
                synchronized (object) {
                    if (this._boundToResourceState.equals((Object)ResourceBoundState.UNBOUND) || this._startState.equals((Object)StartState.STARTING)) {
                        Object object2 = this.messageQueue.getLock();
                        synchronized (object2) {
                            this.messageQueue.stop();
                            this._startState = StartState.STOPPED;
                            return false;
                        }
                    }
                    if (this._startState.equals((Object)StartState.STOPPED)) {
                        return false;
                    }
                    if (this._startState.equals((Object)StartState.STOPPING) && this._inCallbackThreadId == Thread.currentThread().getId()) {
                        return false;
                    }
                    if (this._startState.equals((Object)StartState.STOPPING)) {
                        throw new IllegalStateException("Cannot stop consumer, already stopping");
                    }
                    this._stoppingLatch = new CountDownLatch(1);
                    this._startState = StartState.STOPPING;
                }
                object = this.messageQueue.getLock();
                synchronized (object) {
                    this.messageQueue.stop();
                    if (this._inCallbackThreadId == 0L || this._inCallbackThreadId == Thread.currentThread().getId()) {
                        this._stoppingLatch.countDown();
                    }
                }
                this.manageAckForStop(allowSendAcks);
            }
            catch (IllegalStateException illegalStateException) {
                continue;
            }
            break;
        }
        return true;
    }

    protected void manageAckForStop(boolean allowSendAcks) {
        this.stopAckTimer();
        if (allowSendAcks && this.tcpChannel.connected() && this.ad_enabled) {
            WireMessage ackmsg = this.tpCreateAck();
            this.tpSendAck(ackmsg, false, false);
            this.Trace.debug(String.format("ack>>> flow=%s, tp=%s, ws=%s", this.getFlowId(), this.getLastInOrderTpMsg(), this.getWindowSize()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void manageChildFlowStop(boolean allowSendAcks) {
        if (!this.largeMessaging) {
            return;
        }
        Object object = this.msgSegmentFlowLock;
        synchronized (object) {
            if (this.msgSegmentFlows.size() > 0) {
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug("stop segment flows and timer for flow " + this.flowId);
                }
                this.stopMsgSegmentTimer();
                Iterator<FlowHandleImpl> it = this.msgSegmentFlows.values().iterator();
                while (it.hasNext()) {
                    it.next().stopImpl(allowSendAcks, false, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopSyncWait() throws JCSMPInterruptedException {
        if (!this._startState.equals((Object)StartState.STOPPING)) {
            throw new IllegalStateException("Entered stopSyncWait without being in STOPPING state");
        }
        try {
            if (this._stoppingLatch != null) {
                this._stoppingLatch.await();
            }
        }
        catch (InterruptedException e) {
            throw new JCSMPInterruptedException("stopSyncWait interripted", e);
        }
        finally {
            this._stoppingLatch = null;
            Object object = this.startStopLock;
            synchronized (object) {
                this._startState = StartState.STOPPED;
            }
        }
    }

    public void handlePreRollback() {
        if (this.isRedelivertDelayInProgress()) {
            if (this.Trace.isInfoEnabled()) {
                this.Trace.info("The redelivery delay timer is already running");
            }
            return;
        }
        if (this.isRedelivertDelayEnabled()) {
            int delayInMs = this.getNextWaitIntervalInMs();
            if (delayInMs > 0) {
                this.stopByRollback();
                this.startRedeliveryDelayTimer(delayInMs);
            } else if (this.Trace.isErrorEnabled()) {
                this.Trace.error("got an invalid delivery delay value: " + delayInMs);
            }
        }
    }

    public void redeliverDelayResetFlowResume(boolean isReconnect) {
        block5: {
            this.resetWaitIntervalInMs();
            if (this.isRedelivertDelayInProgress()) {
                try {
                    this.stopRedeliveryDelayTimer();
                    if (isReconnect) {
                        this._startState = StartState.STARTED;
                    } else {
                        this.start();
                    }
                }
                catch (JCSMPException e) {
                    if (!this.Trace.isDebugEnabled()) break block5;
                    this.Trace.debug("caught an exception", e);
                }
            }
        }
    }

    public void notifyPostReconnect() {
        if (this.isTransacted()) {
            this.getTransactedSession().notifyPostReconnect(this);
            this.redeliverDelayResetFlowResume(true);
        }
    }

    public void notifyReconnected() {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("notifyReconnected flowId= " + this.flowId + "; state=" + (Object)((Object)this._startState));
        }
        if (!this._startState.equals((Object)StartState.STARTED)) {
            return;
        }
        if (this.ad_enabled) {
            WireMessage ackmsg = this.tpCreateAck();
            this.tpSendAck(ackmsg, true, false);
            if (this.unackedList.hasUnsentAcks()) {
                this.startAckTimer();
            }
        }
    }

    public void handleException(JCSMPException e) {
        String extra_dbg = "";
        if (this.tcpChannel instanceof TcpClientChannel) {
            extra_dbg = String.format("(channel:%s) ", ((TcpClientChannel)this.tcpChannel).getDbgId());
        }
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("FlowHandleImpl:handleException() for flow " + this.flowId + ": " + extra_dbg + e.getMessage());
        }
        this.handleControllerException(e);
        this.handleQueueException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleControllerException(JCSMPException e) {
        LiveResponseListener[] respListeners = null;
        HashMap<String, LiveResponseListener> hashMap = this.liveResponseMap;
        synchronized (hashMap) {
            respListeners = new LiveResponseListener[this.liveResponseMap.size()];
            respListeners = this.liveResponseMap.values().toArray(respListeners);
        }
        for (int i = 0; i < respListeners.length; ++i) {
            respListeners[i].onLiveException(this, e);
        }
        LiveTopicListener[] msgListeners = null;
        HashMap<String, LiveTopicListener> hashMap2 = this.liveTopicMap;
        synchronized (hashMap2) {
            msgListeners = new LiveTopicListener[this.liveTopicMap.size()];
            msgListeners = this.liveTopicMap.values().toArray(msgListeners);
        }
        for (int i = 0; i < msgListeners.length; ++i) {
            msgListeners[i].onLiveException(this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyAdMessage(JCSMPXMLMessage msg) {
        AbstractUnackedMessageList.EAddResult addResult = null;
        if (JCSMPUtils.isAdMessage(msg)) {
            if (this.getSpoolerUniqueId() != 0L) {
                if (msg.getSpoolerUniqueId() != 0L) {
                    this.setSpoolerUniqueId(msg.getSpoolerUniqueId());
                } else {
                    msg.setSpoolerUniqueId(this.getSpoolerUniqueId());
                }
            } else {
                msg.setSpoolerUniqueId(0L);
            }
            if (this.getConsumerNotifDsp().hasReachedConfigurableCapacity()) {
                if (this.Trace.isInfoEnabled()) {
                    this.Trace.info("Flow " + this.flowId + ": ConsumerNotificationDispatcher Queue was full - dropping message  " + msg);
                }
                return false;
            }
            this.startAckTimer();
            long msgId = msg.getMessageIdLong();
            if (this.isOutOfOrderMessage(msg)) {
                return false;
            }
            if (this.isStaleMessage(msg)) {
                if (!this.isBrowser() && this.unackedList.isKnownAppAcked(msgId)) {
                    this.sendSingleAck(msgId, false);
                } else {
                    this.unackedList.sendAcks("threshold", false);
                }
                return false;
            }
            Object object = this.ackInfoLock;
            synchronized (object) {
                this.lastInOrderTpMsg = msgId;
                ++this.numUnackedTpMsg;
            }
            msg.setAdSessionUid(this.adSessionUid);
            boolean need_threshold_ack = false;
            Object object2 = this.ackInfoLock;
            synchronized (object2) {
                need_threshold_ack = this.numUnackedTpMsg >= this.ackThreshold;
            }
            addResult = !this.isBrowser() ? this.unackedList.add(msgId) : AbstractUnackedMessageList.EAddResult.OK;
            if (need_threshold_ack) {
                this.unackedList.sendAcks("threshold", false);
            }
            if (this.isRedeliveryCountEnabled()) {
                int count = 0;
                try {
                    count = msg.getDeliveryCount() + 1;
                }
                catch (UnsupportedOperationException e) {
                    count = 1;
                }
                finally {
                    msg.setDeliveryCount(Long.valueOf(count));
                }
            } else {
                msg.setDeliveryCount(null);
            }
            return addResult == AbstractUnackedMessageList.EAddResult.OK;
        }
        return true;
    }

    public boolean processMessage(JCSMPXMLMessage msg) {
        if (!this._startState.equals((Object)StartState.STARTED) && !JCSMPUtils.isAdMessage(msg)) {
            return false;
        }
        this.onLiveMessage(msg);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleQueueException(JCSMPException e) {
        Object object = this.messageQueue.getLock();
        synchronized (object) {
            block11: {
                if (this.messageListener == null) {
                    this.messageQueue.enqueue(e);
                } else {
                    try {
                        if (!this.getConsumerNotifDsp().enqueueNonBlockingNotification(new ConsumerErrorNotification(this.messageListener, e, this))) {
                            if (this.Trace.isWarnEnabled()) {
                                this.Trace.warn("Failed to enqueue consumer error notification for flow " + this.flowId);
                            }
                        } else if (this.Trace.isDebugEnabled()) {
                            this.Trace.debug("Enqueued an exception notification for flow " + this.flowId + ": " + e.toString() + "\n calling stack: " + ThreadUtil.getMyStackTrace());
                        }
                    }
                    catch (Throwable t) {
                        if (!this.Trace.isWarnEnabled()) break block11;
                        this.Trace.warn("Unhandled error in XMLMessageListener for flow " + this.flowId, t);
                    }
                }
            }
        }
    }

    private final void postEnqueueTrigger() {
        if (this.subQueueHook != null) {
            this.subQueueHook.postEnqueue();
        }
    }

    private final void postDequeueTrigger() {
        if (this.subQueueHook != null) {
            this.subQueueHook.postDequeue();
        }
    }

    public ConsumerNotificationDispatcher getConsumerNotifDsp() {
        if (this.consumerNotifDsp == null) {
            this.consumerNotifDsp = this.consumerNotifDspFac == null ? this.context.getConsumerDispatcher() : this.consumerNotifDspFac.getDispatcher();
        }
        return this.consumerNotifDsp;
    }

    private boolean enqueueNotification() {
        try {
            this.getConsumerNotifDsp().enqueueBlockingNotification(new ConsumerMessageNotification(this));
            return true;
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    private boolean enqueueNotification(ConsumerMessageNotification notification) {
        try {
            this.getConsumerNotifDsp().enqueueBlockingNotification(notification);
            return true;
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkLocalQueueEmptyAcks() {
        if (this.ad_enabled) {
            boolean need_send_ack = false;
            Object object = this.ackInfoLock;
            synchronized (object) {
                int deliveryQueueSizePostDequeue = this.messageQueue.size();
                if (deliveryQueueSizePostDequeue == 0) {
                    int leftInWindow = this.lastReportedWinSz - this.numUnackedTpMsg;
                    int leftToNextTpAck = Math.max(this.ackThreshold - this.numUnackedTpMsg, 0);
                    if (leftToNextTpAck >= leftInWindow) {
                        need_send_ack = true;
                    }
                }
            }
            if (need_send_ack) {
                this.unackedList.sendAcks("uncongested-threshold", false);
            }
        }
    }

    public void openWindow() {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("Open window for flowId=" + this.flowId);
        }
        this.pauseFlowInternally = false;
        if (this.ad_enabled && !this.isRedelivertDelayInProgress()) {
            this.unackedList.sendAcks("open-window", false);
        }
    }

    public void closeWindow() {
        if (this.ad_enabled) {
            this.unackedList.sendCloseAcks("close-window", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object triggerAsyncDelivery() {
        XMLMessageListener localListener = null;
        Object object = this.messageQueue.getLock();
        synchronized (object) {
            this._inCallbackThreadId = Thread.currentThread().getId();
        }
        Object deliver = null;
        try {
            Object jcsmpMsg;
            Object object2;
            localListener = this.messageListener;
            if (localListener == null) {
                Object var3_4 = null;
                return var3_4;
            }
            try {
                object2 = this.messageQueue.getLock();
                synchronized (object2) {
                    deliver = this.messageQueue.dequeueNoWait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (deliver == null || deliver instanceof JCSMPXMLMessage && this.isTransacted() && !this.getTransactedSession().hasNotDeliveredToFlow(this, (JCSMPXMLMessage)deliver)) {
                object2 = null;
                return object2;
            }
            if (deliver instanceof XMLMessage) {
                jcsmpMsg = (JCSMPXMLMessage)deliver;
                ((JCSMPXMLMessage)jcsmpMsg).setSession(this.session);
                if (this.msgAckModeClient) {
                    ((JCSMPXMLMessage)jcsmpMsg).setMessageConsumer(this);
                }
                if (this.isTransacted()) {
                    this.addMsgToTransactionStep((JCSMPXMLMessage)jcsmpMsg);
                }
                this.postDequeueTrigger();
                this.checkLocalQueueEmptyAcks();
                this.setLastMsgIdAcked(((JCSMPXMLMessage)jcsmpMsg).getMessageIdLong());
                localListener.onReceive(FlowHandleImpl.createStructuredType((JCSMPXMLMessage)jcsmpMsg));
                if (!this.msgAckModeClient) {
                    this.ackMessage((JCSMPXMLMessage)jcsmpMsg);
                }
            }
            if (deliver instanceof JCSMPException) {
                localListener.onException((JCSMPException)deliver);
            }
            jcsmpMsg = deliver;
            return jcsmpMsg;
        }
        catch (Throwable t) {
            this.Trace.warn("Exception occurred in async delivery for flow " + this.flowId, t);
            if (t instanceof JCSMPException) {
                localListener.onException((JCSMPException)t);
            } else if (!(t instanceof IllegalStateException) || !t.getMessage().contains(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageConsumer.attemptOpOnClosed")) || this.opened) {
                localListener.onException(new JCSMPException("Error calling XMLMessagelistener", t));
            }
            Object object3 = deliver;
            return object3;
        }
        finally {
            Object object4 = this.messageQueue.getLock();
            synchronized (object4) {
                this._inCallbackThreadId = 0L;
                if (this._stoppingLatch != null) {
                    this._stoppingLatch.countDown();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMsgToTransactionStep(JCSMPXMLMessage jcsmpMsg) {
        if (!this.msgSegmentFlow) {
            ConsumerLargeMessageNotification notif;
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug(String.format("Entering addMsgToTransactionStep(): sessionName='%s', flowId=%d, msgId=%d, ackMsgId=%d", this.transactedSession.getName(), this.flowId, jcsmpMsg.getMessageIdLong(), jcsmpMsg.getAckMessageId()));
            }
            this.transactedSession.addInputStep(this, jcsmpMsg.getMessageIdLong(), jcsmpMsg.getAckMessageId());
            if (jcsmpMsg.getLargeMsgInfo() != null && (notif = jcsmpMsg.getLargeMsgInfo()).getLastSegmentMsgRecvd() != null) {
                Object object = this.msgSegmentFlowLock;
                synchronized (object) {
                    this.unackedMsgSegments.put(notif.getLgmMsgId(), notif.getLastSegmentMsgRecvd());
                }
                jcsmpMsg.setLargeMsgInfo(null);
            }
        }
    }

    boolean isStaleMessage(JCSMPXMLMessage msg) {
        if (msg.getMessageIdLong() <= this.getLastInOrderTpMsg()) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug(String.format("Subscriber received stale message [MsgId=%s], expected [MsgId > %s] on Flow (%s), ignoring.", msg.getMessageId(), this.getLastInOrderTpMsg(), this.getLogFlowInfoString()));
            }
            this.session.getSessionStats().incStat(StatType.RELIABLE_MSGS_DISCARDED_DUPLICATES);
            return true;
        }
        return false;
    }

    boolean isOutOfOrderMessage(JCSMPXMLMessage msg) {
        if (msg.getPrevMessageId() > this.getLastInOrderTpMsg()) {
            if (this.Trace.isInfoEnabled()) {
                this.Trace.info(String.format("Subscriber received out-of-order message [MsgId=%s PrevId=%s], expected [PrevId <= %s] on Flow (%s), ignoring.", msg.getMessageId(), msg.getPrevMessageId(), this.getLastInOrderTpMsg(), this.getLogFlowInfoString()));
            }
            this.session.getSessionStats().incStat(StatType.RELIABLE_MSGS_DISCARDED_OUTOFORDER);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastInOrderTpMsg() {
        Object object = this.ackInfoLock;
        synchronized (object) {
            return this.lastInOrderTpMsg;
        }
    }

    private boolean isZeroWindowSizeRequired() {
        if (!this._startState.equals((Object)StartState.STARTED) && !this._startState.equals((Object)StartState.STARTING)) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("Flow " + this.flowId + ": window size 0 due to startState=" + (Object)((Object)this._startState));
            }
            return true;
        }
        if (this.pauseFlowInternally) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("Flow " + this.flowId + ": window size 0 due to pauseFlowInternally=" + this.pauseFlowInternally);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getWindowSize() {
        if (this.isZeroWindowSizeRequired()) {
            return 0;
        }
        return this.unackedList.getWindowSize();
    }

    public AbstractUnackedMessageList.UnackedMessageListInfo getCurrentUnackedMessageListInfo() {
        AbstractUnackedMessageList.UnackedMessageListInfo umli = this.unackedList.getCurrentUnackedMessageListInfo();
        if (umli == null) {
            return null;
        }
        if (this.isZeroWindowSizeRequired()) {
            umli.setWindowSize(0);
        }
        return umli;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNumUnackedTpMsgs(int num) {
        Object object = this.ackInfoLock;
        synchronized (object) {
            this.numUnackedTpMsg = num;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumUnackedTpMsgs() {
        Object object = this.ackInfoLock;
        synchronized (object) {
            return this.numUnackedTpMsg;
        }
    }

    public String getLogFlowInfoString() {
        return String.format("FlowID:%s, lastInOrderTpMsg:%s, numUnackedTpMsgs:%s, Binding:'%s'", this.getFlowId(), this.getLastInOrderTpMsg(), this.getNumUnackedTpMsgs(), StringUtil.truncateStringWithEllipsis(this.getBoundResource().toString(), 40));
    }

    @Override
    public void logFlowInfo(JCSMPLogLevel level) {
        String logmessage = String.format("Info for flow: %s", this.getLogFlowInfoString());
        LogLevelAdapter.log(level, this.Trace, logmessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAckTimer(int millis) {
        StringBuilder logmsg = null;
        boolean DBG = this.Trace.isDebugEnabled();
        if (DBG) {
            logmsg = new StringBuilder();
            logmsg.append("Flow " + this.flowId + ": Starting sub ad timer: ");
        }
        Object object = this.ackTimerLock;
        synchronized (object) {
            if (this.ackTimer == null || !this.ackTimer.isActive()) {
                this.ackTimer = this.timerQueue.schedule_relative(millis, this.subAckTask);
                if (DBG) {
                    logmsg.append("scheduled new timer in ").append(millis);
                }
            } else if (DBG) {
                logmsg.append("already scheduled in ").append(this.ackTimer.getTimeout() - System.currentTimeMillis());
            }
        }
        if (DBG) {
            this.Trace.debug(logmsg);
        }
    }

    @Override
    public void startAckTimer() {
        this.startAckTimer(this.ackTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAckTimer() {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("Flow " + this.flowId + ": Clear AD timer");
        }
        Object object = this.ackTimerLock;
        synchronized (object) {
            if (this.ackTimer != null) {
                this.timerQueue.cancelTimer(this.ackTimer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMsgSegmentTimer(int millis, boolean restart) {
        StringBuilder logmsg = null;
        boolean DBG = this.Trace.isDebugEnabled();
        if (DBG) {
            logmsg = new StringBuilder();
            logmsg.append("Flow " + this.flowId + ": ");
        }
        Object object = this.msgSegmentFlowLock;
        synchronized (object) {
            if (!restart && this.msgSegmentTimer == null || this.msgSegmentTimer != null && !this.msgSegmentTimer.isActive()) {
                if (DBG) {
                    logmsg.append("Starting message segment reconstruction timer: ");
                }
                this.msgSegmentTimer = this.timerQueue.schedule_relative(millis, this.msgSegmentTimeoutTask);
                if (DBG) {
                    logmsg.append("scheduled new message segment reconstruction timer in ").append(millis);
                }
            } else if (DBG) {
                if (this.msgSegmentTimer != null && this.msgSegmentTimer.isActive()) {
                    logmsg.append("already scheduled message segment reconstruction timer in ").append(this.msgSegmentTimer.getTimeout() - System.currentTimeMillis());
                } else {
                    logmsg.append("no need to restart message segment reconstruction timer when it is null");
                }
            }
        }
        if (DBG && logmsg.length() > 0) {
            this.Trace.debug(logmsg);
        }
    }

    public void startMsgSegmentTimer(boolean restart) {
        this.startMsgSegmentTimer(this.msgSegmentTimeout, restart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMsgSegmentTimer() {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("Clear message segment reconstruction timer for flow " + this.flowId);
        }
        Object object = this.msgSegmentFlowLock;
        synchronized (object) {
            if (this.msgSegmentTimer != null) {
                this.timerQueue.cancelTimer(this.msgSegmentTimer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSegmentFlowCreationTimer(int millis) {
        StringBuilder logmsg = null;
        boolean DBG = this.Trace.isDebugEnabled();
        if (DBG) {
            logmsg = new StringBuilder();
            logmsg.append("Flow " + this.flowId + ": ");
        }
        Object object = this.msgSegmentFlowLock;
        synchronized (object) {
            if (this.segmentFlowCreationTimer == null || this.segmentFlowCreationTimer != null && !this.segmentFlowCreationTimer.isActive()) {
                if (DBG) {
                    logmsg.append("Starting segment flow creation timer: ");
                }
                this.segmentFlowCreationTimer = this.timerQueue.schedule_relative(millis, this.segmentFlowCreationTimeoutTask);
                if (DBG) {
                    logmsg.append("scheduled new segment flow creation timer in ").append(millis);
                }
            } else if (DBG && this.segmentFlowCreationTimer != null && this.segmentFlowCreationTimer.isActive()) {
                logmsg.append("already scheduled segment flow creation timer in ").append(this.segmentFlowCreationTimer.getTimeout() - System.currentTimeMillis());
            }
        }
        if (DBG && logmsg.length() > 0) {
            this.Trace.debug(logmsg);
        }
    }

    public void startSegmentFlowCreationTimer() {
        this.startSegmentFlowCreationTimer(this.segmentFlowCreationTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSegmentFlowCreationTimer() {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("Clear segment flow creation timer for flow " + this.flowId);
        }
        Object object = this.msgSegmentFlowLock;
        synchronized (object) {
            if (this.segmentFlowCreationTimer != null) {
                this.timerQueue.cancelTimer(this.segmentFlowCreationTimer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRedeliveryDelayTimer(int millis) {
        StringBuilder logmsg = null;
        boolean DBG = this.Trace.isDebugEnabled();
        if (DBG) {
            logmsg = new StringBuilder();
            logmsg.append("Flow " + this.flowId + ": Starting redelivery delay timer: ");
        }
        Object object = this.redeliveryDelayTimerLock;
        synchronized (object) {
            if (this.redeliveryDelayTimer == null || !this.redeliveryDelayTimer.isActive()) {
                this.redeliveryDelayTimer = this.timerQueue.schedule_relative(millis, this.redeliveryDelayTimedTask);
                if (DBG) {
                    logmsg.append("scheduled new timer in ").append(millis);
                }
            } else if (DBG) {
                logmsg.append("already scheduled in ").append(this.redeliveryDelayTimer.getTimeout() - System.currentTimeMillis());
            }
        }
        if (DBG) {
            this.Trace.debug(logmsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopRedeliveryDelayTimer() {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("Flow " + this.flowId + ": Clear Redelivery Delay timer");
        }
        Object object = this.redeliveryDelayTimerLock;
        synchronized (object) {
            if (this.redeliveryDelayTimer != null) {
                this.timerQueue.cancelTimer(this.redeliveryDelayTimer);
                this.redeliveryDelayTimer = null;
            }
        }
    }

    private boolean isBrowser() {
        return this.flowType == AssuredCtrlEnums.FlowType.BROWSER;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    private final void autoAckOrSetConsumer(JCSMPXMLMessage msg) {
        if (this.msgAckModeClient) {
            msg.setMessageConsumer(this);
        } else {
            this.ackMessage(msg);
        }
    }

    public void throwClosedException(String message) throws InvalidOperationException {
        if (this.lastException != null) {
            throw new StaleSessionException(message, this.lastException);
        }
        throw new ClosedFacilityException(message);
    }

    public void ackMessage(JCSMPXMLMessage msg) {
        block2: {
            try {
                this.ackMessage(msg, false);
            }
            catch (JCSMPException e) {
                if (!this.Trace.isInfoEnabled()) break block2;
                this.Trace.info("ackMessage caught exception", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ackMessage(JCSMPXMLMessage msg, boolean fromSettleMetthod) throws JCSMPException {
        if (!JCSMPUtils.isAdMessage(msg) || msg.isCacheMessage()) {
            return;
        }
        if (!this.opened) {
            throw new IllegalStateException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageConsumer.attemptOpOnClosed"));
        }
        if (this.grantedPermissions != null && this.grantedPermissions < 2L) {
            throw new AccessDeniedException("Access Denied - no permission to remove");
        }
        if (this.adSessionUid != msg.getAdSessionUid()) {
            this.Trace.info(String.format("Flow %s: FlowHandleImpl ignoring application ack (message from different AD session) for message (%s)", this.flowId, msg.toString()));
            return;
        }
        long id = msg.getMessageIdLong();
        boolean isBrowser = this.isBrowser();
        if (isBrowser) {
            this.stopAckTimer();
        }
        boolean force_send = isBrowser || msg.getLargeMsgInfo() != null && !this.isTransacted();
        AbstractUnackedMessageList.EAppAckResult ack_r = this.unackedList.applicationAck(id, force_send);
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug(String.format("appack>>>flowId=%s, id=%s res=%s", new Object[]{this.flowId, id, ack_r}));
        }
        if (msg.getLargeMsgInfo() != null && !this.isTransacted()) {
            ConsumerLargeMessageNotification notif = msg.getLargeMsgInfo();
            if (notif.getLastSegmentMsgRecvd() != null) {
                JCSMPXMLMessage jMsg = (JCSMPXMLMessage)notif.getLastSegmentMsgRecvd();
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug(String.format("Flow %s: Ack large message received: application ack last segment msgId=%s, lgmMsgId=%s, flowId=%s", this.flowId, jMsg.getMessageId(), notif.getLgmMsgId(), jMsg.getFlowId()));
                }
                if (fromSettleMetthod) {
                    notif.getLastSegmentMsgRecvd().settle(XMLMessage.Outcome.ACCEPTED);
                } else {
                    notif.getLastSegmentMsgRecvd().ackMessage();
                }
            }
            Object object = this.msgSegmentFlowLock;
            synchronized (object) {
                FlowHandleImpl msgSegmentFlow = this.msgSegmentFlows.get(notif.getLgmMsgId());
                if (msgSegmentFlow != null) {
                    if (this.Trace.isDebugEnabled()) {
                        this.Trace.debug("Flow " + this.flowId + ": Ack large message received: close segmenet flow for lgmMsgId=" + notif.getLgmMsgId() + " flowId " + msgSegmentFlow.getFlowId());
                    }
                    msgSegmentFlow.close();
                    this.msgSegmentFlows.remove(notif.getLgmMsgId());
                }
            }
            msg.setLargeMsgInfo(null);
        } else if (ack_r == AbstractUnackedMessageList.EAppAckResult.NOT_FOUND || ack_r == AbstractUnackedMessageList.EAppAckResult.OK) {
            JCSMPSessionStats sessionStats = this.session.getSessionStats();
            if (fromSettleMetthod) {
                sessionStats.incStat(StatType.RELIABLE_MSGS_RECVED_ACCEPTED);
                if (msg.getDeliveryMode() == DeliveryMode.PERSISTENT) {
                    sessionStats.incStat(StatType.RELIABLE_PERSISTENT_MSGS_RECVED_ACCEPTED);
                } else if (msg.getDeliveryMode() == DeliveryMode.NON_PERSISTENT) {
                    sessionStats.incStat(StatType.RELIABLE_NONPERSISTENT_MSGS_RECVED_ACCEPTED);
                }
            }
            sessionStats.incStat(StatType.RELIABLE_MSGS_RECVED_ACKED);
            if (msg.getDeliveryMode() == DeliveryMode.PERSISTENT) {
                sessionStats.incStat(StatType.RELIABLE_PERSISTENT_MSGS_RECVED_ACKED);
            } else if (msg.getDeliveryMode() == DeliveryMode.NON_PERSISTENT) {
                sessionStats.incStat(StatType.RELIABLE_NONPERSISTENT_MSGS_RECVED_ACKED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void settle(JCSMPXMLMessage msg, XMLMessage.Outcome settlementOutcome) throws JCSMPException {
        if (settlementOutcome.equals((Object)XMLMessage.Outcome.ACCEPTED)) {
            this.ackMessage(msg, true);
            return;
        }
        if (!JCSMPUtils.isAdMessage(msg) || msg.isCacheMessage()) {
            return;
        }
        if (!this.opened) {
            throw new IllegalStateException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageConsumer.attemptOpOnClosed"));
        }
        if (this.grantedPermissions != null && this.grantedPermissions < 2L) {
            throw new AccessDeniedException("Access Denied - no permission to remove");
        }
        if (this.adSessionUid != msg.getAdSessionUid()) {
            this.Trace.info(String.format("Flow %s: FlowHandleImpl ignoring application ack (message from different AD session) for message (%s)", this.flowId, msg.toString()));
            return;
        }
        long id = msg.getMessageIdLong();
        AbstractUnackedMessageList.EAppAckResult ack_r = this.unackedList.settleMsg(id, settlementOutcome);
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug(String.format("settle>>>flowId=%s, id=%s res=%s, outcome=%s", new Object[]{this.flowId, id, ack_r, settlementOutcome}));
        }
        if (msg.getLargeMsgInfo() != null && !this.isTransacted()) {
            ConsumerLargeMessageNotification notif = msg.getLargeMsgInfo();
            if (notif.getLastSegmentMsgRecvd() != null) {
                JCSMPXMLMessage jMsg = (JCSMPXMLMessage)notif.getLastSegmentMsgRecvd();
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug(String.format("Flow %s: Settle large message received: last segment msgId=%s, lgmMsgId=%s, flowId=%s", this.flowId, jMsg.getMessageId(), notif.getLgmMsgId(), jMsg.getFlowId()));
                }
                notif.getLastSegmentMsgRecvd().settle(settlementOutcome);
            }
            Object object = this.msgSegmentFlowLock;
            synchronized (object) {
                FlowHandleImpl msgSegmentFlow = this.msgSegmentFlows.get(notif.getLgmMsgId());
                if (msgSegmentFlow != null) {
                    if (this.Trace.isDebugEnabled()) {
                        this.Trace.debug("Flow " + this.flowId + ": Settle large message received: close segmenet flow for lgmMsgId=" + notif.getLgmMsgId() + " flowId " + msgSegmentFlow.getFlowId());
                    }
                    msgSegmentFlow.close();
                    this.msgSegmentFlows.remove(notif.getLgmMsgId());
                }
            }
            msg.setLargeMsgInfo(null);
        } else if (ack_r == AbstractUnackedMessageList.EAppAckResult.NOT_FOUND || ack_r == AbstractUnackedMessageList.EAppAckResult.OK) {
            JCSMPSessionStats sessionStats = this.session.getSessionStats();
            if (settlementOutcome.equals((Object)XMLMessage.Outcome.FAILED)) {
                sessionStats.incStat(StatType.RELIABLE_MSGS_RECVED_FAILED);
                if (msg.getDeliveryMode() == DeliveryMode.PERSISTENT) {
                    sessionStats.incStat(StatType.RELIABLE_PERSISTENT_MSGS_RECVED_FAILED);
                } else if (msg.getDeliveryMode() == DeliveryMode.NON_PERSISTENT) {
                    sessionStats.incStat(StatType.RELIABLE_NONPERSISTENT_MSGS_RECVED_FAILED);
                }
            } else if (settlementOutcome.equals((Object)XMLMessage.Outcome.REJECTED)) {
                sessionStats.incStat(StatType.RELIABLE_MSGS_RECVED_REJECTED);
                if (msg.getDeliveryMode() == DeliveryMode.PERSISTENT) {
                    sessionStats.incStat(StatType.RELIABLE_PERSISTENT_MSGS_RECVED_REJECTED);
                } else if (msg.getDeliveryMode() == DeliveryMode.NON_PERSISTENT) {
                    sessionStats.incStat(StatType.RELIABLE_NONPERSISTENT_MSGS_RECVED_REJECTED);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendSingleAck(long msgId, boolean allowReactorComplete) {
        WireMessage ackMsg = null;
        Object object = this.getAckCreateSendLock();
        synchronized (object) {
            ackMsg = this.tpCreateAck();
            AppAckRangeCache rangecache = new AppAckRangeCache();
            rangecache.addTmp(msgId, msgId);
            this.unackedList.tpAddApplicationAcks((AssuredCtrlHeaderBean)ackMsg.getHeaderBean(), rangecache);
        }
        boolean locked = true;
        try {
            if (this.isReactorThread()) {
                locked = this.getAckSendingLock().tryLock();
                if (!locked) {
                    this.getTcpChannel().enqueuePriorityData(ackMsg);
                    return;
                }
            } else {
                this.getAckSendingLock().lock();
            }
            this.tpSendAck(ackMsg, false, allowReactorComplete);
        }
        finally {
            if (locked) {
                this.getAckSendingLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendSingleAck(long msgId, boolean allowReactorComplete, XMLMessage.Outcome out) {
        WireMessage ackMsg = null;
        Object object = this.getAckCreateSendLock();
        synchronized (object) {
            ackMsg = this.tpCreateAck();
            AppAckRangeCache rangecache = new AppAckRangeCache();
            rangecache.addTmp(msgId, msgId);
            this.unackedList.tpAddApplicationAcks((AssuredCtrlHeaderBean)ackMsg.getHeaderBean(), rangecache, out);
        }
        boolean locked = true;
        try {
            if (this.isReactorThread()) {
                locked = this.getAckSendingLock().tryLock();
                if (!locked) {
                    this.getTcpChannel().enqueuePriorityData(ackMsg);
                    return;
                }
            } else {
                this.getAckSendingLock().lock();
            }
            this.tpSendAck(ackMsg, false, allowReactorComplete);
        }
        finally {
            if (locked) {
                this.getAckSendingLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WireMessage tpCreateAck() {
        int tt_windowSz = 0;
        long tt_lastInOrderTpMsg = 0L;
        AbstractUnackedMessageList.UnackedMessageListInfo umli = this.getCurrentUnackedMessageListInfo();
        if (umli != null) {
            tt_windowSz = umli.getWindowSize();
            tt_lastInOrderTpMsg = umli.getLastInOrderTpMsgId();
        } else {
            tt_windowSz = this.getWindowSize();
        }
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("Flow " + this.flowId + ": getWindowSize()=" + tt_windowSz);
        }
        Object object = this.ackInfoLock;
        synchronized (object) {
            if (umli == null) {
                tt_lastInOrderTpMsg = this.getLastInOrderTpMsg();
            }
            WireMessage ackMsg = FlowSmfUtil.tpCreateAck(this.getFlowId(), tt_lastInOrderTpMsg, tt_windowSz);
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("tpCreateAck: flow_d: " + this.getFlowId() + ", tt_lastInOrderTpMsg: " + tt_lastInOrderTpMsg + ", tt_windowSz: " + tt_windowSz);
            }
            this.lastReportedWinSz = tt_windowSz;
            long expect_ack_serial = this.ackSerialCounter.incrementAndGet();
            ackMsg.serialNumber = expect_ack_serial;
            this.setAckLastSerialNumber(expect_ack_serial);
            return ackMsg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WireMessage tpCreateStopAck() {
        int tt_windowSz = 0;
        Object object = this.ackInfoLock;
        synchronized (object) {
            long tt_lastInOrderTpMsg = this.getLastInOrderTpMsg();
            WireMessage ackMsg = FlowSmfUtil.tpCreateAck(this.getFlowId(), tt_lastInOrderTpMsg, tt_windowSz);
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("tpCreateStopAck: flow_d: " + this.getFlowId() + ", tt_lastInOrderTpMsg: " + tt_lastInOrderTpMsg + ", tt_windowSz: " + tt_windowSz);
            }
            this.lastReportedWinSz = tt_windowSz;
            long expect_ack_serial = this.ackSerialCounter.incrementAndGet();
            ackMsg.serialNumber = expect_ack_serial;
            this.setAckLastSerialNumber(expect_ack_serial);
            return ackMsg;
        }
    }

    @Override
    public void tpSendAck(WireMessage ackMsg, boolean allowOnStateSub, boolean allowReactorComplete) {
        if (ackMsg != null && this.tcpChannel.connected()) {
            allowReactorComplete = false;
            this.tpAckStrategy.tpSendAck(ackMsg, allowOnStateSub, allowReactorComplete);
        }
    }

    public SubscriberQueueHooks getSubQueueHooks() {
        return this.subQueueHook;
    }

    public void setSubQueueHooks(SubscriberQueueHooks subQueueHooks) {
        this.subQueueHook = subQueueHooks;
    }

    public int getMessageQueueSize() {
        return this.messageQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLiveTopicAction(CacheLiveDataAction action, Topic topic, LiveTopicListener listener) throws InvalidOperationException {
        if (topic != null) {
            HashMap<String, LiveTopicListener> hashMap = this.liveTopicMap;
            synchronized (hashMap) {
                boolean isInFlowThruMap = this.flowThruMap.containsKey(topic.getName());
                boolean isInLiveMap = this.liveTopicMap.containsKey(topic.getName());
                if (isInLiveMap || isInFlowThruMap && !action.equals((Object)CacheLiveDataAction.FLOW_THRU)) {
                    throw new InvalidOperationException("Cache request for \"" + topic.getName() + " \" already in progress");
                }
                if (action.equals((Object)CacheLiveDataAction.FLOW_THRU)) {
                    if (isInFlowThruMap) {
                        Integer intObj = this.flowThruMap.get(topic.getName());
                        this.flowThruMap.put(topic.getName(), intObj + 1);
                    } else {
                        this.flowThruMap.put(topic.getName(), 1);
                    }
                } else {
                    this.liveTopicMap.put(topic.getName(), listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLiveTopicAction(CacheLiveDataAction action, Topic topic) {
        if (topic != null) {
            HashMap<String, LiveTopicListener> hashMap = this.liveTopicMap;
            synchronized (hashMap) {
                if (action.equals((Object)CacheLiveDataAction.FLOW_THRU)) {
                    Integer intObj = this.flowThruMap.get(topic.getName());
                    if (intObj != null) {
                        if (intObj == 1) {
                            this.flowThruMap.remove(topic.getName());
                        } else {
                            this.flowThruMap.put(topic.getName(), intObj - 1);
                        }
                    }
                } else {
                    this.liveTopicMap.remove(topic.getName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLiveResponseListener(String correlationId, LiveResponseListener listener) {
        if (correlationId != null) {
            HashMap<String, LiveResponseListener> hashMap = this.liveResponseMap;
            synchronized (hashMap) {
                this.liveResponseMap.put(correlationId, listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void injectMessage(XMLMessage msg) {
        boolean enqueueNotification = false;
        ConsumerLargeMessageNotification signalMsgNotif = null;
        boolean enqueueFlow = true;
        if (this.deliverAsyncOnReactor) {
            this.getLock().lock();
        }
        try {
            if (this.largeMessaging && this.durableQueueFlow && !this.isBrowser() && JCSMPUtils.isAdMessage(msg) && msg instanceof JCSMPXMLMessage) {
                JCSMPXMLMessage jMsg = (JCSMPXMLMessage)msg;
                SDTMap userProps = jMsg.getProperties();
                if (userProps != null) {
                    try {
                        String uuid = userProps.getString("JMS_Solace_lgm_guid");
                        Integer numSegments = userProps.getInteger("JMS_Solace_lgm_numSegs");
                        Integer totalSize = userProps.getInteger("JMS_Solace_lgm_size");
                        if (uuid != null && uuid.length() > 0 && numSegments != null) {
                            if (this.Trace.isDebugEnabled()) {
                                this.Trace.debug("Stop the flow, but not segment flows for flow " + this.flowId);
                            }
                            this.stopImpl(true, false, true);
                            enqueueFlow = false;
                            jMsg.clearReadOnly();
                            userProps.remove("JMS_Solace_lgm_guid");
                            userProps.remove("JMS_Solace_lgm_numSegs");
                            userProps.remove("JMS_Solace_lgm_size");
                            signalMsgNotif = new ConsumerLargeMessageNotification(this, jMsg, uuid, numSegments, totalSize);
                            MsgSegmentReconstructionTimedTask segmentTimeoutTask = new MsgSegmentReconstructionTimedTask(this, signalMsgNotif);
                            signalMsgNotif.setTimeoutTask(segmentTimeoutTask);
                            enqueueNotification = this.enqueueConstruction(signalMsgNotif, null);
                        }
                        Object object = this.msgConstructionQueueLock;
                        synchronized (object) {
                            if (this.msgConstructionQueue.size() > 0) {
                                enqueueFlow = false;
                                enqueueNotification = this.enqueueConstruction(null, msg);
                            }
                        }
                    }
                    catch (SDTException e) {
                        if (this.Trace.isErrorEnabled()) {
                            this.Trace.error("Error occurred while retrieving message properties: msg=" + ((JCSMPXMLMessage)msg).getMessageIdLong(), e);
                        }
                        this.handleException(e);
                        if (this.deliverAsyncOnReactor) {
                            this.getLock().unlock();
                        }
                        return;
                    }
                } else {
                    Object object = this.msgConstructionQueueLock;
                    synchronized (object) {
                        if (this.msgConstructionQueue.size() > 0) {
                            enqueueFlow = false;
                            enqueueNotification = this.enqueueConstruction(null, msg);
                        }
                    }
                }
            }
            if (enqueueFlow) {
                enqueueNotification = this.enqueueMessageQueue(msg);
            }
        }
        finally {
            if (this.deliverAsyncOnReactor) {
                this.getLock().unlock();
            }
        }
        if (enqueueNotification) {
            if (signalMsgNotif == null) {
                this.enqueueNotification();
            } else {
                this.enqueueNotification(signalMsgNotif);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enqueueConstruction(ConsumerLargeMessageNotification signalMsgNotif, XMLMessage msg) {
        boolean enqueueNotification = signalMsgNotif != null;
        Object object = this.msgConstructionQueueLock;
        synchronized (object) {
            if (!this.msgConstructionQueueClosed) {
                String str = "";
                if (signalMsgNotif == null) {
                    str = String.format("Enqueued msg to construction: flowId=%s, msg=%s, dest=%s", this.flowId, ((JCSMPXMLMessage)msg).getMessageIdLong(), msg.getDestination());
                    this.msgConstructionQueue.add(msg);
                } else {
                    str = String.format("Enqueued signal msg to construction: flowId=%s, msg=%s, dest=%s, lgmMsgId=%s, lgmNumSegments=%s, lgmTotalSize=%s", this.flowId, signalMsgNotif.getSignalMessage().getMessageId(), signalMsgNotif.getSignalMessage().getDestination(), signalMsgNotif.getLgmMsgId(), signalMsgNotif.getNumSegments(), signalMsgNotif.getTotalSize());
                    this.msgConstructionQueue.add(signalMsgNotif);
                }
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug(str);
                }
            } else {
                enqueueNotification = false;
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug("Construction queue is closed, drop the message for flow " + this.flowId);
                }
            }
        }
        return enqueueNotification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enqueueMessageQueue(XMLMessage msg) {
        boolean enqueueNotification = false;
        Object object = this.messageQueue.getLock();
        synchronized (object) {
            if (this.Trace.isDebugEnabled() && msg instanceof JCSMPXMLMessage) {
                this.Trace.debug("Flow " + this.flowId + ": Enqueue to delivery: msg=" + ((JCSMPXMLMessage)msg).getMessageIdLong() + ", dest=" + msg.getDestination());
            }
            int szRemain = this.messageQueue.enqueue(msg);
            this.postEnqueueTrigger();
            if (!(msg instanceof EventMessage) && szRemain == 0 && JCSMPUtils.isAdMessage(msg)) {
                this.session.getSessionStats().incStat(StatType.SUBSCRIBER_FLOW_WINDOW_CLOSED);
            }
        }
        if (this.messageListener != null) {
            if (this.deliverAsyncOnReactor) {
                this.triggerAsyncDelivery();
            } else {
                enqueueNotification = true;
            }
        }
        return enqueueNotification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void handleLargeMsgNotification(ConsumerLargeMessageNotification notif) {
        FlowHandleImpl internalFlow = null;
        try {
            block36: {
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug(String.format("Flow %s handleLargeMsgNotification - %s", this.flowId, notif));
                }
                if (notif.isSuspended()) {
                    if (!this.Trace.isDebugEnabled()) return;
                    this.Trace.debug("Flow " + this.flowId + ":Ignore suspended large message notification lgmMsgId=" + notif.getLgmMsgId());
                    return;
                }
                if (notif.isTimeoutNotification()) {
                    this.triggerDequeueFromConstructionQueue(notif);
                    return;
                }
                Object object = this.msgConstructionQueueLock;
                // MONITORENTER : object
                if (this.msgConstructionQueueClosed) {
                    if (this.Trace.isDebugEnabled()) {
                        this.Trace.debug("Flow " + this.flowId + ": Message construction queue is closed, ignore stale large message notification - " + notif);
                    }
                    // MONITOREXIT : object
                    return;
                }
                if (this.msgConstructionQueue.size() == 0) {
                    if (this.Trace.isDebugEnabled()) {
                        this.Trace.debug("Flow " + this.flowId + ": Message construction queue is empty, ignore stale large message notification - " + notif);
                    }
                    // MONITOREXIT : object
                    return;
                }
                if (this.currMsgUnderConstruction == null) {
                    if (notif == this.msgConstructionQueue.getFirst()) {
                        this.currMsgUnderConstruction = notif;
                        break block36;
                    } else {
                        if (this.Trace.isDebugEnabled()) {
                            this.Trace.debug("Flow " + this.flowId + ": Ignore stale large message notification - " + notif);
                        }
                        // MONITOREXIT : object
                        return;
                    }
                }
                internalFlow = this.msgSegmentFlows.get(notif.getLgmMsgId());
                if (internalFlow != null) {
                    if (this.Trace.isDebugEnabled()) {
                        this.Trace.debug("Flow " + this.flowId + ": There is already a large message under construction, do nothing");
                    }
                    // MONITOREXIT : object
                    return;
                }
            }
            // MONITOREXIT : object
            ConsumerFlowProperties cfp = new ConsumerFlowProperties();
            cfp.setAckMode("client_ack_windowed");
            cfp.setEndpoint(JCSMPFactory.onlyInstance().createQueue("#LGM/" + this.boundToResource.getName()));
            cfp.setSelector("JMS_Solace_lgm_guid='" + notif.getLgmMsgId() + "'");
            cfp.setTransportWindowSize(1);
            if (this.flowType == AssuredCtrlEnums.FlowType.CONSUMER_REDELIVERY_FLOW) {
                cfp.addRequiredSettlementOutcomes(XMLMessage.Outcome.FAILED, XMLMessage.Outcome.REJECTED);
            }
            cfp.setAckTimerInMsecs(this.ackTimeout);
            cfp.setAckThreshold(this.originalAckThreashold);
            if (this.flowEventHandler != null) {
                cfp.setActiveFlowIndication(true);
            }
            cfp.setConsumerNotificationDispatcherFactory(this.consumerNotifDspFac);
            JCSMPProperties flowSessionProperties = (JCSMPProperties)this.session.getJCSMPProperties().clone();
            flowSessionProperties.setBooleanProperty("large_messaging", false);
            cfp.setFlowSessionProps(flowSessionProperties);
            cfp.setSegmentFlow(true);
            cfp.setWindowedAckMaxSize(65000);
            try {
                if (this._startState.equals((Object)StartState.STOPPED) || this._startState.equals((Object)StartState.STOPPING)) {
                    if (notif.getFlowCreationTimeoutTask() == null) {
                        notif.setFlowCreationTimeoutTask(new SegmentFlowCreationTimedTask(this, notif));
                    }
                    this.segmentFlowCreationTimeoutTask = notif.getFlowCreationTimeoutTask();
                    this.startSegmentFlowCreationTimer();
                    return;
                }
                internalFlow = (FlowHandleImpl)this.session.createFlow((XMLMessageListener)this, cfp, null, this.flowEventHandler);
                notif.setFlowCreationTimeoutTask(null);
            }
            catch (JCSMPException e1) {
                if (this.Trace.isWarnEnabled()) {
                    String extra_dbg = "";
                    if (this.tcpChannel instanceof TcpClientChannel) {
                        extra_dbg = String.format("(channel:%s) ", ((TcpClientChannel)this.tcpChannel).getDbgId());
                    }
                    this.Trace.warn("FlowHandleImpl:handleLargeMsgNotification() for flow " + this.flowId + ": " + extra_dbg + e1.getMessage());
                }
                if (notif.getFlowCreationTimeoutTask() == null) {
                    notif.setFlowCreationTimeoutTask(new SegmentFlowCreationTimedTask(this, notif));
                }
                if (this.msgSegmentTimer != null && this.msgSegmentTimer.isActive() && this.msgSegmentTimer.getTimeout() - System.currentTimeMillis() < 0L) {
                    notif.setTimeoutNotification(true);
                    this.triggerDequeueFromConstructionQueue(notif);
                    return;
                }
                this.segmentFlowCreationTimeoutTask = notif.getFlowCreationTimeoutTask();
                this.startSegmentFlowCreationTimer();
                this.startMsgSegmentTimer(false);
                return;
            }
            boolean closeFlow = false;
            Object object = this.msgConstructionQueueLock;
            // MONITORENTER : object
            if (this.msgConstructionQueue.size() == 0 || notif != this.currMsgUnderConstruction) {
                closeFlow = true;
            }
            // MONITOREXIT : object
            if (closeFlow) {
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug("Flow " + this.flowId + ": Flow rolled back or closed, close segment flow for lgmMsgId=" + notif.getLgmMsgId());
                }
                internalFlow.close();
                return;
            }
            object = this.msgSegmentFlowLock;
            // MONITORENTER : object
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("Flow " + this.flowId + ": Start segment flow for lgmMsgId=" + notif.getLgmMsgId());
            }
            this.msgSegmentFlows.put(notif.getLgmMsgId(), internalFlow);
            this.msgSegmentTimeoutTask = notif.getTimeoutTask();
            // MONITOREXIT : object
            internalFlow.startImpl(false, false);
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("Flow " + this.flowId + ": start segment timer for lgmMsgId=" + notif.getLgmMsgId());
            }
            this.startMsgSegmentTimer(false);
            return;
        }
        catch (JCSMPException e) {
            this.handleException(e);
        }
    }

    public void handleMessageSegmentReconstructionTimeout(MsgSegmentReconstructionTimedTask task) {
        this.stopSegmentFlowCreationTimer();
        this.enqueueNotification(task.getNotif());
    }

    public void handleSegmentFlowCreationTimeout(SegmentFlowCreationTimedTask task) {
        this.enqueueNotification(task.getNotif());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUnackedMsgSegments() {
        Object object = this.msgSegmentFlowLock;
        synchronized (object) {
            if (this.unackedMsgSegments != null && this.unackedMsgSegments.size() > 0) {
                Iterator<String> it = this.unackedMsgSegments.keySet().iterator();
                while (it.hasNext()) {
                    String lgmMsgId = it.next();
                    XMLMessage msg = this.unackedMsgSegments.get(lgmMsgId);
                    msg.ackMessage();
                    FlowHandleImpl fh = this.msgSegmentFlows.get(lgmMsgId);
                    if (fh != null) {
                        fh.close();
                    }
                    it.remove();
                    this.msgSegmentFlows.remove(lgmMsgId);
                }
            }
        }
    }

    @Override
    public void injectNotification(Notification notif) {
        block6: {
            if (this.deliverAsyncOnReactor) {
                try {
                    notif.handleNotification();
                }
                catch (Throwable t) {
                    this.Trace.warn("Flow " + this.flowId + ": Exception occurred delivering notification in client notification handler", t);
                }
            } else {
                try {
                    this.getConsumerNotifDsp().enqueueBlockingNotification(notif);
                }
                catch (InterruptedException ex) {
                    if (!this.Trace.isErrorEnabled()) break block6;
                    this.Trace.error("Error injecting notification", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void injectCacheEvent(CacheEventMessage msg) {
        Object object = this.messageQueue.getLock();
        synchronized (object) {
            if (this.messageListener == null) {
                this.injectMessage(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLiveMessage(JCSMPXMLMessage msg) {
        if (!this.isBrowser() && msg.isReplyMessage()) {
            this.session.getSessionStats().incStat(StatType.REPLIES_RECVED);
            String corrId = msg.getCorrelationId();
            if (corrId != null) {
                LiveResponseListener listener = null;
                HashMap<String, LiveResponseListener> hashMap = this.liveResponseMap;
                synchronized (hashMap) {
                    listener = this.liveResponseMap.remove(corrId);
                }
                if (listener == null && !JCSMPGlobalProperties.shouldDropInternalReplyMessages()) {
                    this.injectMessage(msg);
                    return;
                }
                if (listener == null) {
                    if (corrId.startsWith("#CRQ") || corrId.startsWith("#REQ")) {
                        if (JCSMPUtils.isAdMessage(msg)) {
                            this.ackMessage(msg);
                        }
                        this.session.getSessionStats().incStat(StatType.REPLIES_DISCARDED);
                        if (this.Trace.isInfoEnabled()) {
                            this.Trace.info("Flow " + this.flowId + ": Received reply message to SDK-generated request with null message listener callback for correlation id \"" + corrId + "\", ignoring.");
                        }
                    } else {
                        this.injectMessage(msg);
                    }
                } else {
                    if (JCSMPUtils.isAdMessage(msg)) {
                        this.autoAckOrSetConsumer(msg);
                    }
                    listener.onLiveResponse(this, msg);
                }
                return;
            }
        }
        LiveTopicListener listener = null;
        HashMap<String, LiveTopicListener> hashMap = this.liveTopicMap;
        synchronized (hashMap) {
            Destination dest;
            if (!this.liveTopicMap.isEmpty() && (dest = msg.getDestination()) instanceof Topic) {
                listener = this.liveTopicMap.get(dest.getName());
            }
        }
        if (listener != null && listener.onLiveTopic(this, msg)) {
            return;
        }
        this.injectMessage(msg);
    }

    @Override
    public HashMap<String, LiveTopicListener> getLiveTopicMap() {
        return this.liveTopicMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLiveResponseListener(String correlationId) {
        if (correlationId != null) {
            HashMap<String, LiveResponseListener> hashMap = this.liveResponseMap;
            synchronized (hashMap) {
                this.liveResponseMap.remove(correlationId);
            }
        }
    }

    public static BytesXMLMessage createStructuredType(JCSMPXMLMessage msg) {
        if (msg.isStructuredMsg()) {
            if (msg.getStructuredMsgType() == 10) {
                return new MapMessageImpl((BytesXMLMessage)((Object)msg));
            }
            if (msg.getStructuredMsgType() == 11) {
                return new StreamMessageImpl((BytesXMLMessage)((Object)msg));
            }
            if (msg.getStructuredMsgType() == 7) {
                return new TextMessageImpl((BytesXMLMessage)((Object)msg));
            }
        } else if (msg.getStructuredMsgType() == 1) {
            return new XMLContentMessageImpl((BytesXMLMessage)((Object)msg));
        }
        return new BytesMessageImpl((BytesXMLMessage)((Object)msg));
    }

    @Override
    public Endpoint getEndpoint() {
        return this.boundToResource;
    }

    @Override
    public Subscription getSubscription() {
        return this.getCachedTopic();
    }

    @Override
    public Destination getDestination() {
        Endpoint e = this.getEndpoint();
        if (e instanceof Queue) {
            return (Queue)e;
        }
        if (e instanceof TopicEndpoint) {
            return this.getCachedTopic();
        }
        return null;
    }

    public void setSubscription(Topic s) {
        this.cachedTopic = s;
    }

    public AssuredCtrlEnums.FlowType getFlowType() {
        return this.flowType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        this.stopMsgSegmentTimer();
        if (this.msgConstructionQueue != null) {
            Object object = this.msgConstructionQueueLock;
            synchronized (object) {
                Iterator it = this.msgConstructionQueue.iterator();
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (obj instanceof ConsumerLargeMessageNotification) {
                        ((ConsumerLargeMessageNotification)obj).cancel();
                    }
                    it.remove();
                }
                this.currMsgUnderConstruction = null;
            }
        }
        this.closeSegmentFlows(false, true);
        this.transportInit();
        this.messageQueue.clear();
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug(String.format("Rolled back flowId %s, numUnackedTpMsg %s, lastInOrderTpMsg %s", this.flowId, this.numUnackedTpMsg, this.lastInOrderTpMsg));
        }
    }

    public BaseTransactedSessionImpl getTransactedSession() {
        return this.transactedSession;
    }

    public boolean isTransacted() {
        return this.getTransactedSession() != null;
    }

    public void setAckLastSerialNumber(long ackLastSerialNumber) {
        this.ackLastSerialNumber = ackLastSerialNumber;
    }

    public long getAckLastSerialNumber() {
        return this.ackLastSerialNumber;
    }

    public FlowEventHandler getFlowEventHandler() {
        return this.flowEventHandler;
    }

    public void notifyFlowEventHandler(FlowEventArgs eventArgs) {
        if (this.flowEventHandler != null) {
            this.getConsumerNotifDsp().enqueueNonBlockingNotification(new ConsumerFlowNotification(this.flowEventHandler, eventArgs, this));
        }
    }

    private void invokeInterceptorForConstructedLargeMessageIfNeeded(JCSMPXMLMessage m) {
        if (this.session.getMessageConsumerInterceptorInstance() != null) {
            BytesXMLMessage clonedMsg = JCSMPFactory.onlyInstance().createMessage(FlowHandleImpl.createStructuredType(m));
            try {
                this.session.getMessageConsumerInterceptorInstance().onPreReceive(new JCSMPReceiverInterceptingContextImpl(clonedMsg));
            }
            catch (JCSMPException e) {
                if (this.Trace.isWarnEnabled()) {
                    this.Trace.warn("got an exception, message discarded: " + clonedMsg.toString(), e);
                }
                return;
            }
            m = clonedMsg instanceof BytesXMLMessageWrapper ? (JCSMPXMLMessage)((Object)((BytesXMLMessageWrapper)((Object)clonedMsg)).getWrappedMessage()) : (JCSMPXMLMessage)((Object)clonedMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerDequeueFromConstructionQueue(ConsumerLargeMessageNotification timeoutNotification) {
        ConsumerLargeMessageNotification newNotif;
        block39: {
            ConsumerLargeMessageNotification notif;
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("Flow " + this.flowId + ": dequeue from construction queue");
            }
            ConsumerLargeMessageNotification timeoutNotif = timeoutNotification;
            newNotif = null;
            boolean isCurrent = false;
            while (true) {
                Object obj = null;
                Object object = this.msgConstructionQueueLock;
                synchronized (object) {
                    if (this.msgConstructionQueue.size() == 0) {
                        if (this.Trace.isDebugEnabled()) {
                            this.Trace.debug("Flow " + this.flowId + ": Message construction queue is empty");
                        }
                        this.currMsgUnderConstruction = null;
                        if (timeoutNotif != null && this.Trace.isInfoEnabled()) {
                            this.Trace.info("Flow " + this.flowId + ": Construction queue is empty. Ignore stale large message timeout notification for lgmMsgId=" + timeoutNotif.getLgmMsgId());
                        }
                        break block39;
                    }
                    obj = this.msgConstructionQueue.getFirst();
                    if (obj instanceof JCSMPXMLMessage) {
                        obj = this.msgConstructionQueue.removeFirst();
                    } else {
                        ConsumerLargeMessageNotification notif2 = (ConsumerLargeMessageNotification)obj;
                        if (notif2 == this.currMsgUnderConstruction) {
                            isCurrent = true;
                            obj = this.msgConstructionQueue.removeFirst();
                            this.currMsgUnderConstruction = null;
                        } else {
                            if (this.Trace.isDebugEnabled()) {
                                this.Trace.debug(String.format("Flow %s: Not current msg under construction, notification lgmMsgId=%s, currMsgUnderConstruciton lgmMsgId=%s", this.flowId, notif2.getLgmMsgId(), this.currMsgUnderConstruction == null ? "" : this.currMsgUnderConstruction.getLgmMsgId()));
                            }
                            isCurrent = false;
                        }
                    }
                }
                if (obj instanceof JCSMPXMLMessage) {
                    JCSMPXMLMessage m = (JCSMPXMLMessage)obj;
                    if (this.Trace.isDebugEnabled()) {
                        this.Trace.debug("Flow " + this.flowId + ": enqueue regular message from construction queue to delivery queue");
                    }
                    this.invokeInterceptorForConstructedLargeMessageIfNeeded(m);
                    boolean enqueueNotification = this.enqueueMessageQueue(m);
                    if (!enqueueNotification) continue;
                    this.enqueueNotification();
                    continue;
                }
                notif = (ConsumerLargeMessageNotification)obj;
                if (!isCurrent) break;
                boolean timeoutStale = false;
                if (timeoutNotif != null && timeoutNotif != notif) {
                    if (this.Trace.isInfoEnabled()) {
                        this.Trace.info("Flow " + this.flowId + ": In trigger dequeue. Ignore stale timeout large message notification for lgMsgId=" + timeoutNotif.getLgmMsgId());
                    }
                    timeoutStale = true;
                }
                notif.clearSegmentsBuffer();
                boolean incompleteMsg = notif.getSegmentRecvd() != notif.getNumSegments().intValue();
                String exMsg = "";
                String msgDump = "";
                if (incompleteMsg) {
                    msgDump = notif.getSignalMessage().dump();
                    exMsg = String.format("Flow %s : incomplete message received: msgId=%s, lgmMsgId=%s, expected %s segments, received %s segments", this.flowId, notif.getSignalMessage().getMessageId(), notif.getLgmMsgId(), notif.getNumSegments(), notif.getSegmentRecvd());
                    if (this.Trace.isErrorEnabled()) {
                        this.Trace.error(exMsg + "\n" + msgDump);
                    }
                    if (!this.isTransacted()) {
                        Object object2 = this.msgSegmentFlowLock;
                        synchronized (object2) {
                            FlowHandleImpl msgSegmentFlow = this.msgSegmentFlows.get(notif.getLgmMsgId());
                            if (msgSegmentFlow != null) {
                                if (this.Trace.isDebugEnabled()) {
                                    this.Trace.debug("Flow " + this.flowId + ": Incomplete message received: close segment flow for lgmMsgId=" + notif.getLgmMsgId());
                                }
                                msgSegmentFlow.close();
                                this.msgSegmentFlows.remove(notif.getLgmMsgId());
                            }
                            this.msgSegmentTimer = null;
                            this.msgSegmentTimeoutTask = null;
                        }
                    }
                    JCSMPIncompleteLargeMessageReceivedException iex = new JCSMPIncompleteLargeMessageReceivedException(exMsg, msgDump, notif.getSignalMessage().getDestination().getName(), "JMS_Solace_lgm_guid='" + notif.getLgmMsgId() + "'", notif.getLastSegmentMsgRecvd() == null ? "#LGM/" + notif.getSignalMessage().getDestination().getName() : notif.getLastSegmentMsgRecvd().getDestination().getName(), "JMS_Solace_lgm_guid='" + notif.getLgmMsgId() + "'");
                    if (this.messageListener == null) {
                        try {
                            this.messageQueue.enqueue(iex);
                        }
                        catch (Exception exception) {}
                    } else {
                        this.session.handleSessionEvent(new SessionEventArgsImpl(SessionEvent.INCOMPLETE_LARGE_MESSAGE_RECVD, exMsg, iex, 0));
                    }
                    if (timeoutStale) continue;
                    timeoutNotif = null;
                    continue;
                }
                Object iex = this.msgSegmentFlowLock;
                synchronized (iex) {
                    this.msgSegmentTimer = null;
                    this.msgSegmentTimeoutTask = null;
                }
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug(String.format("Flow " + this.flowId + ": enqueue large message from construction queue to delivery queue msgId=%s, lgmMsgId=%s", notif.getSignalMessage().getMessageId(), notif.getLgmMsgId()));
                }
                ((JCSMPXMLMessage)notif.getSignalMessage()).setLargeMsgInfo(notif);
                ((JCSMPXMLMessage)notif.getSignalMessage()).setReadOnly();
                this.invokeInterceptorForConstructedLargeMessageIfNeeded((JCSMPXMLMessage)notif.getSignalMessage());
                boolean enqueueNotification = this.enqueueMessageQueue(notif.getSignalMessage());
                if (!enqueueNotification) continue;
                this.enqueueNotification();
            }
            newNotif = notif;
        }
        if (newNotif == null) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("Flow " + this.flowId + ": restart the flow, but not segment flows");
            }
            try {
                this.startImpl(false, true);
            }
            catch (JCSMPException e) {
                if (this.Trace.isWarnEnabled()) {
                    this.Trace.warn("Flow " + this.flowId + ": Error occurred while restarting flow: " + e);
                }
                this.handleException(e);
            }
        } else {
            this.handleLargeMsgNotification(newNotif);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReceive(BytesXMLMessage message) {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("stop segment timer");
        }
        this.stopMsgSegmentTimer();
        JCSMPXMLMessage segMsg = (JCSMPXMLMessage)((Object)((MessageImpl)message).getWrappedMessage());
        try {
            SDTMap userProps = segMsg.getProperties();
            String lgmMsgId = userProps.getString("JMS_Solace_lgm_guid");
            Integer segId = userProps.getInteger("JMS_Solace_lgm_segId");
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug(String.format("Flow " + this.flowId + ":Received message on segment flow: flowId=%s, msgId=%s, dest=%s lgmMsgId=%s lgmSegId=%s", segMsg.getFlowId(), message.getMessageId(), message.getDestination(), lgmMsgId, segId));
            }
            FlowHandleImpl msgSegmentFlow = null;
            Object object = this.msgSegmentFlowLock;
            synchronized (object) {
                msgSegmentFlow = this.msgSegmentFlows.get(lgmMsgId);
            }
            segMsg.setMessageConsumer(msgSegmentFlow);
            boolean triggerDequeue = false;
            Object object2 = this.msgConstructionQueueLock;
            synchronized (object2) {
                if (this.currMsgUnderConstruction == null || !this.currMsgUnderConstruction.getLgmMsgId().equals(lgmMsgId)) {
                    if (this.Trace.isInfoEnabled()) {
                        this.Trace.info(String.format("Flow " + this.flowId + ": Cannot find signal message whose lgmMsgId matches segment's flowId=%s, lgmMsgId=%s, discard message msgId=%s", segMsg.getFlowId(), lgmMsgId, message.getMessageId()));
                    }
                    return;
                }
                boolean outOfOrder = false;
                if (this.currMsgUnderConstruction.getLastSegId() + 1 != segId) {
                    if (this.Trace.isInfoEnabled()) {
                        this.Trace.info(String.format("Flow " + this.flowId + ": Out of order segment received from flowId=%s, lgmMsgId=%s, discard message msgId=%s", segMsg.getFlowId(), lgmMsgId, message.getMessageId()));
                    }
                    outOfOrder = true;
                } else {
                    if (segMsg.getContentLength() > 0) {
                        this.currMsgUnderConstruction.appendSegment(segMsg.getContent(), true);
                    }
                    if (segMsg.getAttachmentContentLength() > 0) {
                        this.currMsgUnderConstruction.appendSegment(segMsg.getAttachmentContent(), false);
                    }
                    this.currMsgUnderConstruction.setLastSegId(segId);
                }
                segMsg.clearReadOnly();
                segMsg.clearContent();
                segMsg.clearAttachment();
                this.currMsgUnderConstruction.setLastSegmentMsgRecvd(segMsg);
                int segRecv = this.currMsgUnderConstruction.getSegmentRecvd();
                if (!outOfOrder) {
                    segRecv = this.currMsgUnderConstruction.incSegementRecvd();
                }
                if (segRecv == this.currMsgUnderConstruction.getNumSegments()) {
                    BytesXMLMessage signalMsg = (BytesXMLMessage)this.currMsgUnderConstruction.getSignalMessage();
                    byte[] segmentsBuffer = this.currMsgUnderConstruction.getSegmentsBuffer();
                    if (this.currMsgUnderConstruction.getXmlContentLen() > 0) {
                        signalMsg.writeBytes(segmentsBuffer, 0, this.currMsgUnderConstruction.getXmlContentLen());
                        if (this.currMsgUnderConstruction.getTotalSize() - this.currMsgUnderConstruction.getXmlContentLen() > 0) {
                            signalMsg.writeAttachment(segmentsBuffer, this.currMsgUnderConstruction.getXmlContentLen(), this.currMsgUnderConstruction.getTotalSize() - this.currMsgUnderConstruction.getXmlContentLen());
                        }
                    } else {
                        signalMsg.writeAttachment(segmentsBuffer);
                    }
                    triggerDequeue = true;
                }
            }
            if (triggerDequeue) {
                this.triggerDequeueFromConstructionQueue(null);
            } else {
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug("Flow " + this.flowId + ": restart segment timer");
                }
                this.startMsgSegmentTimer(true);
            }
        }
        catch (JCSMPException e) {
            if (this.Trace.isErrorEnabled()) {
                this.Trace.error("Flow " + this.flowId + ":Error occurred while receiving message segment: msg=" + ((JCSMPXMLMessage)((Object)message)).getMessageIdLong(), e);
            }
            this.handleException(e);
            return;
        }
    }

    @Override
    public void onException(JCSMPException exception) {
        if (this.Trace.isInfoEnabled()) {
            this.Trace.info("Flow " + this.flowId + ":Received exception on segment flow: " + exception);
        }
        this.handleException(exception);
    }

    public boolean isMsgSegmentFlow() {
        return this.msgSegmentFlow;
    }

    public Long getEndpointErrorId() {
        return this.endpointErrorId;
    }

    public void setEndpointErrorId(Long id) {
        this.endpointErrorId = id;
    }

    public boolean isRequiredSettlementCapable() {
        return this.session.isRequiredSettlementCapable(this.flowProps.getRequiredSettlementOutcomes());
    }

    public boolean isRequiredSettlementSupported(XMLMessage.Outcome o) {
        return this.flowProps.getRequiredSettlementOutcomes().contains((Object)o);
    }

    static final class FlowDebugStats {
        volatile long lastTpAckMsg = 0L;
        volatile long lastTpAckReportedWinSz = 0L;

        FlowDebugStats() {
        }
    }

    private static interface AckRunner {
        public void tpSendAck(WireMessage var1, boolean var2, boolean var3);
    }

    class AckRetryTimeoutHandler
    implements JCSMPTimeoutHandler {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleTimeout() {
            FlowHandleImpl flow = FlowHandleImpl.this;
            try {
                WireMessage ackMsg = null;
                int write_code = 0;
                int winSz = flow.getWindowSize();
                if (FlowHandleImpl.this.Trace.isDebugEnabled()) {
                    FlowHandleImpl.this.Trace.debug("Flow " + FlowHandleImpl.this.flowId + ": ACK timeout; getWindowSize = " + winSz);
                }
                flow.setLastReportedWinSz(winSz);
                Object object = FlowHandleImpl.this.getAckCreateSendLock();
                synchronized (object) {
                    ackMsg = FlowSmfUtil.tpCreateAck(flow.getFlowId(), flow.getLastInOrderTpMsg(), winSz);
                }
                boolean locked = true;
                try {
                    if (FlowHandleImpl.this.isReactorThread()) {
                        locked = FlowHandleImpl.this.getAckSendingLock().tryLock();
                        if (!locked) {
                            FlowHandleImpl.this.getTcpChannel().enqueuePriorityData(ackMsg);
                            return;
                        }
                    } else {
                        FlowHandleImpl.this.getAckSendingLock().lock();
                    }
                    if ((write_code = FlowHandleImpl.this.tcpChannel.sendAckMessage(ackMsg, true, false)) == 1) {
                        FlowHandleImpl.this.Trace.debug("Scheduling AckRetryTimeoutHandler again (couldn't run).");
                        FlowHandleImpl.this.ackRetryTimer_last = flow.timerQueue.schedule_relative(10L, this);
                    }
                }
                finally {
                    if (locked) {
                        FlowHandleImpl.this.getAckSendingLock().unlock();
                    }
                }
            }
            catch (JCSMPException e) {
                FlowHandleImpl.this.handleException(e);
                FlowHandleImpl.this.Trace.debug("Flow " + FlowHandleImpl.this.flowId + ": Scheduling AckRetryTimeoutHandler again (couldn't run).");
                FlowHandleImpl.this.ackRetryTimer_last = flow.timerQueue.schedule_relative(10L, this);
            }
        }
    }

    public static enum ResourceBoundState {
        BOUND,
        UNBOUND;

    }

    public static enum StartState {
        STARTED,
        STARTING,
        STOPPED,
        STOPPING;

    }

    private static enum ConsumeMode {
        NOT_SET,
        ASYNC,
        SYNC;

    }
}

