/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util.i18n;

import com.solacesystems.common.ChainedException;
import com.solacesystems.common.util.i18n.GenericResourceBundleSupport;
import java.net.URL;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.MissingResourceException;

public class StringResourceBundleSupport
extends GenericResourceBundleSupport {
    public static final boolean NO_TRIM_PACKAGE_NAME = false;
    public static final boolean TRIM_PACKAGE_NAME = true;

    public StringResourceBundleSupport(String baseName, ClassLoader classloader) throws MissingResourceException {
        super(baseName, classloader);
    }

    public char getChar(String key) throws ChainedException {
        try {
            Character ch = (Character)this.getObject(key);
            return ch.charValue();
        }
        catch (MissingResourceException mrex) {
            throw new ChainedException(mrex);
        }
        catch (ClassCastException ccex) {
            throw new ChainedException(ccex);
        }
    }

    public Character getCharacter(String key) throws ChainedException {
        try {
            return (Character)this.getObject(key);
        }
        catch (MissingResourceException mrex) {
            throw new ChainedException(mrex);
        }
        catch (ClassCastException ccex) {
            throw new ChainedException(ccex);
        }
    }

    public MessageFormat getFormat(String key) {
        return new MessageFormat(this.getString(key));
    }

    public String getFormattedMessage(String key, Object[] args) {
        MessageFormat fmt = this.getFormat(key);
        StringBuffer result = new StringBuffer();
        fmt.format(args, result, (FieldPosition)null);
        return result.toString();
    }

    public String getString(String key) {
        return (String)this.m_bundle.getObject(key);
    }

    public String getStringSafely(String key) {
        return this.getStringSafely(key, false);
    }

    public String getStringSafely(String key, boolean trimPackageName) {
        String value = "";
        try {
            value = (String)this.m_bundle.getObject(key);
        }
        catch (MissingResourceException e) {
            int index;
            value = !trimPackageName ? key : ((index = key.lastIndexOf(46)) != -1 ? key.substring(index + 1) : key);
        }
        return value;
    }

    public URL getURL(String key) throws ChainedException {
        String fileName = this.getStringSafely(key);
        URL url = this.m_classLoader.getResource(fileName);
        if (url == null) {
            this.handleMissingFileAndRethrow(key, fileName);
        }
        return url;
    }

    public URL getURLByValue(String value) throws ChainedException {
        URL url = this.m_classLoader.getResource(value);
        if (url == null) {
            this.handleMissingFileAndRethrow("-not keyed-", value);
        }
        return url;
    }
}

