/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.property;

import com.solacesystems.common.property.PropertyConversionException;
import com.solacesystems.common.property.PropertyConverter;
import com.solacesystems.common.property.PropertySourceChangeEvent;
import com.solacesystems.common.property.PropertySourceChangeListener;
import com.solacesystems.common.property.PropertyVetoException;
import com.solacesystems.common.property.VetoablePropertySourceChangeListener;
import java.util.ArrayList;
import java.util.HashMap;

public class PropertySource<T>
implements Cloneable {
    public static final int PRIORITY_1 = 1;
    public static final int PRIORITY_2 = 2;
    public static final int PRIORITY_3 = 3;
    public static final int PRIORITY_4 = 4;
    public static final int PRIORITY_5 = 5;
    public static final int PRIORITY_6 = 6;
    public static final int PRIORITY_7 = 7;
    public static final int HIGHEST_PRIORITY = 1;
    public static final int LOWEST_PRIORITY = Integer.MAX_VALUE;
    public static final int DEFAULT_PRIORITY = 1;
    public static final boolean NULL_VALID = true;
    public static final boolean NULL_INVALID = false;
    public static boolean DEFAULT_NULL_VALID = false;
    protected String mName;
    protected int mPriority;
    protected T mValue;
    protected boolean mIsSet;
    protected boolean mNullValid;
    protected ArrayList<PropertySourceChangeListener<T>> mListeners;
    protected ArrayList<VetoablePropertySourceChangeListener<T>> mVetoableListeners;
    protected PropertyConverter mConverter;
    protected HashMap<String, Object> mUserData;
    protected boolean mTrimStrings;
    protected boolean mPrintable;

    public PropertySource(PropertySource<T> source) {
        this.mName = source.mName;
        this.mPriority = source.mPriority;
        this.mValue = source.mValue;
        this.mIsSet = source.mIsSet;
        this.mNullValid = source.mNullValid;
        this.mListeners = null;
        this.mVetoableListeners = null;
        this.mConverter = source.mConverter;
        this.mUserData = source.mUserData;
        this.mTrimStrings = source.mTrimStrings;
        this.mPrintable = source.mPrintable;
    }

    public PropertySource(String name) {
        this(name, 1, DEFAULT_NULL_VALID, null);
    }

    public PropertySource(String name, int priority) {
        this(name, priority, DEFAULT_NULL_VALID, null);
    }

    public PropertySource(String name, boolean nullValid) {
        this(name, 1, nullValid, null);
    }

    public PropertySource(String name, PropertyConverter converter) {
        this(name, 1, DEFAULT_NULL_VALID, converter);
    }

    public PropertySource(String name, int priority, boolean nullValid) {
        this(name, priority, nullValid, null);
    }

    public PropertySource(String name, int priority, PropertyConverter converter) {
        this(name, priority, DEFAULT_NULL_VALID, converter);
    }

    public PropertySource(String name, int priority, boolean nullValid, PropertyConverter converter) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (priority < 1) {
            throw new IllegalArgumentException("Priority value out of range - " + priority + ", must be in the range [" + 1 + "," + Integer.MAX_VALUE + "]");
        }
        this.mName = name;
        this.mPriority = priority;
        this.mValue = null;
        this.mIsSet = false;
        this.mNullValid = nullValid;
        this.mListeners = null;
        this.mVetoableListeners = null;
        this.mConverter = converter;
        this.mUserData = null;
        this.mTrimStrings = false;
        this.mPrintable = true;
    }

    public String getName() {
        return this.mName;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public T getValue() {
        return this.mValue;
    }

    public boolean isSet() {
        return this.mIsSet;
    }

    public boolean isNullValid() {
        return this.mNullValid;
    }

    public void setTrimStrings(boolean trimStrings) {
        this.mTrimStrings = trimStrings;
    }

    public boolean getTrimStrings() {
        return this.mTrimStrings;
    }

    public void setPrintable(boolean printable) {
        this.mPrintable = printable;
    }

    public boolean getPrintable() {
        return this.mPrintable;
    }

    public PropertyConverter getConverter() {
        return this.mConverter;
    }

    public void addListener(PropertySourceChangeListener<T> listener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        this.mListeners.add(listener);
    }

    public void removeListener(PropertySourceChangeListener<T> listener) {
        if (this.mListeners != null) {
            this.mListeners.remove(listener);
        }
    }

    public void addVetoableListener(VetoablePropertySourceChangeListener<T> listener) {
        if (this.mVetoableListeners == null) {
            this.mVetoableListeners = new ArrayList();
        }
        this.mVetoableListeners.add(listener);
    }

    public void removeVetoableListener(VetoablePropertySourceChangeListener<T> listener) {
        if (this.mVetoableListeners != null) {
            this.mVetoableListeners.remove(listener);
        }
    }

    public HashMap<String, Object> getUserDataMap() {
        if (this.mUserData == null) {
            this.mUserData = new HashMap();
        }
        return this.mUserData;
    }

    public void setUserDataMap(HashMap<String, Object> map) {
        this.mUserData = map;
    }

    public void initialize() throws PropertyVetoException, PropertyConversionException {
    }

    public void setValue(T value) throws PropertyVetoException {
        boolean isSet = value != null || this.mNullValid;
        PropertySourceChangeEvent<T> event = new PropertySourceChangeEvent<T>(this, this.mIsSet, isSet, this.mValue, value, this.mPriority, this.mPriority);
        this.notifyVetoableListeners(event);
        this.mIsSet = isSet;
        this.mValue = value instanceof String && this.mTrimStrings ? ((String)value).trim() : value;
        this.notifyListeners(event);
    }

    public void setPriority(int priority) throws PropertyVetoException {
        this.mPriority = priority;
        PropertySourceChangeEvent<T> event = new PropertySourceChangeEvent<T>(this, this.mIsSet, this.mIsSet, this.mValue, this.mValue, this.mPriority, priority);
        this.notifyVetoableListeners(event);
        this.notifyListeners(event);
    }

    public void setObjectValue(Object value) throws PropertyConversionException, PropertyVetoException {
        try {
            if (value == null) {
                this.setValue(null);
            } else if (this.mConverter == null) {
                this.setValue(value);
            } else if (value instanceof String && this.mTrimStrings) {
                this.setValue(this.mConverter.convert(((String)value).trim()));
            } else {
                this.setValue(this.mConverter.convert(value));
            }
        }
        catch (PropertyConversionException e) {
            e.addUserData("Source", this.mName);
            throw e;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return new PropertySource<T>(this);
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("name=\"");
        bldr.append(this.mName);
        bldr.append("\", value=");
        if (this.mPrintable) {
            if (this.mValue instanceof String) {
                bldr.append("\"");
                bldr.append(this.mValue);
                bldr.append("\"");
            } else {
                bldr.append(this.mValue);
            }
        } else if (this.mIsSet) {
            bldr.append("******");
        }
        bldr.append(", isSet=");
        bldr.append(this.mIsSet);
        bldr.append(", priority=");
        bldr.append(this.mPriority);
        if (this.mPriority == 1) {
            bldr.append("(HIGHEST)");
        } else if (this.mPriority == Integer.MAX_VALUE) {
            bldr.append("(LOWEST)");
        }
        bldr.append(", nullValid=");
        bldr.append(this.mNullValid);
        bldr.append(", trimStrings=");
        bldr.append(this.mTrimStrings);
        return bldr.toString();
    }

    protected void notifyVetoableListeners(PropertySourceChangeEvent<T> event) throws PropertyVetoException {
        if (this.mVetoableListeners == null || this.mVetoableListeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.mVetoableListeners.size(); ++i) {
            this.mVetoableListeners.get(i).vetoablePropertySourceChanged(event);
        }
    }

    protected void notifyListeners(PropertySourceChangeEvent<T> event) {
        if (this.mListeners == null || this.mListeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.mListeners.size(); ++i) {
            this.mListeners.get(i).propertySourceChanged(event);
        }
    }
}

