/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.jndi;

import com.solacesystems.common.jndi.JNDIObject;
import com.solacesystems.common.jndi.PropertyList;
import com.solacesystems.common.jndi.PropertyNotFoundException;

public class JNDIUtil {
    private static final String ERROR_JNDI_NAME_IS_NULL = "JNDI name cannot be null";
    private static final String ERROR_JNDI_NAME_TOO_SHORT = "JNDI name must have a minimum length of ";
    private static final String ERROR_JNDI_NAME_TOO_LONG = "JNDI name must have a maximum length of ";
    private static final String ERROR_JNDI_NAME_HAS_ILLEGAL_CHAR = "JNDI name contains illegal character [";
    private static final String ERROR_JNDI_NAME_HAS_ILLEGAL_WHITESPACE = "JNDI name contains illegal whitespace [";
    public static final int MIN_JNDI_NAME_LENGTH = 1;
    public static final int MAX_JNDI_NAME_LENGTH = 256;

    public static void isValidJNDIName(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException(ERROR_JNDI_NAME_IS_NULL);
        }
        int length = name.length();
        if (length < 1) {
            throw new IllegalArgumentException("JNDI name must have a minimum length of 1");
        }
        if (length > 256) {
            throw new IllegalArgumentException("JNDI name must have a maximum length of 256");
        }
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (c == '*') {
                throw new IllegalArgumentException(ERROR_JNDI_NAME_HAS_ILLEGAL_CHAR + c + "]");
            }
            if (!Character.isWhitespace(c)) continue;
            throw new IllegalArgumentException(ERROR_JNDI_NAME_HAS_ILLEGAL_WHITESPACE + c + "]");
        }
    }

    public static String getProperty(JNDIObject obj, String property) throws PropertyNotFoundException {
        return JNDIUtil.getProperty(obj, "___DEFAULT___", property);
    }

    public static String getProperty(JNDIObject obj, String propertyList, String property) throws PropertyNotFoundException {
        String prop = null;
        PropertyList list = obj.getPropertyList(propertyList);
        if (list == null) {
            throw new PropertyNotFoundException("Property List not found");
        }
        prop = list.getProperty(property);
        if (prop == null) {
            throw new PropertyNotFoundException("Property not found");
        }
        return prop;
    }
}

