/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ObjectPropertySet {
    private HashMap<String, Object> _properties = new HashMap();

    public Object getProperty(String name) {
        return this._properties.get(name);
    }

    public Object setProperty(String name, Object value) {
        return this._properties.put(name, value);
    }

    public void setProperties(Map<String, Object> properties) {
        this._properties.putAll(properties);
    }

    public Integer getIntegerProperty(String name) {
        Integer result = null;
        try {
            result = (Integer)this.getProperty(name);
        }
        catch (Exception e) {
            return null;
        }
        return result;
    }

    public Long getLongProperty(String name) {
        Long result = null;
        try {
            result = (Long)this.getProperty(name);
        }
        catch (Exception e) {
            return null;
        }
        return result;
    }

    public Double getDoubleProperty(String name) {
        Double result = null;
        try {
            result = (Double)this.getProperty(name);
        }
        catch (Exception e) {
            return null;
        }
        return result;
    }

    public Boolean getBooleanProperty(String name) {
        Boolean result = null;
        try {
            result = (Boolean)this.getProperty(name);
        }
        catch (Exception e) {
            return null;
        }
        return result;
    }

    public String getStringProperty(String name) {
        String result = null;
        try {
            result = (String)this.getProperty(name);
        }
        catch (Exception e) {
            return null;
        }
        return result;
    }

    public Object setIntegerProperty(String name, int value) {
        return this.setProperty(name, new Integer(value));
    }

    public Object setLongProperty(String name, long value) {
        return this.setProperty(name, new Long(value));
    }

    public Object setDoubleProperty(String name, double value) {
        return this.setProperty(name, new Double(value));
    }

    public Object setBooleanProperty(String name, boolean value) {
        return this.setProperty(name, new Boolean(value));
    }

    public Set<String> propertyNames() {
        return this._properties.keySet();
    }

    public String toString() {
        ArrayList<String> sortedNames = new ArrayList<String>(this.propertyNames());
        Collections.sort(sortedNames);
        int longest = 0;
        for (String str : sortedNames) {
            longest = str.length() > longest ? str.length() : longest;
        }
        String fmt = " %-" + String.valueOf(longest) + "s    %s\n";
        StringBuilder sb = new StringBuilder();
        for (String str : sortedNames) {
            sb.append(String.format(fmt, str, this.getProperty(str)));
        }
        return sb.toString();
    }
}

