/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.semp;

import com.solacesystems.common.semp.SEMPException;
import com.solacesystems.common.semp.SEMPNoSuchObjectException;
import com.solacesystems.common.semp.SEMPParseException;
import com.solacesystems.common.xml.parsers.SolSAXParser;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SEMPSAXParser
extends SolSAXParser {
    protected static final String RpcKeyword = "rpc";
    protected static final String ParseErrorKeyword = "parse-error";
    protected static final String ExecuteResultKeyword = "execute-result";
    protected static final String ExecuteResultCodeKeyword = "code";
    protected static final String ExecuteResultReasonKeyword = "reason";
    protected static final String ExecuteResultReasonCodeKeyword = "reasonCode";
    protected StringBuilder mCurrentElementText = new StringBuilder();
    protected boolean mIsInRpc;
    protected boolean mIsInParseError;
    protected String mParseError;
    protected String mCode;
    protected String mReason;
    protected Integer mReasonCode;
    protected String mComment;

    @Override
    public void startElement(String s, String s1, String s2, Attributes attributes1) throws SAXException {
        if (!this.mIsInRpc && s2.equalsIgnoreCase(ParseErrorKeyword)) {
            this.mIsInParseError = true;
        } else if (s2.equalsIgnoreCase(RpcKeyword)) {
            this.mIsInRpc = true;
        } else if (s2.equalsIgnoreCase(ExecuteResultKeyword)) {
            String reasonCodeStr;
            int index = attributes1.getIndex(ExecuteResultCodeKeyword);
            if (index != -1) {
                this.mCode = attributes1.getValue(index);
            }
            if ((index = attributes1.getIndex(ExecuteResultReasonKeyword)) != -1) {
                this.mReason = attributes1.getValue(index);
            }
            if ((index = attributes1.getIndex(ExecuteResultReasonCodeKeyword)) != -1 && (reasonCodeStr = attributes1.getValue(index)) != null) {
                try {
                    this.mReasonCode = Integer.valueOf(reasonCodeStr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.mCurrentElementText.delete(0, this.mCurrentElementText.length());
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.mIsInRpc && qName.equalsIgnoreCase(ParseErrorKeyword)) {
            this.mIsInParseError = false;
            this.mParseError = this.mCurrentElementText.toString();
        } else if (qName.equalsIgnoreCase(RpcKeyword)) {
            this.mIsInRpc = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.mIsInParseError) {
            this.mCurrentElementText.append(ch, start, length);
        }
    }

    public String getParseError() {
        return this.mParseError;
    }

    public String getCode() {
        return this.mCode;
    }

    public String getReason() {
        return this.mReason;
    }

    public Integer getReasonCode() {
        return this.mReasonCode;
    }

    public String getComment(String str) {
        int index = str.indexOf("<!--");
        if (index != -1) {
            return str.substring(index + 5, str.indexOf("-->", index + 5));
        }
        return null;
    }

    public boolean isSuccessful() {
        if (this.mCode == null) {
            return false;
        }
        return this.mCode.equalsIgnoreCase("ok");
    }

    protected void initializeParser(String str) {
        this.mIsInParseError = false;
        this.mParseError = null;
        this.mCode = null;
        this.mReason = null;
        this.mReasonCode = null;
        this.mComment = this.getComment(str);
    }

    protected void processResponse() throws SEMPException {
        if (this.mParseError != null) {
            throw new SEMPParseException(this.mParseError.trim());
        }
        if (this.isSuccessful()) {
            return;
        }
        if (this.mReasonCode != null && (this.mReasonCode == 6 || this.mReasonCode == 21 || this.mReasonCode == 191)) {
            if (this.mComment != null) {
                throw new SEMPNoSuchObjectException(this.mComment);
            }
            throw new SEMPNoSuchObjectException();
        }
        StringBuilder bldr = new StringBuilder("SEMP request failed - ");
        if (this.mReason != null) {
            bldr.append(this.mReason);
        }
        if (this.mReasonCode != null) {
            bldr.append(" (");
            bldr.append(this.mReasonCode);
            bldr.append(")");
        }
        if (this.mComment != null) {
            bldr.append(" - ");
            bldr.append(this.mComment);
        }
        throw new SEMPException(bldr.toString());
    }
}

