/*
 * Decompiled with CFR 0.152.
 */
package com.solace.spring.cloud.stream.binder.config;

import com.solace.spring.cloud.stream.binder.SolaceMessageChannelBinder;
import com.solace.spring.cloud.stream.binder.config.SolaceBinderClientInfoProvider;
import com.solace.spring.cloud.stream.binder.config.SolaceHealthIndicatorsConfiguration;
import com.solace.spring.cloud.stream.binder.health.SolaceBinderHealthAccessor;
import com.solace.spring.cloud.stream.binder.health.handlers.SolaceSessionEventHandler;
import com.solace.spring.cloud.stream.binder.meter.SolaceMeterAccessor;
import com.solace.spring.cloud.stream.binder.properties.SolaceExtendedBindingProperties;
import com.solace.spring.cloud.stream.binder.provisioning.SolaceQueueProvisioner;
import com.solacesystems.jcsmp.Context;
import com.solacesystems.jcsmp.ContextProperties;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPFactory;
import com.solacesystems.jcsmp.JCSMPProperties;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.SessionEventHandler;
import jakarta.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.lang.Nullable;

@Configuration
@Import(value={SolaceHealthIndicatorsConfiguration.class})
@EnableConfigurationProperties(value={SolaceExtendedBindingProperties.class})
public class SolaceMessageChannelBinderConfiguration {
    private final JCSMPProperties jcsmpProperties;
    private final SolaceExtendedBindingProperties solaceExtendedBindingProperties;
    private final SolaceSessionEventHandler solaceSessionEventHandler;
    private JCSMPSession jcsmpSession;
    private Context context;
    private static final Log logger = LogFactory.getLog(SolaceMessageChannelBinderConfiguration.class);

    public SolaceMessageChannelBinderConfiguration(JCSMPProperties jcsmpProperties, SolaceExtendedBindingProperties solaceExtendedBindingProperties, @Nullable SolaceSessionEventHandler eventHandler) {
        this.jcsmpProperties = jcsmpProperties;
        this.solaceExtendedBindingProperties = solaceExtendedBindingProperties;
        this.solaceSessionEventHandler = eventHandler;
    }

    @PostConstruct
    private void initSession() throws JCSMPException {
        JCSMPProperties jcsmpProperties = (JCSMPProperties)this.jcsmpProperties.clone();
        jcsmpProperties.setProperty("client_info_provider", (Object)new SolaceBinderClientInfoProvider());
        try {
            if (this.solaceSessionEventHandler != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Registering Solace Session Event handler on session");
                }
                this.context = JCSMPFactory.onlyInstance().createContext(new ContextProperties());
                this.jcsmpSession = JCSMPFactory.onlyInstance().createSession(jcsmpProperties, this.context, (SessionEventHandler)this.solaceSessionEventHandler);
            } else {
                this.jcsmpSession = JCSMPFactory.onlyInstance().createSession(jcsmpProperties);
            }
            logger.info((Object)String.format("Connecting JCSMP session %s", this.jcsmpSession.getSessionName()));
            this.jcsmpSession.connect();
            if (this.solaceSessionEventHandler != null) {
                this.solaceSessionEventHandler.setSessionHealthUp();
            }
        }
        catch (Exception e) {
            if (this.context != null) {
                this.context.destroy();
            }
            throw e;
        }
    }

    @Bean
    SolaceMessageChannelBinder solaceMessageChannelBinder(SolaceQueueProvisioner solaceQueueProvisioner, @Nullable SolaceBinderHealthAccessor solaceBinderHealthAccessor, @Nullable SolaceMeterAccessor solaceMeterAccessor) {
        SolaceMessageChannelBinder binder = new SolaceMessageChannelBinder(this.jcsmpSession, this.context, solaceQueueProvisioner);
        binder.setExtendedBindingProperties(this.solaceExtendedBindingProperties);
        binder.setSolaceMeterAccessor(solaceMeterAccessor);
        if (solaceBinderHealthAccessor != null) {
            binder.setSolaceBinderHealthAccessor(solaceBinderHealthAccessor);
        }
        return binder;
    }

    @Bean
    SolaceQueueProvisioner provisioningProvider() {
        return new SolaceQueueProvisioner(this.jcsmpSession);
    }
}

