/*
 * Decompiled with CFR 0.152.
 */
package com.solace.spring.cloud.stream.binder.config;

import com.solace.spring.boot.autoconfigure.SolaceJavaAutoCloudConfiguration;
import com.solace.spring.boot.autoconfigure.SolaceJavaAutoConfiguration;
import com.solace.spring.boot.autoconfigure.SolaceJavaProperties;
import com.solace.spring.cloud.stream.binder.config.SolaceMessageChannelBinderConfiguration;
import com.solacesystems.jcsmp.JCSMPChannelProperties;
import com.solacesystems.jcsmp.JCSMPProperties;
import com.solacesystems.jcsmp.SpringJCSMPFactory;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.Cloud;
import org.springframework.cloud.CloudFactory;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;

@Configuration
@ConditionalOnMissingBean(value={Binder.class})
@Import(value={SolaceMessageChannelBinderConfiguration.class})
public class SolaceServiceAutoConfiguration {

    @Configuration
    @Profile(value={"cloud"})
    protected static class CloudProfile {
        protected CloudProfile() {
        }

        @Configuration
        @ConditionalOnClass(value={Cloud.class})
        protected static class CloudConnectors {
            protected CloudConnectors() {
            }

            @Bean
            @ConditionalOnMissingBean
            public Cloud cloud() {
                return new CloudFactory().getCloud();
            }

            @Configuration
            @ConditionalOnProperty(value={"spring.cloud.stream.overrideCloudConnectors"})
            @EnableConfigurationProperties(value={SolaceJavaProperties.class})
            protected static class OverrideCloudConnectors {
                protected OverrideCloudConnectors() {
                }

                @Bean
                @Primary
                SpringJCSMPFactory getSpringJCSMPFactory(Cloud cloud, SolaceJavaProperties properties) {
                    Properties apiProps = new Properties();
                    Set set = properties.getApiProperties().entrySet();
                    for (Map.Entry entry : set) {
                        apiProps.put("jcsmp." + (String)entry.getKey(), entry.getValue());
                    }
                    JCSMPProperties jcsmpProps = apiProps != null ? JCSMPProperties.fromProperties((Properties)apiProps) : new JCSMPProperties();
                    jcsmpProps.setProperty("host", (Object)properties.getHost());
                    jcsmpProps.setProperty("vpn_name", (Object)properties.getMsgVpn());
                    jcsmpProps.setProperty("username", (Object)properties.getClientUsername());
                    jcsmpProps.setProperty("password", (Object)properties.getClientPassword());
                    if (properties.getClientName() != null && !properties.getClientName().isEmpty()) {
                        jcsmpProps.setProperty("client_name", (Object)properties.getClientName());
                    }
                    JCSMPChannelProperties cp = (JCSMPChannelProperties)jcsmpProps.getProperty("client_channel");
                    cp.setConnectRetries(properties.getConnectRetries());
                    cp.setReconnectRetries(properties.getReconnectRetries());
                    cp.setConnectRetriesPerHost(properties.getConnectRetriesPerHost());
                    cp.setReconnectRetryWaitInMillis(properties.getReconnectRetryWaitInMillis());
                    return new SpringJCSMPFactory(jcsmpProps);
                }
            }

            @Configuration
            @ConditionalOnProperty(value={"spring.cloud.stream.overrideCloudConnectors"}, havingValue="false", matchIfMissing=true)
            @Import(value={SolaceJavaAutoCloudConfiguration.class, SolaceJavaAutoConfiguration.class})
            protected static class UseCloudConnectors {
                protected UseCloudConnectors() {
                }
            }
        }

        @Configuration
        @ConditionalOnMissingClass(value={"org.springframework.cloud.Cloud"})
        @Import(value={SolaceJavaAutoCloudConfiguration.class, SolaceJavaAutoConfiguration.class})
        protected static class NoCloudConnectors {
            protected NoCloudConnectors() {
            }
        }
    }

    @Configuration
    @Profile(value={"!cloud"})
    @Import(value={SolaceJavaAutoCloudConfiguration.class, SolaceJavaAutoConfiguration.class})
    protected static class NoCloudProfile {
        protected NoCloudProfile() {
        }
    }
}

