/*
 * Decompiled with CFR 0.152.
 */
package com.solace.spring.cloud.stream.binder.config;

import com.solace.spring.cloud.stream.binder.SolaceMessageChannelBinder;
import com.solace.spring.cloud.stream.binder.properties.SolaceExtendedBindingProperties;
import com.solace.spring.cloud.stream.binder.provisioning.SolaceQueueProvisioner;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.SpringJCSMPFactory;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SolaceExtendedBindingProperties.class})
public class SolaceMessageChannelBinderConfiguration {
    @Autowired
    private SpringJCSMPFactory springJCSMPFactory;
    @Autowired
    private SolaceExtendedBindingProperties solaceExtendedBindingProperties;
    private JCSMPSession jcsmpSession;

    @PostConstruct
    private void initSession() throws JCSMPException {
        this.jcsmpSession = this.springJCSMPFactory.createSession();
        this.jcsmpSession.connect();
    }

    @Bean
    SolaceMessageChannelBinder solaceMessageChannelBinder() throws Exception {
        SolaceMessageChannelBinder binder = new SolaceMessageChannelBinder(this.jcsmpSession, this.provisioningProvider());
        binder.setExtendedBindingProperties(this.solaceExtendedBindingProperties);
        return binder;
    }

    @Bean
    SolaceQueueProvisioner provisioningProvider() {
        return new SolaceQueueProvisioner(this.jcsmpSession);
    }
}

