/*
 * Decompiled with CFR 0.152.
 */
package com.solace.spring.cloud.stream.binder;

import com.solace.spring.cloud.stream.binder.inbound.JCSMPInboundChannelAdapter;
import com.solace.spring.cloud.stream.binder.inbound.JCSMPMessageSource;
import com.solace.spring.cloud.stream.binder.outbound.JCSMPOutboundMessageHandler;
import com.solace.spring.cloud.stream.binder.properties.SolaceCommonProperties;
import com.solace.spring.cloud.stream.binder.properties.SolaceConsumerProperties;
import com.solace.spring.cloud.stream.binder.properties.SolaceExtendedBindingProperties;
import com.solace.spring.cloud.stream.binder.properties.SolaceProducerProperties;
import com.solace.spring.cloud.stream.binder.provisioning.SolaceQueueProvisioner;
import com.solace.spring.cloud.stream.binder.util.JCSMPSessionProducerManager;
import com.solace.spring.cloud.stream.binder.util.SolaceErrorMessageHandler;
import com.solace.spring.cloud.stream.binder.util.SolaceMessageHeaderErrorMessageStrategy;
import com.solace.spring.cloud.stream.binder.util.SolaceProvisioningUtil;
import com.solacesystems.jcsmp.EndpointProperties;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.Queue;
import java.util.UUID;
import java.util.function.Consumer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.cloud.stream.binder.AbstractMessageChannelBinder;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.DefaultPollableMessageSource;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.support.DefaultErrorMessageStrategy;
import org.springframework.integration.support.ErrorMessageStrategy;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.retry.RecoveryCallback;

public class SolaceMessageChannelBinder
extends AbstractMessageChannelBinder<ExtendedConsumerProperties<SolaceConsumerProperties>, ExtendedProducerProperties<SolaceProducerProperties>, SolaceQueueProvisioner>
implements ExtendedPropertiesBinder<MessageChannel, SolaceConsumerProperties, SolaceProducerProperties>,
DisposableBean {
    private final JCSMPSession jcsmpSession;
    private final JCSMPSessionProducerManager sessionProducerManager;
    private final String errorHandlerProducerKey = UUID.randomUUID().toString();
    private SolaceExtendedBindingProperties extendedBindingProperties = new SolaceExtendedBindingProperties();
    private static final SolaceMessageHeaderErrorMessageStrategy errorMessageStrategy = new SolaceMessageHeaderErrorMessageStrategy();

    public SolaceMessageChannelBinder(JCSMPSession jcsmpSession, SolaceQueueProvisioner solaceQueueProvisioner) {
        super(new String[0], (ProvisioningProvider)solaceQueueProvisioner);
        this.jcsmpSession = jcsmpSession;
        this.sessionProducerManager = new JCSMPSessionProducerManager(jcsmpSession);
    }

    public void destroy() {
        this.sessionProducerManager.release(this.errorHandlerProducerKey);
        this.jcsmpSession.closeSession();
    }

    protected MessageHandler createProducerMessageHandler(ProducerDestination destination, ExtendedProducerProperties<SolaceProducerProperties> producerProperties, MessageChannel errorChannel) {
        JCSMPOutboundMessageHandler handler = new JCSMPOutboundMessageHandler(destination, this.jcsmpSession, errorChannel, producerProperties, this.sessionProducerManager);
        if (errorChannel != null) {
            handler.setErrorMessageStrategy((ErrorMessageStrategy)new DefaultErrorMessageStrategy());
        }
        return handler;
    }

    protected MessageProducer createConsumerEndpoint(ConsumerDestination destination, String group, ExtendedConsumerProperties<SolaceConsumerProperties> properties) {
        JCSMPInboundChannelAdapter adapter = new JCSMPInboundChannelAdapter(destination, this.jcsmpSession, properties.getConcurrency(), this.getConsumerEndpointProperties(properties), this.getConsumerPostStart(properties));
        AbstractMessageChannelBinder.ErrorInfrastructure errorInfra = this.registerErrorInfrastructure(destination, group, (ConsumerProperties)properties);
        if (properties.getMaxAttempts() > 1) {
            adapter.setRetryTemplate(this.buildRetryTemplate((ConsumerProperties)properties));
            adapter.setRecoveryCallback((RecoveryCallback)errorInfra.getRecoverer());
        } else {
            adapter.setErrorChannel((MessageChannel)errorInfra.getErrorChannel());
        }
        adapter.setErrorMessageStrategy((ErrorMessageStrategy)errorMessageStrategy);
        return adapter;
    }

    protected AbstractMessageChannelBinder.PolledConsumerResources createPolledConsumerResources(String name, String group, ConsumerDestination destination, ExtendedConsumerProperties<SolaceConsumerProperties> consumerProperties) {
        if (consumerProperties.getConcurrency() > 1) {
            this.logger.warn((Object)"Polled consumers do not support concurrency > 1, it will be ignored...");
        }
        EndpointProperties endpointProperties = this.getConsumerEndpointProperties(consumerProperties);
        Consumer<Queue> postStart = this.getConsumerPostStart(consumerProperties);
        JCSMPMessageSource messageSource = new JCSMPMessageSource(destination, this.jcsmpSession, consumerProperties, endpointProperties, postStart);
        AbstractMessageChannelBinder.ErrorInfrastructure errorInfra = this.registerErrorInfrastructure(destination, group, (ConsumerProperties)consumerProperties, true);
        return new AbstractMessageChannelBinder.PolledConsumerResources((MessageSource)messageSource, errorInfra);
    }

    protected void postProcessPollableSource(DefaultPollableMessageSource bindingTarget) {
        bindingTarget.setAttributesProvider((accessor, message) -> {
            Object rawMessage = message.getHeaders().get((Object)"solace_raw_message");
            if (rawMessage != null) {
                accessor.setAttribute("solace_raw_message", rawMessage);
            }
        });
    }

    protected MessageHandler getErrorMessageHandler(ConsumerDestination destination, String group, ExtendedConsumerProperties<SolaceConsumerProperties> consumerProperties) {
        return new SolaceErrorMessageHandler(destination, consumerProperties, this.errorHandlerProducerKey, this.sessionProducerManager);
    }

    protected MessageHandler getPolledConsumerErrorMessageHandler(ConsumerDestination destination, String group, ExtendedConsumerProperties<SolaceConsumerProperties> consumerProperties) {
        MessageHandler handler = this.getErrorMessageHandler(destination, group, consumerProperties);
        if (handler != null) {
            return handler;
        }
        return super.getPolledConsumerErrorMessageHandler(destination, group, consumerProperties);
    }

    protected ErrorMessageStrategy getErrorMessageStrategy() {
        return errorMessageStrategy;
    }

    protected String errorsBaseName(ConsumerDestination destination, String group, ExtendedConsumerProperties<SolaceConsumerProperties> consumerProperties) {
        return destination.getName() + ".errors";
    }

    public SolaceConsumerProperties getExtendedConsumerProperties(String channelName) {
        return (SolaceConsumerProperties)this.extendedBindingProperties.getExtendedConsumerProperties(channelName);
    }

    public SolaceProducerProperties getExtendedProducerProperties(String channelName) {
        return (SolaceProducerProperties)this.extendedBindingProperties.getExtendedProducerProperties(channelName);
    }

    public String getDefaultsPrefix() {
        return this.extendedBindingProperties.getDefaultsPrefix();
    }

    public Class<? extends BinderSpecificPropertiesProvider> getExtendedPropertiesEntryClass() {
        return this.extendedBindingProperties.getExtendedPropertiesEntryClass();
    }

    public void setExtendedBindingProperties(SolaceExtendedBindingProperties extendedBindingProperties) {
        this.extendedBindingProperties = extendedBindingProperties;
    }

    private EndpointProperties getConsumerEndpointProperties(ExtendedConsumerProperties<SolaceConsumerProperties> properties) {
        return SolaceProvisioningUtil.getEndpointProperties((SolaceCommonProperties)((SolaceCommonProperties)properties.getExtension()));
    }

    private Consumer<Queue> getConsumerPostStart(ExtendedConsumerProperties<SolaceConsumerProperties> properties) {
        return queue -> {
            for (String topic : ((SolaceQueueProvisioner)this.provisioningProvider).getTrackedTopicsForQueue(queue.getName())) {
                ((SolaceQueueProvisioner)this.provisioningProvider).addSubscriptionToQueue(queue, topic, (SolaceCommonProperties)properties.getExtension());
            }
        };
    }
}

