/*
 * Decompiled with CFR 0.152.
 */
package com.solace.spring.boot.autoconfigure;

import com.solace.spring.cloud.core.SolaceMessagingInfo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.Cloud;
import org.springframework.cloud.CloudFactory;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.context.annotation.Bean;

abstract class SpringSolJmsConfCloudFactoryImplBase {
    private static final Logger logger = LoggerFactory.getLogger(SpringSolJmsConfCloudFactoryImplBase.class);
    private CloudFactory cloudFactory = new CloudFactory();

    SpringSolJmsConfCloudFactoryImplBase() {
    }

    @Bean
    public List<SolaceMessagingInfo> getSolaceMessagingInfos() {
        ArrayList<SolaceMessagingInfo> solaceMessagingInfoList = new ArrayList<SolaceMessagingInfo>();
        Cloud cloud = this.cloudFactory.getCloud();
        List serviceInfos = cloud.getServiceInfos();
        for (ServiceInfo serviceInfo : serviceInfos) {
            if (!(serviceInfo instanceof SolaceMessagingInfo)) continue;
            solaceMessagingInfoList.add((SolaceMessagingInfo)serviceInfo);
        }
        return solaceMessagingInfoList;
    }

    @Bean
    public SolaceMessagingInfo findFirstSolaceMessagingInfo() {
        SolaceMessagingInfo solacemessaging = null;
        Cloud cloud = this.cloudFactory.getCloud();
        List serviceInfos = cloud.getServiceInfos();
        for (ServiceInfo serviceInfo : serviceInfos) {
            if (!(serviceInfo instanceof SolaceMessagingInfo)) continue;
            solacemessaging = (SolaceMessagingInfo)serviceInfo;
            logger.info("Found Cloud Solace Messaging Service Instance Id: " + solacemessaging.getId());
            break;
        }
        if (solacemessaging == null) {
            logger.error("Cloud Solace Messaging Info was not found, cannot auto-configure");
            throw new IllegalStateException("Unable to create SolConnectionFactory did not find SolaceMessagingInfo in the current cloud environment");
        }
        return solacemessaging;
    }
}

