/*
 * Decompiled with CFR 0.152.
 */
package com.solace.spring.boot.autoconfigure;

import com.solace.spring.boot.autoconfigure.SolaceJmsProperties;
import com.solace.spring.boot.autoconfigure.SolaceJndiAutoCloudConfiguration;
import com.solacesystems.jndi.SolJNDIInitialContextFactory;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jms.JmsAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jndi.JndiTemplate;

@Configuration
@AutoConfigureBefore(value={JmsAutoConfiguration.class})
@AutoConfigureAfter(value={SolaceJndiAutoCloudConfiguration.class})
@ConditionalOnClass(value={ConnectionFactory.class, SolJNDIInitialContextFactory.class})
@ConditionalOnMissingBean(value={JndiTemplate.class})
@EnableConfigurationProperties(value={SolaceJmsProperties.class})
public class SolaceJndiAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SolaceJndiAutoConfiguration.class);
    @Autowired
    private SolaceJmsProperties properties;

    @Bean
    public JndiTemplate jndiTemplate() {
        try {
            Properties env = new Properties();
            env.putAll(this.properties.getApiProperties());
            env.put("java.naming.factory.initial", "com.solacesystems.jndi.SolJNDIInitialContextFactory");
            env.put("java.naming.provider.url", this.properties.getHost());
            env.put("java.naming.security.principal", this.properties.getClientUsername() + '@' + this.properties.getMsgVpn());
            env.put("java.naming.security.credentials", this.properties.getClientPassword());
            JndiTemplate jndiTemplate = new JndiTemplate();
            jndiTemplate.setEnvironment(env);
            return jndiTemplate;
        }
        catch (Exception ex) {
            logger.error("Exception found during Solace JNDI Initial Context creation.", (Throwable)ex);
            throw new IllegalStateException("Unable to create Solace JNDI Initial Context, ensure that the sol-jms-<version>.jar is the classpath", ex);
        }
    }
}

