/*
 * Decompiled with CFR 0.152.
 */
package com.solace.spring.boot.autoconfigure;

import com.solace.spring.boot.autoconfigure.CloudCondition;
import com.solace.spring.boot.autoconfigure.SolaceJmsProperties;
import com.solace.spring.boot.autoconfigure.SpringSolJmsConfCloudFactoryImplBase;
import com.solace.spring.cloud.core.SolaceMessagingInfo;
import com.solacesystems.jms.SpringSolJmsJndiTemplateCloudFactory;
import com.solacesystems.jndi.SolJNDIInitialContextFactory;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jms.JmsAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.CloudFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.jndi.JndiTemplate;

@Configuration
@AutoConfigureBefore(value={JmsAutoConfiguration.class})
@ConditionalOnClass(value={ConnectionFactory.class, SolJNDIInitialContextFactory.class, CloudFactory.class})
@ConditionalOnMissingBean(value={JndiTemplate.class})
@Conditional(value={CloudCondition.class})
@EnableConfigurationProperties(value={SolaceJmsProperties.class})
public class SolaceJndiAutoCloudConfiguration
extends SpringSolJmsConfCloudFactoryImplBase
implements SpringSolJmsJndiTemplateCloudFactory {
    private static final Logger logger = LoggerFactory.getLogger(SolaceJndiAutoCloudConfiguration.class);
    @Autowired
    private SolaceJmsProperties properties;

    @Override
    public JndiTemplate getJndiTemplate(SolaceMessagingInfo solacemessaging) {
        try {
            Properties env = new Properties();
            env.putAll(this.properties.getApiProperties());
            env.put("java.naming.factory.initial", "com.solacesystems.jndi.SolJNDIInitialContextFactory");
            if (solacemessaging.getJmsJndiUri() != null) {
                env.put("java.naming.provider.url", solacemessaging.getJmsJndiUri());
            } else {
                env.put("java.naming.provider.url", this.properties.getHost());
            }
            if (solacemessaging.getMsgVpnName() != null && solacemessaging.getClientUsername() != null) {
                env.put("java.naming.security.principal", solacemessaging.getClientUsername() + '@' + solacemessaging.getMsgVpnName());
            } else {
                env.put("java.naming.security.principal", this.properties.getClientUsername() + '@' + this.properties.getMsgVpn());
            }
            if (solacemessaging.getClientPassword() != null) {
                env.put("java.naming.security.credentials", solacemessaging.getClientPassword());
            } else {
                env.put("java.naming.security.credentials", this.properties.getClientPassword());
            }
            JndiTemplate jndiTemplate = new JndiTemplate();
            jndiTemplate.setEnvironment(env);
            return jndiTemplate;
        }
        catch (Exception ex) {
            logger.error("Exception found during Solace JndiTemplate creation.", (Throwable)ex);
            throw new IllegalStateException("Unable to create Solace JndiTemplate", ex);
        }
    }

    @Override
    @Bean
    public JndiTemplate getJndiTemplate() {
        return this.getJndiTemplate(this.findFirstSolaceMessagingInfo());
    }
}

