/*
 * Decompiled with CFR 0.152.
 */
package com.solace.spring.boot.autoconfigure;

import com.solace.spring.boot.autoconfigure.SolaceJmsAutoCloudConfiguration;
import com.solace.spring.boot.autoconfigure.SolaceJmsProperties;
import com.solace.spring.boot.autoconfigure.SolaceJndiAutoConfiguration;
import com.solacesystems.jms.SolConnectionFactory;
import com.solacesystems.jms.SolConnectionFactoryImpl;
import com.solacesystems.jms.property.JMSProperties;
import java.util.Hashtable;
import javax.jms.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jms.JmsAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={JmsAutoConfiguration.class})
@AutoConfigureAfter(value={SolaceJmsAutoCloudConfiguration.class, SolaceJndiAutoConfiguration.class})
@ConditionalOnClass(value={ConnectionFactory.class, SolConnectionFactory.class})
@ConditionalOnMissingBean(value={ConnectionFactory.class})
@EnableConfigurationProperties(value={SolaceJmsProperties.class})
public class SolaceJmsAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SolaceJmsAutoConfiguration.class);
    @Autowired
    private SolaceJmsProperties properties;

    @Bean
    public SolConnectionFactoryImpl connectionFactory() {
        try {
            Hashtable<String, String> ht = new Hashtable<String, String>();
            ht.putAll(this.properties.getApiProperties());
            JMSProperties props = new JMSProperties(ht);
            props.initialize();
            SolConnectionFactoryImpl cf = new SolConnectionFactoryImpl(props);
            cf.setHost(this.properties.getHost());
            cf.setVPN(this.properties.getMsgVpn());
            cf.setUsername(this.properties.getClientUsername());
            cf.setPassword(this.properties.getClientPassword());
            cf.setDirectTransport(Boolean.valueOf(this.properties.isDirectTransport()));
            return cf;
        }
        catch (Exception ex) {
            logger.error("Exception found during Solace Connection Factory creation.", (Throwable)ex);
            throw new IllegalStateException("Unable to create Solace connection factory, ensure that the sol-jms-<version>.jar is the classpath", ex);
        }
    }
}

