/*
 * Decompiled with CFR 0.152.
 */
package com.solace.spring.boot.autoconfigure;

import com.solace.spring.boot.autoconfigure.CloudCondition;
import com.solace.spring.boot.autoconfigure.SolaceJmsProperties;
import com.solace.spring.boot.autoconfigure.SolaceJndiAutoCloudConfiguration;
import com.solace.spring.boot.autoconfigure.SpringSolJmsConfCloudFactoryImplBase;
import com.solace.spring.cloud.core.SolaceMessagingInfo;
import com.solacesystems.jms.SolConnectionFactory;
import com.solacesystems.jms.SolConnectionFactoryImpl;
import com.solacesystems.jms.SpringSolJmsConnectionFactoryCloudFactory;
import com.solacesystems.jms.property.JMSProperties;
import java.util.Hashtable;
import javax.jms.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jms.JmsAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.CloudFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={JmsAutoConfiguration.class})
@AutoConfigureAfter(value={SolaceJndiAutoCloudConfiguration.class})
@ConditionalOnClass(value={ConnectionFactory.class, SolConnectionFactory.class, CloudFactory.class})
@ConditionalOnMissingBean(value={ConnectionFactory.class})
@Conditional(value={CloudCondition.class})
@EnableConfigurationProperties(value={SolaceJmsProperties.class})
public class SolaceJmsAutoCloudConfiguration
extends SpringSolJmsConfCloudFactoryImplBase
implements SpringSolJmsConnectionFactoryCloudFactory {
    private static final Logger logger = LoggerFactory.getLogger(SolaceJmsAutoCloudConfiguration.class);
    @Autowired
    private SolaceJmsProperties properties;

    @Override
    public SolConnectionFactory getSolConnectionFactory(SolaceMessagingInfo solacemessaging) {
        try {
            Hashtable<String, String> ht = new Hashtable<String, String>();
            ht.putAll(this.properties.getApiProperties());
            JMSProperties props = new JMSProperties(ht);
            props.initialize();
            SolConnectionFactoryImpl cf = new SolConnectionFactoryImpl(props);
            if (solacemessaging.getSmfHost() != null) {
                cf.setHost(solacemessaging.getSmfHost());
            } else {
                cf.setHost(this.properties.getHost());
            }
            if (solacemessaging.getMsgVpnName() != null) {
                cf.setVPN(solacemessaging.getMsgVpnName());
            } else {
                cf.setVPN(this.properties.getMsgVpn());
            }
            if (solacemessaging.getClientUsername() != null) {
                cf.setUsername(solacemessaging.getClientUsername());
            } else {
                cf.setUsername(this.properties.getClientUsername());
            }
            if (solacemessaging.getClientPassword() != null) {
                cf.setPassword(solacemessaging.getClientPassword());
            } else {
                cf.setPassword(this.properties.getClientPassword());
            }
            cf.setDirectTransport(Boolean.valueOf(this.properties.isDirectTransport()));
            return cf;
        }
        catch (Exception ex) {
            logger.error("Exception found during Solace Connection Factory creation.", (Throwable)ex);
            throw new IllegalStateException("Unable to create Solace connection factory", ex);
        }
    }

    @Override
    @Bean
    public SolConnectionFactory getSolConnectionFactory() {
        return this.getSolConnectionFactory(this.findFirstSolaceMessagingInfo());
    }
}

