/*
 * Decompiled with CFR 0.152.
 */
package com.solace.spring.boot.autoconfigure;

import com.solace.spring.boot.autoconfigure.SolaceJavaProperties;
import com.solacesystems.jcsmp.JCSMPChannelProperties;
import com.solacesystems.jcsmp.JCSMPProperties;
import com.solacesystems.jcsmp.SpringJCSMPFactory;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jms.JmsAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={JmsAutoConfiguration.class})
@ConditionalOnClass(value={JCSMPProperties.class})
@ConditionalOnMissingBean(value={SpringJCSMPFactory.class})
@EnableConfigurationProperties(value={SolaceJavaProperties.class})
public class SolaceJavaAutoConfiguration {
    private SolaceJavaProperties properties;

    @Autowired
    public SolaceJavaAutoConfiguration(SolaceJavaProperties properties) {
        this.properties = properties;
    }

    @Bean
    public SpringJCSMPFactory getSpringJCSMPFactory(JCSMPProperties jcsmpProperties) {
        return new SpringJCSMPFactory(jcsmpProperties);
    }

    @Bean
    public JCSMPProperties getJCSMPProperties() {
        Properties p = new Properties();
        Set<Map.Entry<String, String>> set = this.properties.getApiProperties().entrySet();
        for (Map.Entry<String, String> entry : set) {
            p.put("jcsmp." + entry.getKey(), entry.getValue());
        }
        JCSMPProperties jcsmpProps = this.createFromApiProperties(p);
        jcsmpProps.setProperty("host", (Object)this.properties.getHost());
        jcsmpProps.setProperty("vpn_name", (Object)this.properties.getMsgVpn());
        jcsmpProps.setProperty("username", (Object)this.properties.getClientUsername());
        jcsmpProps.setProperty("password", (Object)this.properties.getClientPassword());
        if (this.properties.getClientName() != null && !this.properties.getClientName().isEmpty()) {
            jcsmpProps.setProperty("client_name", (Object)this.properties.getClientName());
        }
        JCSMPChannelProperties cp = (JCSMPChannelProperties)jcsmpProps.getProperty("client_channel");
        cp.setConnectRetries(this.properties.getConnectRetries());
        cp.setReconnectRetries(this.properties.getReconnectRetries());
        cp.setConnectRetriesPerHost(this.properties.getConnectRetriesPerHost());
        cp.setReconnectRetryWaitInMillis(this.properties.getReconnectRetryWaitInMillis());
        return jcsmpProps;
    }

    private JCSMPProperties createFromApiProperties(Properties apiProps) {
        return apiProps != null ? JCSMPProperties.fromProperties((Properties)apiProps) : new JCSMPProperties();
    }

    void setProperties(SolaceJavaProperties properties) {
        this.properties = properties;
    }
}

