/*
 * Decompiled with CFR 0.152.
 */
package com.solace.serdes;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;

class EncodingUtil {
    private EncodingUtil() {
    }

    public static Charset getEncoding(Object encodingValue) {
        if (encodingValue instanceof String) {
            String name = (String)encodingValue;
            try {
                return Charset.forName(name);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                throw new IllegalArgumentException("Unsupported charset encoding " + name, e);
            }
        }
        if (encodingValue instanceof Charset && ((Charset)encodingValue).canEncode()) {
            return (Charset)encodingValue;
        }
        throw new IllegalArgumentException("Unsupported charset encoding type");
    }
}

