/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.util.internal;

import com.solace.messaging.util.internal.Internal;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public final class Validation {
    private Validation() {
    }

    public static void regexMatchIllegal(String toTest, Pattern pattern, String message) {
        Matcher matcher = pattern.matcher(toTest);
        if (matcher.matches()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void regexMatchIllegal(String toTest, String regex, String message) {
        if (toTest.matches(regex)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> void nullIllegal(T obj, String message) throws IllegalArgumentException {
        if (null == obj) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> void nullOrEmptyIllegal(byte[] array, String message) throws IllegalArgumentException {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> void nullOrEmptyIllegal(String s, String message) throws IllegalArgumentException {
        if (null == s || s.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> void predicateIllegal(Predicate<String> predicate, String s, String message) throws IllegalArgumentException {
        if (predicate.test(s)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void nonNaturalNumbersIllegal(int i, String message) throws IllegalArgumentException {
        if (0 > i) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void smallerThanNumbersIllegal(int lowerBoundary, int i, String message) throws IllegalArgumentException {
        if (lowerBoundary > i) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void smallerThanNumbersIllegal(long lowerBoundary, long i, String message) throws IllegalArgumentException {
        if (lowerBoundary > i) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void outOfRangeIllegal(int lowerBoundary, int highBoundary, int i, String message) throws IllegalArgumentException {
        if (lowerBoundary > i || highBoundary < i) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void outOfRangeIllegal(long lowerBoundary, long highBoundary, long i, String message) throws IllegalArgumentException {
        if (lowerBoundary > i || highBoundary < i) {
            throw new IllegalArgumentException(message);
        }
    }
}

