/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging;

import com.solace.messaging.AbstractConfigurableBuilder;
import com.solace.messaging.DirectMessagePublisherBuilder;
import com.solace.messaging.MessagingService;
import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.config.ReceiverPropertyConfiguration;
import com.solace.messaging.config.provider.ReceiverPropertiesConfigurationProvider;
import com.solace.messaging.receiver.RequestReplyMessageReceiver;
import com.solace.messaging.receiver.RequestReplyMessageReceiverImpl;
import com.solace.messaging.resources.ShareName;
import com.solace.messaging.resources.TopicSubscription;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.MessagingServiceInternalView;
import com.solace.messaging.util.internal.Validation;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface RequestReplyMessageReceiverBuilder
extends ReceiverPropertyConfiguration {
    @Override
    public RequestReplyMessageReceiverBuilder fromProperties(Properties var1) throws IllegalArgumentException;

    public RequestReplyMessageReceiverBuilder onReplierBackPressureElastic();

    public RequestReplyMessageReceiverBuilder onReplierBackPressureWait(int var1);

    public RequestReplyMessageReceiverBuilder onReplierBackPressureReject(int var1);

    public RequestReplyMessageReceiver build(TopicSubscription var1) throws PubSubPlusClientException;

    public RequestReplyMessageReceiver build(TopicSubscription var1, ShareName var2) throws PubSubPlusClientException;

    @Internal
    @ProviderType
    public static class RequestReplyMessageReceiverBuilderImpl
    extends AbstractConfigurableBuilder
    implements RequestReplyMessageReceiverBuilder {
        private final MessagingService messagingService;
        private final MessagingServiceInternalView messagingServiceInternalView;
        private final DirectMessagePublisherBuilder replierBuilder;
        private final List<TopicSubscription> topicSubscriptions;

        RequestReplyMessageReceiverBuilderImpl(MessagingServiceInternalView messagingServiceInternalView) {
            super(messagingServiceInternalView.getActiveProfile());
            this.messagingServiceInternalView = messagingServiceInternalView;
            this.messagingService = (MessagingService)((Object)messagingServiceInternalView);
            this.replierBuilder = this.messagingService.createDirectMessagePublisherBuilder();
            this.topicSubscriptions = new CopyOnWriteArrayList<TopicSubscription>();
        }

        @Override
        TypedProperties createDefaultConfiguration() {
            return this.activeProfile.getConfigurationObjectFactory().createDirectReceiverConfiguration().getConfiguration();
        }

        @Override
        public RequestReplyMessageReceiverBuilder fromProperties(Properties configuration) throws IllegalArgumentException {
            this.configProviders.add(ReceiverPropertiesConfigurationProvider.of(configuration));
            return this;
        }

        @Override
        public RequestReplyMessageReceiverBuilder onReplierBackPressureElastic() {
            this.replierBuilder.onBackPressureElastic();
            return this;
        }

        @Override
        public RequestReplyMessageReceiverBuilder onReplierBackPressureWait(int bufferCapacity) {
            this.replierBuilder.onBackPressureWait(bufferCapacity);
            return this;
        }

        @Override
        public RequestReplyMessageReceiverBuilder onReplierBackPressureReject(int bufferCapacity) {
            this.replierBuilder.onBackPressureReject(bufferCapacity);
            return this;
        }

        @Override
        public RequestReplyMessageReceiver build(TopicSubscription requestTopicSubscription) throws PubSubPlusClientException {
            Validation.nullIllegal(requestTopicSubscription, "requestTopicSubscription can't be null");
            this.topicSubscriptions.add(requestTopicSubscription);
            return new RequestReplyMessageReceiverImpl(this.messagingServiceInternalView, this.composeConfiguration(), this.replierBuilder, this.topicSubscriptions);
        }

        @Override
        public RequestReplyMessageReceiver build(TopicSubscription requestTopicSubscription, ShareName shareName) throws PubSubPlusClientException {
            Validation.nullIllegal(requestTopicSubscription, "requestTopicSubscription can't be null");
            Validation.nullIllegal(shareName, "shareName can't be null");
            shareName.validate();
            this.topicSubscriptions.add(requestTopicSubscription);
            return new RequestReplyMessageReceiverImpl(this.messagingServiceInternalView, this.composeConfiguration(), this.replierBuilder, this.topicSubscriptions, shareName);
        }

        @Override
        void validate(TypedProperties properties) throws IllegalArgumentException {
        }
    }
}

