/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging;

import com.solace.messaging.AbstractConfigurableBuilder;
import com.solace.messaging.MessagePublisherBuilder;
import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.config.provider.PublisherBackPressureConfigurationProvider;
import com.solace.messaging.config.provider.PublisherPropertiesConfigurationProvider;
import com.solace.messaging.publisher.DirectMessagePublisher;
import com.solace.messaging.publisher.DirectMessagePublisherImpl;
import com.solace.messaging.publisher.OutboundMessageBuilder;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.MessagingServiceInternalView;
import com.solace.messaging.util.internal.Validation;
import java.util.Properties;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface DirectMessagePublisherBuilder
extends MessagePublisherBuilder {
    @Override
    public DirectMessagePublisherBuilder fromProperties(Properties var1) throws IllegalArgumentException;

    @Override
    public DirectMessagePublisherBuilder onBackPressureReject(int var1);

    @Override
    public DirectMessagePublisherBuilder onBackPressureWait(int var1);

    @Override
    public DirectMessagePublisherBuilder onBackPressureElastic();

    public DirectMessagePublisher build() throws PubSubPlusClientException;

    @Internal
    @ProviderType
    public static class DirectMessagePublisherBuilderImpl
    extends AbstractConfigurableBuilder
    implements DirectMessagePublisherBuilder {
        private final MessagingServiceInternalView serviceInternalView;
        private final OutboundMessageBuilder messageBuilder;

        DirectMessagePublisherBuilderImpl(OutboundMessageBuilder messageBuilder, MessagingServiceInternalView serviceInternalView) {
            super(serviceInternalView.getActiveProfile());
            this.messageBuilder = messageBuilder;
            this.serviceInternalView = serviceInternalView;
        }

        @Override
        public DirectMessagePublisherBuilder onBackPressureReject(int bufferCapacity) {
            this.configProviders.add(PublisherBackPressureConfigurationProvider.bufferAndReject(bufferCapacity));
            return this;
        }

        @Override
        public DirectMessagePublisherBuilder onBackPressureElastic() {
            this.configProviders.add(PublisherBackPressureConfigurationProvider.elastic());
            return this;
        }

        @Override
        public DirectMessagePublisherBuilder onBackPressureWait(int bufferCapacity) {
            this.configProviders.add(PublisherBackPressureConfigurationProvider.bufferAndWait(bufferCapacity));
            return this;
        }

        @Override
        public DirectMessagePublisherBuilder fromProperties(Properties configuration) throws IllegalArgumentException {
            this.configProviders.add(PublisherPropertiesConfigurationProvider.of(configuration));
            return this;
        }

        @Override
        public DirectMessagePublisher build() throws PubSubPlusClientException {
            return new DirectMessagePublisherImpl(this.serviceInternalView, this.composeConfiguration(), this.messageBuilder);
        }

        @Override
        void validate(TypedProperties properties) throws IllegalArgumentException {
            String bpStrategy = properties.getProperty("solace.messaging.publisher.back-pressure.strategy");
            Validation.nullOrEmptyIllegal(bpStrategy, "Back-pressure strategy settings are missing");
            switch (bpStrategy) {
                case "ELASTIC": {
                    break;
                }
                case "BUFFER_REJECT_WHEN_FULL": 
                case "BUFFER_WAIT_WHEN_FULL": {
                    try {
                        int capacity = properties.getIntegerProperty("solace.messaging.publisher.back-pressure.buffer-capacity");
                        if (capacity < 0) {
                            throw new IllegalArgumentException(String.format("Negative buffer capacity %d", capacity));
                        }
                        break;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Missing or illegal buffer capacity");
                    }
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unknown back-pressure strategy: %s", bpStrategy));
                }
            }
        }

        @Override
        TypedProperties createDefaultConfiguration() {
            return this.activeProfile.getConfigurationObjectFactory().createDirectPublisherConfiguration().getConfiguration();
        }
    }
}

