/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.util.internal;

import com.solace.messaging.MessagingService;
import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.config.profile.SolaceSessionConfiguration;
import com.solace.messaging.util.internal.ClientSession;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.SessionEventHandlerAdapter;
import com.solacesystems.common.SolReserved;
import com.solacesystems.jcsmp.Browser;
import com.solacesystems.jcsmp.BrowserProperties;
import com.solacesystems.jcsmp.CacheSession;
import com.solacesystems.jcsmp.CacheSessionProperties;
import com.solacesystems.jcsmp.CapabilityType;
import com.solacesystems.jcsmp.Consumer;
import com.solacesystems.jcsmp.ConsumerFlowProperties;
import com.solacesystems.jcsmp.Context;
import com.solacesystems.jcsmp.DurableTopicEndpoint;
import com.solacesystems.jcsmp.Endpoint;
import com.solacesystems.jcsmp.EndpointProperties;
import com.solacesystems.jcsmp.FlowEventHandler;
import com.solacesystems.jcsmp.FlowReceiver;
import com.solacesystems.jcsmp.InvalidPropertiesException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPFactory;
import com.solacesystems.jcsmp.JCSMPLogLevel;
import com.solacesystems.jcsmp.JCSMPProducerEventHandler;
import com.solacesystems.jcsmp.JCSMPProperties;
import com.solacesystems.jcsmp.JCSMPReconnectEventHandler;
import com.solacesystems.jcsmp.JCSMPResponseListener;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.JCSMPSessionStats;
import com.solacesystems.jcsmp.JCSMPStreamingPublishEventHandler;
import com.solacesystems.jcsmp.JndiMessage;
import com.solacesystems.jcsmp.ProducerFlowProperties;
import com.solacesystems.jcsmp.Queue;
import com.solacesystems.jcsmp.Requestor;
import com.solacesystems.jcsmp.SessionEventHandler;
import com.solacesystems.jcsmp.Subscription;
import com.solacesystems.jcsmp.SubscriptionStateProvider;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.TopicEndpoint;
import com.solacesystems.jcsmp.XMLMessageConsumer;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jcsmp.XMLMessageProducer;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.protocol.impl.TcpClientChannel;
import com.solacesystems.jcsmp.protocol.nio.impl.ConsumerNotificationDispatcherFactory;
import com.solacesystems.jcsmp.transaction.TransactedSession;
import com.solacesystems.jcsmp.transaction.xa.XASession;
import java.lang.reflect.InvocationTargetException;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class ClientSessionImpl
implements ClientSession {
    private final JCSMPSession delegate;
    private final SessionEventHandlerAdapter eventDispatcher;
    private volatile boolean connected;
    private final ClientSessionStateListenerDispatcher clientSessionStateListenerDispatcher;
    private static final Log logger = LogFactory.getLog(ClientSessionImpl.class);

    ClientSessionImpl(JCSMPSession session, SessionEventHandlerAdapter eventDispatcher) {
        this.delegate = session;
        this.eventDispatcher = eventDispatcher;
        MessagingService.ServiceInterruptionListener internal = e -> {
            this.connected = false;
        };
        this.eventDispatcher.addServiceInterruptionListener(internal);
        if (this.delegate instanceof JCSMPBasicSession) {
            this.eventDispatcher.setJCSMPBasicSession((JCSMPBasicSession)this.delegate);
        }
        this.clientSessionStateListenerDispatcher = new ClientSessionStateListenerDispatcher();
    }

    public static ClientSessionImpl createInstance(SolaceSessionConfiguration properties, Context context, boolean allowSharedClientId) throws InvalidPropertiesException {
        SessionEventHandlerAdapter eventAdapter = new SessionEventHandlerAdapter();
        try {
            return new ClientSessionImpl(JCSMPFactory.onlyInstance().createSession((JCSMPProperties)properties, context, (SessionEventHandler)eventAdapter, allowSharedClientId), eventAdapter);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new PubSubPlusClientException.InvalidConfigurationException(e.getMessage(), e);
        }
    }

    @Override
    public XMLMessageProducer getDefaultProducer() {
        if (this.delegate instanceof JCSMPBasicSession) {
            return ((JCSMPBasicSession)this.delegate).getProducer();
        }
        return null;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isReconnecting() {
        if (this.delegate instanceof JCSMPBasicSession) {
            return ((JCSMPBasicSession)this.delegate).isReconnectInProgress();
        }
        return false;
    }

    @Override
    public String getVirtualRouterName() {
        if (this.delegate instanceof JCSMPBasicSession) {
            return ((JCSMPBasicSession)this.delegate).getVirtualRouterName();
        }
        return null;
    }

    @Override
    public TcpClientChannel getClientChannel() {
        if (this.delegate instanceof JCSMPBasicSession) {
            return ((JCSMPBasicSession)this.delegate).getClientChannel();
        }
        return null;
    }

    public void addSubscription(Subscription subscription) throws JCSMPException {
        this.delegate.addSubscription(subscription);
    }

    public void addSubscription(Subscription subscription, boolean b) throws JCSMPException {
        this.delegate.addSubscription(subscription, b);
    }

    @SolReserved
    public Consumer addSubscription(Subscription subscription, XMLMessageListener xmlMessageListener, ConsumerNotificationDispatcherFactory consumerNotificationDispatcherFactory) throws JCSMPException {
        return this.delegate.addSubscription(subscription, xmlMessageListener, consumerNotificationDispatcherFactory);
    }

    public void removeSubscription(Subscription subscription) throws JCSMPException {
        this.delegate.removeSubscription(subscription);
    }

    public void removeSubscription(Subscription subscription, boolean b) throws JCSMPException {
        this.delegate.removeSubscription(subscription, b);
    }

    public void addSubscription(Endpoint endpoint, Subscription subscription, int i) throws JCSMPException {
        this.delegate.addSubscription(endpoint, subscription, i);
    }

    public void removeSubscription(Endpoint endpoint, Subscription subscription, int i) throws JCSMPException {
        this.delegate.removeSubscription(endpoint, subscription, i);
    }

    public void applySubscriptions(Set<Subscription> set) throws JCSMPException {
        this.delegate.applySubscriptions(set);
    }

    public XMLMessageProducer getMessageProducer(JCSMPStreamingPublishEventHandler jcsmpStreamingPublishEventHandler) throws JCSMPException {
        return this.delegate.getMessageProducer(jcsmpStreamingPublishEventHandler);
    }

    public XMLMessageProducer getMessageProducer(JCSMPStreamingPublishEventHandler jcsmpStreamingPublishEventHandler, JCSMPProducerEventHandler jcsmpProducerEventHandler) throws JCSMPException {
        return this.delegate.getMessageProducer(jcsmpStreamingPublishEventHandler, jcsmpProducerEventHandler);
    }

    public XMLMessageProducer getMessageProducer() throws JCSMPException {
        return this.delegate.getMessageProducer();
    }

    public XMLMessageProducer getDirectMessageProducer(JCSMPStreamingPublishEventHandler jcsmpStreamingPublishEventHandler) throws JCSMPException {
        return this.delegate.getDirectMessageProducer(jcsmpStreamingPublishEventHandler);
    }

    @SolReserved
    public XMLMessageProducer createProducer(ProducerFlowProperties producerFlowProperties, JCSMPStreamingPublishEventHandler jcsmpStreamingPublishEventHandler) throws JCSMPException {
        return this.delegate.createProducer(producerFlowProperties, jcsmpStreamingPublishEventHandler);
    }

    @SolReserved
    public XMLMessageProducer createProducer(ProducerFlowProperties producerFlowProperties, JCSMPStreamingPublishEventHandler jcsmpStreamingPublishEventHandler, JCSMPProducerEventHandler jcsmpProducerEventHandler) throws JCSMPException {
        return this.delegate.createProducer(producerFlowProperties, jcsmpStreamingPublishEventHandler, jcsmpProducerEventHandler);
    }

    public XMLMessageConsumer getMessageConsumer(XMLMessageListener xmlMessageListener) throws JCSMPException {
        return this.delegate.getMessageConsumer(xmlMessageListener);
    }

    public XMLMessageConsumer getMessageConsumer() throws JCSMPException {
        return this.delegate.getMessageConsumer();
    }

    public XMLMessageConsumer getMessageConsumer(JCSMPReconnectEventHandler jcsmpReconnectEventHandler, XMLMessageListener xmlMessageListener) throws JCSMPException {
        return this.delegate.getMessageConsumer(jcsmpReconnectEventHandler, xmlMessageListener);
    }

    public XMLMessageConsumer getMessageConsumer(JCSMPReconnectEventHandler jcsmpReconnectEventHandler) throws JCSMPException {
        return this.delegate.getMessageConsumer(jcsmpReconnectEventHandler);
    }

    @Deprecated
    public XMLMessageConsumer getMessageConsumer(SubscriptionStateProvider subscriptionStateProvider, XMLMessageListener xmlMessageListener) throws JCSMPException {
        return this.delegate.getMessageConsumer(subscriptionStateProvider, xmlMessageListener);
    }

    public XMLMessageConsumer getMessageConsumer(SubscriptionStateProvider subscriptionStateProvider) throws JCSMPException {
        return this.delegate.getMessageConsumer(subscriptionStateProvider);
    }

    @Deprecated
    public XMLMessageConsumer getMessageConsumer(SubscriptionStateProvider subscriptionStateProvider, JCSMPReconnectEventHandler jcsmpReconnectEventHandler, XMLMessageListener xmlMessageListener) throws JCSMPException {
        return this.delegate.getMessageConsumer(subscriptionStateProvider, jcsmpReconnectEventHandler, xmlMessageListener);
    }

    @Deprecated
    public XMLMessageConsumer getMessageConsumer(SubscriptionStateProvider subscriptionStateProvider, JCSMPReconnectEventHandler jcsmpReconnectEventHandler) throws JCSMPException {
        return this.delegate.getMessageConsumer(subscriptionStateProvider, jcsmpReconnectEventHandler);
    }

    @SolReserved
    public JndiMessage executeJndiQuery(JndiMessage jndiMessage) throws JCSMPException {
        return this.delegate.executeJndiQuery(jndiMessage);
    }

    public FlowReceiver createFlow(Endpoint endpoint, Subscription subscription, XMLMessageListener xmlMessageListener) throws JCSMPException {
        return this.delegate.createFlow(endpoint, subscription, xmlMessageListener);
    }

    public FlowReceiver createFlow(XMLMessageListener xmlMessageListener, ConsumerFlowProperties consumerFlowProperties) throws JCSMPException {
        return this.delegate.createFlow(xmlMessageListener, consumerFlowProperties);
    }

    public FlowReceiver createFlow(XMLMessageListener xmlMessageListener, ConsumerFlowProperties consumerFlowProperties, EndpointProperties endpointProperties) throws JCSMPException {
        return this.delegate.createFlow(xmlMessageListener, consumerFlowProperties, endpointProperties);
    }

    public FlowReceiver createFlow(XMLMessageListener xmlMessageListener, ConsumerFlowProperties consumerFlowProperties, EndpointProperties endpointProperties, FlowEventHandler flowEventHandler) throws JCSMPException {
        return this.delegate.createFlow(xmlMessageListener, consumerFlowProperties, endpointProperties, flowEventHandler);
    }

    public void logFlowInfo(JCSMPLogLevel jcsmpLogLevel) {
        this.delegate.logFlowInfo(jcsmpLogLevel);
    }

    public void unsubscribeDurableTopicEndpoint(DurableTopicEndpoint durableTopicEndpoint) throws JCSMPException {
        this.delegate.unsubscribeDurableTopicEndpoint(durableTopicEndpoint);
    }

    public void setProperty(String s, Object o) throws JCSMPException {
        this.delegate.setProperty(s, o);
    }

    public Object getProperty(String s) {
        return this.delegate.getProperty(s);
    }

    public CacheSession createCacheSession(CacheSessionProperties cacheSessionProperties) throws JCSMPException {
        return this.delegate.createCacheSession(cacheSessionProperties);
    }

    public Requestor createRequestor() throws JCSMPException {
        return this.delegate.createRequestor();
    }

    public TopicEndpoint createNonDurableTopicEndpoint() throws JCSMPException {
        return this.delegate.createNonDurableTopicEndpoint();
    }

    public TopicEndpoint createNonDurableTopicEndpoint(String s) throws JCSMPException {
        return this.delegate.createNonDurableTopicEndpoint(s);
    }

    public Queue createTemporaryQueue() throws JCSMPException {
        return this.delegate.createTemporaryQueue();
    }

    public Queue createTemporaryQueue(String s) throws JCSMPException {
        return this.delegate.createTemporaryQueue(s);
    }

    public Topic createTemporaryTopic() throws JCSMPException {
        return this.delegate.createTemporaryTopic();
    }

    public Object getCapability(CapabilityType capabilityType) throws JCSMPException {
        return this.delegate.getCapability(capabilityType);
    }

    public boolean isCapable(CapabilityType capabilityType) {
        return this.delegate.isCapable(capabilityType);
    }

    public void connect() throws JCSMPException {
        this.delegate.connect();
        this.connected = true;
    }

    public Set<Subscription> getSubscriptionCache() {
        return this.delegate.getSubscriptionCache();
    }

    public void provision(Endpoint endpoint, EndpointProperties endpointProperties, long l) throws JCSMPException {
        this.delegate.provision(endpoint, endpointProperties, l);
    }

    public void deprovision(Endpoint endpoint, long l) throws JCSMPException {
        this.delegate.deprovision(endpoint, l);
    }

    public Browser createBrowser(BrowserProperties browserProperties) throws JCSMPException {
        return this.delegate.createBrowser(browserProperties);
    }

    public Browser createBrowser(BrowserProperties browserProperties, FlowEventHandler flowEventHandler) throws JCSMPException {
        return this.delegate.createBrowser(browserProperties, flowEventHandler);
    }

    public TransactedSession createTransactedSession() throws JCSMPException {
        return this.delegate.createTransactedSession();
    }

    @SolReserved
    public XASession createXASession() throws JCSMPException {
        return this.delegate.createXASession();
    }

    @SolReserved
    public void setJmsClientId(String s, boolean b) throws JCSMPException {
        this.delegate.setJmsClientId(s, b);
    }

    public void addSubscription(Subscription subscription, JCSMPResponseListener jcsmpResponseListener, Object o) throws JCSMPException {
        this.delegate.addSubscription(subscription, jcsmpResponseListener, o);
    }

    public void addSubscription(Endpoint endpoint, Subscription subscription, JCSMPResponseListener jcsmpResponseListener, Object o) throws JCSMPException {
        this.delegate.addSubscription(endpoint, subscription, jcsmpResponseListener, o);
    }

    public void removeSubscription(Subscription subscription, JCSMPResponseListener jcsmpResponseListener, Object o) throws JCSMPException {
        this.delegate.removeSubscription(subscription, jcsmpResponseListener, o);
    }

    public void removeSubscription(Endpoint endpoint, Subscription subscription, JCSMPResponseListener jcsmpResponseListener, Object o) throws JCSMPException {
        this.delegate.removeSubscription(endpoint, subscription, jcsmpResponseListener, o);
    }

    public String getSessionName() {
        return this.delegate.getSessionName();
    }

    public void closeSession() {
        this.delegate.closeSession();
        this.connected = false;
        this.clientSessionStateListenerDispatcher.onClientSessionStateChange(new ClientSessionStateChangeEventImpl(ClientSession.ClientSessionState.CLOSED));
    }

    @SolReserved
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public JCSMPSessionStats getSessionStats() {
        return this.delegate.getSessionStats();
    }

    public void logSessionStats(JCSMPLogLevel jcsmpLogLevel) {
        this.delegate.logSessionStats(jcsmpLogLevel);
    }

    public void clearSubscriber() throws JCSMPException {
        this.delegate.clearSubscriber();
    }

    public void deleteSubscriber() throws JCSMPException {
        this.delegate.deleteSubscriber();
    }

    public void addSubscriber() throws JCSMPException {
        this.delegate.addSubscriber();
    }

    public void removeSubscriber() throws JCSMPException {
        this.delegate.removeSubscriber();
    }

    @Override
    public void addReconnectionListener(MessagingService.ReconnectionListener l) {
        this.eventDispatcher.addReconnectionListener(l);
    }

    @Override
    public void addReconnectionListeners(Collection<MessagingService.ReconnectionListener> ls) {
        this.eventDispatcher.addReconnectionListeners(ls);
    }

    @Override
    public boolean removeReconnectionListener(MessagingService.ReconnectionListener l) {
        return this.eventDispatcher.removeReconnectionListener(l);
    }

    @Override
    public void addReconnectionAttemptListener(MessagingService.ReconnectionAttemptListener l) {
        this.eventDispatcher.addReconnectionAttemptListener(l);
    }

    @Override
    public void addReconnectionAttemptListeners(Collection<MessagingService.ReconnectionAttemptListener> ls) {
        this.eventDispatcher.addReconnectionAttemptListeners(ls);
    }

    @Override
    public boolean removeReconnectionAttemptListener(MessagingService.ReconnectionAttemptListener l) {
        return this.eventDispatcher.removeReconnectionAttemptListener(l);
    }

    @Override
    public void addServiceInterruptionListener(MessagingService.ServiceInterruptionListener l) {
        this.eventDispatcher.addServiceInterruptionListener(l);
    }

    @Override
    public boolean removeServiceInterruptionListener(MessagingService.ServiceInterruptionListener l) {
        return this.eventDispatcher.removeServiceInterruptionListener(l);
    }

    @Override
    public void addClientSessionStateListener(ClientSession.ClientSessionStateListener clientSessionStateListener) {
        this.clientSessionStateListenerDispatcher.addClientSessionStateListener(clientSessionStateListener);
    }

    @Override
    public void removeClientSessionStateListener(ClientSession.ClientSessionStateListener clientSessionStateListener) {
        this.clientSessionStateListenerDispatcher.removeServiceInterruptionListener(clientSessionStateListener);
    }

    @Override
    public void removeAllListener() {
        this.eventDispatcher.removeAllListener();
        this.clientSessionStateListenerDispatcher.removeAllListener();
    }

    static class ClientSessionStateChangeEventImpl
    implements ClientSession.ClientSessionStateChangeEvent {
        final long timestamp;
        final String message;
        final PubSubPlusClientException cause;
        final ClientSession.ClientSessionState newClientSessionState;
        final ClientSession.ClientSessionState previousClientSessionState;

        ClientSessionStateChangeEventImpl(long timestamp, String message, PubSubPlusClientException cause, ClientSession.ClientSessionState newClientSessionState, ClientSession.ClientSessionState previousClientSessionState) {
            this.timestamp = timestamp;
            this.message = message;
            this.cause = cause;
            this.newClientSessionState = newClientSessionState;
            this.previousClientSessionState = previousClientSessionState;
        }

        ClientSessionStateChangeEventImpl(ClientSession.ClientSessionState newClientSessionState, ClientSession.ClientSessionState previousClientSessionState) {
            this(Instant.now().toEpochMilli(), null, null, newClientSessionState, previousClientSessionState);
        }

        ClientSessionStateChangeEventImpl(ClientSession.ClientSessionState newClientSessionState) {
            this(Instant.now().toEpochMilli(), null, null, newClientSessionState, null);
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public PubSubPlusClientException getCause() {
            return this.cause;
        }

        @Override
        public ClientSession.ClientSessionState getNewSessionState() {
            return this.newClientSessionState;
        }

        @Override
        public ClientSession.ClientSessionState getPreviousSessionState() {
            return this.previousClientSessionState;
        }
    }

    @Internal
    @ProviderType
    static class ClientSessionStateListenerDispatcher
    implements ClientSession.ClientSessionStateListener {
        private final Map<ClientSession.ClientSessionStateListener, Boolean> clientSessionStateListenerMap = new ConcurrentHashMap<ClientSession.ClientSessionStateListener, Boolean>();
        private final Set<ClientSession.ClientSessionStateListener> clientSessionStateListenerView = this.clientSessionStateListenerMap.keySet();

        ClientSessionStateListenerDispatcher() {
        }

        @Override
        public void onClientSessionStateChange(ClientSession.ClientSessionStateChangeEvent event) {
            this.clientSessionStateListenerView.forEach(l -> {
                block2: {
                    try {
                        l.onClientSessionStateChange(event);
                    }
                    catch (Exception ex) {
                        if (!logger.isWarnEnabled()) break block2;
                        logger.warn((Object)"Unhandled exception by processing of session state change event", (Throwable)ex);
                    }
                }
            });
        }

        void addClientSessionStateListener(ClientSession.ClientSessionStateListener l) {
            this.clientSessionStateListenerMap.put(l, Boolean.FALSE);
        }

        boolean removeServiceInterruptionListener(ClientSession.ClientSessionStateListener l) {
            return this.clientSessionStateListenerView.remove(l);
        }

        void removeAllListener() {
            this.clientSessionStateListenerView.clear();
        }
    }
}

