/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.config.provider;

import com.solace.messaging.config.MissingResourcesCreationConfiguration;
import com.solace.messaging.config.provider.ReceiverConfigurationProvider;
import com.solace.messaging.config.provider.ReceiverPropertiesConverter;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.Validation;
import java.util.Properties;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class ReceiverMissingResourcesCreationConfigurationProvider
implements ReceiverConfigurationProvider {
    private final Properties configurationSource = new Properties();

    private ReceiverMissingResourcesCreationConfigurationProvider() {
    }

    public static ReceiverMissingResourcesCreationConfigurationProvider of(MissingResourcesCreationConfiguration.MissingResourcesCreationStrategy strategy) {
        Validation.nullIllegal(strategy, "Resources creation strategy can't be null");
        switch (strategy) {
            case DO_NOT_CREATE: {
                return ReceiverMissingResourcesCreationConfigurationProvider.doNotCreateMissingResources();
            }
            case CREATE_ON_START: {
                return ReceiverMissingResourcesCreationConfigurationProvider.createOnStart();
            }
        }
        throw new IllegalArgumentException("Unsupported missing resource creation strategy " + (Object)((Object)strategy));
    }

    private static ReceiverMissingResourcesCreationConfigurationProvider doNotCreateMissingResources() {
        ReceiverMissingResourcesCreationConfigurationProvider provider = new ReceiverMissingResourcesCreationConfigurationProvider();
        provider.configurationSource.setProperty("solace.messaging.receiver.persistent.missing-resource-creation-strategy", "DO_NOT_CREATE");
        return provider;
    }

    private static ReceiverMissingResourcesCreationConfigurationProvider createOnStart() {
        ReceiverMissingResourcesCreationConfigurationProvider provider = new ReceiverMissingResourcesCreationConfigurationProvider();
        provider.configurationSource.setProperty("solace.messaging.receiver.persistent.missing-resource-creation-strategy", "CREATE_ON_START");
        return provider;
    }

    @Override
    public TypedProperties getConfiguration() {
        return ReceiverPropertiesConverter.toTypedProperties(this.configurationSource);
    }
}

