/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.config.provider;

import com.solace.messaging.config.TypedConfiguration;
import com.solace.messaging.config.provider.QueueBrowserPropertiesConverter;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.Validation;
import java.util.Properties;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class QueueBrowserConfigurationProvider
implements TypedConfiguration {
    private final Properties configurationSource = new Properties();

    private QueueBrowserConfigurationProvider() {
    }

    public static QueueBrowserConfigurationProvider messageSelector(String selectorQueryExpression) {
        Validation.nullOrEmptyIllegal(selectorQueryExpression, "selector query expression can't be null or empty");
        QueueBrowserConfigurationProvider provider = new QueueBrowserConfigurationProvider();
        provider.configurationSource.setProperty("solace.messaging.queue-browser.selector-query", selectorQueryExpression);
        return provider;
    }

    public static QueueBrowserConfigurationProvider windowSize(int windowSize) {
        Validation.outOfRangeIllegal(1, 255, windowSize, "Window size can't be outside of 1-255 range");
        QueueBrowserConfigurationProvider provider = new QueueBrowserConfigurationProvider();
        provider.configurationSource.setProperty("solace.messaging.queue-browser.persistent.transport-window-size", String.valueOf(windowSize));
        return provider;
    }

    @Override
    public TypedProperties getConfiguration() {
        return QueueBrowserPropertiesConverter.toTypedProperties(this.configurationSource);
    }
}

