/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.config.provider;

import com.solace.messaging.config.provider.ReceiverConfigurationProvider;
import com.solace.messaging.config.provider.ReceiverPropertiesConverter;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.Validation;
import java.util.Properties;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class ReceiverBackPressureConfigurationProvider
implements ReceiverConfigurationProvider {
    private final Properties configurationSource = new Properties();

    private ReceiverBackPressureConfigurationProvider() {
    }

    public static ReceiverBackPressureConfigurationProvider elastic() {
        ReceiverBackPressureConfigurationProvider provider = new ReceiverBackPressureConfigurationProvider();
        provider.configurationSource.setProperty("solace.messaging.receiver.direct.back-pressure.strategy", "ELASTIC");
        return provider;
    }

    public static ReceiverBackPressureConfigurationProvider dropOldest(int capacity) {
        Validation.smallerThanNumbersIllegal(1, capacity, "Buffer capacity can't be less 1");
        ReceiverBackPressureConfigurationProvider provider = new ReceiverBackPressureConfigurationProvider();
        provider.configurationSource.setProperty("solace.messaging.receiver.direct.back-pressure.strategy", "BUFFER_DROP_OLDEST_WHEN_FULL");
        provider.configurationSource.setProperty("solace.messaging.receiver.direct.back-pressure.buffer-capacity", String.valueOf(capacity));
        return provider;
    }

    public static ReceiverBackPressureConfigurationProvider dropLatest(int capacity) {
        Validation.smallerThanNumbersIllegal(1, capacity, "Buffer capacity can't be less 1");
        ReceiverBackPressureConfigurationProvider provider = new ReceiverBackPressureConfigurationProvider();
        provider.configurationSource.setProperty("solace.messaging.receiver.direct.back-pressure.strategy", "BUFFER_DROP_LATEST_WHEN_FULL");
        provider.configurationSource.setProperty("solace.messaging.receiver.direct.back-pressure.buffer-capacity", String.valueOf(capacity));
        return provider;
    }

    @Override
    public TypedProperties getConfiguration() {
        return ReceiverPropertiesConverter.toTypedProperties(this.configurationSource);
    }
}

