/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging;

import com.solace.messaging.AbstractConfigurableBuilder;
import com.solace.messaging.MessageReceiverBuilder;
import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.config.DirectReceiverBackPressureConfiguration;
import com.solace.messaging.config.provider.ReceiverBackPressureConfigurationProvider;
import com.solace.messaging.config.provider.ReceiverPropertiesConfigurationProvider;
import com.solace.messaging.receiver.DirectMessageReceiver;
import com.solace.messaging.receiver.DirectMessageReceiverImpl;
import com.solace.messaging.resources.ShareName;
import com.solace.messaging.resources.TopicSubscription;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.MessagingServiceInternalView;
import com.solace.messaging.util.internal.Validation;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface DirectMessageReceiverBuilder
extends MessageReceiverBuilder,
DirectReceiverBackPressureConfiguration {
    @Override
    public DirectMessageReceiverBuilder withSubscriptions(TopicSubscription ... var1);

    @Override
    public DirectMessageReceiverBuilder fromProperties(Properties var1) throws IllegalArgumentException;

    @Override
    public DirectMessageReceiverBuilder onBackPressureElastic();

    @Override
    public DirectMessageReceiverBuilder onBackPressureDropOldest(int var1);

    @Override
    public DirectMessageReceiverBuilder onBackPressureDropLatest(int var1);

    public DirectMessageReceiver build() throws PubSubPlusClientException;

    public DirectMessageReceiver build(ShareName var1) throws PubSubPlusClientException;

    @Internal
    @ProviderType
    public static class DirectMessageReceiverBuilderImpl
    extends AbstractConfigurableBuilder
    implements DirectMessageReceiverBuilder {
        private final MessagingServiceInternalView messagingServiceInternalView;
        private final List<TopicSubscription> topicSubscriptions = new CopyOnWriteArrayList<TopicSubscription>();

        DirectMessageReceiverBuilderImpl(MessagingServiceInternalView messagingServiceInternalView) {
            super(messagingServiceInternalView.getActiveProfile());
            this.messagingServiceInternalView = messagingServiceInternalView;
        }

        @Override
        public DirectMessageReceiverBuilder withSubscriptions(TopicSubscription ... subscriptions) {
            if (subscriptions != null && subscriptions.length > 0) {
                for (TopicSubscription ts : subscriptions) {
                    if (ts == null) continue;
                    this.topicSubscriptions.add(ts);
                }
            }
            return this;
        }

        @Override
        public DirectMessageReceiverBuilder fromProperties(Properties configuration) throws IllegalArgumentException {
            this.configProviders.add(ReceiverPropertiesConfigurationProvider.of(configuration));
            return this;
        }

        @Override
        public DirectMessageReceiverBuilder onBackPressureElastic() {
            this.configProviders.add(ReceiverBackPressureConfigurationProvider.elastic());
            return this;
        }

        @Override
        public DirectMessageReceiverBuilder onBackPressureDropOldest(int bufferCapacity) {
            this.configProviders.add(ReceiverBackPressureConfigurationProvider.dropOldest(bufferCapacity));
            return this;
        }

        @Override
        public DirectMessageReceiverBuilder onBackPressureDropLatest(int bufferCapacity) {
            this.configProviders.add(ReceiverBackPressureConfigurationProvider.dropLatest(bufferCapacity));
            return this;
        }

        @Override
        public DirectMessageReceiver build() {
            return new DirectMessageReceiverImpl(this.messagingServiceInternalView, this.composeConfiguration(), this.topicSubscriptions);
        }

        @Override
        public DirectMessageReceiver build(ShareName shareName) {
            Validation.nullIllegal(shareName, "Share name can't be null");
            shareName.validate();
            return new DirectMessageReceiverImpl(this.messagingServiceInternalView, this.composeConfiguration(), this.topicSubscriptions, shareName);
        }

        @Override
        void validate(TypedProperties properties) throws IllegalArgumentException {
            String bpStrategy = properties.getProperty("solace.messaging.receiver.direct.back-pressure.strategy");
            Validation.nullOrEmptyIllegal(bpStrategy, "Back-pressure strategy settings are missing");
            switch (bpStrategy) {
                case "ELASTIC": {
                    break;
                }
                case "BUFFER_DROP_LATEST_WHEN_FULL": 
                case "BUFFER_DROP_OLDEST_WHEN_FULL": {
                    try {
                        int capacity = properties.getIntegerProperty("solace.messaging.receiver.direct.back-pressure.buffer-capacity");
                        if (capacity < 0) {
                            throw new IllegalArgumentException(String.format("Negative buffer capacity %d", capacity));
                        }
                        break;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Missing or illegal buffer capacity");
                    }
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unknown back-pressure strategy: %s", bpStrategy));
                }
            }
        }

        @Override
        TypedProperties createDefaultConfiguration() {
            return this.activeProfile.getConfigurationObjectFactory().createDirectReceiverConfiguration().getConfiguration();
        }
    }
}

