/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.util.internal;

import com.solace.messaging.util.internal.Internal;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.PropertyPermission;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public final class PrivilegedActionUtility {
    private static final Log logger = LogFactory.getLog(PrivilegedActionUtility.class);

    private PrivilegedActionUtility() {
    }

    public static String getSystemProperty(final String propertyName) {
        String property;
        block2: {
            property = null;
            try {
                property = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty(propertyName);
                    }
                }, null, new PropertyPermission(propertyName, "read"));
            }
            catch (SecurityException se) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error((Object)("Not permitted to retrieve system property " + propertyName), (Throwable)se);
            }
        }
        return property;
    }

    public static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader cl = null;
                try {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return cl;
            }
        });
    }
}

