/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.receiver;

import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.receiver.InboundMessage;
import com.solace.messaging.receiver.MessageReceiver;
import com.solace.messaging.util.Manageable;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.async.ToggleLatch;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.Validation;
import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public interface ReceiverBuffers {
    public static ReceiverBuffer createDirectReceiverBuffer(TypedProperties receiverConfiguration, Manageable.ApiMetricsCollector metricsCollector) {
        String strategy = receiverConfiguration.getProperty("solace.messaging.receiver.direct.back-pressure.strategy");
        if (strategy == null) {
            return new ElasticReceiverBuffer();
        }
        int capacity = -1;
        switch (strategy) {
            case "BUFFER_DROP_LATEST_WHEN_FULL": {
                try {
                    capacity = receiverConfiguration.getIntegerProperty("solace.messaging.receiver.direct.back-pressure.buffer-capacity");
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Can't create capacity bonded buffer without capacity");
                }
                Validation.smallerThanNumbersIllegal(1, capacity, "Can't create capacity bonded buffer without capacity smaller than 1");
                return new DropLatestReceiverBuffer(capacity, metricsCollector);
            }
            case "BUFFER_DROP_OLDEST_WHEN_FULL": {
                try {
                    capacity = receiverConfiguration.getIntegerProperty("solace.messaging.receiver.direct.back-pressure.buffer-capacity");
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Can't create capacity bonded buffer without capacity");
                }
                Validation.smallerThanNumbersIllegal(1, capacity, "Can't create capacity bonded buffer without capacity smaller than 1");
                return new DropOldestReceiverBuffer(capacity, metricsCollector);
            }
        }
        return new ElasticReceiverBuffer();
    }

    public static ReceiverBuffer createCapacityAwareBuffer(TypedProperties receiverConfiguration, CapacityChangeListener capacityChangeListener) {
        int upperLimit = receiverConfiguration.getIntegerProperty("sub_ack_window_size") * 2;
        int lowerLimit = upperLimit * receiverConfiguration.getIntegerProperty("sub_ack_window_threshold") / 100;
        if (lowerLimit >= upperLimit) {
            throw new IllegalArgumentException("Can't create capacity aware buffer when 2*lower limit >= upper limit");
        }
        return new ElasticCapacityAwareReceiverBuffer(upperLimit, lowerLimit, capacityChangeListener);
    }

    @Internal
    @ProviderType
    public static class DropOldestReceiverBuffer
    implements ReceiverBuffer {
        private final LinkedBlockingQueue<Receivable> queue;
        private final AtomicBoolean dropped = new AtomicBoolean(false);
        private final CopyOnWriteArrayList<ReceiverBuffer.DiscardMessageHandler> discardMessageHandlers = new CopyOnWriteArrayList();
        final ReentrantLock lock = new ReentrantLock();
        private volatile boolean inAwaitEmpty = false;
        private final ToggleLatch emptyLatch = new ToggleLatch();
        private final Manageable.ApiMetricsCollector metricsCollector;

        public DropOldestReceiverBuffer(int capacity, Manageable.ApiMetricsCollector metricsCollector) {
            this.queue = new LinkedBlockingQueue(capacity);
            this.metricsCollector = metricsCollector;
            this.emptyLatch.open();
        }

        @Override
        public void addDiscardedHandler(ReceiverBuffer.DiscardMessageHandler handler) {
            this.discardMessageHandlers.add(handler);
        }

        @Override
        public void removeDiscardedHandler(ReceiverBuffer.DiscardMessageHandler handler) {
            this.discardMessageHandlers.remove(handler);
        }

        @Override
        public void clearDiscardedHandler() {
            this.discardMessageHandlers.clear();
        }

        @Override
        public int remainingCapacity() {
            return this.queue.remainingCapacity();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void insert(Receivable receivable) throws PubSubPlusClientException.RequestInterruptedException {
            inserted = this.queue.offer(receivable);
            if (inserted) {
                return;
            }
            l = this.lock;
            try {
                l.lockInterruptibly();
                do lbl-1000:
                // 3 sources

                {
                    if ((droppedHead = this.queue.poll()) == null) continue;
                    this.notifyOnDiscarded(droppedHead);
                    this.dropped.set(true);
                    reinserted = this.queue.offer(receivable);
                    if (!reinserted) ** GOTO lbl-1000
                    return;
                } while (!(reinserted = this.queue.offer(receivable)));
                return;
            }
            catch (InterruptedException ignore) {
                return;
            }
            finally {
                l.unlock();
            }
        }

        @Override
        public Receivable consume() throws PubSubPlusClientException.RequestInterruptedException {
            Receivable r = null;
            try {
                Receivable receivable = r = this.queue.take();
                return receivable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new PubSubPlusClientException.RequestInterruptedException("Consume operation was interrupted", e);
            }
            finally {
                boolean pulledAfterDrop;
                if (r != null && (pulledAfterDrop = this.dropped.compareAndSet(true, false))) {
                    r.indicateDiscard();
                    if (this.metricsCollector != null) {
                        this.metricsCollector.incrementMetric(Manageable.ApiMetrics.Metric.INTERNAL_DISCARD_NOTIFICATIONS);
                    }
                }
                if (this.inAwaitEmpty && this.queue.isEmpty()) {
                    this.emptyLatch.open();
                }
            }
        }

        @Override
        public Receivable consume(long timeout, TimeUnit unit) throws PubSubPlusClientException.RequestInterruptedException {
            Receivable r = null;
            try {
                Receivable receivable = r = this.queue.poll(timeout, unit);
                return receivable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new PubSubPlusClientException.RequestInterruptedException("Consume operation was interrupted", e);
            }
            finally {
                boolean pulledAfterDrop;
                if (r != null && (pulledAfterDrop = this.dropped.compareAndSet(true, false))) {
                    r.indicateDiscard();
                    if (this.metricsCollector != null) {
                        this.metricsCollector.incrementMetric(Manageable.ApiMetrics.Metric.INTERNAL_DISCARD_NOTIFICATIONS);
                    }
                }
                if (this.inAwaitEmpty && this.queue.isEmpty()) {
                    this.emptyLatch.open();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Receivable consumeOrNull() {
            Receivable r = null;
            try {
                Receivable receivable = r = this.queue.poll();
                return receivable;
            }
            finally {
                boolean pulledAfterDrop;
                if (r != null && (pulledAfterDrop = this.dropped.compareAndSet(true, false))) {
                    r.indicateDiscard();
                    if (this.metricsCollector != null) {
                        this.metricsCollector.incrementMetric(Manageable.ApiMetrics.Metric.INTERNAL_DISCARD_NOTIFICATIONS);
                    }
                }
                if (this.inAwaitEmpty && this.queue.isEmpty()) {
                    this.emptyLatch.open();
                }
            }
        }

        /*
         * Loose catch block
         */
        @Override
        public boolean awaitEmpty(long timeout, TimeUnit unit) {
            if (this.queue.isEmpty()) {
                return true;
            }
            try {
                boolean bl;
                this.inAwaitEmpty = true;
                long nanoTimeout = unit.toNanos(timeout);
                try {
                    boolean turnedEmpty = this.queue.isEmpty();
                    if (turnedEmpty) {
                        boolean bl2 = true;
                        return bl2;
                    }
                    this.emptyLatch.lock();
                    bl = this.emptyLatch.await(nanoTimeout, TimeUnit.NANOSECONDS) && this.queue.isEmpty();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new PubSubPlusClientException.RequestInterruptedException("Waiting during graceful termination was interrupted", e);
                }
                finally {
                    this.emptyLatch.open();
                }
                return bl;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.inAwaitEmpty = false;
            }
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        @Override
        public void clear() {
            this.queue.clear();
            this.emptyLatch.open();
            this.inAwaitEmpty = false;
        }

        void notifyOnDiscarded(Receivable r) {
            this.discardMessageHandlers.forEach(h -> h.onDiscardedMessage(r));
        }
    }

    @Internal
    @ProviderType
    public static class DropLatestReceiverBuffer
    implements ReceiverBuffer {
        private final LinkedBlockingQueue<Receivable> queue;
        private final AtomicBoolean dropped = new AtomicBoolean(false);
        private final CopyOnWriteArrayList<ReceiverBuffer.DiscardMessageHandler> discardMessageHandlers = new CopyOnWriteArrayList();
        private volatile boolean inAwaitEmpty = false;
        private final ToggleLatch emptyLatch = new ToggleLatch();
        private final Manageable.ApiMetricsCollector metricsCollector;

        public DropLatestReceiverBuffer(int capacity, Manageable.ApiMetricsCollector metricsCollector) {
            this.queue = new LinkedBlockingQueue(capacity);
            this.metricsCollector = metricsCollector;
            this.emptyLatch.open();
        }

        @Override
        public void addDiscardedHandler(ReceiverBuffer.DiscardMessageHandler handler) {
            this.discardMessageHandlers.add(handler);
        }

        @Override
        public void removeDiscardedHandler(ReceiverBuffer.DiscardMessageHandler handler) {
            this.discardMessageHandlers.remove(handler);
        }

        @Override
        public void clearDiscardedHandler() {
            this.discardMessageHandlers.clear();
        }

        @Override
        public int remainingCapacity() {
            return this.queue.remainingCapacity();
        }

        @Override
        public void insert(Receivable receivable) {
            boolean inserted = this.queue.offer(receivable);
            if (!inserted) {
                this.dropped.set(true);
                this.discarded(receivable);
            } else {
                boolean insertedAfterDrop = this.dropped.compareAndSet(true, false);
                if (insertedAfterDrop) {
                    receivable.indicateDiscard();
                    if (this.metricsCollector != null) {
                        this.metricsCollector.incrementMetric(Manageable.ApiMetrics.Metric.INTERNAL_DISCARD_NOTIFICATIONS);
                    }
                }
            }
        }

        @Override
        public Receivable consume() throws PubSubPlusClientException.RequestInterruptedException {
            try {
                Receivable receivable = this.queue.take();
                return receivable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new PubSubPlusClientException.RequestInterruptedException("Consume operation was interrupted", e);
            }
            finally {
                if (this.inAwaitEmpty && this.queue.isEmpty()) {
                    this.emptyLatch.open();
                }
            }
        }

        @Override
        public Receivable consume(long timeout, TimeUnit unit) throws PubSubPlusClientException.RequestInterruptedException {
            try {
                Receivable receivable = this.queue.poll(timeout, unit);
                return receivable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new PubSubPlusClientException.RequestInterruptedException("Consume operation was interrupted", e);
            }
            finally {
                if (this.inAwaitEmpty && this.queue.isEmpty()) {
                    this.emptyLatch.open();
                }
            }
        }

        @Override
        public Receivable consumeOrNull() {
            try {
                Receivable receivable = this.queue.poll();
                return receivable;
            }
            finally {
                if (this.inAwaitEmpty && this.queue.isEmpty()) {
                    this.emptyLatch.open();
                }
            }
        }

        /*
         * Loose catch block
         */
        @Override
        public boolean awaitEmpty(long timeout, TimeUnit unit) {
            if (this.queue.isEmpty()) {
                return true;
            }
            try {
                boolean bl;
                this.inAwaitEmpty = true;
                long nanoTimeout = unit.toNanos(timeout);
                try {
                    boolean turnedEmpty = this.queue.isEmpty();
                    if (turnedEmpty) {
                        boolean bl2 = true;
                        return bl2;
                    }
                    this.emptyLatch.lock();
                    bl = this.emptyLatch.await(nanoTimeout, TimeUnit.NANOSECONDS) && this.queue.isEmpty();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new PubSubPlusClientException.RequestInterruptedException("Waiting during graceful termination was interrupted", e);
                }
                finally {
                    this.emptyLatch.open();
                }
                return bl;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.inAwaitEmpty = false;
            }
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        @Override
        public void clear() {
            this.queue.clear();
            this.emptyLatch.open();
            this.inAwaitEmpty = false;
        }

        void discarded(Receivable r) {
            this.discardMessageHandlers.forEach(h -> h.onDiscardedMessage(r));
        }
    }

    @Internal
    @ProviderType
    public static class ElasticCapacityAwareReceiverBuffer
    implements ReceiverBuffer {
        private final LinkedBlockingQueue<Receivable> queue;
        private volatile boolean inAwaitEmpty = false;
        private final ReentrantLock takeLock = new ReentrantLock();
        private final ToggleLatch emptyLatch = new ToggleLatch();
        private final int upperLimit;
        private final int lowerLimit;
        private final CapacityChangeListener capacityChangeListener;
        private final AtomicBoolean lowNormalSwitch = new AtomicBoolean(false);

        public ElasticCapacityAwareReceiverBuffer(int upperLimit, int lowerLimit, CapacityChangeListener l) {
            this.upperLimit = upperLimit;
            this.lowerLimit = lowerLimit;
            this.capacityChangeListener = l;
            this.queue = new LinkedBlockingQueue();
            this.emptyLatch.open();
        }

        @Override
        public void addDiscardedHandler(ReceiverBuffer.DiscardMessageHandler handler) {
        }

        @Override
        public void removeDiscardedHandler(ReceiverBuffer.DiscardMessageHandler handler) {
        }

        @Override
        public void clearDiscardedHandler() {
        }

        @Override
        public int remainingCapacity() {
            return Integer.MAX_VALUE;
        }

        @Override
        public void insert(Receivable receivable) {
            this.queue.offer(receivable);
            if (!this.inAwaitEmpty && this.queue.size() >= this.upperLimit && this.lowNormalSwitch.compareAndSet(false, true)) {
                this.capacityChangeListener.low();
            }
        }

        @Override
        public Receivable consume() {
            try {
                Receivable r;
                Receivable receivable = r = this.queue.take();
                return receivable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new PubSubPlusClientException.RequestInterruptedException("Consume operation was interrupted", e);
            }
            finally {
                if (this.inAwaitEmpty && this.queue.isEmpty()) {
                    this.emptyLatch.open();
                }
                if (!this.inAwaitEmpty && this.queue.size() <= this.lowerLimit && this.lowNormalSwitch.compareAndSet(true, false)) {
                    this.capacityChangeListener.normal();
                }
            }
        }

        @Override
        public Receivable consume(long timeout, TimeUnit unit) throws PubSubPlusClientException.RequestInterruptedException {
            try {
                Receivable r;
                Receivable receivable = r = this.queue.poll(timeout, unit);
                return receivable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new PubSubPlusClientException.RequestInterruptedException("Consume operation was interrupted", e);
            }
            finally {
                if (this.inAwaitEmpty && this.queue.isEmpty()) {
                    this.emptyLatch.open();
                }
                if (!this.inAwaitEmpty && this.queue.size() <= this.lowerLimit && this.lowNormalSwitch.compareAndSet(true, false)) {
                    this.capacityChangeListener.normal();
                }
            }
        }

        @Override
        public Receivable consumeOrNull() {
            try {
                Receivable consumed;
                Receivable receivable = consumed = this.queue.poll();
                return receivable;
            }
            finally {
                if (this.inAwaitEmpty && this.queue.isEmpty()) {
                    this.emptyLatch.open();
                }
                if (!this.inAwaitEmpty && this.queue.size() <= this.lowerLimit && this.lowNormalSwitch.compareAndSet(true, false)) {
                    this.capacityChangeListener.normal();
                }
            }
        }

        /*
         * Loose catch block
         */
        @Override
        public boolean awaitEmpty(long timeout, TimeUnit unit) {
            if (this.queue.isEmpty()) {
                return true;
            }
            try {
                boolean bl;
                this.inAwaitEmpty = true;
                long nanoTimeout = unit.toNanos(timeout);
                try {
                    boolean turnedEmpty = this.queue.isEmpty();
                    if (turnedEmpty) {
                        boolean bl2 = true;
                        return bl2;
                    }
                    this.emptyLatch.lock();
                    bl = this.emptyLatch.await(nanoTimeout, TimeUnit.NANOSECONDS) && this.queue.isEmpty();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new PubSubPlusClientException.RequestInterruptedException("Waiting during graceful termination was interrupted", e);
                }
                finally {
                    this.emptyLatch.open();
                }
                return bl;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.inAwaitEmpty = false;
            }
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        @Override
        public void clear() {
            this.queue.clear();
            this.emptyLatch.open();
            this.inAwaitEmpty = false;
        }
    }

    @Internal
    @ProviderType
    public static interface CapacityChangeListener {
        public void low();

        public void normal();
    }

    @Internal
    @ProviderType
    public static class ElasticReceiverBuffer
    implements ReceiverBuffer {
        private final ConcurrentLinkedQueue<Receivable> queue;
        private final AtomicBoolean empty = new AtomicBoolean(true);
        private volatile boolean inAwaitEmpty = false;
        private final ReentrantLock takeLock = new ReentrantLock();
        private final Condition notEmpty = this.takeLock.newCondition();
        private final ToggleLatch emptyLatch = new ToggleLatch();

        public ElasticReceiverBuffer() {
            this.queue = new ConcurrentLinkedQueue();
            this.emptyLatch.open();
        }

        private void onNotEmpty() {
            boolean nEmpty = this.empty.compareAndSet(true, false);
            if (nEmpty) {
                ReentrantLock takeLock = this.takeLock;
                takeLock.lock();
                try {
                    this.notEmpty.signalAll();
                }
                finally {
                    takeLock.unlock();
                }
            }
        }

        @Override
        public void addDiscardedHandler(ReceiverBuffer.DiscardMessageHandler handler) {
        }

        @Override
        public void removeDiscardedHandler(ReceiverBuffer.DiscardMessageHandler handler) {
        }

        @Override
        public void clearDiscardedHandler() {
        }

        @Override
        public int remainingCapacity() {
            return Integer.MAX_VALUE;
        }

        @Override
        public void insert(Receivable receivable) {
            this.queue.offer(receivable);
            if (this.empty.get()) {
                this.onNotEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Receivable consume() {
            try {
                Receivable r;
                Receivable returned = null;
                while ((r = this.queue.poll()) == null) {
                    ReentrantLock takeLock = this.takeLock;
                    try {
                        takeLock.lockInterruptibly();
                        boolean e = this.queue.isEmpty();
                        if (!e) continue;
                        this.empty.set(e);
                        this.notEmpty.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new PubSubPlusClientException.RequestInterruptedException("Consume operation was interrupted", e);
                    }
                    finally {
                        takeLock.unlock();
                    }
                }
                returned = r;
                Receivable receivable = returned;
                return receivable;
            }
            finally {
                if (this.inAwaitEmpty && this.queue.isEmpty()) {
                    this.emptyLatch.open();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Receivable consume(long timeout, TimeUnit unit) throws PubSubPlusClientException.RequestInterruptedException {
            try {
                Receivable r;
                Receivable returned = null;
                long nanos = unit.toNanos(timeout);
                while ((r = this.queue.poll()) == null) {
                    if (nanos <= 0L) {
                        this.empty.set(true);
                        Receivable receivable = null;
                        return receivable;
                    }
                    ReentrantLock takeLock = this.takeLock;
                    try {
                        takeLock.lockInterruptibly();
                        boolean e = this.queue.isEmpty();
                        if (!e) continue;
                        this.empty.set(e);
                        nanos = this.notEmpty.awaitNanos(nanos);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new PubSubPlusClientException.RequestInterruptedException("Consume operation was interrupted", e);
                    }
                    finally {
                        takeLock.unlock();
                    }
                }
                returned = r;
                Receivable receivable = returned;
                return receivable;
            }
            finally {
                if (this.inAwaitEmpty && this.queue.isEmpty()) {
                    this.emptyLatch.open();
                }
            }
        }

        @Override
        public Receivable consumeOrNull() {
            try {
                Receivable consumed = this.queue.poll();
                if (consumed == null) {
                    this.empty.set(this.queue.isEmpty());
                }
                Receivable receivable = consumed;
                return receivable;
            }
            finally {
                if (this.inAwaitEmpty && this.queue.isEmpty()) {
                    this.emptyLatch.open();
                }
            }
        }

        /*
         * Loose catch block
         */
        @Override
        public boolean awaitEmpty(long timeout, TimeUnit unit) {
            if (this.queue.isEmpty()) {
                return true;
            }
            try {
                boolean bl;
                this.inAwaitEmpty = true;
                long nanoTimeout = unit.toNanos(timeout);
                try {
                    boolean turnedEmpty = this.queue.isEmpty();
                    if (turnedEmpty) {
                        this.empty.set(true);
                        boolean bl2 = true;
                        return bl2;
                    }
                    this.emptyLatch.lock();
                    bl = this.emptyLatch.await(nanoTimeout, TimeUnit.NANOSECONDS) && this.queue.isEmpty();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new PubSubPlusClientException.RequestInterruptedException("Waiting during graceful termination was interrupted", e);
                }
                finally {
                    this.emptyLatch.open();
                }
                return bl;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.inAwaitEmpty = false;
            }
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        @Override
        public void clear() {
            this.queue.clear();
            this.empty.set(true);
            this.emptyLatch.open();
            this.inAwaitEmpty = false;
        }
    }

    @Internal
    @ProviderType
    public static interface ReceiverBuffer
    extends Serializable {
        public void addDiscardedHandler(DiscardMessageHandler var1);

        public void removeDiscardedHandler(DiscardMessageHandler var1);

        public void clearDiscardedHandler();

        public int remainingCapacity();

        public void insert(Receivable var1);

        public Receivable consume() throws PubSubPlusClientException.RequestInterruptedException;

        public Receivable consume(long var1, TimeUnit var3) throws PubSubPlusClientException.RequestInterruptedException;

        public Receivable consumeOrNull();

        public boolean awaitEmpty(long var1, TimeUnit var3);

        public boolean isEmpty();

        public int size();

        public void clear();

        @Internal
        @ProviderType
        public static interface DiscardMessageHandler {
            public void onDiscardedMessage(Receivable var1);
        }
    }

    @Internal
    @ProviderType
    public static interface Receivable {
        public InboundMessage getMessage();

        public void indicateDiscard();

        public static Receivable of(InboundMessage message) {
            return new ReceivableImpl(message);
        }

        @Internal
        @ProviderType
        public static class ReceivableImpl
        implements Receivable {
            private final InboundMessage message;

            ReceivableImpl(InboundMessage message) {
                this.message = message;
            }

            @Override
            public InboundMessage getMessage() {
                return this.message;
            }

            @Override
            public void indicateDiscard() {
                InboundMessage im = this.message;
                if (im != null && im instanceof MessageReceiver.InboundMessageImpl) {
                    ((MessageReceiver.InboundMessageImpl)im).indicateDiscard();
                }
            }

            public String toString() {
                return "ReceivableImpl{message=" + this.message + '}';
            }
        }
    }
}

