/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.config.provider;

import com.solace.messaging.config.SolaceProperties;
import com.solace.messaging.publisher.OutboundMessageBuilder;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.PropertiesKey;
import com.solace.messaging.util.internal.Validation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public final class MessagePropertiesConverter {
    private static final Map<String, MappingInfo> CONVERTER_MAP;

    public static TypedProperties toTypedProperties(Properties properties) {
        Validation.nullIllegal(properties, "Argument properties can't be null");
        TypedProperties.TypedPropertiesImpl output = new TypedProperties.TypedPropertiesImpl();
        Set<String> userPropertyKeys = properties.stringPropertyNames();
        for (String nextKey : userPropertyKeys) {
            MappingInfo fieldInfo = CONVERTER_MAP.get(nextKey);
            if (fieldInfo == null) continue;
            if (String.class.equals(fieldInfo.getValueType())) {
                output.setProperty(nextKey, properties.getProperty(nextKey));
                continue;
            }
            if (Integer.TYPE.equals(fieldInfo.getValueType())) {
                String valueMayBeInt = properties.getProperty(nextKey);
                try {
                    output.setIntegerProperty(nextKey, Integer.parseInt(valueMayBeInt));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Property %s has to be of type integer, can't convert value [%s]", nextKey, valueMayBeInt));
                }
            }
            if (Long.TYPE.equals(fieldInfo.getValueType())) {
                String valueMayBeLong = properties.getProperty(nextKey);
                try {
                    output.setLongProperty(nextKey, Long.parseLong(valueMayBeLong));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Property %s has to be of type long, can't convert value [%s]", nextKey, valueMayBeLong));
                }
            }
            if (!Boolean.TYPE.equals(fieldInfo.getValueType())) continue;
            String valueMayBeBoolean = properties.getProperty(nextKey);
            output.setBooleanProperty(nextKey, Boolean.parseBoolean(valueMayBeBoolean));
        }
        return output;
    }

    public static TypedProperties.ConfigurationProperties toMixedProperties(Properties properties) {
        Validation.nullIllegal(properties, "Argument 'properties' can't be null");
        TypedProperties.TypedPropertiesImpl typed = new TypedProperties.TypedPropertiesImpl();
        Properties untyped = new Properties();
        TypedProperties.ConfigurationProperties out = new TypedProperties.ConfigurationProperties(typed, untyped);
        Set<String> userPropertyKeys = properties.stringPropertyNames();
        for (String nextKey : userPropertyKeys) {
            MappingInfo fieldInfo = CONVERTER_MAP.get(nextKey);
            if (fieldInfo == null) {
                untyped.setProperty(nextKey, properties.getProperty(nextKey));
                continue;
            }
            if (String.class.equals(fieldInfo.getValueType())) {
                typed.setProperty(nextKey, properties.getProperty(nextKey));
                continue;
            }
            if (Integer.TYPE.equals(fieldInfo.getValueType())) {
                String valueMayBeInt = properties.getProperty(nextKey);
                try {
                    typed.setIntegerProperty(nextKey, Integer.parseInt(valueMayBeInt));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Property %s has to be of type integer, can't convert value [%s]", nextKey, valueMayBeInt));
                }
            }
            if (Long.TYPE.equals(fieldInfo.getValueType())) {
                String valueMayBeLong = properties.getProperty(nextKey);
                try {
                    typed.setLongProperty(nextKey, Long.parseLong(valueMayBeLong));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Property %s has to be of type long, can't convert value [%s]", nextKey, valueMayBeLong));
                }
            }
            if (!Boolean.TYPE.equals(fieldInfo.getValueType())) continue;
            String valueMayBeBoolean = properties.getProperty(nextKey);
            typed.setBooleanProperty(nextKey, Boolean.parseBoolean(valueMayBeBoolean));
        }
        return out;
    }

    public static TypedProperties.ConfigurationProperties toMixedProperties(String key, String value) {
        Validation.nullIllegal(key, "Argument 'key' can't be null");
        TypedProperties.TypedPropertiesImpl typed = new TypedProperties.TypedPropertiesImpl();
        Properties untyped = new Properties();
        TypedProperties.ConfigurationProperties out = new TypedProperties.ConfigurationProperties(typed, untyped);
        MappingInfo fieldInfo = CONVERTER_MAP.get(key);
        if (fieldInfo == null) {
            untyped.setProperty(key, value);
        } else if (String.class.equals(fieldInfo.getValueType())) {
            typed.setProperty(key, value);
        } else if (Integer.TYPE.equals(fieldInfo.getValueType())) {
            String valueMayBeInt = value;
            try {
                typed.setIntegerProperty(key, Integer.parseInt(valueMayBeInt));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Property %s has to be of type integer, can't convert value [%s]", key, valueMayBeInt));
            }
        } else if (Long.TYPE.equals(fieldInfo.getValueType())) {
            String valueMayBeLong = value;
            try {
                typed.setLongProperty(key, Long.parseLong(valueMayBeLong));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Property %s has to be of type long, can't convert value [%s]", key, valueMayBeLong));
            }
        } else if (Boolean.TYPE.equals(fieldInfo.getValueType())) {
            String valueMayBeBoolean = value;
            typed.setBooleanProperty(key, Boolean.parseBoolean(valueMayBeBoolean));
        }
        return out;
    }

    public static boolean isTypedProperty(String propertyName) {
        MappingInfo fieldInfo = CONVERTER_MAP.get(propertyName);
        return fieldInfo != null;
    }

    static {
        Class<?>[] innerInterfaces;
        CONVERTER_MAP = new HashMap<String, MappingInfo>();
        for (Class<?> c : innerInterfaces = SolaceProperties.class.getClasses()) {
            for (Field f : c.getDeclaredFields()) {
                int hostFiledModifiers = f.getModifiers();
                if (f.isSynthetic() || !Modifier.isStatic(hostFiledModifiers) || !Modifier.isPublic(hostFiledModifiers) || !Modifier.isFinal(hostFiledModifiers) || !String.class.equals(f.getType())) continue;
                try {
                    PropertiesKey directMapper = f.getAnnotation(PropertiesKey.class);
                    if (directMapper == null) continue;
                    String propertyId = (String)f.get(null);
                    Class<?> targetType = directMapper.target();
                    if (!OutboundMessageBuilder.class.equals(targetType)) continue;
                    CONVERTER_MAP.put(propertyId, new MappingInfo(targetType, directMapper.valueType(), directMapper.required()));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    @Internal
    @ProviderType
    private static class MappingInfo {
        final Class<?> targetClass;
        final Class<?> valueType;
        final boolean required;

        public MappingInfo(Class<?> targetClass, Class<?> valueType, boolean required) {
            this.targetClass = targetClass;
            this.valueType = valueType;
            this.required = required;
        }

        public Class<?> getValueType() {
            return this.valueType;
        }

        public Class<?> getTargetClass() {
            return this.targetClass;
        }

        public boolean isRequired() {
            return this.required;
        }
    }
}

