/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.config;

import com.solace.messaging.receiver.InboundMessage;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.Validation;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface ReplayStrategy {
    public static ReplayStrategy allMessages() {
        return new AllMessagesReplay();
    }

    public static ReplayStrategy timeBased(Date replayStartDate, String zoneId) {
        Validation.nullIllegal(replayStartDate, "Replay Date can't be null");
        Validation.nullIllegal(zoneId, "Zone Id can't be null");
        return new TimeBasedReplay(ZonedDateTime.ofInstant(replayStartDate.toInstant(), ZoneId.of(zoneId)));
    }

    public static ReplayStrategy timeBased(ZonedDateTime replayStartDate) {
        Validation.nullIllegal(replayStartDate, "Replay start date can't be null");
        return new TimeBasedReplay(replayStartDate);
    }

    public static ReplayStrategy replicationGroupMessageIdBased(InboundMessage.ReplicationGroupMessageId replicationGroupMessageId) {
        Validation.nullIllegal(replicationGroupMessageId, "ReplicationGroupMessageId to start Replay can't be null");
        return new ReplicationGroupMessageIdReplay(replicationGroupMessageId);
    }

    @Internal
    @ProviderType
    public static final class ReplicationGroupMessageIdReplay
    implements ReplayStrategy {
        private final InboundMessage.ReplicationGroupMessageId replayId;

        private ReplicationGroupMessageIdReplay(InboundMessage.ReplicationGroupMessageId replayId) {
            this.replayId = replayId;
        }

        public InboundMessage.ReplicationGroupMessageId getReplicationGroupMessageId() {
            return this.replayId;
        }
    }

    @Internal
    @ProviderType
    public static final class TimeBasedReplay
    implements ReplayStrategy {
        private final ZonedDateTime replayDate;

        private TimeBasedReplay(ZonedDateTime replayDate) {
            this.replayDate = replayDate;
        }

        public ZonedDateTime getReplayDate() {
            return this.replayDate;
        }

        public String toString() {
            return "TimeBasedReplay{replayDate=" + this.replayDate + '}';
        }
    }

    @Internal
    @ProviderType
    public static final class AllMessagesReplay
    implements ReplayStrategy {
        private AllMessagesReplay() {
        }
    }
}

