/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging;

import com.solace.messaging.config.ReceiverActivationPassivationConfiguration;
import com.solace.messaging.config.TypedConfiguration;
import com.solace.messaging.config.profile.ConfigurationProfile;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.internal.Internal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public abstract class AbstractConfigurableBuilder {
    final List<TypedConfiguration> configProviders;
    final ConfigurationProfile activeProfile;

    AbstractConfigurableBuilder(ConfigurationProfile activeProfile) {
        this.activeProfile = activeProfile;
        this.configProviders = new CopyOnWriteArrayList<TypedConfiguration>();
    }

    abstract void validate(TypedProperties var1) throws IllegalArgumentException;

    abstract TypedProperties createDefaultConfiguration();

    TypedProperties composeConfiguration() {
        TypedProperties configuration = this.createDefaultConfiguration();
        this.configProviders.forEach(config -> {
            if (config != null) {
                TypedProperties typedConfiguration = config.getConfiguration();
                typedConfiguration.propertyNames().forEach(key -> {
                    Object value = typedConfiguration.getObjectProperty((String)key);
                    if (value == null) throw new UnsupportedOperationException("Unsupported null value for property " + key);
                    if (value instanceof Integer) {
                        configuration.setIntegerProperty((String)key, (Integer)value);
                        return;
                    } else if (value instanceof Long) {
                        configuration.setLongProperty((String)key, (Long)value);
                        return;
                    } else if (value instanceof Boolean) {
                        configuration.setBooleanProperty((String)key, (Boolean)value);
                        return;
                    } else if (value instanceof String) {
                        configuration.setProperty((String)key, (String)value);
                        return;
                    } else if (value instanceof ZonedDateTime) {
                        configuration.setObjectProperty((String)key, (ZonedDateTime)value);
                        return;
                    } else {
                        if (!(value instanceof ReceiverActivationPassivationConfiguration.ReceiverStateChangeListener)) throw new UnsupportedOperationException("Unsupported property value type " + value.getClass().getName());
                        configuration.setObjectProperty((String)key, (ReceiverActivationPassivationConfiguration.ReceiverStateChangeListener)value);
                    }
                });
            }
        });
        this.validate(configuration);
        return configuration;
    }
}

