/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.util.internal;

import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.receiver.MessageReceiver;
import com.solace.messaging.resources.ReceiverInfo;
import com.solace.messaging.util.async.ThreadFactories;
import com.solace.messaging.util.internal.Internal;
import java.time.Instant;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class MessageReceiptFailureNotificationDispatcher {
    private final ExecutorService failureNotificationExecutorService;
    private volatile MessageReceiver.ReceiveFailureListener receiveFailureListener;
    private final ReceiverInfo receiverInfo;
    private static final Log logger = LogFactory.getLog(MessageReceiptFailureNotificationDispatcher.class);

    public MessageReceiptFailureNotificationDispatcher(ReceiverInfo receiverInfo) {
        this.receiverInfo = receiverInfo;
        this.failureNotificationExecutorService = Executors.newSingleThreadExecutor(new ThreadFactories.NamedDaemonThreadFactory(this.receiverInfo.getInstanceName() + "-error-dispatcher"));
    }

    public void onException(Exception e) {
        block7: {
            if (e == null) {
                return;
            }
            MessageReceiver.ReceiveFailureListener l = this.receiveFailureListener;
            if (l == null) {
                return;
            }
            ScheduledFailureNotification notification = new ScheduledFailureNotification(e, Instant.now().toEpochMilli());
            try {
                this.failureNotificationExecutorService.submit(notification);
            }
            catch (RejectedExecutionException ex) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)(this.receiverInfo.getInstanceName() + " could not schedule failure notification, notification wil be processed on an internal thread"));
                }
                try {
                    notification.call();
                }
                catch (Exception exc) {
                    if (!logger.isErrorEnabled()) break block7;
                    logger.error((Object)("Application code throw an unhandled exception by processing failure notification: " + notification), (Throwable)ex);
                }
            }
        }
    }

    public void setReceiveFailureListener(MessageReceiver.ReceiveFailureListener receiverFailureListener) {
        this.receiveFailureListener = receiverFailureListener;
    }

    @Internal
    @ProviderType
    class ScheduledFailureNotification
    implements Callable<Void> {
        final Exception e;
        final long timeStamp;

        ScheduledFailureNotification(Exception e, long timeStamp) {
            this.e = e;
            this.timeStamp = timeStamp;
        }

        @Override
        public Void call() throws Exception {
            block3: {
                MessageReceiver.ReceiveFailureListener l = MessageReceiptFailureNotificationDispatcher.this.receiveFailureListener;
                if (l == null) {
                    return null;
                }
                MessageReceiver.FailedReceiveEvent failedReceiveEvent = new MessageReceiver.FailedReceiveEvent(this.mapException(this.e), this.timeStamp);
                try {
                    l.onFailedReceive(failedReceiveEvent);
                }
                catch (Exception ex) {
                    if (!logger.isErrorEnabled()) break block3;
                    logger.error((Object)("Application code throw an unhandled exception by processing failure notification: " + failedReceiveEvent), (Throwable)ex);
                }
            }
            return null;
        }

        PubSubPlusClientException mapException(Exception e) {
            if (e instanceof PubSubPlusClientException) {
                return (PubSubPlusClientException)e;
            }
            return new PubSubPlusClientException(e);
        }

        public String toString() {
            return "FailureNotification{e=" + this.e + ", timeStamp=" + this.timeStamp + '}';
        }
    }
}

